/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "wmconfigurationwindow.h"
#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>
#include <qcheckbox.h>

WMConfigurationWindow::WMConfigurationWindow(QObject *parent, const char *name)
 : GPluginSDKCfg(0, name)
{
connect(this,SIGNAL(xApplyParameter(const QString, const QString)),parent,SLOT(xSetupParameter(const QString, const QString)));
}


WMConfigurationWindow::~WMConfigurationWindow()
{
}

void WMConfigurationWindow::pOK_clicked()
{
	xApplyParameter("themepath",ThemePath->text());
	xApplyParameter("minitext",QString("%1").arg(MiniText->currentItem()));
	if(Italian->isChecked())xApplyParameter("italian","1");
	else xApplyParameter("italian","0");
	hide();
}

void WMConfigurationWindow::xSetupParameter(QString vname,QString vvalue)
{
	bool okRet=false;
	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}
	if(vname=="minitext")
	{
		int i=vvalue.toInt(&okRet);
		MiniText->setCurrentItem(i);
	}
	if(vname=="italian")
	{
		if(vvalue=="0")
		{
			Italian->setChecked(false);
		}
		else Italian->setChecked(true);
	}
}



void WMConfigurationWindow::pBrowseTheme_clicked()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Plugin Theme Path");
	
	
	if(cfgPath==NULL)
	{
		qWarning("cannot find the path");
		return;
	}
	
	ThemePath->setText(cfgPath);
}




#include "wmconfigurationwindow.moc"
