/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GDATE_H
#define XEPLUGIN_GDATE_H

#include <qobject.h>
#include <kiconloader.h>
#include <libkxdocker.h>

class GDate : public gPluginSDK
{
  Q_OBJECT
public:
	GDate(QObject *parent = 0, const char *name = 0);
	~GDate();
	QObject *Respawn(QObject *);
public slots:
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xPaint(int);
    virtual void polling();
    virtual void xApplyCfg();
    virtual void xStop();
    virtual void xStart();
protected:
	void loadResources(const QString newPath);
	void oldPaint();
	int iMiniText;
	int ita;

	QImage bufferImage;
	QImage bufferDay;
	QImage Original;
};



#endif
