//
// C++ Implementation: gcpu
//
// Description: 
//
//
// Author: Stefano <stefano@xiaprojects.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gcpu.h"
#include "gcpu.moc"



#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <kconfig.h>
#include <kurlrequester.h>
#include <kglobalsettings.h>
#include <klocale.h>


extern "C" QObject *xeplugin_register(QObject *parent)
{
	qWarning("GCpu xeplugin_register()");
	return new GCpu(parent,"GCpu");
}


GCpu::GCpu(QObject *parent, const char *name)
 : gPluginSDK(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="CPU Usage Meter";


	// compatibility with 0.29
	QString Version="0.3";
	PluginInformations.append("KXDocker GCpu");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20050605"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gcpu");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gcpu");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1;name=%1").arg(Version).arg(name)); // url update


#ifdef Q_OS_LINUX
  m_procStream = 0L;
  if ((m_procFile = fopen("/proc/stat", "r")))
    m_procStream = new QTextStream(m_procFile, IO_ReadOnly);
#endif
	IconsPath="kxdocker/plugins/gcpu/";
	PollingRate=1000;
}



GCpu::~GCpu()
{
	delete m_procStream;

}




/*!
    \fn GCpu::xGetParameterList(QStringList *a)
 */
void GCpu::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("polling");
	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
}






/*!
    \fn GCpu::xGetParameter(const QString vname, QString&vvalue)
 */
void GCpu::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=IconsPath;
	}
	if(vname=="polling")
	{
		vvalue.setNum(PollingRate);
	}

	gPluginSDK::xGetParameter(vname,vvalue);
}



void GCpu::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("themepath",IconsPath);
		}
		// done in 0.4
		//lastValue=-1;
		loadImages();
		//xRefreshIcon(xGIcon);
	}



	bool okRet=false;
	if(vname=="polling")
	{
		PollingRate=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			PollingRate=1000;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("polling",PollingRate);
		}
	}

	gPluginSDK::xSetupParameter(vname,vvalue);
}

void GCpu::xStart()
{
	gPluginSDK::xStart();
}


void GCpu::xStop()
{
	gPluginSDK::xStop();
}


void GCpu::polling()
{
	if(isStopped){
		return;
	}

	//qWarning("CPU0 Status:");
	CpuData cpuData;
	int cpuNumber=0;
	updateCpu(cpuData,cpuNumber);
	
	/*
	qWarning(QString("name: [%1] user: [%1] nice: [%1] sys: [%1] idle: [%1]")
		.arg(cpuData.name)
		.arg(cpuData.user)
		.arg(cpuData.nice)
		.arg(cpuData.sys)
		.arg(cpuData.idle)
		);
	*/	
	int cpuDiff = 0;
	current.setData(cpuData);
	cpuData -= current.oldData();
	cpuDiff = cpuData.sys + cpuData.user + cpuData.nice;
	//cpuDiff = cpuData.user;
	if (cpuDiff > 100)
		cpuDiff = 100;
	Value=cpuDiff;
	QTimer::singleShot( PollingRate, this, SLOT(polling()));
	xRefreshIcon(xGIcon);

}


void GCpu::loadImages()
{
	// base Image
	QString kdeshare="kxdocker/plugins/gcpu/";
	QString cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/CPUMonitor.png";
	QFile a(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"CPUMonitor.png";
	}
	BasePixmap.load(::locate("data",cpuPaths));
	BufferPixmap.resize(BasePixmap.size());
	/*
	QImage TBuffer;
		TBuffer.create(
			128,
			128,
			32);
		
		TBuffer.setAlphaBuffer(false);
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		
	BufferPixmap.convertFromImage(TBuffer);
	*/
	BufferPixmap.fill(Qt::black);
}


void GCpu::xPaint(int nPercentage)
{
	ToolTip=QString("CPU0: %1%").arg(nPercentage);


	
	QPixmap line;
	QString kdeshare="kxdocker/plugins/gcpu/";
	QString cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/line.png";
	QFile a(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"line.png";
	}
	
	QPixmap Pixmap;
	// copying background
	
	Pixmap.load(::locate("data",cpuPaths));
	cpuPaths=IconsPath;
	cpuPaths=cpuPaths+"/empty.png";
	a.setName(cpuPaths);
	if(!a.exists() || cpuPaths==QString::null)
	{
		cpuPaths=kdeshare+"empty.png";
	}
	QPixmap Empty;
	Empty.load(::locate("data",cpuPaths));
	
	// sliding the buffer
	//QPixmap	offScreen(128,128);
	QPixmap	offScreen=BasePixmap;
	QPixmap	offScreen2(128,128);
	//offScreen.fill(Qt::black);
	offScreen2.fill(Qt::black);
	QBitmap	maskera(128,128);
	maskera.fill(Qt::color0);
	// the base monitor
	//bitBlt(&offScreen,0,0,&BasePixmap,Qt::CopyROP);
	//offScreen=BasePixmap;
	// the green layout
	// moving to right
	bitBlt(&offScreen2,13+Pixmap.size().width(),15,&BufferPixmap,13,15);
	// clean the line with backgrund transparent
	bitBlt(&offScreen2,13,15,&Empty);
	// draw the percentage
	bitBlt(&offScreen2,13,115-nPercentage,&Pixmap,0,100-nPercentage,Pixmap.size().width(),nPercentage);
	// draw to the layout
	bitBlt(&BufferPixmap,0,0,&offScreen2,0,0,BasePixmap.size().width()-13);
	//bitBlt(&maskera,0,0,&BufferPixmap,0,0,BasePixmap.size().width()-13);
	
	//BufferPixmap.setMask(maskera);
/*	
	
	offScreen.setMask(offScreen.createHeuristicMask());
*/	
	BufferPixmap.setMask(BufferPixmap.createHeuristicMask());
	
	bitBlt(&offScreen,0,0,&BufferPixmap);
	*xImgSource=offScreen.convertToImage();
}


/*!
    \fn GCpu::xApplyCfg()
 */
void GCpu::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker");
	}
	BasePixmap.convertFromImage(*xImgSource);
	loadImages();
	lastValue=-1;
}



/*!
    \fn GCpu::updateCpu(CpuData &cpu, int cpuNumber)
 */
void GCpu::updateCpu(CpuData &cpu, int cpuNumber)
{
#ifdef Q_OS_LINUX
  if (!m_procStream)
    return;

  bool cpuFound = false;
  QString output;
  QString parser;
  QString cpuString;
  cpuString.setNum(cpuNumber).prepend("cpu");

  // Parse the proc file
  while (!m_procStream->atEnd()) {
    parser = m_procStream->readLine();
    // remove all the entries apart from the line containing 'cpuString'
    if (!cpuFound && parser.find(QRegExp(cpuString)) != -1) {
      output = parser;
      cpuFound = true;
    }
  }

  QStringList cpuList = QStringList::split(' ', output);

  if (!cpuList.isEmpty()) {
    cpu.name = cpuList[0].stripWhiteSpace();
    cpu.user = cpuList[1].toULong();
    cpu.nice = cpuList[2].toULong();
    cpu.sys = cpuList[3].toULong();
    cpu.idle = cpuList[4].toULong();
  }

  fseek(m_procFile, 0L, SEEK_SET);
#endif

#ifdef Q_OS_FREEBSD
#warning "add support for SMP on FreeBSD"
  static int name2oid[2] = { 0, 3 };
  static int oidCpuTime[CTL_MAXNAME + 2];
  static size_t oidCpuTimeLen = sizeof(oidCpuTime);
  long cpuTime[CPUSTATES];
  size_t cpuTimeLen = sizeof(cpuTime);
  static char *name = "kern.cp_time";
  static int initialized = 0;

  if (!initialized) {
    if (sysctl(name2oid, 2, oidCpuTime, &oidCpuTimeLen,
       name, strlen(name)) < 0)
      return;

    oidCpuTimeLen /= sizeof(int);
    initialized = 1;
  }

  if (sysctl(oidCpuTime, oidCpuTimeLen,
     cpuTime, &cpuTimeLen, 0, 0) < 0)
    return;

  cpu.user = cpuTime[CP_USER];
  cpu.nice = cpuTime[CP_NICE];
  cpu.sys = cpuTime[CP_SYS];
  cpu.idle = cpuTime[CP_IDLE];
#endif

#if defined(Q_OS_OPENBSD) || defined(Q_OS_NETBSD)
#warning "add support for SMP on OpenBSD and NetBSD"
  int name2oid[2] = { CTL_KERN, KERN_CPTIME };
  long cpuTime[CPUSTATES];
  unsigned int cpuTimeLen = sizeof(cpuTime);

  if (sysctl(name2oid, 2, &cpuTime, &cpuTimeLen,
     0, 0) < 0)
    return;

  cpu.user = cpuTime[CP_USER];
  cpu.nice = cpuTime[CP_NICE];
  cpu.sys = cpuTime[CP_SYS];
  cpu.idle = cpuTime[CP_IDLE];
#endif
}
