/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gclock.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>

#include <string.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <krun.h>
#include <qtimer.h>
#include <qdatetime.h>

#include "gpluginpainter.h"


#include "gclock.moc"



extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("GAmarok xeplugin_register()");
	return new GClock(parent,"GClock");
}



GClock::GClock(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{

	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.1";
	// Project name
	PluginInformations.append("KXDocker GClock");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20050917");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gclock");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gclock");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	IconsPath="kxdocker/plugins/gclock/";
	iMiniText=1;
	ita=1;
}

GClock::~GClock()
{

}

void GClock::xSetupParameter(const QString vname, const QString vvalue)
{

	if(vname=="themepath")
	{
		IconsPath=vvalue;
	}
	bool okRet=false;
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;
		ToolTip2="";
	}
	if(vname=="italian")
	{
		ita=vvalue.toInt(&okRet);
		if(okRet==false)ita=1;
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{

		xXMLIconConfig->item(0).toElement().setAttribute("themepath",IconsPath);
		xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		xXMLIconConfig->item(0).toElement().setAttribute("italian",ita);

	}
	else
	{
		createXMLTree();
	}
	gPluginSDK::xSetupParameter(vname,vvalue);

	// update the resources
	loadResources(IconsPath);
	lastValue=-1;
	xRefreshIcon(xGIcon);
}

void GClock::xGetParameter(const QString vname, QString&vvalue)
{

	if(vname=="themepath")
	{
		vvalue=IconsPath;
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	if(vname=="italian")
	{
		vvalue.setNum(ita);
	}
	gPluginSDK::xGetParameter(vname, vvalue);

}
void GClock::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("minitext");
	a->append("italian");

	gPluginSDK::xGetParameterList(a);
}


void GClock::xPaint(int)
{
	//ToolTip=QString("%1 %1 %1 %1").arg(QDate::shortDayName(QDate::currentDate().dayOfWeek ())).arg(QDate::currentDate().day()).arg(QDate::longMonthName (QDate::currentDate().month())).arg(QDate::currentDate().year());

	if(iMiniText>0)ToolTip2="";
	char filename[30];
	sprintf(filename,"%d:%02d %d/%d/%d",
		QTime::currentTime().hour(),
		QTime::currentTime().minute(),
		QDate::currentDate().month(),
		QDate::currentDate().day(),
		QDate::currentDate().year()
		);
	ToolTip=filename;
	switch(iMiniText)
	{
		case 1:
			ToolTip2=QDate::shortDayName(QDate::currentDate().dayOfWeek ());
		break;
		case 2:
			ToolTip2=QDate::longDayName(QDate::currentDate().dayOfWeek ());
		break;
		case 3:
			if(ita==0)sprintf(filename,"%02d/%02d/%04d",QDate::currentDate().month(),QDate::currentDate().day(),QDate::currentDate().year());
			else sprintf(filename,"%02d/%02d/%04d",QDate::currentDate().day(),QDate::currentDate().month(),QDate::currentDate().year());
			ToolTip2=filename;
		break;
		case 4:
			if(ita==0)sprintf(filename,"%d-%02d",QDate::currentDate().month(),QDate::currentDate().day());
			else sprintf(filename,"%d-%02d",QDate::currentDate().day(),QDate::currentDate().month());
			ToolTip2=filename;
		break;
		case 5:
			ToolTip2=QDate::currentDate().day();
		break;
		case 6:
			ToolTip2=QDate::currentDate().month();
		break;
	}





	*xImgSource=bufferImage;
	
}


void GClock::polling()
{

	if(isStopped){
		qWarning("void GClock::polling() exiting...");
		return;
	}
	oldPaint();
	Value++;
	xRefreshIcon(xGIcon);

	QTimer::singleShot(1000+ 60*1000*(60-QTime::currentTime().minute()), this, SLOT(polling()) );
	//QTimer::singleShot(10000, this, SLOT(polling()));
}


void GClock::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{

		IconsPath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gclock/");
		if(IconsPath=="")IconsPath="kxdocker/plugins/gclock/";
		QString vvalue=xXMLIconConfig->item(0).toElement().attribute("minitext","1");
		bool okRet=false;
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;
		vvalue=xXMLIconConfig->item(0).toElement().attribute("ita","1");
		ita=vvalue.toInt(&okRet);
		if(okRet==false)ita=1;
	}
	Original=*xImgSource;
	// to enable the first pass
	lastValue=-1;
	// update the resources
	loadResources(IconsPath);
}


void GClock::xStop()
{

	gPluginSDK::xStop();

}


void GClock::xStart()
{


	gPluginSDK::xStart();
}


void GClock::loadResources(const QString)
{
	oldPaint();
}

/*!
    \fn GClock::oldPaint()
 */
void GClock::oldPaint()
{
/**********************************************************/



	// 0.29
	// GClock is a DIGITAL clock not analog....
	// check out the new GAClock for analog themes
	if(xGIcon==NULL)return;
	
	QString ClockPaths=IconsPath;
	ClockPaths=ClockPaths+"/clock.png";
	QFile a(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gclock/clock.png";
	}
	QPixmap Pixmap;
	Pixmap.load(::locate("data",ClockPaths));
	bufferImage=Pixmap.convertToImage();
	
	char filename[50];
	
	// 0.29
	// GClock is a DIGITAL clock not analog....
	sprintf(filename,"gclock_h%d.png",(QTime::currentTime().hour()));
	
	ClockPaths=IconsPath;
	ClockPaths=ClockPaths+"/"+filename;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gclock/";
		ClockPaths=ClockPaths+filename;
		a.setName(ClockPaths);
		if(!a.exists() || ClockPaths==QString::null)
		{
			//sprintf(filename,"gclock_h%d.png",QTime::currentTime().hour());
			ClockPaths=IconsPath;
			ClockPaths=ClockPaths+"/"+filename;
			a.setName(ClockPaths);
			
			if(!a.exists() || ClockPaths==QString::null)
			{
				ClockPaths="kxdocker/plugins/gclock/";
				ClockPaths=ClockPaths+filename;
				a.setName(ClockPaths);
				if(!a.exists() || ClockPaths==QString::null)
				{
					//sprintf(filename,"gclock_h%d.png",QTime::currentTime().hour());
					ClockPaths="kxdocker/plugins/gclock/";
					ClockPaths=ClockPaths+filename;
				}
			}
		}
	}
	
	//qWarning(ClockPaths);
	Pixmap.load(::locate("data",ClockPaths));
	
	
	QImage iPixmap=Pixmap.convertToImage();
	bitBlt(&bufferImage,0,0,&iPixmap,0,Qt::CopyROP);
	
	ClockPaths="kxdocker/plugins/gclock/";
	////////////////////////////////////
	sprintf(filename,"gclock_m%d.png",QTime::currentTime().minute());
	ClockPaths=IconsPath;
	ClockPaths=ClockPaths+"/"+filename;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gclock/";
		ClockPaths=ClockPaths+filename;
	}
	//qWarning(ClockPaths);
	Pixmap.load(::locate("data",ClockPaths));
	
	iPixmap=Pixmap.convertToImage();
	bitBlt(&bufferImage,0,0,&iPixmap,0,Qt::CopyROP);
	
	ClockPaths="kxdocker/plugins/gclock/";
	sprintf(filename,"gclock_c%d.png",QDate::currentDate().day());
	ClockPaths=IconsPath;
	ClockPaths=ClockPaths+"/"+filename;
	a.setName(ClockPaths);
	
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gclock/";
		ClockPaths=ClockPaths+filename;
	}
	//qWarning(ClockPaths);
	Pixmap.load(::locate("data",ClockPaths));
	
	iPixmap=Pixmap.convertToImage();
	bitBlt(&bufferImage,0,0,&iPixmap,0,Qt::CopyROP);
	
/************************************************************/



}

