/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GBATTERY_H
#define XEPLUGIN_GBATTERY_H

#include <qobject.h>
#include <libkxdocker.h>
#include <kiconloader.h>
#include <qimage.h>

struct GBatteryTheme
{
	QString battery_none;
	QString battery_ac;
	QString battery_full;
	QString battery_plug_full;
	QString battery_plug_over;
	QString battery_plug_back;
	QString battery_plug_top;
	QString battery_plug_middle;
	QString battery_plug_empty;
	QString battery_prefix;
	QString battery_prefix_plug;
	QString battery_empty;
	QString battery_back;
	QString battery_over;
	QString battery_top;
	QString battery_middle;

	QImage img_battery_none;
	QImage img_battery_ac;
	QImage img_battery_full;
	QImage img_battery_plug_full;
	QImage img_battery_plug_over;
	QImage img_battery_plug_back;
	QImage img_battery_plug_top;
	QImage img_battery_plug_middle;
	QImage img_battery_prefix;
	QImage img_battery_prefix_plug;
	QImage img_battery_back;
	QImage img_battery_over;
	QImage img_battery_top;
	QImage img_battery_middle;
	QImage img_battery_empty;
	QImage img_battery_plug_empty;

	int align;
	int xbase;
	int ybase;
};

class GBattery : public gPluginSDK
{
  Q_OBJECT
public:
	GBattery(QObject *parent = 0, const char *name = 0);
	~GBattery();
	QObject *   Respawn(QObject *);
public slots:
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xPaint(int);
    virtual void polling();
    virtual void xApplyCfg();
    virtual void dirty(int, int);
    virtual void xStop();
    virtual void xStart();
    void pollingAnimation();


protected:
	void loadResources(const QString newPath);
	void managePopUp();

	int lastAC, lastB;
	/*
	gPluginPainter *Painter;
	QImage *PainterGauge;
	QImage *PainterTop;
	QImage *PainterBG;
	QImage Pixmap;
	//gPluginPainter *PainterBottom;
	//gPluginPainter *PainterBG;
	int	ThemeYMinTop;
	int	ThemeYMaxTop;
	*/

	QImage ImageBuffer;
	
	int lastAnimationStep;
	class QTimer	*Animator;
	int iMiniText;
	QString themepath;
	QString iconName;
	QString tryFindIcon(int,QString,QString);
	void loadOldTheme(int,int);
	//int loadNewTheme(int,int);
	GBatteryTheme bTheme;
	void gb08LoadNewTheme(const QString &);
	int gb08Paint(int,int);
protected:
    void gb08LoadImage(QImage &, const QString &,const QString &);
};


#endif
