/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gbattery.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>

#include <string.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include "portable.h"

#include "portable.cpp"


#include <krun.h>
#include <qtimer.h>


#include "gpluginpainter.h"


#include "gbattery.moc"



extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("GAmarok xeplugin_register()");
	return new GBattery(parent,"GBattery");
}



GBattery::GBattery(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{

	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.6";
	// Project name
	PluginInformations.append("KXDocker GBattery");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20050828");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gbattery");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gbattery");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	//int IconSize=128;

	PainterTop=new QPixmap();
	PainterGauge=new QPixmap();
	PainterBG=new QPixmap();


	themepath="kxdocker/plugins/gbattery/";

	lastAnimationStep=0;
	ThemeYMinTop=90;
	ThemeYMaxTop=30;
	Animator=new QTimer();
	connect(Animator, SIGNAL(timeout()),this,SLOT(pollingAnimation()));
	iMiniText=1;
}

GBattery::~GBattery()
{

}

void GBattery::xSetupParameter(const QString vname, const QString vvalue)
{

	if(vname=="themepath")
	{
		themepath=vvalue;
	}
	bool okRet=false;
	if(vname=="minitext")
	{
		iMiniText=vvalue.toInt(&okRet);
		if(okRet==false)iMiniText=1;

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("minitext",iMiniText);
		}
		ToolTip2="";
		lastValue=-1;
		xRefreshIcon(xGIcon);
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{

		xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);

	}
	else
	{
		createXMLTree();
	}
	gPluginSDK::xSetupParameter(vname,vvalue);
	
	
	// update the resources
	loadResources(themepath);

	// restart the polling
	//if(ShowGauge=="yes")QTimer::singleShot(30000, this, SLOT(polling()));
	//dirty("");

}

void GBattery::xGetParameter(const QString vname, QString&vvalue)
{

	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	if(vname=="minitext")
	{
		vvalue.setNum(iMiniText);
	}
	gPluginSDK::xGetParameter(vname, vvalue);

}
void GBattery::xGetParameterList(QStringList *a)
{

	a->append("themepath");
	a->append("minitext");
	gPluginSDK::xGetParameterList(a);
}


void GBattery::xPaint(int)
{
	if(lastAnimationStep==0)
	{
		Pixmap.load(iconName);
	}
	*xImgSource=Pixmap.convertToImage();
	
}


void GBattery::polling()
{

	if(isStopped){
		qWarning("void GBattery::polling() exiting...");
		return;
	}

	//qWarning("void GBattery::polling()");
	if(laptop_portable::has_power_management())
	{
		int num_batteries;
		QStringList names;
		QStringList state;
		QStringList values;
		laptop_portable::get_battery_status(num_batteries, names, state, values);
		struct power_result binfo=laptop_portable::poll_battery_state();
		//int ac=laptop_portable::get_acpi_ac();
		int ac=binfo.powered;
		//ToolTip="Monitoring...";
		if(iMiniText==1)ToolTip2="";
		if(ac>0)
		{
			// external power
			//TODO: plugged without battery
			if(binfo.percentage>0)ToolTip=QString("Charging... (%1%)").arg(binfo.percentage);
			else ToolTip="AC On-line";
			if(iMiniText==1)ToolTip2=QString("%1%").arg(binfo.percentage);
			if(iMiniText==2)ToolTip2="";
			dirty(1,binfo.percentage);
			// we have to check if it's charging
		}
		else
		{
			if(num_batteries<1)return;
			if(iMiniText==1)ToolTip2=QString("%1%").arg(binfo.percentage);
			if(binfo.time>0)
			{
			int h=binfo.time/60;
			int m=binfo.time-h*60;
			char stringa[50];
			sprintf(stringa,"%02d:%02d",h,m);
			ToolTip=QString("%1: %1 left (%1%)").arg(names[0]).arg(stringa).arg(values[0]);
				if(iMiniText==2)ToolTip2=QString("%1:%1").arg(h).arg(m);
			}
			else
			{
				ToolTip=QString("%1: (%1%)").arg(names[0]).arg(values[0]);
				if(iMiniText>0)ToolTip2=QString("%1%").arg(values[0]);
			}
			dirty(0,binfo.percentage);
		}
		//xRefresh();
		QTimer::singleShot( 10*1000, this, SLOT(polling()));
	}
	else
	{
		// you dont have ACPI installed than we can put a plug?
		ToolTip="AC On-line";
		if(iMiniText==1)ToolTip2="";
		dirty(1,-1);

		// i don't want update more
	}



	//QTimer::singleShot(10000, this, SLOT(polling()));
}


void GBattery::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{

		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gbattery/");

	}
	// to enable the first pass
	lastValue=-1;
	// update the resources
	loadResources(themepath);

	//dirty("");
}


void GBattery::dirty(int AC, int B)
{

	Animator->stop();

	if(isStopped){
		qWarning("void GBattery::dirty exiting...");
		return;
	}

	//qWarning(QString("void GBattery::dirty(%1, %1)").arg(AC).arg(B));

	if(lastAC==AC and lastB == B and lastAnimationStep==0)return;
	if(lastAC!=AC || lastB != B)
	{
		lastAC=AC;
		lastB=B;
		lastAnimationStep=0;
	
	
		if(!loadNewTheme(AC,B))
		{
			loadOldTheme(AC,B);
			if(iconName==NULL or iconName.isEmpty())return;
		}
	}
	else
	{
		// animate it
		if(AC>0)
		{
			if(B<=lastAnimationStep)lastAnimationStep=1;

			if(!loadNewTheme(AC,lastAnimationStep))
			{
				lastAnimationStep=0;
				return;
			}
			//QTimer::singleShot( 300, this, SLOT(pollingAnimation()));
			Animator->start(250);
		}
	}
	Value=AC*100+B+lastAnimationStep*1000;
	xRefreshIcon(xGIcon);
}


void GBattery::xStop()
{

	gPluginSDK::xStop();

}


void GBattery::xStart()
{


	gPluginSDK::xStart();
}


void GBattery::loadResources(const QString)
{
}


/*!
    \fn GBattery::managePopUp(int)
 */
void GBattery::managePopUp()
{
	PluginPopupMenu->clear();
}



QString GBattery::tryFindIcon(int AC ,QString B, QString themePath)
{
	// search for theme/c95.png
	QString basePath=themePath+"/";
//qWarning(B);
	QString batteryPaths=B;
	//batteryPaths.setNum(B);
	if(AC>0)
	{
	batteryPaths="c"+batteryPaths;
	}
	else
	{
	
	}
	batteryPaths=basePath+batteryPaths;
	batteryPaths=batteryPaths+".png";
	
	batteryPaths=::locate("data",batteryPaths);
//qWarning(batteryPaths);
	QFile a(batteryPaths);
	//qWarning(QString("Alimentazione: %1 %1 %1 %1").arg(AC).arg(B).arg(themePath).arg(batteryPaths));
	if(!a.exists() || batteryPaths==QString::null)
	{
		return NULL;
	}
	return batteryPaths;	
}


/*!
    \fn GBattery::loadOldTheme(int, int)
 */
void GBattery::loadOldTheme(int AC, int B)
{
	// base Image
	IconsPath=themepath+"/";
	QString kdeshare="kxdocker/plugins/gbattery/";
	QString batteryPaths=IconsPath;
	batteryPaths=batteryPaths+"/0.png";
	QFile a(batteryPaths);
	if(!a.exists() || batteryPaths==QString::null)
	{
		batteryPaths=kdeshare+"na.png";
	}
	QPixmap Pixmap;
	Pixmap.load(::locate("data",batteryPaths));
	// TODO!!
	if(!Pixmap.isNull())*xImgSource=Pixmap.convertToImage();
	QString Bstring;
	iconName="";
	// ACOnline without battery
	if(AC>0 && B<1)
	{
		//iconName=tryFindIcon(0,"charged",IconsPath);
		//if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",kdeshare);
	}

	// try theme c98.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),IconsPath);
	// try theme c9.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),IconsPath);
	// try kde c98.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),kdeshare);
	// try kde c9.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),kdeshare);
	// try >8 
	if(iconName==NULL or iconName.isEmpty())
	{
		if(B>80)
		{
			if(AC>0)
			{
				iconName=tryFindIcon(0,"charged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_plugged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_plugged",kdeshare);
			}
			else 
			{
				B=80;
			}
		}
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),IconsPath);
		// try kde c98.png
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),kdeshare);
		// try kde c9.png
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),kdeshare);

		
		if(B>=70)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_full",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_full",kdeshare);
		}
		if(B<70 && B>40)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_two_thirds",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_two_thirds",kdeshare);
		}
		if(B<40 && B>10)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_low",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_low",kdeshare);
		}
		if(B<10 && B>0)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_empty",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_empty",kdeshare);
		}
		if(B<=0)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",kdeshare);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"na",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"na",kdeshare);
		}
		
		
	}

}


/*!
    \fn GBattery::locadNewTheme(int,int)
 */
int GBattery::loadNewTheme(int AC,int B)
{
	//qWarning("int GBattery::loadNewTheme(int AC,int B)");
	QString FileName;
	QString endFileName;
	QFile a;
	// searching for new themes

	if(B>99)
	{
		//qWarning(QString("if(B>100)"));
		return 0;
	}
	if(B<0)
	{
		//qWarning(QString("if(B<0)"));
		return 0;
	}

	if(B==0)
	{
		//qWarning(QString("if(B=0)"));
		//return 0;
	}


	if(B>0)endFileName=QString("bg%1.png").arg(1);
	else endFileName=QString("bg%1.png").arg(0);

	//
	if(AC==0)FileName=themepath+"/battery_analog_";
	else FileName=themepath+"/battery_analog_plug_";

	FileName=FileName+endFileName;

	FileName=::locate("data",FileName);

	a.setName(FileName);
	if(!a.exists() || FileName==QString::null)
	{
		// old theme format
		return 0;
	}
	Pixmap.load(FileName);
	//qWarning(QString("Pixmap.load(FileName=%1);").arg(FileName));
	//PainterBG->load(FileName);
	if(B>0)
	{

		if(AC==0)FileName=themepath+"/battery_analog_gauge.png";
		else FileName=themepath+"/battery_analog_plug_gauge.png";

		FileName=::locate("data",FileName);
		a.setName(FileName);
		if(!a.exists() || FileName==QString::null)return 0;
		else PainterGauge->load(FileName);
		//
		if(AC==0)FileName=themepath+"/battery_analog_level.png";
		else FileName=themepath+"/battery_analog_plug_level.png";
		FileName=::locate("data",FileName);
		a.setName(FileName);
		if(!a.exists() || FileName==QString::null)return 0;
		else PainterTop->load(FileName);
		//
		if(AC==0)FileName=themepath+"/battery_analog_fg.png";
		else FileName=themepath+"/battery_analog_plug_fg.png";
		FileName=::locate("data",FileName);
		a.setName(FileName);
		if(!a.exists() || FileName==QString::null)return 0;
		else PainterBG->load(FileName);
		//
		int dy=Pixmap.width()-PainterGauge->width();
		dy=dy+ThemeYMinTop;
		double k=ThemeYMinTop-ThemeYMaxTop;
		k=k/(double)100;
		int dy0=dy-(int)k*B;
		bitBlt(&Pixmap,0,dy0,PainterGauge,0,dy0,PainterGauge->width(),dy);
		bitBlt(&Pixmap,0,dy0-PainterTop->height()/2,PainterTop,0,0);
		bitBlt(&Pixmap,0,0,PainterBG,0,0);

		//qWarning(QString("bitBlt(&Pixmap,0,dy0-PainterTop->height()/2,PainterTop,0,0); %1").arg(dy0));
	}

	// enable new themes
	lastAnimationStep++;

	return lastAnimationStep;
}


/*!
    \fn GBattery::pollingAnimation()
 */
void GBattery::pollingAnimation()
{
	dirty(lastAC,lastB);
}
