/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <xeplugin_gapager.h>
#include "xeplugin_gapager.moc"

#include <wmconfigurationwindow.h>


#include <kstandarddirs.h>
#include <klocale.h>
#include <kglobalsettings.h> 
#include <qimage.h>
#include <qstring.h>
#include <qdatetime.h>
#include <qtimer.h>
#include <qfile.h>

#include <krootpixmap.h>
#include <kstandarddirs.h>
#include <kwinmodule.h>
#include <netwm.h>

#include <qpainter.h>
#include <qdrawutil.h>
#include <qlineedit.h>
#include <qbitmap.h>
#include <dcopclient.h>
#include <qtimer.h>
#include <stdlib.h>





extern "C" QObject *xeplugin_register(QObject *parent)
{
	//qWarning("QObject *xeplugin_register(QObject *parent)");
	return new GAPager(parent,"GAPager");
}



GAPager::GAPager(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{
	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.6";
	// Project name
	PluginInformations.append("KXDocker GAPager");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20060121");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gapager");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gapager");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	
	/* custom */
	KDEWM=NULL;
	active=0;
	nRows=2;
	nCols=2;
	desktopPreview=1;
	transparency = 128;
	iconSize=128;
	
	bgcolor=QColor(128,(int)(drand48()*256),(int)(drand48()*256));
	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);
}

GAPager::~GAPager()
{
	// 0.40 check if already attached...
	XEObject::xPluginDel(this);
}

void GAPager::xSetupParameter(const QString vname, const QString vvalue)
{
/***************************************/
	if(vname=="desktopPreview")
	{
		bool okRet=false;
		desktopPreview=vvalue.toInt(&okRet);
		if(okRet==false)
		{
			desktopPreview=0;
		}
	}
	gPluginSDK::xSetupParameter(vname,vvalue);
/***************************************/
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("desktopPreview",desktopPreview);
	}
	else
	{
		createXMLTree();
	}
}

void GAPager::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="desktopPreview")vvalue.setNum(desktopPreview);
	gPluginSDK::xGetParameter(vname,vvalue);
}
void GAPager::xGetParameterList(QStringList *a)
{
	a->append("desktopPreview");
	gPluginSDK::xGetParameterList(a);
}

void GAPager::xPaint(int)
{
	//qWarning("void GAPager::xPaint(int newValue)");
	*xImgSource = paintBuffer;
}

void GAPager::polling()
{
	if(isStopped){
		return;
	}
	

	//qWarning("void GAPager::polling()");
	/* Started only the first time */
	/* May be used to be called by timer since it's a slot*/
	Value++;
	xRefresh();
/*
	QTimer::singleShot(1000, this, SLOT(polling()));
*/
}

void GAPager::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
		bool okRet=false;
		QString sOk=xXMLIconConfig->item(0).toElement().attribute("desktopPreview","0");
		desktopPreview=sOk.toInt(&okRet);
		
		if(okRet==false)
		{
			desktopPreview=0;
		}
	}
	// to enable the first pass
	//lastValue=-1;
}


void GAPager::xStart()
{
	/* setup */
	// todo may be wrong setting Icon size = 128
	//qWarning("void GAPager::xStart()");
	paintBuffer=QImage(iconSize,iconSize,32);
	paintBuffer.fill(Qt::black.pixel());
	paintBuffer.setAlphaBuffer(true);
	pixmapBackground.resize(iconSize,iconSize);
	pixmapBackground.fill(Qt::black);
	
	vd[0].load(::locate("data","kxdocker/themes/bar/virtual_desktop.png"));
	vd[1].load(::locate("data","kxdocker/themes/bar/virtual_desktop_active.png"));
	if(vd[0].isNull())
	{
		QImage TBuffer;
		// we cannot load the pillow than we create a fully transparent image
		TBuffer.create(
			24,
			21,
			32);
		TBuffer.setAlphaBuffer(false);
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		vd[0] = TBuffer;
		vd[0].detach();
	}
	if(vd[1].isNull())
	{
		QImage TBuffer;
		// we cannot load the pillow than we create a fully transparent image
		TBuffer.create(
			24,
			21,
			32);
		TBuffer.setAlphaBuffer(false);
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		vd[1]=TBuffer;
		vd[1].detach();
	}
	if(KDEWM==NULL)
	{
		KDEWM=new KWinModule();
		active = KDEWM->activeWindow();
		connect( KDEWM, SIGNAL( activeWindowChanged(WId)), SLOT( slotActiveWindowChanged(WId) ) );
    		connect( KDEWM, SIGNAL( windowAdded(WId) ), this, SLOT( slotWindowAdded(WId) ) );
    		connect( KDEWM, SIGNAL( windowRemoved(WId) ), this, SLOT( slotWindowRemoved(WId) ) );
    		connect( KDEWM, SIGNAL( windowChanged(WId,unsigned int) ), this, SLOT( slotWindowChanged(WId,unsigned int) ) );
    		connect( KDEWM, SIGNAL( stackingOrderChanged() ), this, SLOT( slotStackingOrderChanged() ) );
	for(
		QValueList<WId>::ConstIterator it = KDEWM->windows().begin();
		it !=KDEWM->windows().end();
		++it)
		{
			slotWindowAdded( *it );
		}
		connect(KDEWM,SIGNAL(currentDesktopChanged(int)),this,SLOT(currentDesktopChanged(int)));
	}
	
	// by default we use 2 rows
	//nRows=2;
	if(nRows<1)nRows=1;
	nCols=(KDEWM->numberOfDesktops()/nRows);
	if((KDEWM->numberOfDesktops()%nRows)>0)nCols++;
	if(nCols>nRows)
	{
		nRows=nCols;
		nCols=(KDEWM->numberOfDesktops()/nRows);
		if((KDEWM->numberOfDesktops()%nRows)>0)nCols++;
	}
	//paintBuffer.scale(iconSize/2*nCols,iconSize/2*nRows);
	//resize(vd[0].width()*ncols,vd[0].height()*nRows);

	/* end setup */
	// TODO: resources must be released on xStop



	lastDesktop=KDEWM->currentDesktop();
	xUpdate();
	
	//show();
	/* this will call polling after 1 second */
	gPluginSDK::xStart();
	// 0.40
	if(ConfigurationWindow==NULL)
	{
		ConfigurationWindow=new WMConfigurationWindow(this);
	}
}


/******************************************************************************/
/* code From Saurabh */
/* 15 Mar 2005 */
/* Many thanks to Saurabh */


/*!
    \fn XEPlugin_GAPager::backgroundUpdated(const QPixmap &)
 */
void GAPager::backgroundUpdated(const QPixmap &pb)
{
	pixmapBackground=pb;
	xUpdate();
	xRefresh();
}


/*!
    \fn XEPlugin_GAPager::xUpdate()
 */
void GAPager::xUpdate()
{
	//qWarning("void GAPager::xUpdate()");
	//paintBuffer=pixmapBackground;
	int dy=0;
	int nd=0;
	int dx=0;
	//nCols=(KDEWM->numberOfDesktops()/nRows);
	
	//QBitmap paintMask = *(paintBuffer.mask());
	for(int k=0;k<nRows;k++)
	{
		for(int i=0;i<nCols;i++)
		{
			dy=k*iconSize/2;
			dx=i*iconSize/2;
			if (desktopPreview) {
			QImage desk;
			desk=paintDesktop(nd+1,iconSize/2,iconSize/2,lastDesktop==nd+1);
			bitBlt(&paintBuffer,dx,dy,&desk, 0,0,-1,-1);
			//bitBlt(&paintMask,dx,dy,desk.mask(), 0,0,-1,-1,Qt::CopyROP,TRUE);
			} else {
			if(lastDesktop==nd+1) bitBlt(&paintBuffer,dx,dy,&vd[0]);
			else bitBlt(&paintBuffer,dx,dy,&vd[1]);
			}
			nd++;
			if(KDEWM->numberOfDesktops()<nd)return;
		}
	}
	//paintBuffer.setMask(paintMask);
	int w = paintBuffer.width();
	int h = paintBuffer.height();
	for (int i=0;i<w;i++)
		for (int j=0;j<h;j++) {
			QRgb p = paintBuffer.pixel(i,j);
			if (i && j && i != w/2 && j != h/2 && i != w-1 && j != h-1)
			paintBuffer.setPixel(i,j,qRgba(qRed(p),qGreen(p),qBlue(p),transparency));
		}
}


/*!
    \fn XEPlugin_GAPager::currentDesktopChanged(int)
 */
void GAPager::currentDesktopChanged(int Desktop)
{
	if(lastDesktop!=Desktop)
	{
		lastDesktop=Desktop;
		xUpdate();
		bgcolor=QColor((int)(drand48()*256),(int)(drand48()*256),(int)(drand48()*256));
	}
	xRefresh();
	
}



#ifdef FocusOut
#undef FocusOut
#endif

QPixmap GAPager::paintDesktop(int deskNum, int width, int height,bool curr)
{
    QPainter p;
    QPixmap pf( width, height );
    int transparent=0;


    // the following breaks dark color schemes
    QWidget *qxGDocker=(QWidget *)xGDocker;
    QBrush bg;
    if (curr) bg = QBrush(bgcolor);
    else bg = qxGDocker->colorGroup().brush( QColorGroup::Base );
    //setBackgroundOrigin( AncestorOrigin );
    QColor fg =( transparent) ? qxGDocker->colorGroup().base() : qxGDocker->colorGroup().text();

    if ( desktopPreview ) {
	QPixmap pm( width , height );
	QBitmap pmask( pm.size(), true /*clear*/ );
	//if (pm.isNull() || pmask.isNull()) return pm;
	QPainter pp( &pm );
	QPainter pmaskp( &pmask );

	if( ! transparent )
	    pp.fillRect( pm.rect(), bg );
	pp.setPen(fg);
	int dw = QApplication::desktop()->width();
	int dh = QApplication::desktop()->height();
	QValueList<WId>::ConstIterator it;
	// SELI this needs checking for kwin_iii
	for ( it = KDEWM->stackingOrder().begin();
	      it != KDEWM->stackingOrder().end(); ++it )
        {
	    KWin::WindowInfo* info = this->info( *it );

	    if ( info &&
                 info->windowType( NET::NormalMask | NET::DesktopMask | NET::DockMask
	            | NET::ToolbarMask | NET::MenuMask | NET::DialogMask | NET::OverrideMask
	            | NET::TopMenuMask | NET::UtilityMask | NET::SplashMask ) != NET::Desktop &&
                 !info->isMinimized() &&
                 (info->onAllDesktops() || info->desktop() == deskNum ) &&
                 !(info->state() & NET::SkipPager || info->state() & NET::Shaded ) )
            {
		QRect r =  info->frameGeometry();
		r = QRect( r.x() * pm.width() / dw, 2 + r.y() * pm.height() / dh,
			   r.width() * pm.width() / dw, r.height() * pm.height() / dh );
		if ( KDEWM->activeWindow() == (*it) ) {
		    qDrawShadeRect( &pp, r, qxGDocker->colorGroup(), false, 1, 0, &qxGDocker->colorGroup().brush( QColorGroup::Highlight ) );
		} else {
		    pp.fillRect( r, qxGDocker->colorGroup().brush(  QColorGroup::Button ) );
		    qDrawShadeRect( &pp, r, qxGDocker->colorGroup(), true, 1, 0 );
		}
		if( transparent )
		    pmaskp.fillRect( r, color1 );
	    }
	}
	pp.end();
	pmaskp.end();
	if( transparent )
	{
	    pm.setMask( pmask );
	}
	return pm;
	p.begin( &pf );
	p.drawPixmap( 1, 1, pm );
    } else {
	p.begin( &pf );
	//if( ! transparent )
	    //p.fillRect( rect(), bg );
    }

    p.setPen( fg );

    if( transparent )
	p.setRasterOp( XorROP );

    p.drawRect(QRect(0,0,width,height));
    p.end();
    return pf;
}


void GAPager::slotActiveWindowChanged( WId win )
{
    if ( !desktopPreview )
	return;
    active = win;
	slotRefresh();
}

void GAPager::slotWindowAdded( WId )
{
    if ( !desktopPreview )
	return;
	slotRefresh();
}

void GAPager::slotWindowRemoved( WId win )
{
    if ( !desktopPreview ) {
	windows.remove( win );
	return;
    }
    if (win == active)
        active = 0;

    windows.remove( (long) win );

	    slotRefresh();
}

void GAPager::slotWindowChanged( WId win , unsigned int properties )
{
    if(( properties & ( NET::WMState | NET::XAWMState | NET::WMDesktop )) == 0 )
        return;
    if ( !desktopPreview ) {
	windows.remove( win );
	return;
    }
    windows.remove( (long) win );
	    xUpdate();
	    xRefresh();
}

KWin::WindowInfo* GAPager::info( WId win )
{
    KWin::WindowInfo* info = windows[win];
    if (!info ) {
	info = new KWin::WindowInfo( win,
            NET::WMWindowType | NET::WMState | NET::XAWMState | NET::WMDesktop | NET::WMGeometry | NET::WMKDEFrameStrut, 0 );
	windows.insert( (long) win, info );
    }
    return info;
}

void GAPager::slotStackingOrderChanged()
{
    if ( !desktopPreview )
	return;
    slotRefresh();
}

void GAPager::slotRefresh()
{
	xUpdate();
	xRefresh();
}
/******************************************************************************/


/*!
    \fn GAPager::xEventClick(void *,int,int,int)
 */
void GAPager::xEventClick(void *pIcon,int x,int y,int button,int iconSize)
{
	//qWarning(QString("void GAPager::xEventClick(void *pIcon,int %1,int %1,int %1)").arg(x).arg(y).arg(button));
	if(pIcon!=this->xGIcon)return;
	
	//qWarning("ok it's mine");
	
	int DesktopNum=x/(iconSize/2);
	DesktopNum=DesktopNum+(y/(iconSize/2))*nCols;
	
	// left button
	if(button==1)
	{
		if(DesktopNum+1==KDEWM->currentDesktop())showDesktop();
		else KWin::setCurrentDesktop(DesktopNum+1);
	}
}


/*!
    \fn GAPager::xEnabledClick(int &)
 */
void GAPager::xEnabledClick(int &a)
{
	// this will enable plugin to get Mouseclick
	// kxdocker >= 0.29 will call void GAPager::xEventClick(void *pIcon,int x,int y,int b)
	a=1;
}


/*!
    \fn GAPager::xRefresh()
 */
void GAPager::xRefresh()
{
	if(isStopped){
		return;
	}
	

	/* compatibility for GApplet from kxdocker source*/
	Value++;
	xRefreshIcon(xGIcon);
}


/*!
    \fn GAPager::xStop()
 */
void GAPager::xStop()
{
	gPluginSDK::xStart();
}


/*!
    \fn GAPager::showDesktop()
 */
void GAPager::showDesktop()
{
	for(
		QValueList<WId>::ConstIterator it = KDEWM->windows().begin();
		it !=KDEWM->windows().end();
		++it)
		{
			KWin::iconifyWindow( *it, false );
		}
}


/*!
    \fn GAPager::Respawn(QObject *)
 */
QObject * GAPager::Respawn(QObject *p)
{
	//0.40
	return (QObject *  )new GAPager(p,"GAPager");
}
