//
// C++ Implementation: ganimations
//
// Description: 
//
//
// Author: Stefano <stefano@xiaprojects.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "ganimations.h"
#include "ganimations.moc"



#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <kconfig.h>
#include <kurlrequester.h>
#include <kglobalsettings.h>
#include <klocale.h>

extern "C" QObject *xeplugin_register(QObject *parent)
{
	qWarning("GAnimations xeplugin_register()");
	return new GAnimations(parent,"GAnimations");
}


GAnimations::GAnimations(QObject *parent, const char *name)
 : gPluginSDK(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="Animator";


	// compatibility with 0.29
	QString Version="0.3";
	PluginInformations.append("KXDocker GAnimations");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20050630"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#ganimations");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#ganimations");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1;name=%1").arg(Version).arg(name)); // url update


	AnimationSleep=100;
}



GAnimations::~GAnimations()
{
}




/*!
    \fn GAnimations::xGetParameterList(QStringList *a)
 */
void GAnimations::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	a->append("AnimationSleep");
	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
}






/*!
    \fn GAnimations::xGetParameter(const QString vname, QString&vvalue)
 */
void GAnimations::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=IconsPath;
	}

	if(vname=="AnimationSleep")
	{
		vvalue.setNum(AnimationSleep);
	}

	gPluginSDK::xGetParameter(vname,vvalue);
}



void GAnimations::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("themepath",IconsPath);
		}
		// done in 0.4
		//lastValue=-1;
		loadImages();
		//xRefreshIcon(xGIcon);
	}
	bool okRet=false;

	if(vname=="AnimationSleep")
	{
		AnimationSleep=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			AnimationSleep=100;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("AnimationSleep",AnimationSleep);
		}
	}

	gPluginSDK::xSetupParameter(vname,vvalue);
}

void GAnimations::xStart()
{
	gPluginSDK::xStart();
}


void GAnimations::xStop()
{
	gPluginSDK::xStop();
}


void GAnimations::polling()
{
	if(isStopped){
		return;
	}
	Value++;

	//xSetupParameter("ImageFX_Y_degree",QString("%1").arg(Value));
	//xSetupParameter("ImageFX_Intensity",QString("%1").arg(Value));

	QTimer::singleShot(AnimationSleep, this, SLOT(polling()));
	xRefreshIcon(xGIcon);
}


void GAnimations::loadImages()
{
	KIconLoader KDEIconLoader;
	QString kdeshare="kxdocker/plugins/ganimations/";
	QString iPaths=IconsPath;
	//qWarning(iPaths);
	xFindResource("icon",iPaths);
	//iPaths=::locate("data",iPaths);
	//qWarning(iPaths);
	QFile a(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+IconsPath;
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}

	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
		iPaths=IconsPath;
		BasePixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}
	else
	{/*
		BasePixmap=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	*/
		BasePixmap.load(iPaths);
	}
	// setup image data
	h=BasePixmap.height();
	w=BasePixmap.width();
	qWarning(QString("[%1][%1]").arg(w).arg(h));
	multiImageImage=BasePixmap.convertToImage();

}


void GAnimations::xPaint(int nAnimationStep)
{
	ToolTip=i18n(QString("%1").arg(nAnimationStep));


/************************************/
	if(h==w)
	{
		*xImgSource=multiImageImage;
		return;
	}
	else
	{
		//QPixmap  offScreen;
		QImage offScreen;
		
		if(w>h)
		{
			int maxstep=w/h;
			if(nAnimationStep>=maxstep)nAnimationStep=Value=0;
			offScreen.create(h,h,32);
			offScreen.setAlphaBuffer(false);
			offScreen.fill(0);
			offScreen.setAlphaBuffer(true);
			
			bitBlt(&offScreen,0,0,&multiImageImage,nAnimationStep*h,0,h,h);
		}
		else
		{
			int maxstep=h/w;
			if(nAnimationStep>=maxstep)nAnimationStep=Value=0;
			offScreen.create(w,w,32);
			offScreen.setAlphaBuffer(false);
			offScreen.fill(0);
			offScreen.setAlphaBuffer(true);
			
			bitBlt(&offScreen,0,0,&multiImageImage,0,nAnimationStep*w,w,w);
		}
		*xImgSource=offScreen;
	}
/************************************/

	//*xImgSource=BasePixmap.convertToImage();
}


/*!
    \fn GAnimations::xApplyCfg()
 */
void GAnimations::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker");
	}
	BasePixmap.convertFromImage(*xImgSource);
	loadImages();
	lastValue=-1;
}

