/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_iconconfigurationwindow.h"
#include <krun.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>
#include <qcheckbox.h>


XEPlugin_IconConfigurationWindow::XEPlugin_IconConfigurationWindow(QObject *parent, const char *name)
    :GPluginSDKCfg(0, name)
{
connect(this,SIGNAL(xApplyParameter(const QString, const QString)),parent,SLOT(xSetupParameter(const QString, const QString)));
}


#include "xeplugin_iconconfigurationwindow.moc"


/*!
    \fn XEPlugin_IconConfigurationWindow::xWMSetupParameter(const QString,QString&)
 */
void XEPlugin_IconConfigurationWindow::xSetupParameter(const QString vname,const QString vvalue)
{
	if(vname=="themepath")
	{
		ThemePath->setText(vvalue);
	}
	/*
	bool okRet=false;

	if(vname=="device")
	{
		Device->setCurrentText(vvalue);
	}
	if(vname=="polling")
	{
		Polling->setValue(vvalue.toInt(&okRet));
		if(!okRet)Polling->setValue(1000);
	}
	if(vname=="dotpitch")
	{
		dotPitch->setValue(vvalue.toInt(&okRet));
		if(!okRet)dotPitch->setValue(0);
	}
	if(vname=="drawdirection")
	{
		if(vvalue=="0")invert->setChecked(false);
		else invert->setChecked(true);
	}

	if(vname=="rate_bytes")
	{
		Scale->setValue(vvalue.toInt(&okRet));
		if(!okRet)Scale->setValue(1024);
	}
	if(vname=="minitext")
	{
		int i=vvalue.toInt(&okRet);
		MiniText->setCurrentItem(i);
	}

	if(vname=="mountcmd")
	{
		MountCmd->setCurrentText(vvalue);
	}
	if(vname=="umountcmd")
	{
		uMountCmd->setCurrentText(vvalue);
	}

	if(vname=="showgauge")
	{
		mGauge->setCurrentText(vvalue);
	}
	if(vname=="icon_mounted")
	{
		tMounted->setCurrentText(vvalue);
	}
	if(vname=="icon_unmounted")
	{
		tuMounted->setCurrentText(vvalue);
	}
	*/
	/*
	if(vname=="ImageFX_GrayScale")
	{
		GrayScale->setCurrentText(vvalue);
	}
	if(vname=="ImageFX_X_degree")
	{
		XDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)XDegree->setValue(0);
	}
	if(vname=="ImageFX_Y_degree")
	{
		YDegree->setValue(vvalue.toInt(&okRet));
		if(!okRet)YDegree->setValue(0);
	}
	if(vname=="ImageFX_Intensity")
	{
		Intensity->setValue(vvalue.toInt(&okRet));
		if(!okRet)Intensity->setValue(100);
	}
	*/

}


void XEPlugin_IconConfigurationWindow::pBrowseTheme_clicked()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,"Open KXDocker Plugin Theme Path");
	
	
	if(cfgPath==NULL)
	{
		return;
	}
	
	ThemePath->setText(cfgPath);
}

void XEPlugin_IconConfigurationWindow::pOK_clicked()
{
	xApplyParameter("themepath",ThemePath->text());
	//xApplyParameter("device",Device->currentText());
	/*
	QString stringa;
	xApplyParameter("ImageFX_GrayScale",GrayScale->currentText());
	stringa.setNum(XDegree->value());
	xApplyParameter("ImageFX_X_degree",stringa);
	stringa.setNum(YDegree->value());
	xApplyParameter("ImageFX_Y_degree",stringa);
	stringa.setNum(Intensity->value());
	xApplyParameter("ImageFX_Intensity",stringa);
	*/
	/**************************************/
	/*
	stringa.setNum(Scale->value());
	xApplyParameter("rate_bytes",stringa);
	stringa.setNum(Polling->value());
	xApplyParameter("polling",stringa);
	xApplyParameter("minitext",QString("%1").arg(MiniText->currentItem()));
	stringa.setNum(dotPitch->value());
	xApplyParameter("dotpitch",stringa);
	if(invert->isChecked())xApplyParameter("drawdirection","1");
	else xApplyParameter("drawdirection","0");
	*/
	hide();
}


