/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#include "gamarok.h"
#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <qimage.h>
#include <kstandarddirs.h>
#include <kmountpoint.h>
#include <kiconloader.h>
#include <kdirwatch.h>
#include <qlabel.h>

#include <dcopref.h>
#include <dcopclient.h>


#include <kmainwindow.h>
#include <klocale.h>

#include "gpluginpainter.h"

#include "gamarok.moc"



extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	//qWarning("GAmarok xeplugin_register()");
	return new GAmarok(parent,"GAmarok");
}



GAmarok::GAmarok(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{
    themepath="kxdocker/plugins/gamarok/";
    
	/* Standard plugin information since kxdocker 0.29 */
	QString Version="0.5";
	// Project name
	PluginInformations.append("KXDocker GAmarok");
	// version
	PluginInformations.append(Version);
	// date
	PluginInformations.append("20050811");
	// Author
	PluginInformations.append("Stefano");
	// Author mail
	PluginInformations.append("stefano@xiaprojects.com");
	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gamarok");
	// url documentation
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gamarok");
	// url update
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version));
	
	IconSize=128;

	client= new DCOPClient();
	client->attach();
	defaultBackground="amarok";
	Title="Not playing";
	lastTitle="";
	Painter=new gPluginPainter(0,"current",DRAW_GaugeVert2);
	Painter->setRect(QRect(1,0,IconSize,IconSize));
}

GAmarok::~GAmarok()
{

}

void GAmarok::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="themepath")
	{
		themepath=vvalue;
	}

	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("themepath",themepath);
	}
	else
	{
		createXMLTree();
	}

	gPluginSDK::xSetupParameter(vname,vvalue);

	// update the resources
	loadResources(themepath);
}

void GAmarok::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="themepath")
	{
		vvalue=themepath;
	}
	
	gPluginSDK::xGetParameter(vname,vvalue);
	
}
void GAmarok::xGetParameterList(QStringList *a)
{
	a->append("themepath");
	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
	
}


void GAmarok::xPaint(int newValue)
{
	if(lastTitle!="")ToolTip=lastTitle;
	else ToolTip="not playing";
	if(newValue)
	{
		Painter->setValue(QString("%1").arg(newValue));
		Painter->paint(&lastImage);
 	}
	*xImgSource=lastImage.convertToImage();
}


void GAmarok::polling()
{
/*
	Value++;
	xRefreshIcon(xGIcon);
	QTimer::singleShot(1000, this, SLOT(polling()));
*/

	if(isStopped){
		qWarning("void GAmarok::polling exiting...");
		return;
	}

	QString AlbumImage;
	getAlbumImage(AlbumImage);
	getTitle(Title);
	//qWarning(AlbumImage);
	dirty(AlbumImage);
	QTimer::singleShot(5000, this, SLOT(polling()));
}


void GAmarok::xApplyCfg()
{
	if(xXMLIconConfig->count()>0)
	{
		themepath=xXMLIconConfig->item(0).toElement().attribute("themepath","kxdocker/plugins/gamarok");
	}
	loadResources(themepath);
	// to enable the first pass
	lastValue=-1;
	//dirty("");
}


void GAmarok::dirty(const QString &AlbumImage)
{

	if(isStopped){
		return;
	}
	//qWarning(QString("Totale: %1").arg(getPlayPercentage()));

	if(AlbumImage==lastAlbumImage && Title==lastTitle && getPlayPercentage()==Value)return;
	//Value++;
	Value=getPlayPercentage();
	lastAlbumImage=AlbumImage;
	lastTitle=Title;
	setAlbum(lastAlbumImage);

	// apply the background image
	lastImage=background;
	
	// 
	
	xRefreshIcon(xGIcon);
}


void GAmarok::xStop()
{
	gPluginSDK::xStop();

}


void GAmarok::xStart()
{
	gPluginSDK::xStart();

}


void GAmarok::loadResources(const QString newPath)
{
	//**********************************************************
	// path where to find images
	QString fminiPlay="play.png";
	QString ClockPaths=newPath;
	ClockPaths=ClockPaths+"/"+fminiPlay;
	// check if it exists
	QFile a(ClockPaths);
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gamarok/";
		ClockPaths=ClockPaths+fminiPlay;
	}
	
	miniPlay.load(::locate("data",ClockPaths));

	a.setName(ClockPaths);
	ClockPaths=newPath;
	QString FanV="fanv.png";
	ClockPaths=ClockPaths+"/"+FanV;
	if(!a.exists() || ClockPaths==QString::null)
	{
		ClockPaths="kxdocker/plugins/gamarok/";
		ClockPaths=ClockPaths+FanV;
	}
	Painter->load(::locate("data",ClockPaths));
}


/*!
    \fn GAmarok::setAlbum(const QString)
 */
void GAmarok::setAlbum(const QString filename)
{
	if(filename=="")
	{
		QString targetFile=defaultBackground;
		xFindResource("icon",targetFile);
		background.load(::locate("data",targetFile));
		if(background.isNull())
		{
			KIconLoader KDEIconLoader;
			background=KDEIconLoader.loadIcon(
					defaultBackground,
					KIcon::NoGroup,
					128
					);
		}
	
	}
	else
	{
		background.load(filename);
		QImage pippo=background.convertToImage();
		pippo=pippo.smoothScale(IconSize,IconSize,QImage::ScaleMax);
		background.convertFromImage(pippo);
	}

}


/*!
    \fn GAmarok::getAlbumImage(QString &)
 */
void GAmarok::getAlbumImage(QString &a)
{
	a="";
	if(client->isApplicationRegistered("amarok")){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		//outgoingStream<<iconName;

	        if(client->call("amarok",
                        "player",
                        "coverImage()",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="QString"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> a;
					//qWarning(QString("Found icon: %1").arg(foundedIcon));
				
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}
}


/*!
    \fn GAmarok::getTitle(QString &)
 */
void GAmarok::getTitle(QString &a)
{
	a="";
	if(client->isApplicationRegistered("amarok")){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		//outgoingStream<<iconName;

	        if(client->call("amarok",
                        "player",
                        "nowPlaying()",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="QString"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> a;
					//qWarning(QString("Found icon: %1").arg(foundedIcon));
				
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}
}


/*!
    \fn GAmarok::getTotalTime()
 */
int GAmarok::getTotalTime()
{
	QString a="";
	if(client->isApplicationRegistered("amarok")){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		//outgoingStream<<iconName;

	        if(client->call("amarok",
                        "player",
                        "totalTime()",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="QString"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> a;
					//qWarning(QString("Found icon: %1").arg(foundedIcon));
					
					// ok than the format is
					// Minutes:Seconds
					int seconds=0;
					bool f=0;
					QStringList seekable;
					seekable=seekable.split(":",a);
					for(int i=0;i<seekable.count();i++)
					{
						seconds=seconds*60;
						seconds=seconds+seekable[i].toInt(&f);
					}
					return seconds;
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}

	return 0;
}


/*!
    \fn GAmarok::getCurrentTime()
 */
int GAmarok::getCurrentTime()
{
	QString a="";
	if(client->isApplicationRegistered("amarok")){
	
		QByteArray outgoingData;
        	QByteArray replyData;
		QCString replyType;

		QDataStream outgoingStream( outgoingData, IO_WriteOnly );
		//outgoingStream<<iconName;

	        if(client->call("amarok",
                        "player",
                        "currentTime()",
                        outgoingData,
                        replyType,
                        replyData,
                        false)){
				if(replyType=="QString"){
					QDataStream argIn( replyData, IO_ReadOnly );
					argIn >> a;
					//qWarning(QString("Found icon: %1").arg(foundedIcon));
					
					// ok than the format is
					// Minutes:Seconds
					int seconds=0;
					bool f=0;
					QStringList seekable;
					seekable=seekable.split(":",a);
					for(int i=0;i<seekable.count();i++)
					{
						seconds=seconds*60;
						seconds=seconds+seekable[i].toInt(&f);
					}
					return seconds;
				}
				else{
				//qWarning("error: int libkxdocker::findIcon()");
				}
			}
		else
		{
				//qWarning("error: int libkxdocker::findIcon()");
		}
	}

	return 0;
}


/*!
    \fn GAmarok::getPlayPercentage()
 */
int GAmarok::getPlayPercentage()
{
	int totale=getTotalTime();
	int attuale=getCurrentTime();

	if(totale>0)return 100-(totale-attuale)*100/totale;
	return 0;
}
