/***************************************************************************
 *   Copyright (C) 2005 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GACLOCK__H
#define GACLOCK__H

#include "gpluginsdk.h"
#include <math.h>
#include <stdlib.h>
#include <qwmatrix.h>
    


class GAClock : public gPluginSDK
{
  Q_OBJECT
public:
	GAClock(QObject *parent = 0, const char *name = 0);
	~GAClock();
    void ruotaSimply(QPixmap &,const QPixmap &,double degree);
    void ruotaSmooth(QPixmap &target,const QPixmap &source,double gradi);
    
public slots:
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xPaint(int);
    virtual void polling();
    virtual void xApplyCfg();
    virtual void dirty(const QString &);
    virtual void xStop();
    virtual void xStart();
protected:
void (GAClock::*ruota)(QPixmap &,const QPixmap &,double);
    QString themepath;
    QString besmooth;
    QWMatrix m;
    QPixmap theClockPixmap;
    QPixmap rotatedPixmap;
	int iMiniText,italian;
    //QImage ImageBuffer;
    
    QString background;
    QString foreground;
    QString hour_hand;
    QString min_hand;
    QString sec_hand;
    QString day_image;
    QString alwaysShowDate;
    
    
    QPixmap background_pixmap;
    QPixmap foreground_pixmap;
    QPixmap hour_hand_pixmap;
    QPixmap min_hand_pixmap;
    QPixmap sec_hand_pixmap;
    QPixmap day_image_pixmap;
    
    QPixmap hour_hand_pixmap_rotated;
    QPixmap min_hand_pixmap_rotated;
    QPixmap sec_hand_pixmap_rotated;
    
protected:
    void loadResources(const QString newPath);
    void loadDateResource();
};


#endif
