/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_dcopinterface.h"
#include "xeplugin_dcopbase.h"

#include <qtextcodec.h>



XEPlugin_DCOPInterface 	*XEPlugin_DCOPBase::DCOPInterface;
XEPlugin_DCOPBase	*XEPlugin_DCOPInterface::DockerInterface;



XEPlugin_DCOPInterface::XEPlugin_DCOPInterface(XEPlugin_DCOPBase *dInterface):DCOPObject("docker")
{
	DockerInterface=dInterface;
	functionsList=QStringList();
	functionsList.append("list");
	functionsList.append("exit");
}

QStringList XEPlugin_DCOPInterface::list()
{
	return functionsList;
}

bool XEPlugin_DCOPInterface::exit()
{
	DockerInterface->queryExit();
	return true;
}

XEPlugin_DCOPInterface::~ XEPlugin_DCOPInterface()
{
}

bool XEPlugin_DCOPInterface::changebackground(const QString newpath)
{
	DockerInterface->changeBackground(newpath);
	return true;
}

void XEPlugin_DCOPInterface::changeImage(int index,const QString newImage)
{
	DockerInterface->changeImage(index,newImage);
}

void XEPlugin_DCOPInterface::changeText(int index,const QString newText)
{
	DockerInterface->changeText(index,newText);
}

int XEPlugin_DCOPInterface::findIcon(const QString iconName)
{
	return DockerInterface->findIcon(iconName);
}
void XEPlugin_DCOPInterface::swapIcons(int a,int b)
{
	DockerInterface->swapIcons(a,b);
}

void XEPlugin_DCOPInterface::addIcon(
	const QString newName,
	const QString newImg,
	const QString overText,
	const QString onClickExec,
	const QString className,
	const QString groupName,
	const QString fileName,
	const QString windowTitle,
	const QString taskName,
	const QString taskClass

)
{
	DockerInterface->addIcon(
	newName,
	newImg,
	overText,
	onClickExec,
	className,
	groupName,
	fileName,
	windowTitle,
	taskName,
	taskClass
	);
}

void XEPlugin_DCOPInterface::removeIcon(int index)
{
	DockerInterface->removeIcon(index);
}

void XEPlugin_DCOPInterface::changeImageByName(const QString ImageName,const QString newImage)
{
    DockerInterface->changeImageByName(ImageName,newImage);
}

void XEPlugin_DCOPInterface::changeTextByName(const QString iconName,const QString newText)
{
    DockerInterface->changeTextByName(iconName,newText);
}



void XEPlugin_DCOPInterface::changeEncodedMiniTextByName(const QString a,const QString b, const QString c)
{
	QCString locallyEncoded(b);
	QTextCodec *codec = QTextCodec::codecForName(c); // get the codec for KOI8-R
	if(codec==NULL)return;
	QString b1 = codec->toUnicode(locallyEncoded);
	DockerInterface->changeMiniTextByName(a,b1);
}

void XEPlugin_DCOPInterface::changeEncodedTextByName(const QString a,const QString b, const QString c)
{
	QCString locallyEncoded(b);
	QTextCodec *codec = QTextCodec::codecForName(c); // get the codec for KOI8-R
	if(codec==NULL)return;
	QString b1 = codec->toUnicode(locallyEncoded);
	DockerInterface->changeTextByName(a,b1);
}
/*

void XEPlugin_DCOP::changeUtf8TextByName(const QString iconName,const QString newText)
{
	changeTextByName(iconName,QString::fromLocal8Bit(newText));
}
void XEPlugin_DCOPInterface::changeUtf8TextByName(const QString iconName,const QString newText)
{
	const char *pippo=(const char *)newText;
    DockerInterface->changeTextByName(iconName,QString::fromUtf8(pippo));
}


void XEPlugin_DCOP::changeLocal8TextByName(const QString iconName,const QString newText)
{

	changeTextByName(iconName,newText);
}
void XEPlugin_DCOPInterface::changeLocal8TextByName(const QString iconName,const QString newText)
{
    DockerInterface->changeTextByName(iconName,QString::fromLocal8Bit(newText));
}
*/

void XEPlugin_DCOPInterface::bounceByName(const QString iname)
{
	DockerInterface->bounceByName(iname);
}

void XEPlugin_DCOPInterface::stopAnimateBackground()
{
	DockerInterface->xStopAnimateBackground();
}


void XEPlugin_DCOPInterface::startAnimateBackground()
{
	DockerInterface->xStartAnimateBackground();
}


void XEPlugin_DCOPInterface::rollUpIcon(int i)
{
    DockerInterface->rollUpIcon(i);
}

void XEPlugin_DCOPInterface::rollDownIcon(int i)
{
    DockerInterface->rollDownIcon(i);
}


void XEPlugin_DCOPInterface::rollUpIconByName(const QString ImageName)
{
	DockerInterface->rollUpIconByName(ImageName);
}
void XEPlugin_DCOPInterface::addAlias(const QString newAlias)
{
	DockerInterface->addAlias(newAlias);
}


void XEPlugin_DCOPInterface::rollDownIconByName(const QString ImageName)
{
	DockerInterface->rollDownIconByName(ImageName);
}



void XEPlugin_DCOPInterface::removeByName(const QString iname)
{
    DockerInterface->removeByName(iname);
}

QStringList XEPlugin_DCOPInterface::getPluginParameters(const QString a)
{
	return DockerInterface->getPluginParameters(a);
}



QStringList XEPlugin_DCOPInterface::getPluginList()
{
	return DockerInterface->getPluginList();
}


void XEPlugin_DCOPInterface::addPlugin(const QString a)
{
	DockerInterface->addPlugin(a);
}

void XEPlugin_DCOPInterface::loadPlugin(const QString a)
{
	DockerInterface->loadPlugin(a);
}


void XEPlugin_DCOPInterface::configurePlugin(const QString a)
{
	DockerInterface->configurePlugin(a);
}

void XEPlugin_DCOPInterface::hide()
{
	DockerInterface->hide();
}


void XEPlugin_DCOPInterface::startPluginIconByName(const QString a)
{
	DockerInterface->startPluginIconByName(a);
}


void XEPlugin_DCOPInterface::removePlugin(const QString a)
{
	DockerInterface->removePlugin(a);
}


void XEPlugin_DCOPInterface::setPluginParameter(
const QString a, const QString b, const QString c)
{
	DockerInterface->setPluginParameter(a,b,c);
}


void XEPlugin_DCOPInterface::show()
{
	DockerInterface->show();
}

void XEPlugin_DCOPInterface::startPlugin(const QString a)
{
	DockerInterface->startPlugin(a);
}


void XEPlugin_DCOPInterface::stopPlugin(const QString a)
{
	DockerInterface->stopPlugin(a);
}
void XEPlugin_DCOPInterface::parse(const QString p,const QString a,int b)
{
	DockerInterface->parse(p,a,b);
}
void XEPlugin_DCOPInterface::stopBounceByName(const QString i)
{
	DockerInterface->stopBounceByName(i);
}

void XEPlugin_DCOPInterface::startBounceByName(const QString i)
{
	DockerInterface->startBounceByName(i);
}
int XEPlugin_DCOPInterface::getRunningByName(const QString iname)
{
 return DockerInterface->getRunningByName(iname);
}

void XEPlugin_DCOPInterface::setRunningByName(const QString iname, int i)
{
DockerInterface->setRunningByName(iname, i);
}
void XEPlugin_DCOPInterface::changeImage(int index, QPixmap newImage)
{
	DockerInterface->changeImage(index,newImage);
}
void XEPlugin_DCOPInterface::changeImageByName(const QString ImageName, QPixmap newImage)
{
	DockerInterface->changeImage(ImageName,newImage);
}
void XEPlugin_DCOPInterface::changeImage(int index, QImage newImage)
{
	DockerInterface->changeImage(index,newImage);
}
void XEPlugin_DCOPInterface::changeImageByName(const QString ImageName, QImage newImage)
{
	DockerInterface->changeImage(ImageName,newImage);
}
void XEPlugin_DCOPInterface::changeMiniTextByName(const QString a,const QString b)
{
	DockerInterface->changeMiniTextByName(a,b);
}
void XEPlugin_DCOPInterface::changeTextPropertyByName(const QString a,const QString b, const QString c)
{
	DockerInterface->changeTextPropertyByName(a,b,c);
}
int XEPlugin_DCOPInterface::getConfigurationInt(const QString a)
{
	return DockerInterface->getConfigurationInt(a);
}

QString XEPlugin_DCOPInterface::getConfigurationString(const QString a)
{
	return DockerInterface->getConfigurationString(a);
}

QStringList XEPlugin_DCOPInterface::getConfigurationStringList(const QString a)
{
	return DockerInterface->getConfigurationStringList(a);
}


void XEPlugin_DCOPInterface::setOverlayImageByName(const QString name,int x,int y, const QString file)
{
	return DockerInterface->setOverlayImageByName(name,x,y, file);
}


void XEPlugin_DCOPInterface::fadeByName(const QString name,int x)
{
	return DockerInterface->fadeByName(name,x);
}

