/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "xeplugin_cfgicon.h"

#include <kpopupmenu.h>
#include <kiconloader.h>
#include <krun.h>
#include <qlineedit.h>
#include <kcombobox.h>
#include <kstandarddirs.h>
#include <qdir.h>
#include <qcheckbox.h>
#include <kicondialog.h>
#include <kdebug.h>
#include <kiconloader.h>
#include <qcursor.h>
#include <qlistview.h>
#include <klistview.h>
#include <klocale.h>
#include <qlabel.h>
#include <kurllabel.h>
#include <kled.h>

XEPlugin_CfgIcon::XEPlugin_CfgIcon(QWidget* parent, const char* name, bool modal, WFlags fl)
: cfgwnd_icon(parent,name, modal,fl)
{
	Configurator=NULL;
	xGDocker=NULL;
	ActiveConfiguration=NULL;
	ObjectIcon=NULL;
	UpdatingFields=1;
	pMenu=NULL;
	pTaskMenu=NULL;
	casellaTask=NULL;
	// fix some gui
	kListView1->setItemsRenameable(true);
	kListView1->setRenameable(0,true);
	kListView1->setRenameable(1,true);
	kListView1->setRenameable(2,true);
	kListView1->setRenameable(3,true);
}

XEPlugin_CfgIcon::~XEPlugin_CfgIcon()
{
}

void XEPlugin_CfgIcon::onOK()
{
	ObjectIcon=NULL;
	hide();
}

void XEPlugin_CfgIcon::onConfigurePlugin()
{
}

void XEPlugin_CfgIcon::Configure_clicked()
{
	int idx=ActiveConfiguration->RollingIcons.find(ObjectIcon);
	if(idx<0)return;
	XGIcon *icon=xGDocker->xGetPointerObjectIcon(idx);
	if(icon==NULL)return;
	icon->xRunConfiguratorClass();
}


/*$SPECIALIZATION$*/


#include "xeplugin_cfgicon.moc"



/*!
    \fn XEPlugin_CfgIcon::xUpdateForm(const QString &)
 */
void XEPlugin_CfgIcon::xUpdateForm(const QString &iconName)
{
	ObjectIcon=NULL;
	if(ActiveConfiguration==NULL)
	{
		xSetup();
		if(ActiveConfiguration==NULL)return;
	}
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==iconName)xUpdateForm(ActiveConfiguration->RollingIcons.at(i));
	}
}

void XEPlugin_CfgIcon::xUpdateForm(XSGObjectIcon *NewObjectIcon)
{
	kdWarning()<<"XEPlugin_CfgIcon::xUpdateForm()\n";
	ObjectIcon=NULL;
	// update status page
	running->off();
	attach->off();
	showed->off();
	tracing->clear();

	if(ActiveConfiguration==NULL)
	{
		xSetup();
		if(ActiveConfiguration==NULL)return;
	}

	if(ActiveConfiguration->RollingIcons.find(NewObjectIcon)<0 &&cerca_in_plugins_cfg(NewObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	UpdatingFields=1;
	ObjectIcon=NewObjectIcon;

	// fill combo boxes with files
	updateComboFromFolderPNG(obj_image_arrow,"kxdocker/themes/arrows/");
	updateComboFromFolderPNG(obj_image_drop,"kxdocker/themes/arrows/");
	updateComboFromFolderPNG(obj_image_poof,"kxdocker/themes/poof/");
	updateComboFromFolder(obj_image_spinner,"kxdocker/themes/icons/","wait_",".png");
	obj_image_spinner->insertItem("spin_waiting");
	obj_image_spinner->insertItem(QString("wait_%1").arg(ObjectIcon->Info.Name));
	// load icon data
	// Info
	obj_name->setText(ObjectIcon->Info.Name);
	obj_group->setCurrentText(ObjectIcon->Info.Group);
	obj_class->clear();
	obj_class->insertItem("disabled");
	obj_class->insertItem("GIcon");
	obj_class->insertItem("GSeparator");
	if(ObjectIcon->Info.className!="disabled")obj_class->insertItem(ObjectIcon->Info.className);
	obj_class->setCurrentText(ObjectIcon->Info.className);
	obj_group->clear();
	obj_group->insertItem(ObjectIcon->Info.Name);
	if(ObjectIcon->Info.Group!=ObjectIcon->Info.Group)obj_group->insertItem(ObjectIcon->Info.Group);
	obj_group->setCurrentText(ObjectIcon->Info.Group);
	// General
	obj_overtext->setText(ObjectIcon->OverText);
	if(ObjectIcon->Tasks.MiniTextShow==1)
	{
		minitext->setChecked(true);
	}
	else minitext->setChecked(false);
	obj_minitext->setText(ObjectIcon->Tasks.MiniText);
	// Images
	obj_icon->setText(ObjectIcon->Images.imgFileName);
	kIconButton1->setIcon(ObjectIcon->Images.imgFileName);
	obj_image_arrow->setCurrentText(ObjectIcon->Images.imgFileArrow);
	obj_image_drop->setCurrentText(ObjectIcon->Images.imgFileDrop);
	obj_overlay->setText(ObjectIcon->Images.imgFileOverlay);
	obj_image_spinner->setCurrentText(ObjectIcon->Images.imgFileOverlaySpinner);
	obj_image_poof->setCurrentText(ObjectIcon->PoofName);

	// loading action list
	kListView1->clear();
	for(int a=0;a<(int)ObjectIcon->Actions.ActionList.count();a++)
	{
		QString aAction=ObjectIcon->Actions.ActionList.item(a).toElement().attribute("action");
		QString aIcon=ObjectIcon->Actions.ActionList.item(a).toElement().attribute("image");
		if(aAction.isNull() || aAction=="")aAction="exec";
		if(aIcon.isNull() || aIcon=="" )aIcon="run";
		QString aInfo=ObjectIcon->Actions.ActionList.item(a).toElement().attribute("info");
		QString aExe=ObjectIcon->Actions.ActionList.item(a).toElement().attribute("data");
		if(aExe.isNull() || aExe=="" )continue;
		if(aInfo.isNull() || aInfo=="" )aInfo=aExe;
		QListViewItem	*item=new QListViewItem((QListView *)kListView1);
		item->setText(0,aInfo);
		item->setText(1,aIcon);
		item->setText(2,aAction);
		item->setText(3,aExe);
		kListView1->insertItem(item);
	}
	cfg_update_tasklist();
	
	on_click->setText(ObjectIcon->Actions.onClickExec);
	on_drop->setText(ObjectIcon->Actions.onDropExec);
	cfg_dcopraise->setText(ObjectIcon->Tasks.dcopRestore);
	cfg_dcopclose->setText(ObjectIcon->Tasks.dcopClose);
	cfg_dcopnew->setText(ObjectIcon->Tasks.dcopNewWindow);
	// plugin issue
	cfg_update_plugin_info();
	// fix null values
	if(obj_image_arrow->currentText()=="")obj_image_arrow->setCurrentText("arrow.png");
	if(obj_image_drop->currentText()=="")obj_image_drop->setCurrentText("drop.png");
	if(obj_image_poof->currentText()=="")obj_image_poof->setCurrentText("poof.png");
	cfg_update_status();
	UpdatingFields=0;
}

/*!
    \fn XEPlugin_CfgIcon::xSetup()
 */
void XEPlugin_CfgIcon::xSetup()
{
	Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
}


/*!
    \fn XEPlugin_CfgIcon::xUpdateForm(int)
 */
void XEPlugin_CfgIcon::xUpdateForm(int i)
{
	ObjectIcon=NULL;
	if(ActiveConfiguration==NULL)
	{
		xSetup();
		if(ActiveConfiguration==NULL)return;
	}
	if(i>=0&&i<(int)ActiveConfiguration->RollingIcons.count())
	{
		xUpdateForm(ActiveConfiguration->RollingIcons.at(i));
	}
}


void XEPlugin_CfgIcon::obj_icon_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	UpdatingFields=1;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)ObjectIcon->Images.imgFileName=svalue;
	kIconButton1->setIcon(svalue);
	UpdatingFields=0;
	tryReloadIcon();
}

void XEPlugin_CfgIcon::obj_name_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)ObjectIcon->Info.Name=svalue;
	tryReloadIcon();
}

void XEPlugin_CfgIcon::obj_group_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)ObjectIcon->Info.Group=svalue;
	tryReloadIcon();
}

void XEPlugin_CfgIcon::obj_class_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)
	{
		// new feature: we try to update on every icon the className so if user wanna disable a plugin may do this every where
		ObjectIcon->Info.className=svalue;
		apply_this_update_to_everyone(ObjectIcon->Info.Name);
	}
	tryReloadIcon();
}

void XEPlugin_CfgIcon::obj_overtext_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)ObjectIcon->OverText=svalue;
	tryReloadIcon();
}

void XEPlugin_CfgIcon::obj_image_arrow_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)ObjectIcon->Images.imgFileArrow=svalue;
	tryReloadIcon();
}

void XEPlugin_CfgIcon::obj_image_drop_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)ObjectIcon->Images.imgFileDrop=svalue;
	tryReloadIcon();
}

void XEPlugin_CfgIcon::obj_overlay_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)ObjectIcon->Images.imgFileOverlay=svalue;
	tryReloadIcon();
}

void XEPlugin_CfgIcon::obj_image_spinner_textChanged(const QString&svalue)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	if(ObjectIcon!=NULL)ObjectIcon->Images.imgFileOverlaySpinner=svalue;
	tryReloadIcon();
}

void XEPlugin_CfgIcon::kIconButton1_iconChanged(QString a)
{
	if(UpdatingFields>0)return;
	obj_icon->setText(a);
}

void XEPlugin_CfgIcon::plugin_download_leftClickedURL(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));
}

void XEPlugin_CfgIcon::plugin_mail_leftClickedURL(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));
}

void XEPlugin_CfgIcon::plugin_manual_leftURL(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));

}

void XEPlugin_CfgIcon::plugin_update_enteredURL(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));

}

void XEPlugin_CfgIcon::plugin_update_leftURL(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));

}

void XEPlugin_CfgIcon::plugin_manual_leftClickedURL(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));

}

void XEPlugin_CfgIcon::plugin_update_leftClickedURL(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));
}

void XEPlugin_CfgIcon::downloadMoreThemes_leftClickedURL(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));
}

void XEPlugin_CfgIcon::wizard2_clicked()
{
}

void XEPlugin_CfgIcon::kl_remove()
{
	UpdatingFields=1;
	if(casella!=NULL)kListView1->removeItem(casella);
	UpdatingFields=0;
	kListView1_itemRenamed(NULL);
}
void XEPlugin_CfgIcon::kl_insert()
{
	UpdatingFields=1;
	QListViewItem	*item=new QListViewItem((QListView *)kListView1);
	item->setText(0,i18n("My own menu action"));
	item->setText(1,"run");
	item->setText(2,"exec");
	item->setText(3,"konsole");
	kListView1->insertItem(item);
	UpdatingFields=0;
}

void XEPlugin_CfgIcon::kListView1_rightButtonClicked(QListViewItem*casellaNuova,const QPoint&,int)
{
	KIconLoader KDEIcons;
	if(pMenu==NULL){
		pMenu=new KPopupMenu();
	}
	pMenu->clear();
	if(casellaNuova!=NULL)pMenu->insertItem(KDEIcons.loadIcon("remove",KIcon::Small),i18n("Remove this"),this,SLOT(kl_remove()));
	pMenu->insertItem(KDEIcons.loadIcon("add",KIcon::Small),i18n("Add new exec action"),this,SLOT(kl_insert()));

	casella=casellaNuova;

	pMenu->exec(QCursor::pos());
}

void XEPlugin_CfgIcon::updateComboFromFolderPNG(KComboBox *combo,const QString &fpath)
{
	updateComboFromFolder(combo,fpath,"",".png");
}

void XEPlugin_CfgIcon::minitext_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )
	{
		//ObjectIcon=NULL;
		return;
	}

	obj_minitext->setEnabled(b);
	if(b==true && ObjectIcon->Info.className!="GIcon")
	{
		ObjectIcon->Tasks.MiniTextShow=1;
		ObjectIcon->Tasks.MiniText=obj_minitext->text();
	}
	tryReloadIcon();
}



/*!
    \fn XEPlugin_CfgIcon::tryReloadIcon()
 */
void XEPlugin_CfgIcon::tryReloadIcon()
{
	if(UpdatingFields>0)return;
	int idx=ActiveConfiguration->ObjectsIcons.find(ObjectIcon);
	if(idx<0)
	{
		return;
	}
	if(xGDocker!=NULL)xGDocker->xEventReloadIcon(idx);
}


/*!
    \fn XEPlugin_CfgIcon::updateComboFromFolder(KComboBox *,const QString &,const QString &,const QString &)
 */
void XEPlugin_CfgIcon::updateComboFromFolder(KComboBox *combo,const QString &fpath,const QString &px,const QString &ex)
{
	QString xmlsPath=::locate("data",fpath);
	if(xmlsPath.isNull()||xmlsPath=="")
	{
		return;
	}
	{
		QDir d(xmlsPath);
        	d.setFilter( QDir::Files | QDir::Hidden );
	        const QFileInfoList *list = d.entryInfoList();
        	QFileInfoListIterator it( *list );
        	QFileInfo *fi;
		combo->clear();
		while ( (fi = it.current()) != 0 ) {
			if(fi->fileName().endsWith(ex) &&fi->fileName().startsWith(px))
			{
				combo->insertItem(fi->fileName(),-1);
			}
	            ++it;
        	}
	}
}

void XEPlugin_CfgIcon::action_click_textChanged(const QString&)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	ObjectIcon->Actions.onClickExec=on_click->text();

}

void XEPlugin_CfgIcon::action_drop_textChanged(const QString&)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	ObjectIcon->Actions.onDropExec=on_drop->text();
}

void XEPlugin_CfgIcon::kListView1_itemRenamed(QListViewItem*)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	//ObjectIcon->Actions.ActionList.clear();
	// rebuild xml list
	QDomDocument 	doc( "KXDocker_Conf" );
	// the fake root
	QDomElement fakeRoot=doc.createElement("FakeRoot");
	// appending childs
	doc.appendChild(fakeRoot);
	// now creating the configuration
	QDomElement CreatingCfg=doc.createElement("actionlist");
	QPtrList<QListViewItem> lst;
	QListViewItemIterator it((QListView *)kListView1);
	while ( it.current() ) {
		//if ( it.current()->isSelected() )
		//lst.append( it.current() );
		QDomElement menuAction=doc.createElement("menuaction");
		QListViewItem	*item=it.current();
		menuAction.setAttribute("action",item->text(2));
		menuAction.setAttribute("image",item->text(1));
		menuAction.setAttribute("info",item->text(0));
		menuAction.setAttribute("data",item->text(3));
		++it;
		kdWarning()<<item->text(0)<<"\n";
		fakeRoot.appendChild(menuAction);
	}
	fakeRoot.appendChild(CreatingCfg);
	ObjectIcon->Actions.ActionList=fakeRoot.childNodes();
}

void XEPlugin_CfgIcon::XDegree_valueChanged(int)
{
}





/*!
    \fn XEPlugin_CfgIcon::cerca_in_plugins_cfg(XSGObjectIcon *)
 */
int XEPlugin_CfgIcon::cerca_in_plugins_cfg(XSGObjectIcon *cercai)
{
	int ritorno=-1;
	for(int i=ActiveConfiguration->Plugins.Matches.count()-1; i>=0;i--)
	{
		XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
		if(newalias==NULL)break;
		XSGObjectIcon *icon=newalias->Icon;
		if(icon==cercai){
			ritorno=i;
			break;
		}
	}
	return ritorno;
}

void XEPlugin_CfgIcon::kListView9_itemRenamed(QListViewItem*)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;

	QListViewItemIterator it(kListView9);
	// flush old maps
	ObjectIcon->Tasks.dcopName.clear();
	ObjectIcon->Tasks.WindowTitle.clear();
	ObjectIcon->Tasks.TaskName.clear();
	ObjectIcon->Tasks.ClassName.clear();

	while(it.current())
	{
		QListViewItem *item=it.current();
		if(item->text(1)=="DCOP")
		{
			ObjectIcon->Tasks.dcopName.append(item->text(0));
		}
		if(item->text(1)=="Title")
		{
			ObjectIcon->Tasks.WindowTitle.append(item->text(0));
			ObjectIcon->Tasks.TaskName.append("");
			ObjectIcon->Tasks.ClassName.append("");

		}
		if(item->text(1)=="Task")
		{
			ObjectIcon->Tasks.WindowTitle.append("");
			ObjectIcon->Tasks.TaskName.append(item->text(0));
			ObjectIcon->Tasks.ClassName.append("");
		}
		if(item->text(1)=="class")
		{
			ObjectIcon->Tasks.WindowTitle.append("");
			ObjectIcon->Tasks.TaskName.append("");
			ObjectIcon->Tasks.ClassName.append(item->text(0));
		}
		++it;
	}


}

void XEPlugin_CfgIcon::kListView9_rightButtonClicked(QListViewItem*casellaNuova,const QPoint&,int)
{
	KIconLoader KDEIcons;
	if(pTaskMenu==NULL){
		pTaskMenu=new KPopupMenu();
	}
	pTaskMenu->clear();
	pTaskMenu->insertItem(KDEIcons.loadIcon("services",KIcon::Small),i18n("Add new DCOP match"),this,SLOT(task_list_add_dcop()));
	pTaskMenu->insertItem(KDEIcons.loadIcon("services",KIcon::Small),i18n("Add new Window title match"),this,SLOT(task_list_add_title()));
	pTaskMenu->insertItem(KDEIcons.loadIcon("services",KIcon::Small),i18n("Add new Task match"),this,SLOT(task_list_add_task()));
	pTaskMenu->insertItem(KDEIcons.loadIcon("services",KIcon::Small),i18n("Add new Class match"),this,SLOT(task_list_add_class()));
	if(casellaNuova!=NULL)pTaskMenu->insertItem(KDEIcons.loadIcon("remove",KIcon::Small),"Remove this",this,SLOT(task_list_del()));

	casellaTask=casellaNuova;

	pTaskMenu->exec(QCursor::pos());
}



/*!
    \fn XEPlugin_CfgIcon::task_list_add_title()
 */
void XEPlugin_CfgIcon::task_list_add_title()
{
	QListViewItem	*item=new QListViewItem((QListView *)kListView9);
	item->setText(0,i18n("New match string, rename me"));
	item->setText(1,"Title");
	kListView9->insertItem(item);
//	UpdatingFields=1;
//	cfg_update_tasklist();
//	UpdatingFields=0;
}


/*!
    \fn XEPlugin_CfgIcon::task_list_add_class()
 */
void XEPlugin_CfgIcon::task_list_add_class()
{
	QListViewItem	*item=new QListViewItem((QListView *)kListView9);
	item->setText(0,i18n("New match string, rename me"));
	item->setText(1,"Class");
	kListView9->insertItem(item);
//	UpdatingFields=1;
//	cfg_update_tasklist();
//	UpdatingFields=0;
}


/*!
    \fn XEPlugin_CfgIcon::task_list_add_dcop()
 */
void XEPlugin_CfgIcon::task_list_add_dcop()
{
	QListViewItem	*item=new QListViewItem((QListView *)kListView9);
	item->setText(0,i18n("New match string, rename me"));
	item->setText(1,"DCOP");
	kListView9->insertItem(item);
//	UpdatingFields=1;
//	cfg_update_tasklist();
//	UpdatingFields=0;
}


/*!
    \fn XEPlugin_CfgIcon::task_list_add_task()
 */
void XEPlugin_CfgIcon::task_list_add_task()
{
	QListViewItem	*item=new QListViewItem((QListView *)kListView9);
	item->setText(0,i18n("New match string, rename me"));
	item->setText(1,"Task");
	kListView9->insertItem(item);
//	UpdatingFields=1;
//	cfg_update_tasklist();
//	UpdatingFields=0;
}


/*!
    \fn XEPlugin_CfgIcon::task_list_del()
 */
void XEPlugin_CfgIcon::task_list_del()
{
	if(UpdatingFields>0)return;
	if(casellaTask==NULL)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	kListView9->removeItem(casellaTask);
	casellaTask=NULL;
	kListView9_itemRenamed(NULL);
}


/*!
    \fn XEPlugin_CfgIcon::cfg_update_tasklist()
 */
void XEPlugin_CfgIcon::cfg_update_tasklist()
{
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	kListView9->clear();
	for(uint i=0;i<ObjectIcon->Tasks.dcopName.count();i++)
	{
		if(ObjectIcon->Tasks.dcopName[i]=="")continue;
		QListViewItem	*item=new QListViewItem((QListView *)kListView9);
		item->setText(0,ObjectIcon->Tasks.dcopName[i]);
		item->setText(1,"DCOP");
		kListView9->insertItem(item);
	}
	for(uint i=0;i<ObjectIcon->Tasks.WindowTitle.count();i++)
	{
		if(ObjectIcon->Tasks.WindowTitle[i]=="")continue;
		QListViewItem	*item=new QListViewItem((QListView *)kListView9);
		item->setText(0,ObjectIcon->Tasks.WindowTitle[i]);
		item->setText(1,"Title");
		kListView9->insertItem(item);
	}
	for(uint i=0;i<ObjectIcon->Tasks.TaskName.count();i++)
	{
		if(ObjectIcon->Tasks.TaskName[i]=="")continue;
		QListViewItem	*item=new QListViewItem((QListView *)kListView9);
		item->setText(0,ObjectIcon->Tasks.TaskName[i]);
		item->setText(1,"Task");
		kListView9->insertItem(item);
	}
	for(uint i=0;i<ObjectIcon->Tasks.ClassName.count();i++)
	{
		if(ObjectIcon->Tasks.ClassName[i]=="")continue;
		QListViewItem	*item=new QListViewItem((QListView *)kListView9);
		item->setText(0,ObjectIcon->Tasks.ClassName[i]);
		item->setText(1,"Class");
		kListView9->insertItem(item);
	}
}

void XEPlugin_CfgIcon::cfg_dcopnew_textChanged(const QString&)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	ObjectIcon->Tasks.dcopNewWindow=cfg_dcopnew->text();
}

void XEPlugin_CfgIcon::cfg_dcopraise_textChanged(const QString&)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	ObjectIcon->Tasks.dcopRestore=cfg_dcopraise->text();
}

void XEPlugin_CfgIcon::cfg_dcopclose_textChanged(const QString&)
{
	if(UpdatingFields>0)return;
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	ObjectIcon->Tasks.dcopClose=cfg_dcopclose->text();
}


/*!
    \fn XEPlugin_CfgIcon::cfg_update_plugin_info()
 */
void XEPlugin_CfgIcon::cfg_update_plugin_info()
{
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)<0 &&cerca_in_plugins_cfg(ObjectIcon)<0 )return;
	plugin_name->setText("");
	plugin_author->setText("");
	plugin_date->setText("");
	plugin_download->setText("");
	plugin_mail->setText("");
	plugin_manual->setText("");
	plugin_update->setText("");
	plugin_version->setText("");

	//disconnect(this, SIGNAL(xFetchGetInfo(QStringList &)),XEObject::xFindObject(icon->Info.className),SLOT(xGetInfo(QStringList &)));
	if(connect(this, SIGNAL(xFetchGetInfo(QStringList &)),XEObject::xFindObject(ObjectIcon->Info.className),SLOT(xGetInfo(QStringList &))))
	{
		// turn light on status page
		running->on();
		QStringList getInfo;
		xFetchGetInfo(getInfo);
		uint ivs=0;
		if(getInfo.count()>ivs)plugin_name->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)plugin_version->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)plugin_date->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)plugin_author->setText(getInfo[ivs]);
		ivs++;
		if(getInfo.count()>ivs)
		{
			plugin_mail->setText(getInfo[ivs]);
		}
		ivs++;
		if(getInfo.count()>ivs){
			plugin_download->setText(getInfo[ivs]);
		}
		ivs++;
		if(getInfo.count()>ivs)
		{
			plugin_manual->setText(getInfo[ivs]);
		}
		ivs++;
		if(getInfo.count()>ivs)
		{
			plugin_update->setText(getInfo[ivs]);
		}
		disconnect(this, SIGNAL(xFetchGetInfo(QStringList &)),XEObject::xFindObject(ObjectIcon->Info.className),SLOT(xGetInfo(QStringList &)));
	}

}


void XEPlugin_CfgIcon::cfg_update_status()
{
	if(ActiveConfiguration->RollingIcons.find(ObjectIcon)>=0)showed->on();
	int idx=ActiveConfiguration->ObjectsIcons.find(ObjectIcon);
	if(idx>=0)
	{
		XGIcon *icon=xGDocker->xGetPointerObjectIcon(idx);
		if(icon==NULL)return;
		if(icon->xGetClass()!=NULL)attach->on();
	}
	//tracing->clear();
}

/*!
    \fn XEPlugin_CfgIcon::apply_this_update_to_everyone(const QString &)
 */
void XEPlugin_CfgIcon::apply_this_update_to_everyone(const QString &toName)
{
	for(int i=ActiveConfiguration->Plugins.Matches.count()-1; i>=0;i--)
	{
		XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
		if(newalias==NULL)continue;
		XSGObjectIcon *icon=newalias->Icon;
		if(icon->Info.Name==toName)
		{
			// apply the class
			icon->Info.className=obj_class->currentText();
		}
	}
	for(int i=ActiveConfiguration->RollingIcons.count()-1; i>=0;i--)
	{
		XSGObjectIcon *icon=ActiveConfiguration->RollingIcons.at(i);
		if(icon==NULL)continue;
		if(icon->Info.Name==toName)
		{
			// apply the class
			icon->Info.className=obj_class->currentText();
		}
	}
}
