/***************************************************************************
                          c6trayicon.cpp  -  description
                             -------------------
    begin                : Thu Jan 29 2004
    copyright            : (C) 2004 by Giorgio A.
    email                : openc6@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "c6trayicon.h"
#include "c6settings.h"
#include "c6pixmapcache.h"

#ifdef USE_KDE
// KXDOCKER_PATCH_START
#include "libkxdocker.cpp"
// KXDOCKER_PATCH_END

C6TrayIcon::C6TrayIcon(QPopupMenu *a,QWidget *parent, const char *name) : KSystemTray(parent,name)
{
  KPopupMenu *menu;
  C6PixmapCache &pixmap = C6PixmapCache::getInstance();
  C6Settings &settings = C6Settings::getInstance();
  
  trayNormal = new QPixmap(settings.getDefaultIconPath()+"systray.png");
  trayFlash =  new QPixmap(settings.getDefaultIconPath()+"mail_generic.png");
  
  setPixmap(*trayNormal);
  menu = contextMenu();
  menu->changeTitle(menu->idAt(0),pixmap.getPixmap((settings.getDefaultIconPath()+"icon16x16.png")),"OpenC6");
  menu->insertItem("Menu",a);
  flashing = false;
  
  QString text ="Ad icona lampeggiante un click del pulsante destro mostra un popup con tutti i messaggi in arrivo \n";
  text+="Ad icona lampeggiante un doppio click del pulsante sinistro mostra l'ultimo messaggio ricevuto";
  QToolTip::add(this,text);

  msgIncomingClicked = new QSignal(this);
  msgIncomingDoubleClicked = new QSignal(this);

// KXDOCKER_PATCH_START
	KXDocker=new libkxdocker(this,"c6");
	// if the class start with x will not be saved into xml user configuration
	KXDocker->setClientClass("xc6");
	KXDocker->show();
	KXDocker->setText("OpenC6");
	KXDocker->loadIcon((settings.getDefaultIconPath()+"kxdocker_normal.png"));
// KXDOCKER_PATCH_END
}

C6TrayIcon::~C6TrayIcon()
{
// KXDOCKER_PATCH_START
	KXDocker->hide();
// KXDOCKER_PATCH_END
  delete trayNormal;
  delete trayFlash;
}

/** No descriptions */
void C6TrayIcon::flashTrayIconStart()
{
   trayIconStatus = false;
   flashing = true;
// KXDOCKER_PATCH_START
	KXDocker->show();
	KXDocker->setText("Hai messaggi da leggere");
	KXDocker->startBounce();
	C6Settings &settings = C6Settings::getInstance();
	KXDocker->loadIcon((settings.getDefaultIconPath()+"kxdocker_incoming.png"));
// KXDOCKER_PATCH_END
}

/** No descriptions */
void C6TrayIcon::flashTrayIconStop()
{
  setPixmap(*trayNormal);
  trayIconStatus = flashing = false;
// KXDOCKER_PATCH_START
	KXDocker->setText("OpenC6");
	KXDocker->stopBounce();
	C6Settings &settings = C6Settings::getInstance();
	KXDocker->loadIcon((settings.getDefaultIconPath()+"kxdocker_normal.png"));
// KXDOCKER_PATCH_END
}
/** No descriptions */
void C6TrayIcon::trayTimerDone()
{
  trayIconStatus = !trayIconStatus;
  
  if (trayIconStatus)
    setPixmap(*trayFlash);
  else
    setPixmap(*trayNormal);
}

void C6TrayIcon::mouseDoubleClickEvent(QMouseEvent *e)
{
  if ((e->button() == QMouseEvent::LeftButton) && flashing)
   {
      e->accept();
      emit msgIncomingDoubleClicked->activate();
   }
}
void C6TrayIcon::mousePressEvent(QMouseEvent *e)
{
  if (e->button() == QMouseEvent::RightButton)
   {
     if (flashing)
       {
         e->accept();
         msgIncomingClicked->activate();
       }
     else
      KSystemTray::mousePressEvent(e);
   }
  else
    if (!flashing)
      KSystemTray::mousePressEvent(e);
}

/** No descriptions */
bool C6TrayIcon::isFlashing()
{
  return(flashing);
}
/** No descriptions */
void C6TrayIcon::connectIncomingClicked( QObject *receiver, const char *member )
{
  msgIncomingClicked->connect(receiver,member);
}

void C6TrayIcon::connectDoubleClicked( QObject *receiver, const char *member )
{
  msgIncomingDoubleClicked->connect(receiver,member);
}

#endif



