/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeroot.h"

XERoot::XERoot(QObject *parent, const char *name)
 : XEObject(parent, name)
{
	xEngineRoot=this;
}


XERoot::~XERoot()
{
}


#include "xeroot.moc"


/*!
    \fn XERoot::xSetup()
 */
void XERoot::xSetup()
{
	QPtrListIterator<QObject> it(xPlugins);
	QObject *xPlugin;
	while ( (xPlugin = it.current()) != 0 ) {
		++it;
		connect(this,
			SIGNAL(xPluginSetup()),
			xPlugin,
			SLOT(xSetup())
			);
			
		connect(this,
			SIGNAL(xPluginStart()),
			xPlugin,
			SLOT(xStart())
			);
		connect(this,
			SIGNAL(xPluginStop()),
			xPlugin,
			SLOT(xStop())
			);
			
	}
	xPluginSetup();
}


/*!
    \fn XERoot::xStart()
 */
void XERoot::xStart()
{
	xPluginStart();
}


/*!
    \fn XERoot::xStop()
 */
void XERoot::xStop()
{
	//qWarning("void XERoot::xStop()");
	xPluginStop();
}


/*!
    \fn XERoot::xStart(const QString&)
 */
void XERoot::xStartThis(const QString&sPName)
{
	QObject *pObject=XEObject::xFindObject(sPName);
	if(!pObject)return;
	connect(this,SIGNAL(xThisPluginStart()),pObject, SLOT(xStart()));
	xThisPluginStart();
	disconnect(SIGNAL(xThisPluginStart()));
}


/*!
    \fn XERoot::xSetup(const QString &)
 */
void XERoot::xSetupThis(const QString &sPName)
{
	QObject *pObject=XEObject::xFindObject(sPName);
	if(!pObject)return;
	connect(this,SIGNAL(xThisPluginSetup()),pObject, SLOT(xSetup()));
	xThisPluginSetup();
	disconnect(SIGNAL(xThisPluginSetup()));
}


/*!
    \fn XERoot::xStop(const QString &)
 */
void XERoot::xStopThis(const QString &sPName)
{
	QObject *pObject=XEObject::xFindObject(sPName);
	if(!pObject)return;
	connect(this,SIGNAL(xThisPluginStop()),pObject, SLOT(xStop()));
	xThisPluginStop();
	disconnect(SIGNAL(xThisPluginStop()));
}


/*!
    \fn XERoot::xParse(const QString &, const QString &, int, void *)
 */
void XERoot::xParseTo(const QString &sPName, const QString &a, int i, void *p)
{
	QObject *pObject=XEObject::xFindObject(sPName);
	if(!pObject)return;
	connect(this,SIGNAL(xParseForeign(const QString &, int, void *)),pObject, SLOT(xParse(const QString &, int, void *)));
	xParseForeign( a,i,p);
	disconnect(SIGNAL(xParseForeign(const QString &, int, void *)));

}


/*!
    \fn XERoot::xParse(const QString &, int, void *)
 */
void XERoot::xParse(const QString &, int, void *)
{
    /// @todo implement me
}
