/*
 * Copyright (C) 2004 Stefano <stefano@xiaprojects.com>
 */

#include "kxdocker.h"

#include <dcopclient.h>

#include <qlabel.h>

#include <kmainwindow.h>


#include "xeobject.h"
#include "xeroot.h"
#include "xeevents.h"
#include "xgdocker.h"
#include "xematrix.h"
#include "xktray.h"
#include "xeconfiguration.h"
#include "xeplugin_xmlconf.h"
#include "xeplugin_mouse.h"
#include "xeplugin_command.h"
#include "xeplugin_animator.h"
#include "xeplugin_taskmanager.h"
#include "xeplugin_gapplet.h"
#include "xeplugin_gatrash.h"
#include "xeplugin_gmounts.h"
#include "xeplugin_gaclock.h"
#include "xeplugin_dcop.h"
#include "xeplugin_gepager.h"
#include "xeplugin_configurator.h"
#include "xeplugin_gepillow.h"
#include "xeplugin_garp.h"
#include "xgtaskbar.h"
#include <time.h>

    XERoot		*EngineRoot=NULL;
    XGDocker		*EngineDocker=NULL;
    XEPlugin_XMLConf	*PluginXMLConf=NULL;

extern timespec microSeconds;


KXDocker::KXDocker()
    : KMainWindow( 0, "KXDocker" )
{
    // set the shell's ui resource file
    setXMLFile("kxdockerui.rc");
    XEEvents		*EngineEvents=NULL;
    XEMatrix		*EngineMatrix=NULL;
    XEConfiguration 	*EngineConfiguration=NULL;
    XEPlugin_Mouse	*PluginMouse=NULL;
    XEPlugin_Command	*PluginCommand=NULL;
    XEPlugin_TaskManager *PluginTaskManager=NULL;
    XEPlugin_Animator	*PluginAnimator=NULL;
//    XEPlugin_GApplet	*PluginGDate=NULL;
//    XEPlugin_GATrash	*PluginGATrash=NULL;
    XEPlugin_GMounts	*PluginsGMounts=NULL;
//    XEPlugin_GAClock	*PluginGAClock=NULL;
    XEPlugin_DCOP	*PluginDCOP=NULL;
    XEPlugin_GEPager	*PluginGEPager=NULL;
    XEPlugin_Configurator *PluginConfigurator=NULL;
    XEPlugin_GEPillow	*PluginPillow=NULL;
    XEPlugin_GARP	*PluginARP=NULL;
    
    XGTaskBar		*EngineTaskBar=NULL;
    
    // Plugins
    XKTray	*PluginTray=NULL;
    
    EngineRoot	= new XERoot(this,"xRoot");
    EngineEvents= new XEEvents(EngineRoot,"xEvents");
    EngineDocker= new XGDocker(this,"xDocker");
    EngineMatrix= new XEMatrix(EngineRoot,"xMatrix");
    EngineConfiguration=new XEConfiguration(EngineRoot,"xConfiguration");
    
    // new Engine for configurator !!!!!!!!!!!!!
    PluginXMLConf=new XEPlugin_XMLConf(EngineRoot,"xXML");
    qWarning("loading xml...");    
    PluginXMLConf->xSetup();
    PluginXMLConf->xStart();
    PluginXMLConf->xImportXMLs();

    qWarning("loading plugins...");    
    for(uint i=0; i<EngineConfiguration->xGetConfiguration()
    ->Plugins.Plugin.count(); i++)
{
	// Internals
	//qWarning(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name);
if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="GEPager")
{
	    PluginGEPager	=new XEPlugin_GEPager(EngineDocker,"GEPager");
	    continue;
}	    
if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xConfigurator")   
{
	    PluginConfigurator	=new XEPlugin_Configurator(EngineDocker,"xConfigurator");
	    continue;
}	    

if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xPillow")
{
		PluginPillow = new XEPlugin_GEPillow(EngineDocker,"xPillow");
	    continue;
}	    

if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xMouse")
{
		PluginMouse = new XEPlugin_Mouse(EngineRoot,"xMouse");
	    continue;
}	    
if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xCommand")
{
		PluginCommand=new XEPlugin_Command(EngineRoot,"xCommand");
	    continue;
}	    
if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xMounts")
{
		PluginsGMounts=new XEPlugin_GMounts(EngineRoot,"xMounts");
	    continue;
}
if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xARP")
{
		PluginARP=new XEPlugin_GARP(EngineRoot,"xARP");
	    continue;
}

if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xTaskManager")
{
		PluginTaskManager=new XEPlugin_TaskManager(EngineRoot,"xTaskManager");
	    continue;
}	    
if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xTaskBar")
{
		EngineTaskBar=new XGTaskBar(EngineDocker,"xTaskBar");
	    continue;
}	    
		// Tray must be at end...
if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xTray")
{
		PluginTray	= new XKTray(EngineDocker,"xTray");
	    continue;
}	    
    // Animator (must) came at the end
if(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name=="xAnimator")
{
		PluginAnimator=new XEPlugin_Animator(EngineRoot,"xAnimator");
	    continue;
}	    
	// Loading externals
	EngineConfiguration->xLoadModule(EngineConfiguration->xGetConfiguration()->Plugins.Plugin.at(i)->Info.Name);
}
    
    
    
    
    
    
	// 0.37
    //PluginGDate		= new XEPlugin_GApplet(EngineRoot,"GDate");
//    PluginGATrash	= new XEPlugin_GATrash(EngineRoot,"GTrash");
	// 0.38
    //PluginGAClock	= new XEPlugin_GAClock(EngineRoot,"GClock");
    
    PluginDCOP		= new XEPlugin_DCOP(EngineRoot,"DCOP");
    
    
    
    connect(PluginTray,SIGNAL(quitSelected()),this,SLOT(QueryClose()));
    
    // Registering Plugin
    
    // Root Setup
//    EngineRoot->xSetup();
    
    // We are ready to connect signals
    EngineEvents->xSetup();
    EngineConfiguration->xSetup();
    EngineConfiguration->xLoadModules();

        
    // After we have loaded all plugin we tell to XML Plugin to correct inconsistent XML configurations
    // if you have loaded an onlder or incomplete XML
    // this will help external plugin to store their data
    PluginXMLConf->xXMLExplode();
    
    
    EngineRoot->xSetup();
    
    EngineMatrix->xSetup();
    // 0.26 support multiple plugins
    // is perform xSetup on all icons
    EngineDocker->xSetup();
    

    // Loading configurations    
    //EngineDocker->xCfgChanged();
    
    // We inizialize
    
    // We can Start
    EngineRoot->xStart();
    EngineEvents->xStart();
    // 0.26 support multiple plugins
    // is perform xStart on all icons
    EngineDocker->xStart();
        
    //resize(1024,768);
    kapp->setMainWidget(EngineDocker);
    
	// unshadow
	/*
	QByteArray data;
	QDataStream arg(data, IO_WriteOnly);
	arg << EngineDocker->topLevelWidget()->winId() << "false";
	kapp->dcopClient()->send(
		"kwin",
		"KWinInterface",
		"setShadowed(unsigned long int, bool)"
		,data);
	*/
	// kde 3.4 unshadow
        QByteArray data2;
        QDataStream arg2(data2, IO_WriteOnly);
        arg2 << EngineDocker->topLevelWidget()->winId();
        kapp->dcopClient()->send(
                "kwin",
                "KWinInterface",
                "setUnshadowed(unsigned long int)"
		           ,data2);
	//qWarning(QString("%1").arg(EngineDocker->topLevelWidget()->winId()));

	//PluginXMLConf->xXMLStore();
     
}

KXDocker::~KXDocker()
{
	//qWarning("KXDocker::~KXDocker()");
}

#include "kxdocker.moc"


/*!
    \fn KXDocker::QueryClose()
 */
void KXDocker::QueryClose()
{
	PluginXMLConf->xStop();
	EngineRoot->xStop();
	EngineDocker->xStop();
	close();
}
