/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_ANIMATOR_H
#define XEPLUGIN_ANIMATOR_H

#include <qobject.h>
#include <qmutex.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <qptrlist.h>

class XGIcon;
class XSConfigurations;
class XGDocker;
class QTimer;
class xGFloater;


/**
@author Stefano
*/
class XEPlugin_Animator : public QObject
{
Q_OBJECT
public:
    XEPlugin_Animator(QObject *parent = 0, const char *name = 0);
    ~XEPlugin_Animator();
public slots:
    void xAnimateDockerSlideRight(int,int,int,int,int,int,int,int);
    void xAnimateBounce(XGIcon *);
    void xAnimateMicro(XGIcon *);
    void xSetup();
    void xStop();
    void xEventMouseClick(int,int,int,int);
    void xStart();
    void xEventTaskOpen(int);
    void xEventReset(int,int);
    void xAnimate();
    void xEventAnimateTo(int,int,int,int);
    void xAnimateTo();
    void xEventRemoveIcon(int);
    void xAnimateStepBounce();
    void xAnimateStepMicro();
    void xGetParameter(const QString, QString&);
    void xGetParameterList(QStringList *);
    void xSetupParameter(const QString, const QString);
    void xEventDockerShowed();
    void xEventDockerHidden();
    void xGetInfo(QStringList &);
    void xStopAnimate();
    void xStartAnimate(XGIcon *);
    void xStartAnimate();
    void xAnimateStepBounceDetached();
    void xEventIconAdded(int);
    void xAnimateStepFadeIcon();
    void xAnimateFadeIcon(XGIcon *);
    void xAnimateStepOverlay();
protected:
	XSConfigurations *ActiveConfiguration;
	XGDocker	*xGDocker;
	double radians;
	QPoint mouse;
	QPoint mousef;
	int moltiplier;
	int lastRaise;
	int animatorCounter;
	int BounceHigh;
	//int Counter;
	XGIcon		*lastIcon;
	QPtrList<XGIcon> lastIcons;
	QTimer		*bounceTimer;
	QTimer		*fadeTimer;
	QTimer		*bounceDetachedTimer;
	QTimer		*overlayPollTimer;
	xGFloater *LocalDetachedWindow;
	QMutex		AnimationsMutex;
	
	QString		onClickAnimation;
	QString		onRaiseAnimation;
	QString		onCloseAnimation;
	QString		onHideAnimation;
	QString		onShowAnimation;
	QString		onAddAnimation;
	QString		onSlideAnimation;

	XGIcon		*animatingIcon;
protected:
    void xAnimateDockerSlideShow();
    void xAnimateDockerFadeShow();
    void xAnimateDockerFadeHide();
    void xAnimateDockerSlideHide();
protected:
    void xAnimateOverlay(XGIcon *);
};

#endif
