/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xgdocker.h"
#include "xeobject.h"
#include "xematrix.h"

#include <qevent.h>
#include <qdragobject.h> 
#include <qsizepolicy.h>
#include <qtimer.h>
#include <qpainter.h> 
#include <qimage.h>
#include <qdatetime.h> 
#include <qwidget.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qfont.h>
#include <qcolor.h>
#include <krootpixmap.h>
#include <ksharedpixmap.h>

#include <dcopclient.h>
#include <xeplugin_gepillow.h>

#include <klocale.h>
#include <kstandarddirs.h>
#include <kmainwindow.h>
#include <kicontheme.h>
#include <kwin.h>
#include <kmainwindow.h>
#include <kpopupmenu.h>
#include <kapplication.h>


#include <time.h>
#include <unistd.h>
#include <stdlib.h>
#include <kimageeffect.h>
#include <kpixmapeffect.h>

/*
#include <X11/extensions/Xcomposite.h>
//#include <X11/extensions/compositeproto.h>
#include <X11/extensions/Xrender.h>
#include <X11/extensions/shape.h>
*/


#include "xgdocker.moc"
#include <netwm.h>
//#include "netwm.cpp"

//#undef ENABLE_FINAL

// kde is more fast than X11 calls, I dunno why
//#undef USE_KWIN

#ifndef USE_KWIN
#include <X11/Xlib.h>
/*
void x11SetOnTop(Window w)
{

Display *d=XOpenDisplay(0);
Window r=RootWindow (d, DefaultScreen(d));
static Atom net_wm_state_stays_on_top = 0;
static Atom net_wm_state = 0;
static XEvent e;
unsigned long netwm_sendevent_mask=(SubstructureRedirectMask| SubstructureNotifyMask);
if(net_wm_state_stays_on_top==0)net_wm_state_stays_on_top = XInternAtom(qt_xdisplay(), "_NET_WM_STATE_STAYS_ON_TOP", false);
if(net_wm_state==0)net_wm_state= XInternAtom(d, "_NET_WM_STATE", false);

printf("net_wm_state=%d net_wm_state_stays_on_top=%d\n",net_wm_state,net_wm_state_stays_on_top);
//XInternAtoms(d, (char **) names, netAtomCount, False, atoms);
e.xclient.data.l[0] = 1;
e.xclient.data.l[1] = net_wm_state_stays_on_top;
e.xclient.data.l[2] = 0l;
e.xclient.type = ClientMessage;
e.xclient.message_type = net_wm_state;
printf("%d\n",net_wm_state);
e.xclient.display = d;
e.xclient.window =  w;
e.xclient.format = 32;
e.xclient.data.l[3] = 0l;
e.xclient.data.l[4] = 0l;
//QX11Info::display(), QX11Info::appRootWindow()
XSendEvent(d, r, False, netwm_sendevent_mask, &e);
printf("x11SetOnTop(Window w)\n");
}
*/
void x11SetOnTop(Window w)
{
	static Display *d=XOpenDisplay(0);
	static Window r=RootWindow (d, DefaultScreen(d));
	static NETWinInfo* info=NULL;
	if(info==NULL)info = new NETWinInfo( d, w, r, NET::WMState );
	//info->setDesktop( NETWinInfo::OnAllDesktops);
	//printf("Apply: %d (%d)\n",NET::StaysOnTop,info->state());
	//info->setState(NET::KeepAbove,NET::KeepAbove);
	info->setState(NET::StaysOnTop | NET::KeepAbove,NET::StaysOnTop | NET::KeepAbove);
	//printf("State (%d)\n",info->state());
	delete info;
	info=NULL;
	//NETWinInfo info( qt_xdisplay(), win, qt_xrootwin(), NET::WMState );
	//info.setState( state, state );
	

}
int x11getOnTop(Window w)
{
	static Display *d=XOpenDisplay(0);
	static Window r=RootWindow (d, DefaultScreen(d));
	static NETWinInfo* info=NULL;
	if(info==NULL)info = new NETWinInfo( d, w, r, NET::WMState );
	//info->setDesktop( NETWinInfo::OnAllDesktops);
	//info->setState(NET::KeepAbove,NET::KeepAbove);
	unsigned long wState=info->state();
	delete info;
	info=NULL;
	//printf("Stato:%d\n",wState);
	if(wState&NET::StaysOnTop)return NET::StaysOnTop;
	else return 0;
}
void x11SetFloating(Window w)
{
	static Display *d=XOpenDisplay(0);
	static Window r=RootWindow (d, DefaultScreen(d));
	static NETWinInfo* info=NULL;
	//_NET_WM_STATE_SKIP_TASKBAR
	if(info==NULL)info = new NETWinInfo( d, w, r, NET::WMState |NET::WMWindowType);
	//info->setDesktop( NETWinInfo::OnAllDesktops);
	//info->setState(NET::KeepAbove,NET::KeepAbove);
/*
	info->setState(
		NET::Override |NET::Dock
		,
		NET::Override |NET::Dock
			);
*/
	info->setWindowType(NET::Dock);
	//info->setWindowType(NET::Override);
	info->setState(NET::SkipPager | NET::SkipTaskbar|NET::KeepBelow,NET::SkipPager | NET::SkipTaskbar
		//|NET::KeepAbove);
		|NET::KeepBelow);
	delete info;
	info=NULL;
	//NETWinInfo info( qt_xdisplay(), win, qt_xrootwin(), NET::WMState );
	//info.setState( state, state );
	//_NET_WM_STATE_SKIP_PAGER
	

}


#endif
/*
void print_wmState(Window w)
{
	static Display *d=XOpenDisplay(0);
	static Window r=RootWindow (d, DefaultScreen(d));
	static NETWinInfo* info=NULL;
	if(info==NULL)info = new NETWinInfo( d, w, r,
		NET::WMState
// 		|
// 		NET::WMStrut |
// 		NET::WMWindowType |
// 		NET::WMName |
// 		NET::WMVisibleName |
// 		NET::WMDesktop |
// 		NET::WMPid |
// 		NET::WMKDEFrameStrut |
		//NET::XAWMState
			);
	//info->setDesktop( NETWinInfo::OnAllDesktops);
	//info->setState(NET::KeepAbove,NET::KeepAbove);
	printf("Stato:%d %d %d\n",info->state(),NET::StaysOnTop,NET::KeepAbove);
}

*/

XGDocker::XGDocker(QWidget *parent, const char *name)
 : QWidget(0, name
 //)
 ,
//WStyle_StaysOnTop
//|   WStyle_Customize | 
  WRepaintNoErase
 | WStyle_NoBorder 
 //| WDestructiveClose 
 ////  |Qt::WState_OwnSizePolicy 
  )
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"XGDocker::XGDocker()");
#endif

	Matrix=NULL;
	Configurator=NULL;
	tMouseMoved=NULL;
	tAutoHideTimer=NULL;
	tPostIconAdd=NULL;
	tAutoSendBGTimer=NULL;
	tPostShowRaise=NULL;
//	tAutoSendFGTimer=NULL;
//	tDrawPillow=NULL;
	KDesktopBackground=NULL;
	m_pPixmap=NULL;
	tAnimateBackground=NULL;
	fakeHeightDesktop=0;
	mayRequireDoChangeBackground=0;
	alternativeHeightDesktop=0;
	isDropping=0;
	isDragging=0;
	hasDragged=-1;
	lastActionis=0;
	polling=NULL;

	for(uint i=0; i< MAX_ICONS;i++)activeIcons[i]=NULL;
	activeIconsCounter=0;
	//activeIconsCounterLast=0;
	// Draw issue
	if(parent)
	{
		// Warning this widget cannot be parented
	}
	
	// XD System Wide installation
	XEObject::xSetEngineDocker(this);
	// Setup the Style for this widget:
	setBackgroundMode(Qt::NoBackground,Qt::NoBackground);
#ifdef USE_KWIN
	KWin::setType(winId(), NET::Dock);
	//KWin::setType(winId(), NET::Override);
	KWin::setState( winId(), NET::StaysOnTop );
#else
	//raise();
	x11SetFloating(winId());
	//x11SetOnTop(winId());
#endif
	NETWinInfo* info;
	info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState );
	info->setDesktop( NETWinInfo::OnAllDesktops);
	// Enable the mouseMoveEvent( QMouseEvent *e )
	setMouseTracking (true);
	setFocusPolicy(QWidget::StrongFocus);
	setSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
	//setFixedSize(0,0);
	xReset();
	AxisAreInverted=0;
	setAcceptDrops(TRUE);
	// 0.35 desaturate
	backgroundBarAniFrame=0;
	lastDesaturate=Desaturate=0;
	maxDesaturate=0;
	isLowering=0;
	// 0.27
	// bug fix at startup for taskadd b plugins loaded before xdocker
	//move(-10000,-10000);
	move(QApplication::desktop()->width()+10,QApplication::desktop()->height()+10);


pattern = QString("DESKTOP%1");
    int screen_number = DefaultScreen(qt_xdisplay());
    if (screen_number) {
        pattern = QString("SCREEN%1-DESKTOP").arg(screen_number) + "%1";
    }

	// Composite
	HasComposite=0;
	/*
	Display *dpy = QPaintDevice::x11AppDisplay();
	bool hasNamePixmap = false;
	
	int event_base, error_base;
	if ( XCompositeQueryExtension( dpy, &event_base, &error_base ) )
	{
		// If we get here the server supports the extension
	
		int major = 0, minor = 2; // The highest version we support
		XCompositeQueryVersion( dpy, &major, &minor );  
	
		// major and minor will now contain the highest version the server supports.
		// The protocol specifies that the returned version will never be higher
		// then the one requested. Version 0.2 is the first version to have the
		// XCompositeNameWindowPixmap() request.
		if ( major > 0 || minor >= 2 )
			hasNamePixmap = true;
	}
	if(hasNamePixmap)
	{
		// Composite enabled
		HasComposite=1;
		for ( int i = 0; i < ScreenCount( dpy ); i++ )
        		XCompositeRedirectSubwindows( dpy, RootWindow( dpy, i ),CompositeRedirectAutomatic );
// Create a Render picture so we can reference the window contents.
// We need to set the subwindow mode to IncludeInferiors, otherwise child widgets
// in the window won't be included when we draw it, which is not what we want.
XRenderPictureAttributes pa;
pa.subwindow_mode = IncludeInferiors; // Don't clip child widgets
// We need to find out some things about the window, such as it's size, it's position
// on the screen, and the format of the pixel data
XWindowAttributes attr;
XGetWindowAttributes( dpy, winId(), &attr );
XRenderPictFormat *format = XRenderFindVisualFormat( dpy, attr.visual );
bool hasAlpha             = ( format->type == PictTypeDirect && format->direct.alphaMask );
int x                     = attr.x;
int y                     = attr.y;
int width                 = attr.width;
int height                = attr.height;

Picture picture = XRenderCreatePicture( dpy, winId (), format, CPSubwindowMode, &pa );
// Create a copy of the bounding region for the window
XserverRegion region = XFixesCreateRegionFromWindow( dpy, winId (), WindowRegionBounding );

// The region is relative to the screen, not the window, so we need to offset
// it with the windows position
XFixesTranslateRegion( dpy, region, -x, -y );
XFixesSetPictureClipRegion( dpy, picture, 0, 0, region );
XFixesDestroyRegion( dpy, region );
// notify shape changes
XShapeSelectInput( dpy,  winId (), ShapeNotifyMask );
	}

	if(HasComposite)
	{
		qWarning("Composite shadows are enabled!!!!!!!");
	}
	else
	{
		qWarning("Composite shadows are NOT enabled!!!!!!!");
	}
	*/
}


XGDocker::~XGDocker()
{
#ifndef ENABLE_FINAL
qWarning("XEPlugin_Command::~XEPlugin_Command()");
#endif
}




/*!
    \fn XGDocker::xCfgChanged(QObject *XECfgObject)
 */
void XGDocker::xCfgChanged(QObject *XECfgObject)
{
	// We are going to get the new conf from configurator
	XEConfiguration *NewConfigurator=(XEConfiguration *)XECfgObject;
	if(NewConfigurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"falling back to ActiveConfiguration");
#endif
		// return;
	}
	else
	{
		ActiveConfiguration=NewConfigurator->xGetConfiguration();
	}
	if(ActiveConfiguration==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"error while searching for configuration data");
#endif
		return;
	}
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"appling new configuration");
#endif
	
	/// @todo Dont do Resize
	applyCfg();
}


/*!
    \fn XGDocker::xReset()
 */
void XGDocker::xReset()
{
	// Reset all data
	LayoutPosition=LONBOTTOM;
	ActiveConfiguration=NULL;
	lastButtonStatus=Qt::NoButton;
	lastIconDrag=NULL;
	req.tv_nsec=0;
	req.tv_sec=0;
	//lastRaise=2;
	isRaised=0;
	isAnimating=0;
	lastRaise=0;
	xLastX=0;
	xLastY=0;
	xLastX_real=xLastX;
	xLastY_real=xLastY;	
#ifdef ENABLE_SPECIALENGINE2
	xLastX_notmanaged=xLastX;
	xLastY_notmanaged=xLastY;
#endif
	isAnimating=0;
	xDesignVirtualYMatrix=0;
	lastRaise=0;
	lastIcon=0;
	lastIconActivated=0;
	RefreshMask=0;

	if(polling==NULL)
	{
		polling=new QTimer();
		connect(polling,
		SIGNAL(timeout()),
		this, SLOT(xStep()));
	}
	
	if(KDesktopBackground==NULL)
	{
		KDesktopBackground=new KRootPixmap((QWidget*)this);
		connect(KDesktopBackground, 
		SIGNAL(backgroundUpdated(const QPixmap &)), 
		this, SLOT(backgroundUpdatedbyKDE(const QPixmap &)));
		KDesktopBackground->setCustomPainting(true);
	}
	if(m_pPixmap==NULL)
	{
		m_pPixmap=new KSharedPixmap;
		//qWarning("carica");
		 connect(m_pPixmap, SIGNAL(done(bool)),this, SLOT(backgroundPostDone(bool)));

	}
	if(tMouseMoved==NULL)
	{
		tMouseMoved=new QTimer(this);
		connect(tMouseMoved,SIGNAL(timeout()),this,SLOT(xIRQ_MouseTimeout()));
	}

	if(tAnimateBackground==NULL)
	{
		tAnimateBackground=new QTimer(this);
		connect(tAnimateBackground,SIGNAL(timeout()),this,SLOT(backgroundCicle()));
	}

	if(tAutoHideTimer==NULL)
	{
		tAutoHideTimer=new QTimer(this);
		connect(tAutoHideTimer,SIGNAL(timeout()),
			this,SLOT(xHide()));
	}

	if(tPostIconAdd==NULL)
	{
		tPostIconAdd=new QTimer(this);
		connect(tPostIconAdd,SIGNAL(timeout()),
			this,SLOT(xEventTaskAppendPost()));
	}
	if(tAutoSendBGTimer==NULL)
	{
		tAutoSendBGTimer=new QTimer(this);
		connect(tAutoSendBGTimer,SIGNAL(timeout()),
			this,SLOT(xSendToBackground()));
	}
	if(tPostShowRaise==NULL)
	{
		tPostShowRaise=new QTimer(this);
		connect(tPostShowRaise,SIGNAL(timeout()),
			this,SLOT(showRaisePost()));
	}
/*	if(tAutoSendFGTimer==NULL)
	{
		tAutoSendFGTimer=new QTime(this);
	}
	*/
/*
	if(tDrawPillow==NULL)
	{
		tDrawPillow=new QTimer(this);
		connect(tDrawPillow,SIGNAL(timeout()),
			this,SLOT(xDrawPillow()));
	}
*/	
	
}


/*!
    \fn XGDocker::xSetup()
 */
void XGDocker::xSetup()
{


#ifndef ENABLE_FINAL
qWarning("void XGDocker::xSetup()");
#endif

	// Query for last configuration
	Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	
	Matrix=(XEMatrix *)XEObject::xGetMatrix();
	
	applyCfg();
	//lastRaise=1;
	//isRaised=0;
	//xUpdate(0,0);
	//setMask(maskBackground);
	//polish();
	

	
	// 0.26 Apply xSetup on all modules Icons
	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		activeIcons[iconIndex]->xSetupClass();
	}


#ifndef ENABLE_FINAL
qWarning("void XGDocker::xSetup() end");
#endif

}


/*!
    \fn XGDocker::xStart()
 */
void XGDocker::xStart()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"xStart()");
#endif
#ifdef ENABLE_STATS
	//0.36 TODO!
	ActiveConfiguration->Statistics.dockerStarts++;
	if(ActiveConfiguration->Statistics.dockerFirstStart==0)
	{
		ActiveConfiguration->Statistics.dockerFirstStart=(int)QDateTime::currentDateTime().toTime_t();
	}
	QDateTime tempo=QDateTime::currentDateTime();
	//qWarning(QString("Secondi=%1").arg(ActiveConfiguration->Statistics.dockerSecondsRunning));
	tempo=tempo.addDays(-ActiveConfiguration->Statistics.dockerDaysRunning);
	tempo=tempo.addSecs(-ActiveConfiguration->Statistics.dockerHoursRunning*60*60
		-ActiveConfiguration->Statistics.dockerMinutesRunning*60
		-ActiveConfiguration->Statistics.dockerSecondsRunning);

	ActiveConfiguration->Statistics.lastStart=tempo.toTime_t();

#endif


	Busy.unlock();
	
	KDesktopBackground->start();
	
	//xUpdate();
	//showRaised();
	// 0.27
	//move(QApplication::desktop()->width()+10,QApplication::desktop()->height()+10);
	//setFixedSize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height);
	
	xMoveWidgetCenter();
	checkBackgroundSeparators();
	//backgroundCicle();
	// 0.26 Apply xStart on all modules Icons
	// 0.38 moved to addIcon
	/*
	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		activeIcons[iconIndex]->xStartClass();
	}
	*/
	xUpdateMatrix();
	mayRequireDoChangeBackground=1;
	if(tPostIconAdd->isActive())tPostIconAdd->stop();
	tPostIconAdd->start(200);

	QTimer::singleShot(1500,this,SLOT(xPostStart()));

}

/*!
    \fn XGDocker::xPostStart()
 */
void XGDocker::xPostStart()
{
//	xUpdate();
//	repaint(true);
	//show();
	showRaised();
	//x11SetFloating(winId());
	QTimer::singleShot(1,this,SLOT(xSendToBackground()));
}


/*!
    \fn XGDocker::xStop()
 */
void XGDocker::xStop()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"xStop()");
#endif
	hide();
	KDesktopBackground->stop();
	//releaseMouse();

}

/*!
    \fn XGDocker::mouseMoveEvent( QMouseEvent *e )
 */
void XGDocker::mouseMoveEvent( QMouseEvent *e )
{
#ifdef ENABLE_SPECIALENGINE2
#ifndef ENABLE_FINAL
	qWarning("Engine2: 276");
#endif
	if(isDragging>0 && lastButtonStatus!=Qt::NoButton)
	{
//		qWarning(QString("507 %1").arg(isDragging));
		isDragging++;
		// work around this does not work
		//if(isDragging>ActiveConfiguration->Icons.Size)
		if(isDragging>2)
		{
			startDrag();
			isDragging=0;
		}
	}
	if(cacheBusy.tryLock()==false)return;
	{	
	/*
	xLastX_notmanaged=x;
	xLastY_notmanaged=y;
	*/
#ifndef ENABLE_FINAL
		qWarning("QTimer::singleShot(1,this,SLOT(purgeCacheMovements()));");
#endif
//		QTimer::singleShot(1,this,SLOT(purgeCacheMovements()));

		// 0.27
		// stop all timers
		//tMouseMoved;
		tAutoHideTimer->stop();
		//tPostIconAdd;
		tPostShowRaise->stop();
		tAutoSendBGTimer->stop();


		if(ActiveConfiguration->Window.SendToBackground)
		{
			//0.28
			if(ActiveConfiguration->Window.FastHide)
			{
				
			}
			else
			{
//qWarning("MouseMovement");
//print_wmState(winId());
			
				if(
#ifdef USE_KWIN
					KWin::windowInfo(winId()).state()==NET::StaysOnTop
					||
					windowState()==Qt::WindowActive
#else
					//windowState()==Qt::WindowActive
					x11getOnTop(winId())
					||
					windowState()==Qt::WindowActive
					
#endif
					)
				{
					//qWarning("Already ontop");
				}
				else
				{
				alternativeHeightDesktop=ActiveConfiguration->Icons.Size+16;
				fakeHeightDesktop=alternativeHeightDesktop;
				}
			}
			//if(tAutoSendFGTimer->restart()>
			// we have to raise it!!!
			// 0.27
			//show();
			//showRaised();
//qWarning("Raising");
#ifdef USE_KWIN
			KWin::setState( winId(), NET::StaysOnTop );
//			NETRootInfo rootinfo( qt_xdisplay(), NET::WM2RestackWindow);//NET::WMMoveResize);
			// TODO: fix for WMApplets
			/*
			for(uint iconsCounter=0;iconsCounter<activeIconsCounter;iconsCounter++)
			{
				if(activeIcons[iconsCounter]->iExternal)
				//rootinfo.restackRequest(winId(),activeIcons[iconsCounter]->iExternal,0);
				KWin::setState(activeIcons[iconsCounter]->iExternal, NET::StaysOnTop );
			}
			*/


#else
			//NetWinInfo::setState()
			//raise();
			//QWidget::hide();
			//QWidget::show();
			x11SetOnTop(winId());
#endif
		}

		isAnimating=1;
		if(!isRaised)xLastX=e->pos().x();
		purgeCacheMovements();

	}
	return;
#endif
	int x=e->pos().x();
	int y=e->pos().y();
	
	// Do you like to interrupt animations ?
	// if(isAnimating)return;
	
	funz1=&XGDocker::mouseMoveEventSW;
	
	//mouseMoveEventSW(x,y,0,lastButtonStatus);
	(this->*funz1)(x,y,0,lastButtonStatus);
	xUpdate();
	repaint(false);
}


/*!
    \fn XGDocker::xUpdate(int EnableTransparency=0)
 */
void XGDocker::xUpdate(int Transparency, int pass)
{
	// CleanUP code PASS 1 (20040404)

#ifndef ENABLE_FINAL
qWarning(QString("void XGDocker::xUpdate(int , int %1)").arg(pass));
#endif

	// Ok is software call ?
	// like the Smoothing past engine?
	if(pass==0)
	{
		xUpdatePart1(Transparency,pass);
	}
	else
	{
		switch(Transparency)
		{
			case 1:
			imgFakeBackgroundAfterTransparency=imgFakeBackgroundGlobal;
			imgFakeBackgroundAfterTransparency.detach();
			// this will kreate a plain transparent window
			imgFakeBackgroundGlobal.setAlphaBuffer(false);
			imgFakeBackgroundGlobal.fill(0);
			imgFakeBackgroundGlobal.setAlphaBuffer(true);
			break;
			case 2:
			imgFakeBackgroundGlobal=imgFakeBackgroundAfterTransparency;
			break;
		}
	}
	nanosleep(&req,&rem);
	xUpdateDrawBackground(Transparency);
	// Painting the FAKE WINDOW!!!!

	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
	/*
		if(activeIcons[iconIndex].xSetUpdate>0)
		{
			//activeIcons[iconIndex].imgShowed=activeIcons[iconIndex].imgSource;
			activeIcons[iconIndex].xTransparency=
				activeIcons[iconIndex].xImgShowed.createAlphaMask();;

			//RefreshMask=1;
		}
	*/
#ifndef ENABLE_FINAL
		qWarning(QString("activeIcons[%1][%1][%1][%1]").arg(iconIndex).arg(activeIcons[iconIndex]->xPosition.x()).arg(activeIcons[iconIndex]->xPosition.y()).arg(activeIcons[iconIndex]->xZoom));
#endif
		// 0.37
		if(!activeIcons[iconIndex]->hidden)
		{
			bitBlt(&paintBuffer,
				activeIcons[iconIndex]->xPosition.x(),
				activeIcons[iconIndex]->xPosition.y(),
				&activeIcons[iconIndex]->xImgShowed,0,Qt::CopyROP);
		}
		else
		{
			// check if there is an external window
			if(activeIcons[iconIndex]->wExternal!=NULL)
			{
				activeIcons[iconIndex]->wExternal->move(
				activeIcons[iconIndex]->xPosition.x()+x(),
				activeIcons[iconIndex]->xPosition.y()+y()
					);
				activeIcons[iconIndex]->wExternal->resize(
				activeIcons[iconIndex]->xZoom,
				activeIcons[iconIndex]->xZoom
					);
			}
			else
			{
				if(activeIcons[iconIndex]->iExternal!=0)
				{
//qWarning("hippo");
/*
NETRootInfo *RootInfo=new NETRootInfo(qt_xdisplay(),qt_xrootwin(), "DockApp",NULL,0,0,false);
RootInfo->moveResizeWindowRequest(activeIcons[iconIndex]->iExternal,0,
				activeIcons[iconIndex]->xPosition.x()+x(),
				activeIcons[iconIndex]->xPosition.y()+y(),
				activeIcons[iconIndex]->xZoom,
				activeIcons[iconIndex]->xZoom);
*/
//(Window window, int flags, int x, int y, int width, int height )
/*
NETRootInfo rootinfo( qt_xdisplay(), NET::WMMoveResize);
rootinfo.moveResizeRequest(activeIcons[iconIndex]->iExternal,
				activeIcons[iconIndex]->xPosition.x()+x(),
				activeIcons[iconIndex]->xPosition.y()+y(),
                                //NET::TopLeft|
				//NET::Move
				//NET::TopLeft
				//|NET::Move
				);
*/
NETRootInfo rootinfo( qt_xdisplay(), NET::WM2MoveResizeWindow);//NET::WMMoveResize);
rootinfo.moveResizeWindowRequest(activeIcons[iconIndex]->iExternal,
				NET::TopLeft
				| 1<<8 |1<<9
				,
				//NET::Move,
				activeIcons[iconIndex]->xPosition.x()+x()-ActiveConfiguration->Icons.Size/2+activeIcons[iconIndex]->xZoom/2,
				activeIcons[iconIndex]->xPosition.y()+y()-ActiveConfiguration->Icons.Size/2+activeIcons[iconIndex]->xZoom/2,
				ActiveConfiguration->Icons.Size,
				ActiveConfiguration->Icons.Size
				);
				//activeIcons[iconIndex]->xZoom,
				//activeIcons[iconIndex]->xZoom);
/*
 NETWinInfo info( qt_xdisplay(), activeIcons[iconIndex]->iExternal, activeIcons[iconIndex]->iExternal,0);//qt_xrootwin(), 0 );
    NETStrut strut;
    strut.left = activeIcons[iconIndex]->xPosition.x()+x();
    strut.right =activeIcons[iconIndex]->xPosition.y()+y() ;
    strut.top = activeIcons[iconIndex]->xZoom;
    strut.bottom = activeIcons[iconIndex]->xZoom;
    info.setStrut( strut );
*/
/*
NETWinInfo* info;
info = new NETWinInfo( qt_xdisplay(), activeIcons[iconIndex]->iExternal, qt_xrootwin(), NET::WMState );
info->
*/

/*
moveResizeWindow(Window window, int flags, int x, int y, int width, int height) { Q_UNUSED(window); Q_UNUSED(flags); Q_UNUSED(x); Q_UNUSED(y); Q_UNUSED(width); Q_UNUSED(height); }
*/
				}
			}
		}
		// Drawing arrow
		// TODO: we are polling status of icon from configuration data it may be null
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.TaskInfo!=NULL ||ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.dcopReady
		||ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.forceRunning
		)
		{
			
			bitBlt(&paintBuffer,
				activeIcons[iconIndex]->xPosition.x()
				+activeIcons[iconIndex]->xZoom/2
				-ActiveConfiguration->Icons.Size/2,
				activeIcons[iconIndex]->xPosDefault.y(),
				&activeIcons[iconIndex]->xImgArrow,0,Qt::CopyROP);
		}
		// 0.36 with miniText
		xUpdateRepaintMiniTextInline(iconIndex);



		// 0.31
		// draw overtext
		/*
		if(lastIcon==iconIndex)
		{
			if(!isAnimating)xDrawPillow();
		}
		*/
	}


	/*
	if(RefreshMask>0)
	{
		maskBuffer.fill(Qt::color0);
		
		
		for(long int iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
		{

		bitBlt(&maskBuffer,
			activeIcons[iconIndex]->xPosition.x(),
			activeIcons[iconIndex]->xPosition.y(),
			//&activeIcons[iconIndex].xTransparency,0,Qt::CopyROP);
			&activeIcons[iconIndex]->xTransparency,0,Qt::AndROP);

		}
		// Fake Desktop Patch 02162004 _rev 2
		bitBlt(&maskBuffer,
			0,
			ActiveConfiguration->Window.Height-ActiveConfiguration->Window.HeightDesktop,
			&this->fakeDesktop,0,Qt::CopyROP);
		//setMask(maskBuffer);
		//setMask(newFakeDesktop);
		//qApp->syncX();
		RefreshMask=0;
	}
	*/
	xDrawPillow2();

	xUpdateDrawBackgroundPass2();
	
}


/*!
    \fn XGDocker::paintEvent( QPaintEvent *e)
 */
void XGDocker::paintEvent( QPaintEvent *e)
{
#ifndef ENABLE_FINAL
	//xWarningMsg(this,"void XGDocker::paintEvent( QPaintEvent *e)");
#endif

	rect = e->rect();
	l=rect.left();
	t=rect.top();
	w=rect.width();
	h=rect.height();
	bitBlt(this,
		l,
		t,
		&paintBuffer,
		l,t,w,h,
		Qt::CopyROP);
	//bitBlt(this,0,0,&paintBuffer,0,Qt::CopyROP);
/*
// [Fill the destination widget/pixmap with whatever you want to use as a background here]

Display *dpy = QPaintDevice::x11AppDisplay();
XRenderPictureAttributes pa;
pa.subwindow_mode = IncludeInferiors; // Don't clip child widgets
// We need to find out some things about the window, such as it's size, it's position
// on the screen, and the format of the pixel data
XWindowAttributes attr;
XGetWindowAttributes( dpy, winId(), &attr );
XRenderPictFormat *format = XRenderFindVisualFormat( dpy, attr.visual );
bool hasAlpha             = ( format->type == PictTypeDirect && format->direct.alphaMask );
int x                     = attr.x;
int y                     = attr.y;
int width                 = attr.width;
int height                = attr.height;


Picture picture = XRenderCreatePicture( dpy, winId (), format, CPSubwindowMode, &pa );
XRenderComposite( dpy, hasAlpha ? PictOpOver : PictOpSrc, picture, None,
                x11RenderHandle(), 0, 0, 0, 0, 0, 0, width, height );
*/
/*
Display *dpy = QPaintDevice::x11AppDisplay();
XRenderPictureAttributes pa;
pa.subwindow_mode = IncludeInferiors; // Don't clip child widgets
// We need to find out some things about the window, such as it's size, it's position
// on the screen, and the format of the pixel data
XWindowAttributes attr;
XGetWindowAttributes( dpy, winId(), &attr );
XRenderPictFormat *format = XRenderFindVisualFormat( dpy, attr.visual );
bool hasAlpha             = ( format->type == PictTypeDirect && format->direct.alphaMask );
int x                     = attr.x;
int y                     = attr.y;
int width                 = attr.width;
int height                = attr.height;
// Create a copy of the bounding region for the window
XserverRegion region = XFixesCreateRegionFromWindow( dpy, winId (), WindowRegionBounding );

// The region is relative to the screen, not the window, so we need to offset
// it with the windows position
XFixesTranslateRegion( dpy, region, -x, -y );
XFixesSetPictureClipRegion( dpy,0, 0, 0, region );
XFixesDestroyRegion( dpy, region );
*/
}


/*!
    \fn XGDocker::applyCfg()
 */
void XGDocker::applyCfg()
{
	req.tv_nsec=ActiveConfiguration->Engine.SleepFPS*1000;
	req.tv_sec=0;

	
	req2.tv_nsec=req.tv_nsec/100;
	//(ActiveConfiguration->Engine.SleepThreads/100)*1000;
	if(req2.tv_nsec<1)req2.tv_nsec=1;
	req2.tv_sec=0;

#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"configuration ready");
	char pippo[50];
	sprintf(pippo,"w:%d h:%d top:%d left:%d actual w:%d, h:%d",
			ActiveConfiguration->Window.Width,
			ActiveConfiguration->Window.Height,
			ActiveConfiguration->Window.Top,
			ActiveConfiguration->Window.Left,
			width(),
			height()
		);
	xWarningMsg(this,pippo);
	
#endif
	
	// patch 18042004 check out the align
	//0.30
	xUpdateBackgroundCoords();
	XGIcon::ActiveConfiguration=ActiveConfiguration;
	XGIconTextMaker::ActiveConfiguration=ActiveConfiguration;
	ActiveConfiguration->Window.borderLeft=
		ActiveConfiguration->Matrix.KMatrix
			//[ActiveConfiguration->Matrix.sizeMatrix*2-1];
			[0]
			+ActiveConfiguration->Icons.Size+16;
	
	imgBackground.create(ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,32);
	imgFakeBackgroundGlobal.create(ActiveConfiguration->Window.Width,
		ActiveConfiguration->Window.Height,32);
	paintBuffer.create(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height,32);
	maskBackground.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskSliding.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskBuffer.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskBackground.fill(Qt::color0);
	maskSliding.fill(Qt::color0);
	maskFull.resize(ActiveConfiguration->Window.Width,
	ActiveConfiguration->Window.Height);
	maskFull.fill(Qt::color1);
	
	// 0.27
	//fakeDesktop.resize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.HeightDesktop);
	fakeDesktop.resize(ActiveConfiguration->Window.Width,ActiveConfiguration->Icons.Size+16);
	
	fakeDesktop.fill(Qt::color1);
	
	maskBuffer.fill(Qt::color0);

	// Load - Reload Icons
	if(activeIconsCounter>0)// && activeIcons!=NULL)
	{
		#ifndef ENABLE_FINAL
			xWarningMsg(this,"destroy old icons");	
		#endif
		// Destroy old icons
		for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
		{
			if(activeIcons[iconIndex]==NULL)continue;
			delete activeIcons[iconIndex];
		}	
		activeIconsCounter=0;
	}
	
		// Loading defaults icons
		//XGIcon::ActiveConfiguration=ActiveConfiguration;
		for(uint iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
		{
			if(iconIndex>MAX_ICONS)break;
			iconAdd(ActiveConfiguration->ObjectsIcons.at(iconIndex));
			// 0.38
			// moving this code to iconAdd
			/*
			if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className!="GIcon")
			{
				// 0.31
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")
				{
					// it's a separator:
					// disable the Y and other factors
					// 0.31
					activeIcons[iconIndex]->xExclude=1;
					// Than we check for a right png configuration
					// is done on 
					//changeBackground(ActiveConfiguration->Theme.BackgroundPath);
					//updateBackgroundSeparator(iconIndex);
				}
#ifndef ENABLE_FINAL
	qWarning("XEObject::xFindObject(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);");
	qWarning(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);
#endif
	QObject *GClass=XEObject::xFindObject(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className);
				if(GClass==NULL)continue;
#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:637");
			qWarning("activeIcons[activeIconsCounter-1]->xSetClass(GClass);");
#endif
				// 0.31
				//activeIcons[activeIconsCounter-1]->xSetClass(GClass);
				activeIcons[iconIndex]->xSetClass(GClass);
			}
			*/



#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:591");
#endif
		}
		
	// New Engine with separators 11 May 2004
	// Creating the Background must be done at end
#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:856");
#endif	
	//0.31
	//ok
	changeBackground(ActiveConfiguration->Theme.BackgroundPath);
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:598");
#endif
	xDesignVirtualYMatrix=activeIcons[0]->xHotspot.y();
	
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:601");
#endif
	QString PoofName=ActiveConfiguration->Theme.PoofPath;
	PoofName=PoofName+"/poof.png";

	QFile a(::locate("data",PoofName));
	if(!a.exists() || PoofName==QString::null)
	{
		PoofName="kxdocker/themes/poof/poof.png";
	}
	ActiveConfiguration->Theme.Poof.load(::locate("data",PoofName));
	
	// patch for external pillow
	xPillow=(QWidget *)XEObject::xFindObject("xPillow");
	
	// 0.27
	// polish();
}

/*!
    \fn XGDocker::backgroundUpdatedbyKDE(const QPixmap &)
 */
void XGDocker::backgroundUpdatedbyKDE(const QPixmap &pm)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::backgroundUpdatedbyKDE(const QPixmap &pm)");	
#endif

	//0.29
	//qWarning("void XGDocker::backgroundUpdatedbyKDE(const QPixmap &pm)");
	//return;
	imgBackground=PixmapConverter.convertToImage(pm);
	if(!isRaised)
	{
	bitBlt(&imgFakeBackgroundGlobal,
				0,
				0,
				&imgBackground,0,
				Qt::CopyROP);
	}
	xUpdate(0,1);
	repaint(false);
}


/*!
    \fn XGDocker::backgroundUpdated (const QPixmap &pm)
 */
inline void XGDocker::backgroundUpdated (const QPixmap &pm)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"inline void XGDocker::backgroundUpdated (const QPixmap &pm)");
#endif
	//0.29
	//if(pm.isNull())return;
	// 0.33
	// HERE THERE IS A "KDE" BUG ON MULTIHEAD
	imgBackground=PixmapConverter.convertToImage(pm);
	//qWarning("934");
	bitBlt(&imgFakeBackgroundGlobal,
				0,
				0,
				&imgBackground,0,
				Qt::CopyROP);
	//qWarning("940");
	xUpdate(0,1);
	//qWarning("942");

	repaint(false);
	//qWarning("945");

	return;
	//imgBackground=pm.convertToImage();
	/*
	imgBackground=PixmapConverter.convertToImage(pm);
	int fakeY=0;
	if(LayoutPosition==LONBOTTOM)
	{
		//fakeY=height()-ActiveConfiguration->Window.HeightDesktop;
		fakeY=ActiveConfiguration->Window.Height-fakeHeightDesktop;
	}
	bitBlt(&imgFakeBackgroundGlobal,
				0,
				fakeY,
				&imgBackground,0,
				//height()
				ActiveConfiguration->Window.Height
				-fakeHeightDesktop,
				ActiveConfiguration->Window.Width,
				fakeHeightDesktop
				,Qt::CopyROP);
	*/
}


/*!
    \fn XGDocker::xIRQ_MouseTimeout()
 */
void XGDocker::xIRQ_MouseTimeout()
{
	//lower();
	tMouseMoved->stop();
	tAutoHideTimer->stop();
	// 0.27
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xIRQ_MouseTimeout()");
#endif
	//tAutoSendBGTimer->stop();
	//tDrawPillow->stop();
	//isRaised=0;
	//setMask(maskBuffer);
	//releaseMouse();
	
	xUpdateSmooth();
	
	if(lastIcon>=0 && lastIcon<(int)activeIconsCounter)
	{
		activeIcons[lastIcon]->xSetIntensity(0.1);
		activeIcons[lastIcon]->xStartAnimating();
		/*
		bitBlt(&paintBuffer,activeIcons[lastIcon]->xPosition.x()+
			activeIcons[lastIcon]->xZoom/2
			-
			activeIcons[lastIcon]->xImgDrop.width()/2
			,
			activeIcons[lastIcon]->xPosition.x()
			,&activeIcons[lastIcon]->xImgDrop,
			0,
			Qt::CopyROP);
		*/
		
		if(lastIconActivated!=lastIcon)
		{
			activeIcons[lastIcon]->xStopAnimating();
			lastIconActivated=lastIcon;
		}
		xUpdate(0,1);
		// 0.28
		// basket for drop action

		if(isDropping && ActiveConfiguration->ObjectsIcons.at(lastIcon)->Info.className!="GSeparator")
		{
		bitBlt(&paintBuffer,
			activeIcons[lastIcon]->xPosition.x()
			+
			activeIcons[lastIcon]->xZoom/2-
			activeIcons[lastIcon]->xImgDrop.width()/2
			,
			activeIcons[lastIcon]->xPosition.y()
			,
			&activeIcons[lastIcon]->xImgDrop,
			0,/*0,
			ActiveConfiguration->Icons.SizeBig,
			ActiveConfiguration->Icons.SizeBig,*/
			Qt::CopyROP);
		}
		
	}
	else
	{
		
		xUpdate(0,1);
	}
	
	
	/*	
	if(lastIcon>=0 && lastIcon<activeIconsCounter && isRaised)
	{
		bitBlt(&paintBuffer,activeIcons[lastIcon]->xPosition.x()+
			activeIcons[lastIcon]->xTextDecentre,0,&activeIcons[lastIcon]->xImgText,
			0,
			Qt::CopyROP);
	}
	*/

	// fix for transparency
	repaint(false);
	//repaint(true);
	
	//0.31
	// 0.34
	/*
	for(uint i=0;i<activeIconsCounter ;i++)
	{
		if(activeIcons[i]->xPillow)activeIcons[i]->xPillow->hide();
	}
	*/

	// 0.27
	//xDrawPillow();
	//0.31
	//
	// 0.34
	//if(!isAnimating)xDrawPillow2();
	if(isRaised)
	{
#ifdef ENABLE_SPECIALENGINE3
		QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations*10
			,this,SLOT(xIRQ_Reset()));
#else	
		QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations*10
			,this,SLOT(xIRQ_Reset()));
#endif	
		// TODO: pillow must be an external widget
		// like plugins!!!
		/*
		if(!isAnimating && mouseMoveTimeElapsed.elapsed()>1000)QTimer::singleShot(
			ActiveConfiguration->Engine.SleepAnimations*10
			,this,SLOT(xDrawPillow()));
		*/
		//if(!isAnimating)tDrawPillow->start(1000);
		
	}
	else
	{
		//0.34
		//if(activeIcons[0]->xPillow!=NULL)activeIcons[0]->xPillow->hide();
		// AutoHideTimer
#ifndef ENABLE_FINAL
		qWarning("xgdocker.cpp:627 void XGDocker::xIRQ_MouseTimeout()::Not Raised");
#endif
		if(ActiveConfiguration->Window.FastHide>0)
		{
			// 0.27
			//xHide();
			//QTimer::singleShot(0,this,SLOT(xHide()));
			tAutoHideTimer->start(1);
		}
		else
		{
		if(ActiveConfiguration->Window.HideTimeout>0)
		{
#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:630");
#endif
			//if(tAutoHideTimer->isActive())tAutoHideTimer->stop();
			tAutoHideTimer->start(
				ActiveConfiguration->Window.HideTimeout * 1000
			);
		}
		}
	}
}


/*!
    \fn XGDocker::mousePressEvent( QMouseEvent *e )
 */
void XGDocker::mousePressEvent( QMouseEvent *e )
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::mousePressEvent( QMouseEvent *e )");
#endif
	//qWarning("void XGDocker::mousePressEvent( QMouseEvent *e )");
//	isDragging=0;
	lastButtonStatus=e->button();

	hasDragged=-1;

//	if(e->pos().y()<0)return;
	// 0.37 moved to release
	isDragging=1;
}


/*!
    \fn XGDocker::maskGenerareBigFake()
 */
void XGDocker::maskGenerareBigFake()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::maskGenerareBigFake()");
#endif


	// 28/02/2004 smooth mask
	maskBackground.fill(Qt::color0);
	int fakeY=0;
	// 0.27
	//int fakeH=ActiveConfiguration->Window.HeightDesktop;
	int fakeH=ActiveConfiguration->Icons.Size+16;

	if(LayoutPosition==LONBOTTOM)
	{
		//0.27
		//fakeY=ActiveConfiguration->Window.Height-ActiveConfiguration->Window.HeightDesktop;
		fakeY=ActiveConfiguration->Window.Height-fakeH;
		//old fakeH=ActiveConfiguration->Window.HeightDesktop;
	}
	bitBlt(&maskBackground,
			activeIcons[0]->xPosition.x(),
			fakeY,
			&fakeDesktop,0,0,
			activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			ActiveConfiguration->Icons.Size,
			fakeH
			,Qt::CopyROP);
	bitBlt(&maskBackground,
			activeIcons[0]->xPosition.x()-ActiveConfiguration->Icons.Size-16,
			fakeY,
			&backgroundBarLeft.xTransparency,
			0,Qt::CopyROP);
	
	bitBlt(&maskBackground,
			activeIcons[activeIconsCounter-1]->xPosition.x()
				+ActiveConfiguration->Icons.Size,
			fakeY,
			&backgroundBarRight.xTransparency,
			0,Qt::CopyROP);
			
	if(!isRaised)setMask(maskBackground);
}


/*!
    \fn XGDocker::getObjectIcon(int i)
 */
XGIcon * XGDocker::getObjectIcon(int i)
{
/*
#ifndef ENABLE_FINAL
	char pippo[50];
	sprintf(pippo,"XGDocker::getObjectIcon(int %d)",i);
	qWarning(pippo);
#endif
*/
	if(i<0||i>=(int)activeIconsCounter)return NULL;
/*
#ifndef ENABLE_FINAL
	sprintf(pippo,"XGDocker::getObjectIcon(int %d) -> %d",i,activeIcons[i]->xZoom);
	qWarning(pippo);
#endif
*/
	return activeIcons[i];
}


/*!
    \fn XGDocker::iconAdd(const XSGObjectIcon &, int index=-1)
 */
void XGDocker::iconAdd(const XSGObjectIcon *cfgIcon, int index)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::iconAdd(const XSGObjectIcon *cfgIcon, int index)");
#endif

	int iconIndex=activeIconsCounter;
	XGIcon *addedIcon=new XGIcon;
	mayRequireDoChangeBackground=0;
	// 0.30
	if(ActiveConfiguration->AutoResize==1 &&activeIconsCounter>0)
	{
		
		QPoint testIfOut;
		Matrix->xMakeSpace(activeIconsCounter,&testIfOut);
		//qWarning(QString("AutoResize:[%1-%1]").arg(testIfOut.x()).arg(activeIcons[0]->xPosDefault.x()));
		if((testIfOut.x()-activeIcons[0]->xPosDefault.x())>QApplication::desktop()->width()-ActiveConfiguration->Icons.Size)
		{
			//qWarning("AutoResize, we have to resize...");
			// Calc new IconSize
			int sizeTest=ActiveConfiguration->Icons.Size;
			for(;sizeTest>16;sizeTest=sizeTest-1)
			{
			ActiveConfiguration->Icons.Size=sizeTest;
		
				Matrix->xMakeSpace(activeIconsCounter,&testIfOut);
				if((testIfOut.x()-activeIcons[0]->xPosDefault.x())>QApplication::desktop()->width()-ActiveConfiguration->Icons.Size)continue;
				break;
			}
			xUpdateMatrix();
			//xUpdateSense();
			//
			mayRequireDoChangeBackground=1;
			

		}

	}
	
	if(index>=0 && activeIconsCounter!=(uint)index)
	{
		iconIndex=index;
		// if we have to intert a center icon we have to translate the others
#ifndef ENABLE_FINAL
		qWarning("xgdocker.cpp:733");
#endif
		for(int i=index;i<(int)activeIconsCounter-1;i++)
		{
#ifndef ENABLE_FINAL
			qWarning("xgdocker.cpp:736");
#endif
			activeIcons[i]->xPosition=activeIcons[i+1]->xPosition;
			activeIcons[i]->xPosDefault=activeIcons[i+1]->xPosDefault;
			activeIcons[i]->xHotspot=activeIcons[i+1]->xHotspot;
			activeIcons[i]->xZoom=activeIcons[i+1]->xZoom;
//			activeIcons[i]->xSetSmoothZoom(activeIcons[i]->xZoom);
			activeIcons[i]->xSetSmoothZoom();
		}
		Matrix->xMakeSpace(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xPosition);
		Matrix->xMakeSpace(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xPosDefault);
		Matrix->xMakeCenter(activeIconsCounter,&activeIcons[activeIconsCounter-1]->xHotspot);

		
		
		for(int i=activeIconsCounter;i>=index;i--)
		{
			activeIcons[i+1]=activeIcons[i];
		}
	}
	
	QPixmap Pixmap;
	QString imgFileNameReal=xFindIconFile(cfgIcon->Images.imgFileName);
	QFile ifr(imgFileNameReal);
	if(ifr.exists() && imgFileNameReal!=QString::null)
	{
		Pixmap.load(imgFileNameReal);
#ifndef ENABLE_FINAL
		qWarning(imgFileNameReal);
#endif
	}
	else
	{
		Pixmap=KDEIconLoader.loadIcon(
				cfgIcon->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig,
				KIcon::DefaultState,
				NULL,
				true
				);
		// patch 31052004
		// to load the default icon
		if(Pixmap.isNull())
		{
			if(ActiveConfiguration->Theme.DefaultIcon.isNull())
			{
			imgFileNameReal=xFindIconFile("default");
			ifr.setName(imgFileNameReal);
			if(ifr.exists() && imgFileNameReal!=QString::null)
			{
				ActiveConfiguration->Theme.DefaultIcon.load(imgFileNameReal);
			}
			else
			{
				ActiveConfiguration->Theme.DefaultIcon=KDEIconLoader.loadIcon(
					cfgIcon->Images.imgFileName,
					KIcon::NoGroup,
					ActiveConfiguration->Icons.SizeBig
					);
			}
			}
			else
			{
			
			}
			Pixmap=ActiveConfiguration->Theme.DefaultIcon;
		}
	}


			if(Pixmap.isNull())
			{
				#ifndef ENABLE_FINAL
					xWarningMsg(this,"error loading image");
				#endif
				QImage TDF;
				TDF.create(
					1,
					1,
					32);
				
				TDF.setAlphaBuffer(false);
				TDF.fill(0);
				TDF.setAlphaBuffer(true);
				Pixmap.convertFromImage(TDF);

			}
			// resetting mask, cached data
			addedIcon->xReset();
			// loading the image
			//addedIcon->xImgOriginal=PixmapConverter.convertToImage(Pixmap);
			addedIcon->xImgOriginal=Pixmap.convertToImage();
			if(cfgIcon->Tasks.ShowThumbnail>0)
			{
				addedIcon->xImgSource=cfgIcon->Tasks.Thumbnail;
			}
			else
			{
		
				//addedIcon->xImgSource=PixmapConverter.convertToImage(Pixmap);
				addedIcon->xImgSource=Pixmap.convertToImage();
			}
	
			// Setup cacheing policy
			addedIcon->xAndZoomCache=ActiveConfiguration->Engine.AndZoomCache;
			Matrix->xMakeSpace(iconIndex,&addedIcon->xPosition);
			Matrix->xMakeSpace(iconIndex,&addedIcon->xPosDefault);
			Matrix->xMakeCenter(iconIndex,&addedIcon->xHotspot);
			//
			addedIcon->xZoom=ActiveConfiguration->Icons.Size;
			//addedIcon->xSetSmoothZoom(ActiveConfiguration->Icons.Size);
			addedIcon->xSetSmoothZoom();
			if(addedIcon->xExclude)updateBackgroundSeparator(iconIndex);
			//activeIcons[iconIndex]->xSetZoom(ActiveConfiguration->Icons.Size);
			// setup it ready for update
			// activeIcons[iconIndex]->xSetUpdate=1;
	// Loading arrow
	QString ArrowFileName="arrow.png";
	if(cfgIcon->Images.imgFileArrow!=QString::null &&cfgIcon->Images.imgFileArrow!="")ArrowFileName=cfgIcon->Images.imgFileArrow;
	
	if (ActiveConfiguration->Theme.ArrowsPath[ActiveConfiguration->Theme.ArrowsPath.length()-1]!='/')ActiveConfiguration->Theme.ArrowsPath=ActiveConfiguration->Theme.ArrowsPath+"/";
	
	
	ArrowFileName=::locate("data",ActiveConfiguration->Theme.ArrowsPath)+ArrowFileName;
#ifndef ENABLE_FINAL
	qWarning(ArrowFileName);
#endif
	// TODO: check this!
	ArrowFileName=::locate("data",ArrowFileName);
#ifndef ENABLE_FINAL
	qWarning(ArrowFileName);
#endif

	// bug fix 31052004
	QFile ar(::locate("data",ArrowFileName));
	if(!ar.exists() || ArrowFileName==QString::null)
	{
		ArrowFileName="arrow.png";
if(cfgIcon->Images.imgFileArrow!=QString::null)ArrowFileName=cfgIcon->Images.imgFileArrow;
		ArrowFileName="kxdocker/themes/arrows/"+ArrowFileName;
		
		ArrowFileName=::locate("data",ArrowFileName);
		ar.setName(ArrowFileName);
		if(!ar.exists() || ArrowFileName==QString::null)
		{
			ArrowFileName="kxdocker/themes/arrows/arrow.png";
			ArrowFileName=::locate("data",ArrowFileName);
		}		
	}
	
	QPixmap PixmapArrow(ArrowFileName);
	
	if(PixmapArrow.isNull())
	{
		//PixmapArrow.create(1,1,32);
	}

	addedIcon->xImgArrowSource=PixmapConverter.convertToImage(PixmapArrow);
	// patch 18042004 -> enable other icons sizes
	addedIcon->xImgArrow=addedIcon->xImgArrowSource.smoothScale(
		ActiveConfiguration->Icons.Size,
		ActiveConfiguration->Icons.Size,
		QImage::ScaleMax);
	// Loading Drop icon
	ArrowFileName="drop.png";
	if(cfgIcon->Images.imgFileDrop!=QString::null&&cfgIcon->Images.imgFileDrop!="")ArrowFileName=cfgIcon->Images.imgFileDrop;
	if (ActiveConfiguration->Theme.ArrowsPath[ActiveConfiguration->Theme.ArrowsPath.length()-1]!='/')ActiveConfiguration->Theme.ArrowsPath=ActiveConfiguration->Theme.ArrowsPath+"/";
	// TODO: check this!
	ArrowFileName=::locate("data",ActiveConfiguration->Theme.ArrowsPath)+ArrowFileName;
	ArrowFileName=::locate("data",ArrowFileName);

	ar.setName(::locate("data",ArrowFileName));
	if(!ar.exists() || ArrowFileName==QString::null)
	{
		ArrowFileName="drop.png";
		if(cfgIcon->Images.imgFileArrow!=QString::null)ArrowFileName=cfgIcon->Images.imgFileArrow;
		ArrowFileName="kxdocker/themes/arrows/"+ArrowFileName;
		
		ArrowFileName=::locate("data",ArrowFileName);
		ar.setName(ArrowFileName);
		if(!ar.exists() || ArrowFileName==QString::null)
		{
			ArrowFileName="kxdocker/themes/arrows/drop.png";
			ArrowFileName=::locate("data",ArrowFileName);
		}		
	}
	
	QPixmap PixmapDrop(ArrowFileName);
	
	if(PixmapDrop.isNull())
	{

	}

	addedIcon->xImgDrop=PixmapConverter.convertToImage(PixmapDrop);
	/*
	addedIcon->xImgDrop=addedIcon->xImgDrop.smoothScale(
		ActiveConfiguration->Icons.SizeBig,
		ActiveConfiguration->Icons.SizeBig,
		QImage::ScaleMax);
	*/
	
	
		
	addedIcon->xSetText(cfgIcon->OverText);
	
	QString PoofName=ActiveConfiguration->Theme.PoofPath;
	PoofName=PoofName+"/"+cfgIcon->PoofName;
#ifndef ENABLE_FINAL
	qWarning(PoofName);
#endif

	QFile b(::locate("data",PoofName));
	if(!b.exists() || PoofName==QString::null)
	{
		PoofName="kxdocker/themes/poof/";
		PoofName=PoofName+cfgIcon->PoofName;
	}
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:866");
	qWarning(PoofName);
	qWarning(::locate("data",PoofName));
#endif
	addedIcon->Poof.load(::locate("data",PoofName));
	

	addedIcon->iconConfiguration=cfgIcon;
	
	activeIcons[iconIndex]=addedIcon;
	activeIconsCounter++;
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:876");
#endif

#ifdef ENABLE_STATS
	//0.36 TODO!
//ActiveConfiguration->ObjectsIcons.at(iconIndex)->Statistics.dockerIndexSum=ActiveConfiguration->ObjectsIcons.at(iconIndex)->Statistics.dockerIndexSum+iconIndex;

	if(ActiveConfiguration->Statistics.maxIconsDisplayed < (int)activeIconsCounter)
		ActiveConfiguration->Statistics.maxIconsDisplayed=activeIconsCounter;
/*
	double avgExplode=ActiveConfiguration->Statistics.avgIconsDisplayed*ActiveConfiguration->Statistics.avgCounter;
	qWarning(QString("Stats:%1*%1=%1+%1/%1=%1")
		.arg(ActiveConfiguration->Statistics.avgCounter)
		.arg(ActiveConfiguration->Statistics.avgIconsDisplayed)
		.arg(avgExplode)
		.arg(activeIconsCounter)
		.arg(ActiveConfiguration->Statistics.avgCounter+1)
		.arg(avgExplode/ActiveConfiguration->Statistics.avgCounter)
		);
	avgExplode=avgExplode+activeIconsCounter+activeIconsCounter%2;
*/
	ActiveConfiguration->Statistics.avgCounter++;
	ActiveConfiguration->Statistics.avgIconsDisplayed=ActiveConfiguration->Statistics.avgIconsDisplayed+activeIconsCounter;

#endif



	// 0.38 moved code + ask to load plugin
	QString pClassName=ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className;
	if(pClassName!="GIcon")
	{
		// 0.31
		if(pClassName=="GSeparator")
		{
			activeIcons[iconIndex]->xExclude=1;
		}
		QObject *GClass=XEObject::xFindObject(pClassName);
		if(GClass==NULL)
		{
#ifndef ENABLE_FINAL

		qWarning("activeIcons[iconIndex]->xSetClass(GClass); null");
#endif

			// 0.38
			// ask to load the plugin
			XEConfiguration *NewConfigurator=(XEConfiguration *)XEObject::xGetConfiguration();
			if(NewConfigurator!=NULL)
			{
#ifndef ENABLE_FINAL
		qWarning("activeIcons[iconIndex]->xSetClass(GClass); loading");
		qWarning(pClassName);
#endif
				NewConfigurator->xLoadModule(pClassName);
				GClass=XEObject::xFindObject(pClassName);
				// TODO: need to use: PluginXMLConf->xXMLExplode();
				// now simulating the startup
				if(GClass!=NULL)
				{
					connect(this,SIGNAL(xSetup(const QString &)),XEObject::xGetRoot(), SLOT(xSetupThis(const QString &)));
					//connect(this,SIGNAL(xStop(const QString &)),XEObject::xGetRoot(), SLOT(xStop(const QString &)));
					connect(this,SIGNAL(xStart(const QString &)),XEObject::xGetRoot(), SLOT(xStartThis(const QString &)));
					xSetup(pClassName);
					activeIcons[iconIndex]->xSetClass(GClass);
					xStart(pClassName);
					disconnect(SIGNAL(xStart(const QString &)));
					//disconnect(SIGNAL(xStop(const QString &)));
					disconnect(SIGNAL(xSetup(const QString &)));
					activeIcons[iconIndex]->xStartClass();

				}
			}
		}
		else
		{
#ifndef ENABLE_FINAL
			qWarning("activeIcons[iconIndex]->xSetClass(GClass); attached");
#endif
			activeIcons[iconIndex]->xSetClass(GClass);
			activeIcons[iconIndex]->xStartClass();
		}
	}
}


/*!
    \fn XGDocker::iconRemove(int index)
 */
void XGDocker::iconRemove(int index,int noanimation)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::iconRemove(int index,int noanimation)");
#endif

	if(index<0 || index>=(int)activeIconsCounter)return;
	
	// poof animations
	if(!noanimation)xEventRemoveIcon(index);
	
	
	Configurator->iconRemove(index);
	
	XGIcon *removedIcon=activeIcons[index];

	for(int i=activeIconsCounter-1;i>index;i--)
	{
		if(activeIcons[i-1]->xExclude)
		{
			if(!AxisAreInverted)
			{
			activeIcons[i]->xPosition.setX(activeIcons[i-1]->xPosition.x());
			activeIcons[i]->xPosDefault.setX(activeIcons[i-1]->xPosDefault.x());
			}
			else
			{
			activeIcons[i]->xPosition.setY(activeIcons[i-1]->xPosition.y());
			activeIcons[i]->xPosDefault.setY(activeIcons[i-1]->xPosDefault.y());
			}
			activeIcons[i]->xHotspot=activeIcons[i-1]->xHotspot;
			//activeIcons[i]->xZoom=activeIcons[i-1]->xZoom;
		}
		else
		{
			activeIcons[i]->xPosition=activeIcons[i-1]->xPosition;
			activeIcons[i]->xPosDefault=activeIcons[i-1]->xPosDefault;
			activeIcons[i]->xHotspot=activeIcons[i-1]->xHotspot;
			activeIcons[i]->xZoom=activeIcons[i-1]->xZoom;
		}

	}
	for(int i=index;i<(int)activeIconsCounter-1;i++)
	{
		activeIcons[i]=activeIcons[i+1];
		activeIcons[i]->cachePurge();
		//activeIcons[i]->xSetSmoothZoom(activeIcons[i]->xZoom);
		activeIcons[i]->xSetSmoothZoom();
	}
	//ActiveConfiguration->Engine.IconsShowed--;
	activeIconsCounter--;
	activeIcons[activeIconsCounter]=NULL;
	removedIcon->xStopClass();
//	qWarning("1503");
	//0.32
	// delayed
//	delete removedIcon;
	
	// 0.27
	//xMoveWidgetCenter();
	//maskGenerareBigFake();
	//polish();
// 0.38
if(checkBackgroundSeparators())
{/*
	// TODO: URGENT may be bugghed
	qWarning("if(checkBackgroundSeparators())");
	activeIconsCounter--;
	Configurator->iconRemove(activeIconsCounter);
	delete activeIcons[activeIconsCounter];
	activeIcons[activeIconsCounter]=NULL;
	qWarning("if(checkBackgroundSeparators()) end");
*/
}


	mayRequireDoChangeBackground=0;

	// 0.30
	if(ActiveConfiguration->AutoResize==1 &&activeIconsCounter>0)
	{
		
		QPoint testIfOut;
		Matrix->xMakeSpace(activeIconsCounter,&testIfOut);
		//qWarning(QString("AutoResize:[%1-%1]").arg(testIfOut.x()).arg(activeIcons[0]->xPosDefault.x()));
		if((testIfOut.x()-activeIcons[0]->xPosDefault.x())<QApplication::desktop()->width()-ActiveConfiguration->Icons.Size)
		{
			//qWarning("AutoResize, we have to resize...");
			// Calc new IconSize
			int sizeTest=ActiveConfiguration->Icons.Size;
			for(;sizeTest<=ActiveConfiguration->Icons.SizePrefer;sizeTest=sizeTest+1)
			{
			ActiveConfiguration->Icons.Size=sizeTest;
		
				Matrix->xMakeSpace(activeIconsCounter,&testIfOut);
				if((testIfOut.x()-activeIcons[0]->xPosDefault.x())<QApplication::desktop()->width()-ActiveConfiguration->Icons.Size)continue;
				break;
			}
			xUpdateMatrix();
			//
			mayRequireDoChangeBackground=1;
			//changeBackground(ActiveConfiguration->Theme.BackgroundPath);
			//xUpdateSense();
			//return;

		}

	}


	
	if(tPostIconAdd->isActive())tPostIconAdd->stop();
	tPostIconAdd->start(200);
	// 0.32
//	qWarning("1552");
	delete removedIcon;
//	qWarning("1553");
}



/*!
    \fn XGDocker::xEventTaskAppend(int)
 */
void XGDocker::xEventTaskAppend(int iconIndex)
{
#ifndef ENABLE_FINAL
	qWarning(QString("void XGDocker::xEventTaskAppend(int %1)").arg(iconIndex));
#endif
	// 0.27
	// now we can d animations ;)
	//activeIconsCounterLast=activeIconsCounter;
	iconAdd(ActiveConfiguration->ObjectsIcons.at(iconIndex),iconIndex);
	//activeIcons[iconIndex]->dAnimateNowFade=0;
	// 0.38
	// fading animations
	emit xEventAddedIcon(activeIconsCounter-1);

	if(tPostIconAdd->isActive())tPostIconAdd->stop();
	tPostIconAdd->start(200);
	lastActionis=1;
}


/*!
    \fn XGDocker::xEventTaskAppendPost()
 */
void XGDocker::xEventTaskAppendPost()
{
	//if(isRaised)return;
	tPostIconAdd->stop();

	if(mayRequireDoChangeBackground)
	{
// 		qWarning("if(mayRequireDoChangeBackground)");
		mouseMoveEventSW(xLastX,xLastY,1);
		changeBackground(ActiveConfiguration->Theme.BackgroundPath);
		mayRequireDoChangeBackground=0;
		// 0.38
		xUpdate();
		/*
		repaint(false);
		*/
	}

	xMoveWidgetCenter();
	maskGenerareBigFake();
	if(isRaised)
	{
		//QMouseEvent e(QEvent::MouseMove,QPoint(xLastX,xLastY),0,0);
		//mouseMoveEvent(&e);
		mouseMoveEventSW(xLastX,xLastY,1);
		xUpdate(0,1);
		// 0.38
		/*
		repaint(false);
		*/
	}

	// 0.38
	// fading animations
	//activeIcons[activeIconsCounter]->hidden
	// TODO: this is ugly
	/*
	if(lastActionis)
	{
		//emit xEventAddedIcon(activeIconsCounter-1);
		lastActionis=0;
	}
	*/
	repaint(false);
}

/*!
    \fn XGDocker::xIRQ_Reset()
 */
void XGDocker::xIRQ_Reset()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"xEventReset()");	
#endif	

	xEventMouseMoved(xLastX,xLastY);
	//grabMouse();
	//xEventReset(xLastX,xLastY);
}




/*!
    \fn XGDocker::xMoveWidgetCenter()
 */
void XGDocker::xMoveWidgetCenter()
{
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xMoveWidgetCenter()");
#endif
	// Move Window to layer
	/*
	if(strcmp(ActiveConfiguration->Window.Align,"none")==0)
	{
	}
	*/
	if(LayoutPosition==LONTOP)
	{
#ifndef ENABLE_FINAL
		qWarning("xMoveWidgetCenter() top align");
#endif
		int  rwidth=
			activeIcons[activeIconsCounter-1]->xPosDefault.x()
			-activeIcons[0]->xPosDefault.x()+
			(ActiveConfiguration->Icons.Size+16)*2
			+(ActiveConfiguration->Icons.Size);
		ActiveConfiguration->Window.Left=
			(QApplication::desktop()->width()-rwidth)/2
			-(activeIcons[0]->xPosDefault.x()-ActiveConfiguration->Icons.Size-16);
		
		ActiveConfiguration->Window.Top=0;
		//0.28
		if(ActiveConfiguration->Window.RaiseOnEvents)
                KWin::setStrut( winId(), 0, 0, ActiveConfiguration->Window.HeightDesktop,0);
	}
	
	if(LayoutPosition==LONBOTTOM)
	{
#ifndef ENABLE_FINAL
		qWarning("xMoveWidgetCenter() bottom align");
#endif
		int  rwidth=
			activeIcons[activeIconsCounter-1]->xPosDefault.x()
			-activeIcons[0]->xPosDefault.x()+
			(ActiveConfiguration->Icons.Size+16)*2
			+(ActiveConfiguration->Icons.Size);
		ActiveConfiguration->Window.Left=
			(QApplication::desktop()->width()-rwidth)/2
			-(activeIcons[0]->xPosDefault.x()-ActiveConfiguration->Icons.Size-16);
		
		ActiveConfiguration->Window.Top=
			QApplication::desktop()->height()-ActiveConfiguration->Window.Height;
		//0.28
		if(ActiveConfiguration->Window.RaiseOnEvents)
                KWin::setStrut( winId(), 0, 0, 0, ActiveConfiguration->Window.HeightDesktop );
	}
	ActiveConfiguration->Window.Left=ActiveConfiguration->Window.LeftForce+ActiveConfiguration->Window.Left;
	ActiveConfiguration->Window.Top=ActiveConfiguration->Window.TopForce+ActiveConfiguration->Window.Top;
#ifndef ENABLE_FINAL

		char pippo[50];
		sprintf(pippo,"XGDocker::xMoveWidgetCenter() %d %d",ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
		qWarning(pippo);
#endif
	setFixedSize(ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height);

	// 0.38
	// try using only nn kde env
		int prevx=x();
		int prevy=y();
	if(!isRaised)
	{
		maskSliding.fill(Qt::color0);
		int fakeY=0;
		int fakeH=ActiveConfiguration->Icons.Size+16;
	
		if(LayoutPosition==LONBOTTOM)
		{
			//0.27
			//fakeY=ActiveConfiguration->Window.Height-ActiveConfiguration->Window.HeightDesktop;
			fakeY=ActiveConfiguration->Window.Height-fakeH;
			//old fakeH=ActiveConfiguration->Window.HeightDesktop;
		}
		bitBlt(&maskSliding,
				0,
				fakeY,
				&fakeDesktop,0,0,
				ActiveConfiguration->Window.Width,
				fakeH
				,Qt::CopyROP);
		setMask(maskSliding);
	}
		xEventWidgetBeforeMoved(
			prevx,
			prevy,
			activeIcons[0]->xPosDefault.x(),
			activeIcons[0]->xPosDefault.y(),
			activeIcons[activeIconsCounter-1]->xPosDefault.x(),
			activeIcons[activeIconsCounter-1]->xPosDefault.y(),
			ActiveConfiguration->Window.Left,
			ActiveConfiguration->Window.Top
		);
		backgroundUpdated(xEventGetBackground(
			ActiveConfiguration->Window.Left,
			ActiveConfiguration->Window.Top,
			ActiveConfiguration->Window.Width,
			ActiveConfiguration->Window.Height
			));
		setUpdatesEnabled( FALSE );
		backgroundPostDone(false);
		setUpdatesEnabled( TRUE );
	return;


// 0.27 Background manually updated
//int m_Desk;

QRect m_Rect;
/*
QPoint p1 = QPoint(ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
QPoint p2 = QPoint(ActiveConfiguration->Window.Left+
			ActiveConfiguration->Window.Width
			,ActiveConfiguration->Window.Top
			+ActiveConfiguration->Window.Height);
m_Rect = QRect(p1, p2);
*/
m_Rect = QRect(ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top,
		ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height);
//m_Desk = KWin::windowInfo(this->topLevelWidget()->winId()).desktop();
//m_Desk = KWin::windowInfo(winId()).desktop();
m_Desk = KWin::currentDesktop();

//qWarning(pattern.arg( m_Desk ));
//m_Desk=1;
//QString pattern = QString("DESKTOP%1");
/*
qWarning(QString("p1(%1,%1) p2(%1,%1) desktop:%1 name:_%1_").arg(p1.x()).arg(p1.y()).arg(p2.x()).arg(p2.y())
	.arg(m_Desk).arg(pattern.arg(m_Desk))
	);
*/
	//qWarning("Il desktop e':");
	//qWarning(pattern.arg( m_Desk ));



	bool avail = m_pPixmap->isAvailable(pattern.arg( m_Desk ));
    	if (!avail)
	{
		// 0.37 support for non KDesktop environment
		//QDesktopWidget *d = QApplication::desktop();
//		qWarning("1972");
		backgroundUpdated(xEventGetBackground(
			ActiveConfiguration->Window.Left,
			ActiveConfiguration->Window.Top,
			ActiveConfiguration->Window.Width,
			ActiveConfiguration->Window.Height
			));
		backgroundPostDone(false);
	}
	else
	{
		bool okLoadedShared=m_pPixmap->loadFromShared(pattern.arg( m_Desk ), m_Rect);
		if(okLoadedShared==false){
			//qWarning("okLoadedShared==false");
			// manually call
//		qWarning("1987");
		backgroundUpdated(xEventGetBackground(
			ActiveConfiguration->Window.Left,
			ActiveConfiguration->Window.Top,
			ActiveConfiguration->Window.Width,
			ActiveConfiguration->Window.Height
			));
		backgroundPostDone(false);
			//backgroundPostDone(false);
		}
		else
		{
			//qWarning("okLoadedShared==true");
		}
	}
}


/*!
    \fn XGDocker::backgroundPostDone(bool)
 */
void XGDocker::backgroundPostDone(bool success)
{
#ifndef ENABLE_FINAL

	qWarning(QString("void XGDocker::backgroundPostDone(bool succes=%1)").arg(success));
#endif
	if(success)
	{
/*
		qWarning("if(success) 0");
		backgroundUpdated(*m_pPixmap);
		qWarning("if(success) 1");
		move(ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
		//qWarning("if(success) 2");
		xUpdate(0,1);
		//qWarning("if(success) 3");
		repaint(false);
		//qWarning("if(success) 4");
*/
		// 0.33
		// 0.38 before we ask to the wm to move the docker
		// we like to slide
		
		setUpdatesEnabled( FALSE );
		move(ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
		setUpdatesEnabled( TRUE );
		xEventWidgetBeforeMoved(
			x(),
			y(),
			activeIcons[0]->xPosDefault.x(),
			activeIcons[0]->xPosDefault.y(),
			activeIcons[activeIconsCounter-1]->xPosDefault.x(),
			activeIcons[activeIconsCounter-1]->xPosDefault.y(),
			ActiveConfiguration->Window.Left,
			ActiveConfiguration->Window.Top
		);		//qWarning("if(success) 0");
		if(m_pPixmap->isNull())
		{
		}
		else
		{
			backgroundUpdated(*m_pPixmap);
		}
		//qWarning("if(success) 1");

	}
	else
	{
		//setUpdatesEnabled( FALSE );
		lastRaise=-2;
		xUpdate(0,1);
//qWarning("Before");
		move(ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top);
qApp->syncX();
timespec HundredMilliseconds;
HundredMilliseconds.tv_nsec=1000*1000;
HundredMilliseconds.tv_sec=0;

nanosleep(&HundredMilliseconds,&rem);
//qWarning("After");


		//setUpdatesEnabled( TRUE );
		//repaint(false);
/*
		xEventWidgetBeforeMoved(
			prevx,
			prevy,
			activeIcons[0]->xPosDefault.x(),
			activeIcons[0]->xPosDefault.y(),
			activeIcons[activeIconsCounter-1]->xPosDefault.x(),
			activeIcons[activeIconsCounter-1]->xPosDefault.y(),
			ActiveConfiguration->Window.Left,
			ActiveConfiguration->Window.Top
		);
*/
	}

	
	xEventWidgetMoved(
		ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top,
		activeIcons[0]->xPosDefault.x(),
		activeIcons[0]->xPosDefault.y(),
		activeIcons[activeIconsCounter-1]->xPosDefault.x(),
		activeIcons[activeIconsCounter-1]->xPosDefault.y()
		);

	// 0.36 plugins now will know if they are moved!
	for(uint i=0;i<activeIconsCounter;i++)
	{
		activeIcons[i]->xEventPostSetIconPos(
			i,
			activeIcons[i]->xPosDefault.x(),
			activeIcons[i]->xPosDefault.y(),
			ActiveConfiguration->Icons.Size);
	}
	//polish();

	// 0.38
	//if(!isRaised)setMask(maskBackground);
}

/*!
    \fn XGDocker::xBliz()
 */
void XGDocker::xBliz(int isDesktop)
{
#ifndef ENABLE_FINAL
		qWarning(QString("XGDocker::xBliz(int isDesktop=%1)").arg(isDesktop));
#endif
	// 0.35 fix for the pillow
	//XGIcon *ZeroIcon=xGDocker->getObjectIcon(0);
	//if(ZeroIcon!=NULL && ZeroIcon->xPillow!=NULL)
	//{
	// hide
	if(activeIcons[0]!=NULL && activeIcons[0]->xPillow!=NULL)activeIcons[0]->xPillow->hide();
	// show it
	//		ZeroIcon->xPillow->show();
	//}


	if(isDesktop)
	{
		lastRaise=-2;
	}
	else
	{
		setMask(maskBackground);
		//lower();
		//qApp->flushX();
		qApp->syncX();
		//sleep(2);
		//usleep(100000);
		timespec HundredMilliseconds;
		HundredMilliseconds.tv_nsec=100*1000*1000;
		HundredMilliseconds.tv_sec=0;

		nanosleep(&HundredMilliseconds,&rem);
		lastRaise=0;
		isRaised=1;
		qApp->syncX();
		
		//this->mouseMoveEvent();
	}
	xUpdate();
	repaint(false);

	if(activeIcons[0]!=NULL && activeIcons[0]->xPillow!=NULL)activeIcons[0]->xPillow->show();
	
}


/*!
    \fn XGDocker::getRaised()
 */
int XGDocker::getRaised()
{
    return isRaised;
}


/*!
    \fn XGDocker::mouseMoveSoftware(int,int)
 */
void XGDocker::mouseMoveSoftware(int ,int y)
{
	// called by the software to track the mouse position
	// TODO: top
	if(y<0)xRestore();
}


/*!
    \fn XGDocker::wheelEvent(QWheelEvent * e )
 */
void XGDocker::wheelEvent(QWheelEvent * e )
{
	releaseMouse();
	int x=e->pos().x();
	int y=e->pos().y();
	int b=0;
	if(e->delta()>0)b=1;
	else b=2;
	int iconNum=(x-ActiveConfiguration->Window.borderLeft)
		/
		(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	xEventMouseWheel(iconNum,x,y,b);
}


/*!
    \fn XGDocker::reloadIcon(int icon)
 */
void XGDocker::reloadIcon(int icon)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::reloadIcon(int icon)");
#endif

	QPixmap Pixmap;
	if(ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName!=""){
	QString imgFileNameReal=xFindIconFile(ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName);
	QFile ifr(imgFileNameReal);
	if(ifr.exists() && imgFileNameReal!=QString::null)
	{
		Pixmap.load(imgFileNameReal);
	}
	else
	{
		Pixmap=KDEIconLoader.loadIcon(
			ActiveConfiguration->ObjectsIcons.at(icon)->Images.imgFileName,
				KIcon::NoGroup,
				ActiveConfiguration->Icons.SizeBig
				);
	}

	if(!Pixmap.isNull())activeIcons[icon]->xImgSource=Pixmap.convertToImage();
	else
	{
		activeIcons[icon]->xImgSource.create(
			1,
			1,
			32);
		
		activeIcons[icon]->xImgSource.setAlphaBuffer(false);
		activeIcons[icon]->xImgSource.fill(0);
		activeIcons[icon]->xImgSource.setAlphaBuffer(true);
	}
	activeIcons[icon]->xImgOriginal=activeIcons[icon]->xImgSource.copy();
	//int z=activeIcons[icon]->xZoom;
	//activeIcons[icon]->xZoom=0;
	activeIcons[icon]->cachePurge();
	//activeIcons[icon]->xSetSmoothZoom(z);
	activeIcons[icon]->xSetSmoothZoom();
	activeIcons[icon]->xIconTextPillow.xSetText(ActiveConfiguration->ObjectsIcons.at(icon)->OverText);

	activeIcons[icon]->xIconTextMini.xSetText(ActiveConfiguration->ObjectsIcons.at(icon)->Tasks.MiniText);


	activeIcons[icon]->xIconTextPillow.PillowIsLoaded=0;
	// 0.0.19 20050524
	// Used to tell to the plugin to force redraw
	}
	activeIcons[icon]->xRedraw();
	xUpdate(0,1);
	repaint(false);
	if(icon==lastIcon)xDrawPillow2();
}


/*!
    \fn XGDocker::xFindIconFile(const QString &logicName)
 */
QString XGDocker::xFindIconFile(const QString &logicName)
{
	// new Engine 12 Mar 2004
	// multi path for icons before lets kde chose
	QString imgFileNameLogic=logicName;
	// We like the png before svg?
	QString imgFileNameReal;
	QFile ifr(logicName);
	if(ifr.exists())return logicName;
	
	
	for(uint ifl=0;ifl<ActiveConfiguration->Theme.IconsPaths.count();ifl++)
	{
		// PNG
		imgFileNameReal=ActiveConfiguration->Theme.IconsPaths[ifl];
		//imgFileNameReal=imgFileNameReal;
		imgFileNameReal=imgFileNameReal+"/";
		imgFileNameReal=imgFileNameReal+imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".png";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)break;
		
		// SVG
		imgFileNameReal=ActiveConfiguration->Theme.IconsPaths[ifl];
		//imgFileNameReal=imgFileNameReal;
		imgFileNameReal=imgFileNameReal+"/";
		imgFileNameReal=imgFileNameReal+imgFileNameLogic;
		imgFileNameReal=imgFileNameReal+".svg";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)break;

		// 0.36 all *
		imgFileNameReal=ActiveConfiguration->Theme.IconsPaths[ifl];
		//imgFileNameReal=imgFileNameReal;
		imgFileNameReal=imgFileNameReal+"/";
		imgFileNameReal=imgFileNameReal+imgFileNameLogic;
		//imgFileNameReal=imgFileNameReal+".svg";
		imgFileNameReal=::locate("data",imgFileNameReal);
		ifr.setName(imgFileNameReal);
		if(ifr.exists() && imgFileNameReal!=QString::null)break;
	}
	return imgFileNameReal;
}


//inline void XGDocker::mouseMoveEventSW(int x,int y,int force)
void XGDocker::mouseMoveEventSW(int x,int y,int force,Qt::ButtonState )
{
//Qt::ButtonState button)
	// Mouse move event, software - user
	// Check if you are going near the end of screen Y - horizontal bar
	// TODO: Vertical bar
	xLastX=x;
	xLastY=y;
	
	if(xLastX_real==x && xLastY_real==y && !force)
	{
		return;
	}

	// new engine 2
	xLastX_real=x;
	xLastY_real=y;
	
	int dx,dy,DiffIconX,DiffIconY,DiffIcon,AreMovingToLeft;
	int iconNum=
		(x-ActiveConfiguration->Window.borderLeft)/
		(ActiveConfiguration->Icons.Size
		+ActiveConfiguration->Icons.Separation);

	// adaptive mouse horizontal
	if(iconNum<=0)
	{
		dx=activeIcons[0]->xHotspot.x()-x;
		if(dx>0)
		{
			dy=activeIcons[0]->xHotspot.x()-y;
			if(dy>0)y=y-abs(activeIcons[0]->xHotspot.x()-x);
			else y=abs(activeIcons[0]->xHotspot.x()-x)+y;
			x=activeIcons[0]->xHotspot.x();
		}
	}
	if(iconNum>=(int)activeIconsCounter-1)
	{
		dx=activeIcons[activeIconsCounter-1]->xHotspot.x()-x;
		if(dx<0)
		{
			dy=activeIcons[activeIconsCounter-1]->xHotspot.x()-y;
			if(dy>0)y=y-abs(activeIcons[activeIconsCounter-1]->xHotspot.x()-x);
			else y=abs(activeIcons[activeIconsCounter-1]->xHotspot.x()-x)+y;
			x=activeIcons[activeIconsCounter-1]->xHotspot.x();
		}
	}
	// save last icon index
	lastIcon=iconNum;
	// Optimizing code
	isRaised=0;
/*
	// 0.37 this will optimize repaint but no gain performance
	int minY=activeIcons[0]->xPosition.y();
	int minX=activeIcons[activeIconsCounter-1]->xPosition.x();
	int maxY=0;
	int maxX=0;
*/	
	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{
		dx=activeIcons[iconIndex]->xHotspot.x()-x;
		DiffIconX=abs(dx*ActiveConfiguration->Matrix.DesignXMoltiplier);
		dy=activeIcons[iconIndex]->xHotspot.y()-y;
		DiffIconY=abs(dy*ActiveConfiguration->Matrix.DesignYMoltiplier);
		DiffIcon=DiffIconY+DiffIconX;

		if(DiffIcon<ActiveConfiguration->Matrix.sizeMatrix*2)
		{
			if(dx>0)
			{
				AreMovingToLeft=ActiveConfiguration->Matrix.DMatrix[DiffIconX][DiffIconY];
			}
			else
			{
				AreMovingToLeft=-ActiveConfiguration->Matrix.DMatrix[DiffIconX][DiffIconY];
			}
			if(!activeIcons[iconIndex]->xExclude)
			{
				activeIcons[iconIndex]->xPosition.setX(
					activeIcons[iconIndex]->xPosDefault.x()
					- ActiveConfiguration->Matrix.XMatrix[DiffIcon]+AreMovingToLeft);
				// new Engine with Separators 11 May 2004
				activeIcons[iconIndex]->xPosition.setY(
					activeIcons[iconIndex]->xPosDefault.y()
					-ActiveConfiguration->Matrix.YMatrix[DiffIcon]);

				activeIcons[iconIndex]->xSetZoom(
					ActiveConfiguration->Matrix.ZMatrix[DiffIcon]);
			}
			else
			{
				activeIcons[iconIndex]->xPosition.setX(
					activeIcons[iconIndex]->xPosDefault.x()
					+AreMovingToLeft);
			}
			isRaised=1;

			// 0.37 engine with multirepaint
			/*
			if(activeIcons[iconIndex]->xPosition.x()<minX)minX=activeIcons[iconIndex]->xPosition.x();
			if(activeIcons[iconIndex]->xPosition.x()+ActiveConfiguration->Matrix.ZMatrix[DiffIcon]>maxX)maxX=activeIcons[iconIndex]->xPosition.x();
			if(activeIcons[iconIndex]->xPosition.y()<minY)minY=activeIcons[iconIndex]->xPosition.y();
			if(activeIcons[iconIndex]->xPosition.y()+ActiveConfiguration->Matrix.ZMatrix[DiffIcon]>maxY)maxX=activeIcons[iconIndex]->xPosition.y();
			*/
		}
		else
		{
			if(DiffIconY>=ActiveConfiguration->Matrix.sizeMatrix*2)
			{
				DiffIconY=ActiveConfiguration->Matrix.sizeMatrix*2-1;
				// all hotspot are =y
				// than if you are too away from 1 icon all icons are restored
			}
			if(dx>0)
			{
				AreMovingToLeft=ActiveConfiguration->Matrix.KMatrix[DiffIconY];
			}
			else
			{
				AreMovingToLeft=-ActiveConfiguration->Matrix.KMatrix[DiffIconY];
			}
			activeIcons[iconIndex]->xPosition.setX(
				activeIcons[iconIndex]->xPosDefault.x()
				+AreMovingToLeft);
			activeIcons[iconIndex]->xPosition.setY(
				activeIcons[iconIndex]->xPosDefault.y()
				);
			// 0.31
			// we may update Y and X axis
			if(!activeIcons[iconIndex]->xExclude)
			{
				activeIcons[iconIndex]->xSetZoom(ActiveConfiguration->Icons.Size);
			}
		}
	}


	// 0.37 with multi repaint
	/*
	tUpdateRect.setTop(minY);
	tUpdateRect.setBottom(maxY);
	tUpdateRect.setLeft(minX-ActiveConfiguration->Icons.Size-ActiveConfiguration->Icons.Separation);
	tUpdateRect.setRight(maxX+ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	*/

}


/*!
    \fn XGDocker::xRestore()
 */
void XGDocker::xRestore()
{
	xEventReset(xLastX,xLastY);
}


/*!
    \fn XGDocker::polish()
 */
void XGDocker::polish()
{

	// 0.27
	//return;
	

#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::polish()");
	qWarning("xgdocker.cpp:1328");
#endif
	xUpdate();
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:1330");
#endif
	maskGenerareBigFake();
		
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:1333");
#endif

	xMoveWidgetCenter();
#ifndef ENABLE_FINAL
	qWarning("xgdocker.cpp:1335");
#endif
}


/*!
    \fn XGDocker::xHide()
 */
void XGDocker::xHide()
{
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xHide()");
#endif
	tAutoHideTimer->stop();
	tAutoSendBGTimer->stop();
	if(isRaised)return;
	//xEventDockerHidden();
	hide();
	
}


/*!
    \fn XGDocker::dragEnterEvent(QDragEnterEvent* event)
 */
void XGDocker::dragEnterEvent(QDragEnterEvent* event)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::dragEnterEvent(QDragEnterEvent* event)");
#endif


	isDropping=1;
    event->accept(
        QTextDrag::canDecode(event)
	// ||
        //QImageDrag::canDecode(event)
    );
    tAutoHideTimer->stop();
    tAutoSendBGTimer->stop();
    /*
    QString basket;
    if(QTextDrag::decode ( event, basket)==true)qWarning(basket);
   	*/
}


/*!
    \fn XGDocker::dropEvent(QDropEvent* event)
 */
void XGDocker::dropEvent(QDropEvent* e)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::dropEvent(QDropEvent* e)");
#endif

	isDropping=0;
	Busy.lock();
	int x=e->pos().x();
//	int y=e->pos().y();
	int iconNum=(x-ActiveConfiguration->Window.borderLeft)
		/
		(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
	dropIcon(iconNum,e);
	QString basket;
	Busy.unlock();

}

/*!
    \fn XGDocker::dragLeaveEvent (QDragLeaveEvent * )
 */
void XGDocker::dragLeaveEvent (QDragLeaveEvent * )
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::dragLeaveEvent (QDragLeaveEvent * )");
#endif


	isDropping=0;
	if(ActiveConfiguration->Window.FastHide>0)
	{
		// 0.27
		//xHide();
		//QTimer::singleShot(0,this,SLOT(xHide()));
		tAutoHideTimer->start(1);
	}
	else
	{
		if(!ActiveConfiguration->Window.FastHide)
		{
		#ifndef ENABLE_FINAL
			qWarning("tAutoSendBGTimer->start(200);");
		#endif
			tAutoSendBGTimer->start(200);
		}
		else
		{
			tAutoSendBGTimer->start(1);
		}
		/*
		if(ActiveConfiguration->Window.HideTimeout>0)
		{
			qWarning("xgdocker.cpp:630");
			tAutoHideTimer->start(
				ActiveConfiguration->Window.HideTimeout * 1000
			);
		}
		*/
	}

}

/*!
    \fn XGDocker::dragMoveEvent( QDragMoveEvent * )
 */
void XGDocker::dragMoveEvent( QDragMoveEvent *)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::dragMoveEvent( QDragMoveEvent *)");
#endif

/*
	Busy.lock();
	Busy.unlock();
*/
	//qWarning(QString("[%1][%1]").arg(event->pos().x()).arg(event->pos().y()));
	
	
	/*
	this->mouseMoveEventSW(event->pos().x(),event->pos().y());
	
	xUpdate();
	repaint(false);
	*/
	if(cacheBusy.tryLock()==false)return;
	purgeCacheMovements();
}




/*!
    \fn XGDocker::mouseReleaseEvent ( QMouseEvent * e )
 */
void XGDocker::mouseReleaseEvent (QMouseEvent *e)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::mouseReleaseEvent (QMouseEvent *)");
#endif
	// 0.37 from press event
	if(e->pos().y()<0)return;

	releaseMouse();
	Busy.lock();
	int x=e->pos().x();
	int y=e->pos().y();
	int b=e->button();
	int iconNum=(x-ActiveConfiguration->Window.borderLeft)
		/
		(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);

	//if(isDragging>10+ActiveConfiguration->Icons.Size)
	if(hasDragged>=0)
	{
		//return;
	}
	else
	{
		xEventMouseClick(iconNum,x,y,b);
	}
	//if(isRaised)QTimer::singleShot(500,this,SLOT(xIRQ_Reset()));
	//xBliz();
	//grabMouse();
	Busy.unlock();



	lastButtonStatus=Qt::NoButton;
	lastIconDrag=NULL;
	isDragging=0;
	hasDragged=-1;
}


/*!
    \fn XGDocker::hide()
 */
void XGDocker::hide()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::hide()");
#endif
	xEventDockerHidden();
	QWidget::hide();
	KWin::setStrut( winId(), 0, 0, 0,0);
}


/*!
    \fn XGDocker::show()
 */
void XGDocker::show()
{

#ifndef ENABLE_FINAL
	qWarning("void XGDocker::show()");
#endif
	//qWarning("void XGDocker::show()");

	tAutoSendBGTimer->stop();
	tAutoHideTimer->stop();
	
	if(!isShown())
	{
		showRaised();
	}
	else
	{
		if(ActiveConfiguration->Window.RaiseOnEvents)
		{
			
			showRaised();
		}
		else
		{
			//QWidget::show();
			setUnShadowed();
			KWin::setOnAllDesktops(winId(),true);
/*
#ifdef USE_KWIN
	KWin::setState( winId(), NET::StaysOnTop );
#else
	//raise();
	x11SetOnTop(winId());
#endif
*/
			xEventDockerShowed();
			//tAutoSendBGTimer->stop();
		}
	}
	// 0.27
	//isRaised=1;
	//

	
}

inline void XGDocker::setUnShadowed()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"inline void XGDocker::setUnShadowed()");
#endif
	//0.29 && KDE 3.4 unshadow
       QByteArray data2;
        QDataStream arg2(data2, IO_WriteOnly);
        //arg2 << topLevelWidget()->winId();
	arg2 << winId();
        kapp->dcopClient()->send(
           "kwin",
           "KWinInterface",
           "setUnshadowed(unsigned long int)"
           ,data2);
}



/*!
    \fn XGDocker::showRaised()
 */
void XGDocker::showRaised()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::showRaised()");
#endif
	//qWarning("void XGDocker::showRaised()");
	if(tPostShowRaise->isActive())tPostShowRaise->stop();

	//tAutoSendBGTimer->stop();
	//qWarning("void XGDocker::showRaised()");
	//029
	// very fake background!!
	//if(isShown())QWidget::hide();
	drawVeryFakeBackground();

	if(ActiveConfiguration->Window.HeightDesktop)
	{
		if(LayoutPosition==LONTOP)
		{
			KWin::setStrut( winId(), 0, 0, ActiveConfiguration->Window.HeightDesktop,0);
		}
		else
		if(LayoutPosition==LONBOTTOM)
		{
			KWin::setStrut( winId(), 0, 0, 0,ActiveConfiguration->Window.HeightDesktop);
		}
		tPostShowRaise->start(250);
	}
	else showRaisePost();
	// 0.37 workaround for GNOME
	//QWidget::hide();
	//QWidget::show();
}

/*!
    \fn XGDocker::showRaisePost()
 */
void XGDocker::showRaisePost()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::showRaisedPost()");
#endif
	//qWarning("XGDocker::showRaisedPost()");
	
	tPostShowRaise->stop();
	//qWarning("void XGDocker::showRaised() 2");
	// 0.0.27 ugly trick
	lastRaise=0;
	isRaised=1;
	fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
	alternativeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;

	xUpdate();
	//lastRaise=0;
	isRaised=0;
	xUpdate();
	
	if(isHidden())QWidget::show();
	// 0.37
	setUnShadowed();
#ifdef USE_KWIN
			KWin::setState( winId(), NET::StaysOnTop );
			//
			//KWin::setState( winId(), NET::StaysOnTop );
			for(int workAroundWM=0;workAroundWM<5;workAroundWM++)
			{
				//if(x11getOnTop(winId()))break;
				if(KWin::windowInfo(winId()).state()==NET::StaysOnTop)break;
				KWin::setState( winId(), NET::StaysOnTop );
			}
#else
			//NetWinInfo::setState()
			//raise();
			//QWidget::hide();
			//QWidget::show();
			x11SetOnTop(winId());
			x11SetOnTop(winId());
			for(int workAroundWM=0;workAroundWM<9;workAroundWM++)
			{
				if(x11getOnTop(winId()))break;
				x11SetOnTop(winId());
			}
#endif

	KWin::setOnAllDesktops(winId(),true);
	qApp->syncX();
	//QTimer::singleShot(5,this,SLOT(showRaisedPost2()));
	//qWarning("XGDocker::showRaisedPost() end");
	//usleep(ActiveConfiguration->Engine.SleepAnimations*100);
	//nanosleep(&req,&rem);
	timespec HundredMilliseconds;
	HundredMilliseconds.tv_nsec=ActiveConfiguration->Engine.SleepAnimations*100*1000;
	HundredMilliseconds.tv_sec=0;

	nanosleep(&HundredMilliseconds,&rem);


	showRaisedPost2();
}
/*!
    \fn XGDocker::showRaisedPost2()
 */
void XGDocker::showRaisedPost2()
{
	//qWarning("XGDocker::showRaisedPost2()");
	xEventDockerShowed();
	if(ActiveConfiguration->Window.FastHide)
	{
		fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
		alternativeHeightDesktop=ActiveConfiguration->Icons.Size+16;
	}
	else
	{
		fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
		alternativeHeightDesktop=ActiveConfiguration->Icons.Size+16;
	}
	
	// 0.29 it must go to lower
	if(!ActiveConfiguration->Window.FastHide)
	{
	#ifndef ENABLE_FINAL
		qWarning("tAutoSendBGTimer->start(200);");
	#endif
		tAutoSendBGTimer->start(500);
	}
	else
	{
		tAutoSendBGTimer->start(1);
	}
	//qWarning("XGDocker::showRaisedPost2() end");

}

/*!
    \fn XGDocker::purgeCacheMovements()
 */
void XGDocker::purgeCacheMovements()
{


#ifdef ENABLE_SPECIALENGINE2
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::purgeCacheMovements() Engine 2");
#endif
//	static int lastCalledX=0;
//	static int lastCalledY=0;
//	if(xLastX_notmanaged!=lastCalledX || xLastY_notmanaged!=lastCalledY )
		for(int recallme=1;recallme!=0;)
{

	// workaround!!!!!!!
	QPoint pos, mouse, vect;
	int WinX, WinY;
	int XCoord,YCoord;
	Display *display;
	Window root, RootIDRet, ChildIDRet;
	unsigned int StateMask;
	display = kapp->getDisplay();
	root = RootWindow(display,DefaultScreen(display));
	XQueryPointer(display, root, &RootIDRet, &ChildIDRet, &XCoord,&YCoord, &WinX, &WinY, &StateMask);
	//mouse = xGDocker->mapFromGlobal(QPoint(XCoord,YCoord));
	mouse = this->mapFromGlobal(QPoint(XCoord,YCoord));
	xLastX_notmanaged=mouse.x();
	xLastY_notmanaged=mouse.y();

	static int ymoltiply=1;
//	static int xmoltiply=1;





	recallme=0;
	//if(1)
	if(mouseMoveTimeElapsed.elapsed()>30)
	{
	//recallme=0;
#ifndef ENABLE_FINAL
			qWarning(
			QString("void XGDocker::purgeCacheMovements() Engine 2 count [%1,%1][%1,%1]")
			.arg(xLastX_notmanaged)
			.arg(xLastY_notmanaged)
			.arg(xLastX)
			.arg(xLastY)
			);
#else
#endif

#ifdef ENABLE_SPECIALENGINE4
			if(iconNum<activeIconsCounter && iconNum>=0)
				xLastX_notmanaged=activeIcons[iconNum]->xPosDefault.x()+ActiveConfiguration->Icons.Size/2;
#endif
			
			int ax=xLastX_notmanaged;
			//int ay=xLastY_notmanaged;
			int ay=xLastY;
			int xInterpolationValue=ActiveConfiguration->Engine.InterpolationValue;

			// new Engine 0.20
			// 20040525
#ifdef ENABLE_SPECIALENGINE3
	//qWarning("#ifdef ENABLE_SPECIALENGINE3");
			int iconNum=(xLastX_notmanaged-ActiveConfiguration->Window.borderLeft)
				/
				(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);


 			if(iconNum<0 || iconNum>=(int)activeIconsCounter)
			{
				xLastY_notmanaged=-1;
			}
		else
		{ // start sp3
#else
		{ // start sp3
#endif


			
			// 0.25
			// unused var
			//int xInterpolationStep=50;
			if(xLastX-xLastX_notmanaged>1)
			{

				ax=xLastX-1-(xLastX-xLastX_notmanaged)/xInterpolationValue;
				//ax=xLastX-1;
				recallme=1;
			}
			else
			{
				if(xLastX-xLastX_notmanaged<-1)
				{
					ax=xLastX+1-(xLastX-xLastX_notmanaged)/xInterpolationValue;
					//ax=xLastX+1;
					recallme=1;
				}
			}
		} // end of sp3

 			if(xLastY_notmanaged<0|| xLastY_notmanaged>ActiveConfiguration->Window.Height)
			{
				if(!isRaised)
				{
					releaseMouse();

					// 0.36 this may help to release mouse
					if(activeIcons[0]->xPillow!=NULL)activeIcons[0]->xPillow->hide();


					recallme=0;
					ay=xLastY-5-ymoltiply;
					ymoltiply=1;
					//break;
					//0.27
					if(!ActiveConfiguration->Window.FastHide)
					{
					#ifndef ENABLE_FINAL
						qWarning("tAutoSendBGTimer->start(200);");
					#endif
						tAutoSendBGTimer->start(200);
					}
					else
					{
					tAutoSendBGTimer->start(1);
						//QTimer::singleShot(0,this,SLOT(xSendToBackground()));
						//xSendToBackground();
					}
				}
				else
				{
					// we have to animate
					//ay=xLastY-1-(xLastY-xLastY_notmanaged)/xInterpolationValue;
					releaseMouse();
					ay=xLastY-5-ymoltiply;
					ymoltiply=ymoltiply+5;
					recallme=1;
				}

			}
			else
			{
			
				if(xLastY-xDesignVirtualYMatrix>1)
				{
					ay=xLastY-1-abs(xLastY-xDesignVirtualYMatrix)/xInterpolationValue;
					recallme=1;
				}
				else
				{
					if(xLastY-xDesignVirtualYMatrix<-1)
					{
						ay=xLastY+1+abs(xLastY-xDesignVirtualYMatrix)/xInterpolationValue;
						recallme=1;
					}
				}
			}
				mouseMoveTimeElapsed.start();
				mouseMoveEventSW(ax,ay,0,lastButtonStatus);
				//xUpdate(0,isRaised);
				xUpdate();
				//xDrawPillow();
				//nanosleep(&req2,&rem2);
				repaint(false);
				//repaint(tUpdateRect);
				//repaint(tUpdateRect,false);
				//update();
				// 0.38
				//nanosleep(&req2,&rem2);
		}
	else
	{
		//usleep(10000);
		//qWarning("relax");
		nanosleep(&req2,&rem2);
		recallme=1;
	}
}
	/*
	if(recallme)
	{
#ifdef ENABLE_FINAL
#else
			qWarning("void XGDocker::purgeCacheMovements() Engine 2 repoll");
#endif
			//QTimer::singleShot(0,this,SLOT(purgeCacheMovements()));
			//purgeCacheMovements();
	}
	else
	{
	
			//mouseMoveEventSW(xLastX_notmanaged,xLastY_notmanaged,0,lastButtonStatus);
	}
	*/
			//xUpdate();
			//repaint(false);
			
	cacheBusy.unlock();
	isAnimating=0;

#endif
}


/*!
    \fn XGDocker::xGetWidget(QWidget *&)
 */
void XGDocker::xGetWidget(QWidget *&pObjectWnd)
{
	pObjectWnd=this;
}


/*!
    \fn XGDocker::xMouseMoveSoftware(int,int,Qt::ButtonState)
 */
void XGDocker::xMouseMoveSoftware(int x,int y)
{
	mouseMoveSoftware(x,y);
}


/*!
    \fn XGDocker::xDockerRedraw
 */
void XGDocker::xDockerRedraw()
{
#ifndef ENABLE_FINAL
	qWarning("xDockerRedraw()");
#endif
	// 31052004
	// may be wrong but this will help to alleviate the flickering
	// PS:
	// this will not work properly until we rewrite pillow code
	//xUpdate(0,1);
	//xUpdate();
	//xIRQ_MouseTimeout();
	//xUpdateSmooth();
	xUpdate(0,1);
	repaint(false);
}


/*!
    \fn XGDocker::iconAddSeparator()
 */
void XGDocker::iconAddSeparator()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::iconAddSeparator()");
#endif

			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)
	{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::iconAddSeparator() xEConfiguration==NULL)");
	qWarning(i18n(name()));
#endif
		return;
	}
	

	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//	XSGObjectIcon *addedCfg=new XSGObjectIcon;
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;
	addedCfg->Tasks.Proces.clear();
	addedCfg->Tasks.MiniTextShow=0;
	addedCfg->Info.fileName="";
	// 0.35
	// fix for gcc
/*
xgdocker.cpp: In member function 'void XGDocker::iconAddSeparator()':
xgdocker.cpp:2839: error: cast from 'XSGObjectIcon*' to 'int' loses precision
xgdocker.cpp:2840: error: cast from 'XSGObjectIcon*' to 'int' loses precision
xgdocker.cpp: In member function 'void XGDocker::xDrawPillow()':
xgdocker.cpp:3857: warning: comparison between signed and unsigned integer 
expressions
xgdocker.cpp:3864: warning: taking address of temporary
make[2]: *** [xgdocker.o] Error 1
*/

	addedCfg->Info.Name=QString("AutoAddedSeparator%1").arg((long)addedCfg);
	addedCfg->Info.Group=
	addedCfg->Actions.onClickExec="";
	addedCfg->OverText="";
	addedCfg->Images.imgFileName="";
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Tasks.ClassName.clear();
	addedCfg->Tasks.WindowTitle.clear();
	addedCfg->Tasks.TaskName.clear();
	addedCfg->Tasks.Proces.clear();
	addedCfg->Actions.iAnimationMask=0;
	addedCfg->Tasks.TaskInfo=NULL;
	addedCfg->Tasks.MiniTextShow=0;
	//0.29
	addedCfg->Tasks.dcopReady=0;
	
	//0.33
	addedCfg->Tasks.forceRunning=0;
	
	addedCfg->Info.className="GSeparator";
	// we will not the icon to Rolling Icons because i don't like to save the added Separator
	ActiveConfiguration->ObjectsIcons.append(addedCfg);

	xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
	//if(cfgIcon->Info.className=="GSeparator")
	// 0.31
	createBackgroundSeparators();
	//checkBackgroundSeparators();
	
}



/*!
    \fn XGDocker::xUpdateSmooth()
 */
inline void XGDocker::xUpdateSmooth()
{

#ifndef ENABLE_FINAL
qWarning("inline void XGDocker::xUpdateSmooth()");
#endif

	for(long int iconIndex=0;iconIndex<(int)activeIconsCounter;iconIndex++)
	{
		if(activeIcons[iconIndex]->xSetUpdate==1)
		{
			//activeIcons[iconIndex]->xSetSmoothZoom(activeIcons[iconIndex]->xZoom);
			activeIcons[iconIndex]->xSetSmoothZoom();
			activeIcons[iconIndex]->xSetUpdate=0;
		}
	}
	
}

inline void XGDocker::xUpdateDrawBackground(int Transparency)
{

#ifndef ENABLE_FINAL
qWarning("inline void XGDocker::xUpdateDrawBackground()");
#endif

	// we calc only 1 time the coords
	// TODO: here we can put an if is changed
	xBar=activeIcons[0]->xPosition.x();
	yBar=activeIcons[0]->xPosDefault.y()-8;
	dxBar=activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			activeIcons[activeIconsCounter-1]->xZoom;
	dyBar=ActiveConfiguration->Icons.Size+16;



	// fake background
	// unified to avoid the transparency error
	if(!Transparency)bitBlt(&paintBuffer,
			0,
			0,
			&imgFakeBackgroundGlobal,Qt::CopyROP);

	// draw background bar
	bitBlt(&paintBuffer,
			xBar,
			yBar,
			&backgroundBar.xImgSource,
			xBar,
			0,
			dxBar,
			dyBar,Qt::CopyROP);
	bitBlt(&paintBuffer,
			xBar-ActiveConfiguration->Icons.Size-16,
			yBar,
			//&backgroundBarLeft.xImgSource,
			&backgroundBarLeft.xImgShowed,
			0,Qt::CopyROP);
	
	bitBlt(&paintBuffer,
			xBar+dxBar,
			yBar,
			//&backgroundBarRight.xImgSource,
			&backgroundBarRight.xImgShowed,
			0,Qt::CopyROP);
}


inline void XGDocker::xUpdateDrawBackgroundPass2()
{
	bitBlt(&paintBuffer,
			xBar,
			yBar,
			&backgroundBarOver.xImgSource,
			xBar,
			0,
			dxBar,
			dyBar,Qt::CopyROP);
}

/*!
    \fn XGDocker::xDockerRedraw(XGIcon *)
 */
void XGDocker::xDockerRedraw(QObject *findMe)
{
/*
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xDockerRedraw(QObject *findMe)");
#endif
*/
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(findMe==activeIcons[i])
		{
			// Ok we repaint only this icon
			// 0.38 with steps update the Original not the Source...
			//
			//if(sender()==activeIcons[i]->xClassManager)activeIcons[i]->xImgSource=activeIcons[i]->xImgOriginal;
			xUpdateRepaintInline(i);
			return;
		}
	}
}


void XGDocker::xUpdateRepaint(int iconIndex)
{
	xUpdateRepaintInline(iconIndex);
}
void XGDocker::xDockerRedrawFast(QObject *findMe)
{
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xDockerRedrawFast(QObject *findMe)");
#endif
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(findMe==activeIcons[i])
		{
			// Ok we repaint only this icon
			xUpdateRepaintFast(i);
			return;
		}
	}
}
inline void XGDocker::xUpdateRepaintFast(int iconIndex)
{
	int bsx=activeIcons[iconIndex]->xPosition.x();
	int bsy=activeIcons[iconIndex]->xPosition.y();
	int bsz=activeIcons[iconIndex]->xZoom;
	bitBlt(&paintBuffer,
		activeIcons[iconIndex]->xPosition.x(),
		activeIcons[iconIndex]->xPosition.y(),
		&activeIcons[iconIndex]->xImgShowed,0,Qt::CopyROP);
	repaint(QRect(bsx,bsy,bsz,bsz));
	if(iconIndex==lastIcon)xDrawPillow2();
	//tDrawPillow->start(100);

	// 0.38
	//mouseMoveTimeElapsed.start();
}



/*!
    \fn XGDocker::xGetLayout()
 */
int XGDocker::xGetLayout()
{
	return LayoutPosition;
}


/*!
    \fn XGDocker::xSendToBackground()
 */
void XGDocker::xSendToBackground()
{
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xSendToBackground()");
#endif
	tAutoSendBGTimer->stop();
	if(isRaised)return;
	
	if(activeIcons[0]->xPillow!=NULL)activeIcons[0]->xPillow->hide();

	
	if(ActiveConfiguration->Window.SendToBackground)
	{
		// we have to send it to background
		lower();

#ifdef USE_KWIN
		KWin::setStrut( winId(), 0, 0, 0, 0 );
		KWin::setType(winId(), NET::Dock);
		KWin::setState( winId(), NET::KeepBelow);
#else
		NETWinInfo info( qt_xdisplay(),winId(),qt_xrootwin(), 0 );
		NETStrut strut;
		strut.left = 0;
		strut.right =0;
		strut.top = 0;
		strut.bottom =0;
		info.setStrut( strut );
		x11SetFloating(winId());
#endif
		// 0.27
		// TODO: new event for sending to BAGROUND NOT HIDING!
		//xEventDockerHidden();
		xEventDockerSendToBackground();
		
	}
	else
	{
	}

	// 0.35
	if(!tAnimateBackground->isActive() && maxDesaturate>0)tAnimateBackground->start(250);

}


/*!
    \fn XGDocker::createPopup(KPopup *&,const QObject *)
 */
void XGDocker::createPopup(KPopupMenu *&cpgIcon,const QObject *iiIcon)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::createPopup(KPopupMenu *&cpgIcon,const QObject *iiIcon)");
#endif
	cpgIcon=NULL;
	if(!iiIcon)return;
	XGIcon *pgIcon=(XGIcon *)iiIcon;
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(activeIcons[i]==pgIcon)
		{
			int idx=ActiveConfiguration->ObjectsIcons.find(pgIcon->iconConfiguration);
			if(idx>0)
			{
				ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu=new KPopupMenu();
				cpgIcon=ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu;
			}
		}
	}
}


/*!
    \fn XGDocker::getPopupMenu(KPopupMenu *&, const QObject *)
 */
void XGDocker::getPopupMenu(KPopupMenu *&cpgIcon, const QObject *iiIcon)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::getPopupMenu(KPopupMenu *&cpgIcon, const QObject *iiIcon)");
#endif

	cpgIcon=NULL;
	if(!iiIcon)return;
	XGIcon *pgIcon=(XGIcon *)iiIcon;
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(activeIcons[i]==pgIcon)
		{
			int idx=ActiveConfiguration->ObjectsIcons.find(pgIcon->iconConfiguration);
			if(idx>0)
			{
				cpgIcon=ActiveConfiguration->ObjectsIcons.at(idx)->PluginPopupMenu;
			}
		}
	}
}



/*!
    \fn XGDocker::xFindResource(const QString, QString &)
 */
void XGDocker::xFindResource(const QString rscType, QString &Original)
{
	if(rscType=="icon")
	{
		Original=this->xFindIconFile(Original);
	}
}




/*!
    \fn XGDocker::xBackgroundMove(int,int)
 */
void XGDocker::xBackgroundMove(int nXBar,int nYBar)
{
	xBar=nXBar;
	yBar=nYBar;
}


/*!
    \fn XGDocker::xBackgroundGetCoords(int &,int &)
 */
void XGDocker::xBackgroundGetCoords(int &destXBar,int &destYBar)
{
	destXBar=xBar;
	destYBar=yBar;
}




/*!
    \fn XGDocker::lower()
 */
void XGDocker::lower()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::lower()");
#endif
	isLowering=1;
	// 0.27
	// ugly trick
	fakeHeightDesktop=ActiveConfiguration->Icons.Size+16;
	alternativeHeightDesktop=fakeHeightDesktop;
	lastRaise=1;
	// here we are going to put a big bug on xDrawPillow2
	isRaised=1;
	xUpdate();
	/***/
	// 0.35
	if(activeIcons[0]->xPillow!=NULL)activeIcons[0]->xPillow->hide();
	QWidget::lower();
 	//KWin::setType(winId(), NET::Dock);
 	KWin::setState(winId(), NET::KeepBelow);
	repaint(false);
	lastRaise=0;
	isRaised=0;
	alternativeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
	fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
	isLowering=0;
}






/*!
    \fn XGDocker::xGetIconIndex(const QObject*)
 */
int XGDocker::xGetIconIndex(const QObject*findMe)
{
	for(int i=0;i<(int)activeIconsCounter;i++)
	{
		if(findMe==activeIcons[i])
		{
			// Ok we repaint only this icon
			return i;
		}
	}
	return -1;
}


/*!
    \fn XGDocker::drawVeryFakeBackground()
 */
inline void XGDocker::drawVeryFakeBackground()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::drawVeryFakeBackground()");
#endif

	bitBlt(&paintBuffer,
			0,
			0,
			&imgBackground,Qt::CopyROP);
	repaint(false);
}


/*!
    \fn XGDocker::xUpdateMatrix()
 */
inline void XGDocker::xUpdateMatrix()
{
/*
	xBar=activeIcons[0]->xPosition.x();
	yBar=activeIcons[0]->xPosDefault.y()-8;
	dxBar=activeIcons[activeIconsCounter-1]->xPosition.x()-
			activeIcons[0]->xPosition.x()+
			activeIcons[activeIconsCounter-1]->xZoom;
	dyBar=ActiveConfiguration->Icons.Size+16;
*/
	ActiveConfiguration->Window.Height=
		// 0.34
		//ActiveConfiguration->Icons.FontSize+
		ActiveConfiguration->Icons.Size+
		16+
		(ActiveConfiguration->Icons.SizeBig
		-
		ActiveConfiguration->Icons.Size
		)/2+
		abs(ActiveConfiguration->Icons.Raise)
		;
		ActiveConfiguration->Window.borderTop=
			//ActiveConfiguration->Icons.Size+
			8+
			(ActiveConfiguration->Icons.SizeBig
			-
			ActiveConfiguration->Icons.Size
			)/2+
			abs(ActiveConfiguration->Icons.Raise)
			;

			//qWarning(QString("AutoResize:[%1]").arg(ActiveConfiguration->Icons.Size));
			Matrix->xUpdateMatrix();
			for(int updateAllIconI=0;updateAllIconI<(int)activeIconsCounter;updateAllIconI++)
			{
				//Matrix->xMakeSpace(updateAllIconI,&activeIcons[updateAllIconI]->xPosition);
				//if(activeIcons[activeIconsCounter-1]->xExclude)
				if(activeIcons[updateAllIconI]->xExclude)
				{
					//qWarning("updateBackgroundSeparator(updateAllIconI);");
					updateBackgroundSeparator(updateAllIconI);
				}
				else
				{
					Matrix->xMakeSpace(updateAllIconI,&activeIcons[updateAllIconI]->xPosDefault);
					Matrix->xMakeCenter(updateAllIconI,&activeIcons[updateAllIconI]->xHotspot);
//					activeIcons[updateAllIconI]->xSetSmoothZoom(ActiveConfiguration->Icons.Size);
activeIcons[updateAllIconI]->xZoom=ActiveConfiguration->Icons.Size;
activeIcons[updateAllIconI]->xSetSmoothZoom();
					activeIcons[updateAllIconI]->xImgArrow=activeIcons[updateAllIconI]->xImgArrowSource.smoothScale(
						ActiveConfiguration->Icons.Size,
						ActiveConfiguration->Icons.Size,
						QImage::ScaleMax);
				}
			}

}


/*!
    \fn XGDocker::xUpdateSense()
 */
void XGDocker::xUpdateSense()
{
	xUpdateMatrix();
	changeBackground(ActiveConfiguration->Theme.BackgroundPath);
	if(tPostIconAdd->isActive())tPostIconAdd->stop();
	tPostIconAdd->start(200);
}


/*!
    \fn XGDocker::xUpdateBackgroundCoords()
 */
inline void XGDocker::xUpdateBackgroundCoords()
{
	if(strcmp(ActiveConfiguration->Window.Align,"none")==0)
	{
		LayoutPosition=LONBOTTOM;
	}
	if(strcmp(ActiveConfiguration->Window.Align,"bottom")==0)
	{
		LayoutPosition=LONBOTTOM;
		// bug fix for size >48px
		if(ActiveConfiguration->Engine.MaxIconsShowed<1)ActiveConfiguration->Engine.MaxIconsShowed=(QApplication::desktop()->width()/(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation))-1;
		// 0.27
		ActiveConfiguration->Window.Width=
			(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation)
			*(ActiveConfiguration->Engine.MaxIconsShowed+4+ActiveConfiguration->Matrix.DesignDMoltiplier)
			+
			ActiveConfiguration->Matrix.KMatrix[(ActiveConfiguration->Matrix.sizeMatrix*2-1)]
			*2*ActiveConfiguration->Matrix.DesignXMoltiplier
			+ActiveConfiguration->Window.borderLeft*2;
//		qWarning(QString("Width=%1").arg(ActiveConfiguration->Window.Width));
		//ActiveConfiguration->Window.Width=QApplication::desktop()->width()+256;
		//if(ActiveConfiguration->Window.HeightDesktop!=0)
		//{
			// align the desktop size
			// 0.27
			//ActiveConfiguration->Window.HeightDesktop=ActiveConfiguration->Icons.Size+16;
			fakeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
			alternativeHeightDesktop=ActiveConfiguration->Window.HeightDesktop;
		//}
	}
	if(strcmp(ActiveConfiguration->Window.Align,"top")==0)
	{
		LayoutPosition=LONTOP;
		ActiveConfiguration->Window.Width=
			(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation)
			*(ActiveConfiguration->ObjectsIcons.count()+4+ActiveConfiguration->Matrix.DesignDMoltiplier)
			+
			ActiveConfiguration->Matrix.KMatrix[(ActiveConfiguration->Matrix.sizeMatrix*2-1)]*2*ActiveConfiguration->Matrix.DesignXMoltiplier
			+ActiveConfiguration->Window.borderLeft*2;
		//if(ActiveConfiguration->Window.HeightDesktop!=0)
		//{
			// align the desktop size
			ActiveConfiguration->Window.HeightDesktop=ActiveConfiguration->Icons.Size+16;
		//}
	}
	
	// application height
	ActiveConfiguration->Window.Height=
		// 0.34
		//ActiveConfiguration->Icons.FontSize+
		ActiveConfiguration->Icons.Size+
		16+
		(ActiveConfiguration->Icons.SizeBig
		-
		ActiveConfiguration->Icons.Size
		)/2+
		abs(ActiveConfiguration->Icons.Raise)
		;
		// 0.21 pillow is going to be removed
		//+XGIcon::xGetFontHeight();
		//+32;
	
	if(LayoutPosition==LONTOP)
	{
		ActiveConfiguration->Window.borderTop=8;
	}
	if(LayoutPosition==LONBOTTOM)
	{
		ActiveConfiguration->Window.borderTop=
			//ActiveConfiguration->Icons.Size+
			8+
			(ActiveConfiguration->Icons.SizeBig
			-
			ActiveConfiguration->Icons.Size
			)/2+
			abs(ActiveConfiguration->Icons.Raise)
			;
	}
}



inline void XGDocker::changeBackgroundForce(const QString basePath)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"inline void XGDocker::changeBackgroundForce(const QString basePath)");
#endif

	maxDesaturate=(float)ActiveConfiguration->Theme.Background.Desaturate/(float)100;

	QString barPath=basePath;
	if (barPath[barPath.length()-1]!='/')barPath=barPath+"/";
	barPath=::locate("data",barPath);
	
	QFile a(barPath);
	
	if(basePath.length()>0 && a.exists())
	{
		
		
#ifndef ENABLE_FINAL
		qWarning(barPath);
#endif
		// Setup background theme
		QString filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundCenter;
		
		QPixmap PixmapB(filename);
		// 0.35
		// desaturate
		if(maxDesaturate>0)
		{
			int i=0;
			for(float ifo=0;ifo<maxDesaturate;ifo=ifo+maxDesaturate/20)
			{
				QPixmap PixmapAn(filename);
				if(PixmapAn.isNull())
				{
					backgroundBarAni[i].xReset();
					break;
				}
				// 0.35 fix1
				// error with alpha
				//KPixmap An2=PixmapAn;
				//if(i>0)An2=KPixmapEffect::desaturate(An2,ifo);

				backgroundBarAni[i].xImgSource=PixmapAn.convertToImage();
				//backgroundBarAni[i].xImgSource=An2.convertToImage();

				//  desaturate
				//if(i>0)backgroundBarAni[i].xImgSource=KImageEffect::desaturate(backgroundBarAni[i].xImgSource,ifo);
				if(i>0)backgroundBarAni[i].xDesaturate(ifo);
					backgroundBarAni[i].xImgSource=
						backgroundBarAni[i].xImgSource.smoothScale(
						backgroundBarAni[i].xImgSource.width(),
						ActiveConfiguration->Icons.Size+16);
				backgroundBarAni[i].xRepeat(
						ActiveConfiguration->Window.Width,
						ActiveConfiguration->Icons.Size+16);
				i++;
			}
		}
		else
		{
			for(int i=0;i<64;i++)
			{
				//backgroundBarAni[i].xReset();
				QString fnamebar=barPath+
					QString("ani_%1_").arg(i)
					+ActiveConfiguration->Theme.Background.imgBackgroundCenter;
				//qWarning(fnamebar);
				QPixmap PixmapAn(fnamebar);
				if(PixmapAn.isNull())
				{
					backgroundBarAni[i].xReset();
					//backgroundBarAni[i].xImgSource.reset();
					break;
				}
				backgroundBarAni[i].xImgSource=PixmapAn.convertToImage();
					backgroundBarAni[i].xImgSource=
						backgroundBarAni[i].xImgSource.smoothScale(
						backgroundBarAni[i].xImgSource.width(),
						ActiveConfiguration->Icons.Size+16);
				backgroundBarAni[i].xRepeat(
						ActiveConfiguration->Window.Width,
						ActiveConfiguration->Icons.Size+16);
			}
		}
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			//backgroundBar.xImgSource.reset();
			backgroundBar.xReset();
		}
		else
		{
			// this will load the original background
			backgroundBar.xImgSource=PixmapB.convertToImage();
			// check if it's tiled
			if(ActiveConfiguration->Theme.Background.Tiled)
			{
				backgroundBar.xImgSource=
					backgroundBar.xImgSource.smoothScale(
					backgroundBar.xImgSource.width(),
					ActiveConfiguration->Icons.Size+16);
				backgroundBar.xRepeat(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
			else
			{
				backgroundBar.xImgSource=
					backgroundBar.xImgSource.smoothScale(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundOver;
		
		PixmapB.load(filename);
		
		if(PixmapB.isNull())
		{
			backgroundBarOver.xImgSource.reset();
#ifndef ENABLE_FINAL
			qWarning("errore OVER");
#endif
		}
		else
		{
			//backgroundBarOver.xImgSource=PixmapConverter.convertToImage(PixmapB);
			backgroundBarOver.xImgSource=PixmapB.convertToImage();
			
			if(ActiveConfiguration->Theme.Background.Tiled)
			{
				backgroundBarOver.xImgSource=
					backgroundBarOver.xImgSource.smoothScale(
					backgroundBarOver.xImgSource.width(),
					ActiveConfiguration->Icons.Size+16);
				backgroundBarOver.xRepeat(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
			else
			{
				backgroundBarOver.xImgSource=
					backgroundBarOver.xImgSource.smoothScale(
					ActiveConfiguration->Window.Width,
					ActiveConfiguration->Icons.Size+16);
			}
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundLeft;
		
		PixmapB.load(filename);
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			backgroundBarLeft.xReset();
			//backgroundBarLeft.xImgSource.reset();
			backgroundBarLeft.xTransparency.resize(0,0);
#ifndef ENABLE_FINAL
			qWarning("errore left");
#endif
		}
		else
		{
			backgroundBarLeft.xReset();
			backgroundBarLeft.xImgSource=PixmapB.convertToImage();
			backgroundBarLeft.xImgOriginal.load(barPath+"background-mask-left.png");
			/*backgroundBarLeft.xImgSource=
				backgroundBarLeft.xImgSource.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
			backgroundBarLeft.xTransparency=
				backgroundBarLeft.xImgSource.createHeuristicMask();
				//backgroundBarLeft.xImgSource.createAlphaMask();
			*/
		}
		PixmapB.resize(0,0);
		
		filename=barPath
			+ActiveConfiguration->Theme.Background.imgBackgroundRight;
		
		PixmapB.load(filename);
		// Loading background Bar and tile it
		if(PixmapB.isNull())
		{
			backgroundBarRight.xReset();
			backgroundBarRight.xTransparency.resize(0,0);
#ifndef ENABLE_FINAL
			qWarning("errore right");
#endif
		}
		else
		{
			backgroundBarRight.xReset();
			backgroundBarRight.xImgSource=PixmapB.convertToImage();
			backgroundBarRight.xImgOriginal.load(barPath+"background-mask-right.png");
			/*
			backgroundBarRight.xImgSource=
				backgroundBarRight.xImgSource.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
	
			backgroundBarRight.xTransparency=
				//backgroundBarRight.xImgSource.createAlphaMask();
				backgroundBarRight.xImgSource.createHeuristicMask();
			*/
	}
		PixmapB.resize(0,0);
	}
	else
	{
		// no background
		backgroundBar.xImgSource.reset();
	}

	// auto adding separator
	// 20050601
	// code moved to a func
	// 0.31
	//checkBackgroundSeparators();
	createBackgroundSeparators();
	//maskGenerareBigFake();
	lastBackgroundPath=basePath;

}
void XGDocker::changeBackground(const QString basePath)
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::changeBackground(const QString basePath)");
#endif

#ifdef ENABLE_STATS
	//0.36 TODO!
	ActiveConfiguration->Statistics.changedBackgroundTheme++;
#endif


	// 0.32
	// todo optimize!!!
	//if(lastBackgroundPath!=basePath)
	{
		changeBackgroundForce(basePath);
		
	}
	//else
	{
		if(!backgroundBarRight.xImgSource.isNull()){
			
			//backgroundBarRight.xSetSmoothZoom(ActiveConfiguration->Icons.Size+16);
			backgroundBarRight.xZoom=ActiveConfiguration->Icons.Size+16;
			backgroundBarRight.xSetSmoothZoom();

			QImage tmpMask=backgroundBarRight.xImgShowed;
			if(!backgroundBarRight.xImgOriginal.isNull())
			{
			tmpMask=backgroundBarRight.xImgOriginal.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
			}
			backgroundBarRight.xTransparency=tmpMask.createHeuristicMask();

			/*
			backgroundBarRight.xTransparency=backgroundBarRight
					.xImgShowed
						.createHeuristicMask();

			*/
			// 0.32
			/*
			backgroundBarRight.xTransparency.resize(
				ActiveConfiguration->Icons.Size+16,
				ActiveConfiguration->Icons.Size+16);
			backgroundBarRight.xTransparency.fill(Qt::color1);
			*/
		}
		if(!backgroundBarLeft.xImgSource.isNull())
		{
			//backgroundBarLeft.xSetSmoothZoom(ActiveConfiguration->Icons.Size+16);
			backgroundBarLeft.xZoom=ActiveConfiguration->Icons.Size+16;
			backgroundBarLeft.xSetSmoothZoom();
			QImage tmpMask=backgroundBarLeft.xImgShowed;
			if(!backgroundBarLeft.xImgOriginal.isNull())
			{
			tmpMask=backgroundBarLeft.xImgOriginal.smoothScale(
				ActiveConfiguration->Icons.Size+16
				,ActiveConfiguration->Icons.Size+16);
			}
			backgroundBarLeft.xTransparency=tmpMask.createHeuristicMask();

			/*
			backgroundBarLeft.xTransparency=backgroundBarLeft
					.xImgShowed
						.createHeuristicMask();
			*/
			// 0.32
			/*
			backgroundBarLeft.xTransparency.resize(
				ActiveConfiguration->Icons.Size+16,
				ActiveConfiguration->Icons.Size+16);
			backgroundBarLeft.xTransparency.fill(Qt::color1);
			*/
		}
		// since 0.30 support apply configuration we need only to resize the images...
		checkBackgroundSeparators();
	}
	if(maxDesaturate>0)backgroundCicle();
	// 0.35
	if(!tAnimateBackground->isActive() && maxDesaturate>0)tAnimateBackground->start(250);


}



/*!
    \fn XGDocker::createBackgroundSeparators()
 */
void XGDocker::createBackgroundSeparators()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"void XGDocker::createBackgroundSeparators()");
#endif
	QString barPath=ActiveConfiguration->Theme.BackgroundPath;
	if (barPath[barPath.length()-1]!='/')barPath=barPath+"/";
	barPath=::locate("data",barPath);
	// New engine 11 May 2004
	// we have to search for all separators icons
	// GSeparator
	for(uint iconIndex=0;
		iconIndex<ActiveConfiguration->ObjectsIcons.count();
		iconIndex++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")
		{
			// exclude from resizing
			activeIcons[iconIndex]->xExclude=1;
			QString fname=ActiveConfiguration->ObjectsIcons.at(iconIndex)->Images.imgFileName;
			// check if you like to specify an image
			// 0.31
			if(fname=="")
			{
				// if 't specify an image we load the
				// background-separator.png
				QPixmap PixmapB;
				PixmapB.resize(0,0);
		
				QString filename=barPath
					+ActiveConfiguration->Theme.Background.imgBackgroundSeparator;
#ifndef ENABLE_FINAL
qWarning(filename);
#endif
				PixmapB.load(filename);
				// Loading background Bar and tile it
				activeIcons[iconIndex]->xReset();
				if(PixmapB.isNull())
				{
					// We do nothing!!!
					// TODO: new right engine to load backgrounds
					
					// 0.22 patch 15062004
					// if ou don't have separators we create a transparent image
					activeIcons[iconIndex]->xImgSource.create(1,1,32);
					activeIcons[iconIndex]->xImgSource.setAlphaBuffer(false);
					activeIcons[iconIndex]->xImgSource.fill(0);
					activeIcons[iconIndex]->xImgSource.setAlphaBuffer(true);
				
			
#ifndef ENABLE_FINAL
qWarning("errore imgBackgroundSeparator");
#endif
				}
				else
				{
					activeIcons[iconIndex]->xImgSource=PixmapB.convertToImage();
					// 0.31
					/*
					activeIcons[iconIndex]->xImgSource=
						activeIcons[iconIndex]->xImgSource.smoothScale(
						ActiveConfiguration->Icons.Size+16
						,ActiveConfiguration->Icons.Size+16);
					*/
				}
					// 0.31
				updateBackgroundSeparator(iconIndex);
				// free image
				PixmapB.resize(0,0);
			}
			else
			{
				// you have specified the image
				// other engines will load it
			}
		}
	}
}
/*!
    \fn XGDocker::checkBackgroundSeparators()
 */
inline int XGDocker::checkBackgroundSeparators()
{
#ifndef ENABLE_FINAL
	xWarningMsg(this,"inline void XGDocker::checkBackgroundSeparators()");
#endif
	//qWarning("void XGDocker::checkBackgroundSeparators()");


	for(uint iconIndex=0;
		iconIndex<ActiveConfiguration->ObjectsIcons.count();
		iconIndex++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="GSeparator")
		{
			updateBackgroundSeparator(iconIndex);
		}
	}

	//qWarning("End.");
	if(ActiveConfiguration->ObjectsIcons.at(ActiveConfiguration->ObjectsIcons.count()-1)->Info.className=="GSeparator")
	{
		//iconRemove(ActiveConfiguration->ObjectsIcons.count()-1,1);
#ifndef ENABLE_FINAL
		qWarning("void XGDocker::checkBackgroundSeparators() return 1");
#endif
		return 1;
	}else return 0;
}



/*!
    \fn XGDocker::updateBackgroundSeparator(int)
 */
inline void XGDocker::updateBackgroundSeparator(int iconIndex)
{
#ifndef ENABLE_FINAL
	qWarning(QString("xSetSmoothZoom(%1)").arg(ActiveConfiguration->Icons.Size+16));
#endif

	activeIcons[iconIndex]->xZoom=ActiveConfiguration->Icons.Size+16;
	//activeIcons[iconIndex]->xSetSmoothZoom(ActiveConfiguration->Icons.Size+16);
	activeIcons[iconIndex]->xSetSmoothZoom();
	Matrix->xMakeSpace(iconIndex,&activeIcons[iconIndex]->xPosDefault);
	Matrix->xMakeSpace(iconIndex,&activeIcons[iconIndex]->xPosition);
	Matrix->xMakeCenter(iconIndex,&activeIcons[iconIndex]->xHotspot);
	activeIcons[iconIndex]->xPosDefault.setY(
		activeIcons[iconIndex]->xPosDefault.y()-8);
	activeIcons[iconIndex]->xPosDefault.setX(
		activeIcons[iconIndex]->xPosDefault.x()-8);
	activeIcons[iconIndex]->xPosition=activeIcons[iconIndex]->xPosDefault;
/*
	activeIcons[iconIndex]->xPosition.setY(
		activeIcons[iconIndex]->xPosition.y()-8);
	activeIcons[iconIndex]->xPosition.setX(
		activeIcons[iconIndex]->xPosition.x()-8);
*/
	activeIcons[iconIndex]->xSetUpdate=0;
}




/*!
    \fn XGDocker::backgroundCicle()
 */
void XGDocker::backgroundCicle()
{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	xWarningMsg(this,"XGDocker::backgroundCicle()");
#endif



	//qWarning(QString("void XGDocker::backgroundCicle(%1)").arg(backgroundBarAniFrame));
	if(isRaised){
		// ok than check if we have desaturated
		if(maxDesaturate>0)
		{
			if(backgroundBarAniFrame>0)
			{
				backgroundBarAniFrame--;
				backgroundBar.xImgSource=backgroundBarAni[backgroundBarAniFrame].xImgSource;
				//backgroundBar.xImgSource.fill(0);
				xUpdate();
				repaint(false);
				if(backgroundBarAni[backgroundBarAniFrame].xImgSource.isNull()){
					if(maxDesaturate>0)tAnimateBackground->stop();
					backgroundBarAniFrame=0;
				}
			}
			else
			{
				tAnimateBackground->stop();
			}
			return;
		}

		// 0.35 we need to restart the animation
		// because it may be desaturation
		//backgroundBarAniFrame=0;
		return;
	}
	if(backgroundBarAni[0].xImgSource.isNull()){
		tAnimateBackground->stop();
		return;
	}


	backgroundBar.xImgSource=backgroundBarAni[backgroundBarAniFrame].xImgSource;
	//backgroundBar.xImgSource.fill(0);
	xUpdate();
	repaint(false);
	backgroundBarAniFrame++;
	if(backgroundBarAniFrame>63)backgroundBarAniFrame=0;
	if(backgroundBarAni[backgroundBarAniFrame].xImgSource.isNull()){
		if(maxDesaturate>0)
		{
			tAnimateBackground->stop();
			if(backgroundBarAniFrame>0)backgroundBarAniFrame--;
		}
		else backgroundBarAniFrame=0;
	}

	
}


/*!
    \fn XGDocker::xStopAnimateBackground()
 */
void XGDocker::xStopAnimateBackground()
{
	tAnimateBackground->stop(); 
}


/*!
    \fn XGDocker::xStartAnimateBackground()
 */
void XGDocker::xStartAnimateBackground()
{
	tAnimateBackground->start(250);
}


/*!
    \fn XGDocker::xUpdateRepaintInline(int)
 */
void XGDocker::xUpdateRepaintInline(int iconIndex)
{
	//qWarning("Updating single icon");
	int bsx=activeIcons[iconIndex]->xPosition.x();
	int bsz=activeIcons[iconIndex]->xZoom;
	bitBlt(&paintBuffer,
			bsx,
			// TODO: Pillow must be external!
			// this will help to avoi the pillow transparency
			0,
			
			&imgFakeBackgroundGlobal,
			
			bsx,
			// TODO: Pillow must be external!
			// this will help to avoi the pillow transparency
			0,
			bsz,
			// TODO: Pillow must be external!
			// this will help to avoi the pillow transparency
			//activeIcons[iconIndex]->xZoom,
			ActiveConfiguration->Window.Height,
			Qt::CopyROP);
	bitBlt(&paintBuffer,
			bsx,
			yBar,
			&backgroundBar.xImgSource,
			bsx,
			0,
			bsz,
			ActiveConfiguration->Window.Height,Qt::CopyROP);
	if(activeIcons[iconIndex]->hidden==0)
	{
		bitBlt(&paintBuffer,
			activeIcons[iconIndex]->xPosition.x(),
			activeIcons[iconIndex]->xPosition.y(),
			&activeIcons[iconIndex]->xImgShowed,0,Qt::CopyROP);
	}
		// Drawing arrow
		// TODO: we are polling status of icon from configuration data it may be null
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.TaskInfo!=NULL
		||
		ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.dcopReady
		||
		ActiveConfiguration->ObjectsIcons.at(iconIndex)->Tasks.forceRunning
		)
		{
			
			bitBlt(&paintBuffer,
				activeIcons[iconIndex]->xPosition.x()
				+activeIcons[iconIndex]->xZoom/2
				-ActiveConfiguration->Icons.Size/2,
				activeIcons[iconIndex]->xPosDefault.y(),
				&activeIcons[iconIndex]->xImgArrow,0,Qt::CopyROP);
		}
		// 0.36 with miniText
		xUpdateRepaintMiniTextInline(iconIndex);

	bitBlt(&paintBuffer,
			bsx,
			yBar,
			&backgroundBarOver.xImgSource,
			bsx,
			0,
			bsz,
			ActiveConfiguration->Window.Height,
			Qt::CopyROP);
			
	repaint(QRect(bsx,0,bsz,ActiveConfiguration->Window.Height));
	if(iconIndex==lastIcon)xDrawPillow2();
	//tDrawPillow->start(100);
	// 0.38
	//mouseMoveTimeElapsed.start();

}


/*!
    \fn XGDocker::xDrawPillow2
 */
inline void XGDocker::xDrawPillow()
{
#ifndef ENABLE_FINAL
	qWarning("inline void XGDocker::xDrawPillow()");
#endif
	return;


	if(isRaised)
	{
		if(lastIcon>=0 && lastIcon<(int)activeIconsCounter)
		{
			if(!activeIcons[lastIcon]->xIconTextPillow.isTextDrawed)activeIcons[lastIcon]->xIconTextPillow.xDrawText();
			int bsx=activeIcons[lastIcon]->xPosition.x()+activeIcons[lastIcon]->xZoom/2;
			bsx=bsx-activeIcons[lastIcon]->xIconTextPillow.xTextDecentre;

			bitBlt(&paintBuffer,bsx,0,
				//&activeIcons[lastIcon]->xIconTextPillow.xImgText.convertToImage(),
				&activeIcons[lastIcon]->xIconTextPillow.xImageText,
				0,
//				bsw,
//				bsh,
				Qt::CopyROP);
		}
		//repaint(QRect(bsx,0,bsw,bsh));
		//repaint(false);
/*
		if(lastIcon>=0 && lastIcon<(int)activeIconsCounter)
		{
			if(activeIcons[lastIcon]->xPillow==NULL)
			{
//				qWarning("Creating new pillow...");
				activeIcons[lastIcon]->xPillow=new XEPlugin_GEPillow(0,0);
				activeIcons[lastIcon]->xPillow->xSetup();
				activeIcons[lastIcon]->xPillow->xStart();
				//activeIcons[lastIcon]->xPillow->resize(300,30);
				//activeIcons[lastIcon]->xPillow->move(0,0);
			}
			if(!activeIcons[lastIcon]->isTextDrawed)activeIcons[lastIcon]->xDrawText();
			int bsx=activeIcons[lastIcon]->xPosition.x()+activeIcons[lastIcon]->xZoom/2;
			bsx=bsx-activeIcons[lastIcon]->xTextDecentre;
			
			activeIcons[lastIcon]->xPillow->externalDrawPillow(
			//((XEPlugin_GEPillow *)xPillow)->externalDrawPillow(
				activeIcons[lastIcon],
				bsx+ActiveConfiguration->Window.Left,
				ActiveConfiguration->Window.Top-5
				-
				XGIcon::xGetFontHeight());
			//xPillow->show();
			activeIcons[lastIcon]->xPillow->show();
			
		}
		else
		{
			//xPillow->hide();
		}
*/
	}
}


inline void XGDocker::xDrawPillow2()
{
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xDrawPillow2()");
#endif

	if(isRaised && !isLowering)
	{
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xDrawPillow2() isRaised");
#endif
		if(lastIcon>=0 && lastIcon<(int)activeIconsCounter)
		{
			if(activeIcons[lastIcon]->xPillow==NULL)
			{
				if(activeIcons[0]->xPillow==NULL)
				{
					activeIcons[0]->xPillow=new XEPlugin_GEPillow(0,0);
					if(activeIcons[0]->xPillow==NULL)
					{
						qWarning("KXDocker::XGDocker::xDrawPillow2()::activeIcons[0]->xPillow==NULL I think I'm going to crash!!!");
						return;
					}

					activeIcons[0]->xPillow->xSetup();
					activeIcons[0]->xPillow->xEventWidgetMoved(
						ActiveConfiguration->Window.Left,ActiveConfiguration->Window.Top,
						activeIcons[0]->xPosDefault.x(),
						activeIcons[0]->xPosDefault.y(),
						activeIcons[activeIconsCounter-1]->xPosDefault.x(),
						activeIcons[activeIconsCounter-1]->xPosDefault.y()
					);
					activeIcons[0]->xPillow->xStart();
				}
				// TODO: make static xPillow
				activeIcons[lastIcon]->xPillow=activeIcons[0]->xPillow;
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xDrawPillow2() created xPillow");
#endif

			}
			if(!activeIcons[lastIcon]->xIconTextPillow.isTextDrawed)activeIcons[lastIcon]->xIconTextPillow.xDrawText();
			int bsx=activeIcons[lastIcon]->xPosition.x()+activeIcons[lastIcon]->xZoom/2;
			bsx=bsx-activeIcons[lastIcon]->xIconTextPillow.xTextDecentre;
			
			activeIcons[lastIcon]->xPillow->externalDrawPillow(
			//((XEPlugin_GEPillow *)xPillow)->externalDrawPillow(
				activeIcons[lastIcon],
				bsx
				//+ActiveConfiguration->Window.Left
				,
				0
				//+ActiveConfiguration->Window.Top-5
				//-
				//XGIcon::xGetFontHeight()
				);
			activeIcons[lastIcon]->xPillow->show();

		}
		else
		{
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xDrawPillow2() Not Raised");
#endif
		}
	}
#ifndef ENABLE_FINAL
	qWarning("void XGDocker::xDrawPillow2() End");
#endif
}


/*!
    \fn XGDocker::xSetDesaturate(float)
 */
void XGDocker::xSetDesaturate(float nDesaturate)
{
	Desaturate=nDesaturate;
	repaint(false);
}






/*!
    \fn XGDocker::xUpdateRepaintMiniTextInline(int)
 */
void XGDocker::xUpdateRepaintMiniTextInline(int iconIndex)
{
	if(activeIcons[iconIndex]->xIconTextMini.pillowText.length())
	{
		if(!activeIcons[iconIndex]->xIconTextMini.isTextDrawed)activeIcons[iconIndex]->xIconTextMini.xDrawText();
		int bsx=activeIcons[iconIndex]->xPosition.x()+activeIcons[iconIndex]->xZoom/2;
		bsx=bsx-activeIcons[iconIndex]->xIconTextMini.xTextDecentre;

		bitBlt(&paintBuffer,bsx,
			activeIcons[iconIndex]->xPosDefault.y()+
			ActiveConfiguration->Icons.Size/2,
			&activeIcons[iconIndex]->xIconTextMini.xImageText,
			0,
			Qt::CopyROP);
	}
}


/*!
    \fn XGDocker::startDrag()
 */
void XGDocker::startDrag()
{
	qWarning("void XGDocker::startDrag()");
	if(lastIcon>=0 && lastIcon<(int)activeIconsCounter)
	{
		activeIcons[lastIcon]->hidden=1;
		hasDragged=lastIcon;
		QDragObject *d = new QTextDrag("ciao", this );
		//d->dragCopy();
		if (d->drag() && d->target() == this )
		{
			// ok than you have moved it
			//ActiveConfiguration->RollingIcons.remove(hasDragged);
			//iconRemove(hasDragged,1);
		}
	}
	qWarning("void XGDocker::EndstartDrag()");
	// do NOT delete d.
}

extern  GC kde_xget_temp_gc( int scrn, int depth);
GC kde_xget_temp_gc( int, int depth)
{
	GC gc;
	XGCValues gcv;
	memset(&gcv,0,sizeof(gcv));
	Pixmap pix;
	pix=XCreatePixmap(qt_xdisplay(),qt_xrootwin(), 128, 128, depth);
	gc=XCreateGC(qt_xdisplay(), pix, GCForeground, &gcv);
	return gc;
}

/*!
    \fn XGDocker::xEventGetBackground(int,int,int,int)
 */
QPixmap XGDocker::xEventGetBackground(int l,int t,int wb,int hb)
{
	QPixmap background(wb,hb);

	static Atom prop_root;
//	static Atom atom_eroot;
	Pixmap p = None;
	Atom type;
	int format;
	unsigned long length, after;
	unsigned char* data_root;
	prop_root = XInternAtom(qt_xdisplay(), "_XROOTPMAP_ID", false);
	//atom_eroot = XInternAtom(qt_xdisplay(), "ESETROOT_PMAP_ID", false);
	XGetWindowProperty( qt_xdisplay(), qt_xrootwin(), prop_root, 0L, 1L, False, AnyPropertyType,&type, &format, &length, &after, &data_root);
	//XGetWindowProperty( qt_xdisplay(), qt_xrootwin(), atom_eroot, 0L, 1L, False, AnyPropertyType,&type, &format, &length, &after, &data_root);
	if (type == XA_PIXMAP)
	{
		p = *((Pixmap*)data_root);
		if (p != None){
			Window root=qt_xrootwin();
			Pixmap p_mask = None;
			int x=0, y=0;
			unsigned int w = 0;
			unsigned int h = 0;
			unsigned int border_w=0, depth=0;
			XGetGeometry(qt_xdisplay(), p, &root,
				&x, &y, &w, &h, &border_w, &depth);
			if (w > 0 && h > 0){
				QPixmap pm(w, h);
				// Always detach before doing something behind QPixmap's back.
				pm.detach();
				XCopyArea(qt_xdisplay(),
					p, pm.handle(),
					kde_xget_temp_gc(DefaultScreen(qt_xdisplay()),depth),
					0, 0, w, h, 0, 0);
				if (p_mask != None){
					QBitmap bm(w, h);
					XCopyArea(qt_xdisplay(), p_mask, bm.handle(),
						kde_xget_temp_gc(DefaultScreen(qt_xdisplay()), 1),
						0, 0, w, h, 0, 0);
					pm.setMask(bm);
				}
				bitBlt(&background,0,0,&pm,l,t,wb,hb,Qt::CopyROP);
				return background;
				/*
				qWarning("152");
				bool scale=false;
				int width=0;
				int height=0;
				if ( scale && width > 0 && height > 0 && !pm.isNull() &&
					( (int) w != width || (int) h != height) ){
					background.convertFromImage( pm.convertToImage().smoothScale( width, height ) );
				} else {
				qWarning("173");
					background= pm;
				}
				*/
				//background=pm;
	
			}
		}
	}

	background.fill(Qt::black);
	return background;
}




/*!
    \fn XGDocker::paint(QImage &)
 */
void XGDocker::paint(QImage &target)
{
	bitBlt(&target,
		0,
		0,
		&paintBuffer,
		0,0,ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height,
		Qt::CopyROP);
}


/*!
    \fn XGDocker::paintIn(QImage &)
 */
void XGDocker::paintIn(QImage &source,int Erase)
{
	switch(Erase)
	{
		case 1:
		paintBuffer.setAlphaBuffer(false);
		//paintBuffer.fill(0);
		//paintBuffer.setAlphaBuffer(true);
		break;
		case 2:
		//lastRaised=0;
		xUpdatePart1(0,0);
		break;
	}

	bitBlt(&paintBuffer,
		0,
		0,
		&source,
		0,0,ActiveConfiguration->Window.Width,ActiveConfiguration->Window.Height,
		Qt::CopyROP);
}


/*!
    \fn XGDocker::xUpdatePart1(int,int)
 */
inline void XGDocker::xUpdatePart1(int,int)
{
		// if it's raised we have to do some work
		if(isRaised>0)
		{
			// Emit Mouse Moved Signal to track mouse!
			int fakeWY=0;
			tMouseMoved->start(ActiveConfiguration->Engine.SmoothTimeout);
			// Are we changing the state of the widget?
			if(lastRaise!=isRaised)
			{
				// Grab the new FAKE background, because we are raising over the windows
				//0.27
				int fakeH=ActiveConfiguration->Window.Height-alternativeHeightDesktop;
				//int fakeH=height()-ActiveConfiguration->Window.HeightDesktop;
				fakeWY=y();
				if(LayoutPosition==LONTOP)
				{
					fakeWY=fakeWY+alternativeHeightDesktop;
				}
				// 0.27
				imgWindow=PixmapConverter.convertToImage(
					QPixmap::grabWindow(
					QApplication::desktop()->winId(), 
					x(), fakeWY,
					ActiveConfiguration->Window.Width,
					fakeH
					)
					)
					;


				/*
				imgWindow=PixmapConverter.convertToImage(
					QPixmap::grabWindow(
					QApplication::desktop()->winId(), 
					x(), fakeWY,
					width(),fakeH
					)
					)
					;
				*/
				// After grabbed the window
				// we raise the dock with new mask
				setMask(maskFull);
				//qWarning("xgdocker.cpp:385");
				// Lock the mouse to have a good smooth
				grabMouse();
				// Software update with manual background refresh
				if(lastRaise>=0)
				{
#ifndef ENABLE_FINAL
					qWarning("xgdocker.cpp:389 You are showing the window");
#endif
					/*
					bitBlt(&paintBuffer,
						0,
						0,
						&imgWindow,0,Qt::CopyROP);
					*/
					imgFakeBackground=imgWindow;
				}
				else
				{
					// it's a desktop
					/*
					bitBlt(&paintBuffer,
						0,
						0,
						&imgBackground,0,Qt::CopyROP);
					*/
#ifndef ENABLE_FINAL
					qWarning("xgdocker.cpp:403 You are showing the desktop");
#endif					
					/*
					paintBuffer.fill(0);
					repaint(false);
					sleep(1);
					*/
					imgFakeBackground=imgBackground;
				}
				// save the state
				lastRaise=isRaised;
	// 0.35
	if(!tAnimateBackground->isActive() && maxDesaturate>0)tAnimateBackground->start(250);

			}
			// starting paint background
			// new patch 20040602
			// to avoid transparency error
			
			/*
			bitBlt(&paintBuffer,
					0,
					0,
					&imgFakeBackground,0,Qt::CopyROP);
			*/
			int fakeY=0;
			int fakeBY=fakeHeightDesktop;
			if(LayoutPosition==LONBOTTOM)
			{
				// 0.27
				fakeY=ActiveConfiguration->Window.Height-fakeHeightDesktop;
				//fakeY=height()-ActiveConfiguration->Window.HeightDesktop;
				fakeBY=0;
			}
			bitBlt(&imgFakeBackgroundGlobal,
					0,
					fakeBY,
					&imgFakeBackground,0,Qt::CopyROP);
			bitBlt(&imgFakeBackgroundGlobal,
				0,
				fakeY,
				&imgBackground,0,fakeY,
				ActiveConfiguration->Window.Width,
				//ActiveConfiguration->Window.HeightDesktop
				// 0.27
				fakeHeightDesktop
				//fakeHeightDesktop
				,Qt::CopyROP);
		}
		else
		{
			// we are closed simpli release resources
			if(lastRaise!=isRaised)
			{
				lastRaise=isRaised;
				//xEventReset(xLastX,xLastY);
				releaseMouse();
				setMask(maskBackground);
			}
		}
}


/*!
    \fn XGDocker::xGetBackground()
 */
QImage * XGDocker::xGetBackground()
{
	return &imgFakeBackgroundGlobal;
}


/*!
    \fn XGDocker::xStep()
 */
void XGDocker::xStep()
{
	uint k=0;
	//qWarning("void XGDocker::xStep()");
	for(uint iconIndex=0;iconIndex<activeIconsCounter;iconIndex++)
	{

		// 0.38
		if(activeIcons[iconIndex]->dAnimateStatus
	//		&& 
	//		mouseMoveTimeElapsed.elapsed()>50
		)
		{
			k++;
			activeIcons[iconIndex]->xStep();
			//int z=activeIcons[iconIndex]->xZoom;
			//activeIcons[iconIndex]->xZoom=0;
			// done in GIcon
			//activeIcons[iconIndex]->xSetZoom();
			xUpdateRepaintInline(iconIndex);
			nanosleep(&req,&rem);

		}

	}
	if(k==0)polling->stop();
}


/*!
    \fn XGDocker::xCheckBackgroundSeparators()
 */
void XGDocker::xCheckBackgroundSeparators()
{
	int nIconsBefore=0;
	for(int i=(int)activeIconsCounter-1;i>=0;i--)
	{
		if(
	ActiveConfiguration->ObjectsIcons.at(i)->Info.className.endsWith("GSeparator","false")
		)
		{
			if(nIconsBefore<1)iconRemove(i,1);
			nIconsBefore=0;
		}
		else
		{
	if(
//ActiveConfiguration->ObjectsIcons.at(i)->Info.className.endsWith("GIcon","false")
ActiveConfiguration->ObjectsIcons.at(i)->Info.className.startsWith("x","false")
	)
	{
		nIconsBefore++;
	}
		}
		
	}
}
