/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_xmlconf.h"

#include <xeconfiguration.h>
#include <xeobject.h>
#include <kpopupmenu.h>

#include <qxml.h>
#include <qdom.h>
#include <qmessagebox.h>
#include <qdir.h>

#include <kstandarddirs.h>


#include "xeplugin_xmlconf.moc"

#include <stdio.h>
#include <stdlib.h>

#include <kstandarddirs.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kconfig.h>

#include <kxdocker_setup_sources.h>

//#undef ENABLE_FINAL


XEPlugin_XMLConf::XEPlugin_XMLConf(QObject *parent , const char *name )
// : QXmlDefaultHandler(parent, name)
// : QXmlDefaultHandler()
 : QObject(parent, name)
{
//	XEObject::xPluginAdd(this);
// this cannot be registered as a plugin since plugin are sterupped too late!
	XEObject::xSetXMLParser(this);
	ActiveConfiguration=NULL;
}


XEPlugin_XMLConf::~XEPlugin_XMLConf()
{
}




/*!
    \fn XEPlugin_XMLConf::xStart()
 */
void XEPlugin_XMLConf::xStart()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_XMLConf::xStop()
 */
void XEPlugin_XMLConf::xStop()
{
	if(ActiveConfiguration==NULL)return;
#ifdef ENABLE_STATS
	//0.36
	QDateTime tempo;
	tempo.setTime_t(ActiveConfiguration->Statistics.lastStart);
	int secConta=tempo.secsTo(QDateTime::currentDateTime());
	int minuti=secConta/60;
	int ore=minuti/60;
	int giorni=ore/24;
	secConta=secConta%60;
	minuti=minuti%60;
	ore=ore%24;

	ActiveConfiguration->Statistics.dockerSecondsRunning=secConta;
	ActiveConfiguration->Statistics.dockerDaysRunning=giorni;
	ActiveConfiguration->Statistics.dockerMinutesRunning=minuti;
	ActiveConfiguration->Statistics.dockerHoursRunning=ore;
#endif


	if(ActiveConfiguration->AutoSave)
	{
		qWarning("saving xml configuration...");
		QString homeconfiguration=::locateLocal("data","kxdocker/")+"kxdocker_conf.xml";
		if(homeconfiguration!=""){
			//qWarning(homeconfiguration);
			this->xXMLStore(homeconfiguration);
			KConfig *cfg=KGlobal::config();
			cfg->setGroup("");
			cfg->writeEntry("KXDockerXMLConf",homeconfiguration);
		}


		//ActiveConfiguration->Engine.XMLConf
	}
}


/*!
    \fn XEPlugin_XMLConf::xSetup()
 */
void XEPlugin_XMLConf::xSetup()
{
	// Query for last configuration
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(Configurator==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	
	xLoadXML(ActiveConfiguration->Engine.XMLConf);
	
	
	if(ActiveConfiguration->ObjectsIcons.count()<1)
	{
		qWarning("May be you have load a wrong kxdocker_conf.xml");
		exit(1);
	}
	
	
}


/*!
    \fn XEPlugin_XMLConf::startDocument()
 */
bool XEPlugin_XMLConf::startDocument()
{
	xmlLevel=0;
	return true;
}


/*!
    \fn XEPlugin_XMLConf::startElement( const QString&, const QString&, const QString& ,const QXmlAttributes& )
 */
bool XEPlugin_XMLConf::startElement( const QString&a, const QString&b, const QString&c ,const QXmlAttributes& )
{
	xmlLevel++;
	char pippo[100];
	sprintf(pippo,"(%d) %s,%s,%s",xmlLevel,(const char *)a,(const char *)b,(const char *)c);
#ifndef ENABLE_FINAL
	qWarning(pippo);
#endif
	return true;
}


/*!
    \fn XEPlugin_XMLConf::endElement( const QString&, const QString&, const QString& );
 */
bool XEPlugin_XMLConf::endElement( const QString&, const QString&, const QString& )
{
	xmlLevel--;
	return true;
}


/*!
    \fn XEPlugin_XMLConf::xmlFetch(const QString &tagName,int &retValue,QDomNodeList &xmlEngine)
 */
void XEPlugin_XMLConf::xmlFetch(const QString &tagName,int &retValue,QDomNodeList &xmlEngine)
{
	if(xmlEngine.count()>0)
	{
		QString sValue;
		// Save old Value
		sValue=sValue.setNum(retValue);
		// Try to fetch the attribute
		sValue=xmlEngine.item(0).toElement().attribute(tagName,sValue);
		bool okRet=false;
		int tmpValue=sValue.toInt(&okRet);
		if(okRet==false)
		{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	QString Errors="error while reading XML Attribute VALUE";
	Errors=Errors+" ";
	Errors=Errors+tagName;
#endif
		}
		retValue=tmpValue;
	}
	else
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for XML Attribute");
#endif
	}
}


/*!
    \fn XEPlugin_XMLConf::xmlFetchObjectsIcons(QDomNodeList &xmlIcons)
 */
void XEPlugin_XMLConf::xmlFetchObjectsIcons(QDomNodeList &xmlIcons,XSGObjectIcon *storageIcon)
{
#ifndef ENABLE_FINAL
	qWarning(".objectsicons: Fetching configurations");
#endif
	QDomNodeList xmlEngine;
	for(uint i=0; i<xmlIcons.count();i++)
	{
		//ActiveConfiguration->ObjectsIcons.count();
		XSGObjectIcon	*addedCfg=NULL;
		if(storageIcon!=NULL)addedCfg=storageIcon;
		else
		{
			// 0.35
			/*
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	addedCfg=xEConfiguration->iconAdd();
			*/
			addedCfg=new XSGObjectIcon;




			// patch 0.23 for multi xml loading
			//ActiveConfiguration->RollingIcons.append(addedCfg);
		}
		//ActiveConfiguration->ObjectsIcons.append(addedCfg);
//		addedCfg->Tasks.PopupMenu=new KPopupMenu();
		addedCfg->Tasks.PopupMenu=NULL;
		addedCfg->PluginPopupMenu=NULL;

		
		
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("info");
		if(xmlEngine.count()>0)
		{
			addedCfg->Info.className=
				xmlEngine.item(0).toElement().attribute("className");
#ifndef ENABLE_FINAL
			qWarning("objectsicons.Info.clasName");
#endif
			addedCfg->OverText=
				xmlEngine.item(0).toElement().attribute("OverText");
			addedCfg->Info.Name=xmlEngine.item(0).toElement().attribute("Name");
			addedCfg->Info.Group=xmlEngine.item(0).toElement().attribute("Group");
		}
		
		// check.....
		
		if(storageIcon==NULL)
{

	int FoundIndex=-1;
	
	// check if there is another icon with same name...
	
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
			if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==
				addedCfg->Info.Name)
			{
					FoundIndex=i;
					break;
			}
	}

		if(FoundIndex>=0)
		{
			//ho trovato 
			delete addedCfg;
			addedCfg=NULL;
			continue;
		}
		else
		{
			ActiveConfiguration->RollingIcons.append(addedCfg);
		}
	}
		
		//****************************************
		
		
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("images");
		if(xmlEngine.count()>0)
		{
			addedCfg->Images.imgFileName=
				xmlEngine.item(0).toElement().attribute("imgFileName");
			addedCfg->Images.imgFileArrow=
				xmlEngine.item(0).toElement().attribute("imgFileArrow",
				"arrow.png");
			addedCfg->Images.imgFileDrop=
				xmlEngine.item(0).toElement().attribute("imgFileDrop",
				"drop.png");
			addedCfg->PoofName=
				xmlEngine.item(0).toElement().attribute("PoofName");
			// 0.37
			addedCfg->Images.imgFileOverlay="";
#ifndef ENABLE_FINAL
			qWarning("objectsicons.images.imgFileName");
			qWarning(addedCfg->Images.imgFileName);
#endif
		}
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("actions");


		if(xmlEngine.count()>0)
		{
			addedCfg->Actions.onClickExec=
				xmlEngine.item(0).toElement().attribute("onClickExec");
			addedCfg->Actions.onDropExec=
				xmlEngine.item(0).toElement().attribute("onDropExec");
			
#ifndef ENABLE_FINAL
			qWarning("objectsicons.actions.onclickexec");
			qWarning(addedCfg->Actions.onClickExec);
#endif

			// 0.38
			// inverted mask
			addedCfg->Actions.iAnimationMask=0;
			xmlFetch("iAnimationMask",addedCfg->Actions.iAnimationMask,xmlEngine);

		}


		// 0.36
		addedCfg->Tasks.MiniText="";
		// by default we show count of windows
		addedCfg->Tasks.MiniTextShow=1;

		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("status");
		if(xmlEngine.count()>0)
		{
			xmlFetch("MiniTextShow",addedCfg->Tasks.MiniTextShow,xmlEngine);//.item(0).toElement());
		}


		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("pluginconfiguration");
		if(xmlEngine.count()>0)
		{
			addedCfg->PluginConfiguration=
				xmlEngine.item(0).toElement().childNodes();
		}
		
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("actionlist");
		if(xmlEngine.count()>0)
		{
			addedCfg->Actions.ActionList=
				xmlEngine.item(0).toElement().childNodes();
		}
		
	
		QDomNodeList xmlSubClass=
			xmlIcons.item(i).toElement().elementsByTagName("matchtasks");
		addedCfg->Tasks.TaskInfo=NULL;
		addedCfg->Tasks.ShowThumbnail=0;
		
		for(uint a=0; a<xmlSubClass.count();a++)
		{
			addedCfg->Tasks.WindowTitle.append(
				xmlSubClass.item(a).toElement().attribute("WindowTitle"));
			addedCfg->Tasks.ClassName.append(
				xmlSubClass.item(a).toElement().attribute("ClassName"));
			addedCfg->Tasks.TaskName.append(
				xmlSubClass.item(a).toElement().attribute("TaskName"));
		}
		//0.29
		addedCfg->Tasks.dcopReady=0;
		// 0.33
		addedCfg->Tasks.forceRunning=0;
		xmlSubClass=xmlIcons.item(i).toElement().elementsByTagName("matchdcop");
		for(uint a=0; a<xmlSubClass.count();a++)
		{
			addedCfg->Tasks.dcopName.append(
				xmlSubClass.item(a).toElement().attribute("dcopName"));
		}
		if(addedCfg->Tasks.dcopName.count()<1 &&addedCfg->Tasks.TaskName.count()>0)
		{
			addedCfg->Tasks.dcopName.append(addedCfg->Tasks.TaskName[0]);
			//qWarning(addedCfg->Tasks.TaskName[0]);
		}
		
	}
if(storageIcon==NULL)
{

int FoundIndex;
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		FoundIndex=-1;
		for(uint k=0; k<ActiveConfiguration->ObjectsIcons.count();k++)
		{
			if(ActiveConfiguration->RollingIcons.at(i)->Info.Group==
				ActiveConfiguration->ObjectsIcons.at(k)->Info.Group)
			{
					FoundIndex=k;
					break;
			}
		}
		if(FoundIndex>=0)
		{
			//ho trovato 
		}
		else
		{
			// 0.28 xmls for plugins
			if(ActiveConfiguration->RollingIcons.at(i)->Info.className!="disabled")
			{
				ActiveConfiguration->ObjectsIcons.append(ActiveConfiguration->RollingIcons.at(i));
			}
		}
	}
}
}
void XEPlugin_XMLConf::xmlFetchObjectsPlugins(QDomNodeList &xmlIcons)
{
#ifndef ENABLE_FINAL
	qWarning(".objectsplugins: Fetching configurations");
#endif
	QDomNodeList xmlEngine;
	for(uint i=0; i<xmlIcons.count();i++)
	{
		XSCfgMatchIcons	*addedElement=new XSCfgMatchIcons;
		
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("system");
		if(xmlEngine.count()>0)
		{
			addedElement->SystemName=xmlEngine.item(0).toElement().attribute("SystemName");
		}
		// New engine 07052004
			// 0.35
			/*
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
		addedElement->Icon=xEConfiguration->iconAdd();
		*/
		addedElement->Icon=new XSGObjectIcon;
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("objectsicons");
		if(xmlEngine.count()>0)
		{
			xmlFetchObjectsIcons(xmlEngine,addedElement->Icon);
		}
		/*
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("info");
		if(xmlEngine.count()>0)
		{
			addedElement->Icon.Info.className=
				xmlEngine.item(0).toElement().attribute("className");
			addedElement->Icon.OverText=
				xmlEngine.item(0).toElement().attribute("OverText");
		}
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("images");
		if(xmlEngine.count()>0)
		{
			addedElement->Icon.Images.imgFileName=
				xmlEngine.item(0).toElement().attribute("imgFileName");
			addedElement->Icon.Images.imgFileArrow=
				xmlEngine.item(0).toElement().attribute("imgFileArrow",
				"arrow.png");
		}
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("actions");
		if(xmlEngine.count()>0)
		{
			addedElement->Icon.Actions.onClickExec=
				xmlEngine.item(0).toElement().attribute("onClickExec");
		}
		QDomNodeList xmlSubClass=
		xmlIcons.item(i).toElement().elementsByTagName("matchtasks");
		addedElement->Icon.Tasks.TaskInfo=NULL;
		addedElement->Icon.Tasks.ShowThumbnail=0;
		
		for(int a=0; a<xmlSubClass.count();a++)
		{
			addedElement->Icon.Tasks.WindowTitle.append(
				xmlSubClass.item(a).toElement().attribute("WindowTitle"));
			addedElement->Icon.Tasks.ClassName.append(
				xmlSubClass.item(a).toElement().attribute("ClassName"));
			addedElement->Icon.Tasks.TaskName.append(
				xmlSubClass.item(a).toElement().attribute("TaskName"));
		}
		*/
		
		// new engine with multi configurations
	int FoundIndex=-1;
	for(uint i=0;i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
			if(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Info.Name==
				addedElement->Icon->Info.Name)
			{
					FoundIndex=i;
					break;
			}
	}

		if(FoundIndex>=0)
		{
			//ho trovato 
			delete addedElement->Icon;
			delete addedElement;
			addedElement=NULL;
			continue;
		}
		else
		{
			ActiveConfiguration->Plugins.Matches.append(addedElement);
		}
		//ActiveConfiguration->Plugins.Matches.append(addedElement);
		
	}
}


/*!
    \fn XEPlugin_XMLConf::xmlFetchPathsIcons(QDomNodeList &xmlIcons)
 */
void XEPlugin_XMLConf::xmlFetchPathsIcons(QDomNodeList &xmlIcons)
{
	QDomNodeList xmlEngine;
	for(uint i=0; i<xmlIcons.count();i++)
	{
		ActiveConfiguration->Theme.IconsPaths.append(
			xmlIcons.item(i).toElement().attribute("Path")
			);
	}
}


/*!
    \fn XEPlugin_XMLConf::xmlFetchPathsPlugins(QDomNodeList &xmlIcons)
 */
void XEPlugin_XMLConf::xmlFetchPathsPlugins(QDomNodeList &xmlIcons)
{
	QDomNodeList xmlEngine;
	for(uint i=0; i<xmlIcons.count();i++)
	{
		ActiveConfiguration->Plugins.PluginsPaths.append(
			xmlIcons.item(i).toElement().attribute("Path")
			);
	}
}


/*!
    \fn XEPlugin_XMLConf::xmlFetchPlugins(QDomNodeList &xmlIcons)
 */
void XEPlugin_XMLConf::xmlFetchPlugins(QDomNodeList &xmlIcons)
{
	QDomNodeList xmlEngine;
	for(uint i=0; i<xmlIcons.count();i++)
	{
#ifndef ENABLE_FINAL
		qWarning("void XEPlugin_XMLConf::xmlFetchPlugins(QDomNodeList &xmlIcons)");
#endif
		XSGObjectPlugin	*added=new XSGObjectPlugin;
		
		ActiveConfiguration->Plugins.Plugin.append(added);
		added->Info.Name=xmlIcons.item(i).toElement().attribute("name");
#ifndef ENABLE_FINAL
		qWarning("xeplugin_xmlconf.cpp:524");
#endif
		xmlEngine=xmlIcons.item(i).toElement().elementsByTagName("pluginconf");
#ifndef ENABLE_FINAL
		qWarning("xeplugin_xmlconf.cpp:526");
#endif
		if(xmlEngine.count()>0)
		{
#ifndef ENABLE_FINAL
		qWarning("xeplugin_xmlconf.cpp:529");
#endif
		
			added->xmlConfiguration=
			//xmlEngine.item(0).toElement().childNodes();
			xmlIcons.item(i).toElement().childNodes();
			
		}
		
	}
}


/*!
    \fn XEPlugin_XMLConf::xXMLStore(const QString fileName)
 */
void XEPlugin_XMLConf::xXMLStore(const QString &fileName)
{
	QDomDocument 	doc( "KXDocker_Conf" );
	xmlFile.close();
	xmlFile.setName(fileName);
#ifndef ENABLE_FINAL
	qWarning(fileName);
#endif
	if ( !xmlFile.open( IO_WriteOnly ) )
	{
#ifndef ENABLE_FINAL
		qWarning("Error while writing:");
		qWarning(fileName);
#endif
		//exit(1);
		return;
	}
	/*
	if ( !doc.setContent( &xmlFile) ) {
		qWarning("errore parsiing xml");
		xmlFile.close();
		exit(1);
		return;
	}
	*/
	QDomElement 	kxdocker=doc.createElement("kxdocker");
	doc.appendChild(kxdocker);
	
	kxdocker.setAttribute("version",ActiveConfiguration->Version);
	
	xCfgStore(doc,kxdocker);
	QDomElement 	xmlIconsObjects=doc.createElement("objects");
	kxdocker.appendChild(xmlIconsObjects);
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		xmlStoreObjectsIcons(doc,xmlIconsObjects,	
			ActiveConfiguration->RollingIcons.at(i)
		);
	}
	
	
	for(uint i=0;i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		QDomElement 	xmlMatch=doc.createElement("objectsplugins");
		kxdocker.appendChild(xmlMatch);
		QDomElement 	xmlMatchSystem=doc.createElement("system");
		xmlMatch.appendChild(xmlMatchSystem);
		xmlMatchSystem.setAttribute("SystemName",
		ActiveConfiguration->Plugins.Matches.at(i)->SystemName
		);
		
		xmlStoreObjectsIcons(doc,xmlMatch,
			ActiveConfiguration->Plugins.Matches.at(i)->Icon
		);
	}
	
	QString a=doc.toString();
	//qWarning(a);
#ifndef ENABLE_FINAL
        qWarning("599");
#endif
	xmlFile.writeBlock(a,a.length());
#ifndef ENABLE_FINAL
        qWarning("601");
#endif
	xmlFile.flush();
#ifndef ENABLE_FINAL
        qWarning("603");
#endif
        xmlFile.close();
#ifndef ENABLE_FINAL
        qWarning("605");
#endif
	//exit(1);
}


/*!
    \fn XEPlugin_XMLConf::xXMLStore()
 */
void XEPlugin_XMLConf::xXMLStore()
{
	xXMLStore(ActiveConfiguration->Engine.XMLConf);
}


/*!
    \fn XEPlugin_XMLConf::xmlStoreObjectsIcons(QDomDocument &doc, QDomElement &root, XSGObjectIcon *icon
 */
void XEPlugin_XMLConf::xmlStoreObjectsIcons(QDomDocument &doc, QDomElement &root, XSGObjectIcon *icon)
{
	// Tasks have to be skipped!
	// mounts
	if(icon->Info.className.startsWith("x"))return;
	QDomElement xmlObjectIcon=doc.createElement("objectsicons");
	root.appendChild(xmlObjectIcon);
	QDomElement xmlObjectInfo=doc.createElement("info");
	xmlObjectIcon.appendChild(xmlObjectInfo);
	QDomElement xmlObjectImages=doc.createElement("images");
	xmlObjectIcon.appendChild(xmlObjectImages);

	QDomElement xmlObjecStatus=doc.createElement("status");
	xmlObjectIcon.appendChild(xmlObjecStatus);


	QDomElement xmlObjectActions=doc.createElement("actions");
	xmlObjectIcon.appendChild(xmlObjectActions);
	
	xmlObjectInfo.setAttribute("Name",
	icon->Info.Name);
	xmlObjectInfo.setAttribute("className",
	icon->Info.className);
	xmlObjectInfo.setAttribute("Group",
	icon->Info.Group);
	xmlObjectInfo.setAttribute("fileName",
	icon->Info.fileName);
	xmlObjectInfo.setAttribute("OverText",
	icon->OverText);
	
	xmlObjectImages.setAttribute("imgFileArrow",
	icon->Images.imgFileArrow);
	xmlObjectImages.setAttribute("imgFileDrop",
	icon->Images.imgFileDrop);
	xmlObjectImages.setAttribute("imgFileName",
	icon->Images.imgFileName);
	xmlObjectImages.setAttribute("PoofName",
	icon->PoofName);
	// 0.36
	xmlObjecStatus.setAttribute("MiniTextShow",
	icon->Tasks.MiniTextShow);

	
	xmlObjectActions.setAttribute("onClickExec",icon->Actions.onClickExec);
	xmlObjectActions.setAttribute("onDropExec",icon->Actions.onDropExec);
	QString iAnimationMask;
	iAnimationMask.setNum(icon->Actions.iAnimationMask);
	xmlObjectActions.setAttribute("iAnimationMask",iAnimationMask);

	
	for(uint i=0;i<icon->Tasks.WindowTitle.count();i++)
	{
		QDomElement xmlObjectMatch=doc.createElement("matchtasks");
		xmlObjectIcon.appendChild(xmlObjectMatch);
		
		xmlObjectMatch.setAttribute("WindowTitle",
		icon->Tasks.WindowTitle[i]);
		xmlObjectMatch.setAttribute("WindowTitle",
		icon->Tasks.WindowTitle[i]);
		xmlObjectMatch.setAttribute("TaskName",
		icon->Tasks.TaskName[i]);
		xmlObjectMatch.setAttribute("ClassName",
		icon->Tasks.ClassName[i]);
	}
/*
		xmlSubClass=xmlIcons.item(i).toElement().elementsByTagName("matchdcop");
		for(uint a=0; a<xmlSubClass.count();a++)
		{
			addedCfg->Tasks.dcopName.append(
				xmlSubClass.item(a).toElement().attribute("dcopName"));
		}
		if(addedCfg->Tasks.dcopName.count()<1 &&addedCfg->Tasks.TaskName.count()>0)
		{
			addedCfg->Tasks.dcopName.append(addedCfg->Tasks.TaskName[0]);
			//qWarning(addedCfg->Tasks.TaskName[0]);
		}
*/
	
	for(uint i=0;i<icon->Tasks.dcopName.count();i++)
	{
		QDomElement xmlObjectMatch=doc.createElement("matchdcop");
		xmlObjectIcon.appendChild(xmlObjectMatch);
		
		xmlObjectMatch.setAttribute("dcopName",
		icon->Tasks.dcopName[i]);
	}

	QDomElement xmlObjectPluginConfigurations=doc.createElement("pluginconfiguration");
	xmlObjectIcon.appendChild(xmlObjectPluginConfigurations);
	for(uint i=0;i<icon->PluginConfiguration.count();i++)
	{
	
		QDomNode childcopy=icon->PluginConfiguration.item(i).cloneNode();
		xmlObjectPluginConfigurations.appendChild(childcopy);
	}
	
	QDomElement xmlObjectActionList=doc.createElement("actionlist");
	xmlObjectIcon.appendChild(xmlObjectActionList);
	for(uint i=0;i<icon->Actions.ActionList.count();i++)
	{
	
		QDomNode childcopy=icon->Actions.ActionList.item(i).cloneNode();
		xmlObjectActionList.appendChild(childcopy);
	}
}


/*!
    \fn XEPlugin_XMLConf::xCfgStore(QDomDocument &doc, QDomElement &root)
 */
void XEPlugin_XMLConf::xCfgStore(QDomDocument &doc, QDomElement &kxdocker)
{
	QDomElement 	xmlGeneral=doc.createElement("general");
	
	QDomElement 	xmlEngine=doc.createElement("engine");
	QDomElement 	xmlPlugins=doc.createElement("plugins");
	QDomElement 	xmlIcons=doc.createElement("icons");
	QDomElement 	xmlWindow=doc.createElement("window");
	QDomElement 	xmlTheme=doc.createElement("theme");

	
	kxdocker.appendChild(xmlGeneral);
	xmlGeneral.appendChild(xmlEngine);
	xmlGeneral.appendChild(xmlPlugins);
	xmlGeneral.appendChild(xmlIcons);
	xmlGeneral.appendChild(xmlWindow);
	xmlGeneral.appendChild(xmlTheme);
#ifdef ENABLE_STATS
	// 0.36
	QDomElement 	xmlStats=doc.createElement("statistics");
	xmlGeneral.appendChild(xmlStats);

	xmlStats.setAttribute("dockerStarts",
		ActiveConfiguration->Statistics.dockerStarts);
	xmlStats.setAttribute("dockerDaysRunning",
		ActiveConfiguration->Statistics.dockerDaysRunning);
	xmlStats.setAttribute("dockerHoursRunning",
		ActiveConfiguration->Statistics.dockerHoursRunning);
	xmlStats.setAttribute("dockerMinutesRunning",
		ActiveConfiguration->Statistics.dockerMinutesRunning);
	xmlStats.setAttribute("dockerSecondsRunning",
		ActiveConfiguration->Statistics.dockerSecondsRunning);
	xmlStats.setAttribute("dockerFirstStart",
		ActiveConfiguration->Statistics.dockerFirstStart);
	xmlStats.setAttribute("maxIconsDisplayed",
		ActiveConfiguration->Statistics.maxIconsDisplayed);
	xmlStats.setAttribute("changedBackgroundTheme",
		ActiveConfiguration->Statistics.changedBackgroundTheme);
	xmlStats.setAttribute("avgCounter",
		ActiveConfiguration->Statistics.avgCounter);
	xmlStats.setAttribute("avgIconsDisplayed",
		ActiveConfiguration->Statistics.avgIconsDisplayed);
	xmlStats.setAttribute("startedConfigurator",
		ActiveConfiguration->Statistics.startedConfigurator);

#endif
	
	xmlEngine.setAttribute("xmlconf",
	ActiveConfiguration->Engine.XMLConf);
	xmlEngine.setAttribute("AndZoomCache",
	ActiveConfiguration->Engine.AndZoomCache);
	xmlEngine.setAttribute("AutoSave",
	ActiveConfiguration->AutoSave);

	xmlEngine.setAttribute("AutoResize",
	ActiveConfiguration->AutoResize);

#ifdef ENABLE_SPECIALENGINE2
	xmlEngine.setAttribute("InterpolationValue",
	ActiveConfiguration->Engine.InterpolationValue);
#endif
	
	xmlEngine.setAttribute("MaxIconsShowed",
	ActiveConfiguration->Engine.MaxIconsShowed);
	xmlEngine.setAttribute("SleepAnimations",
	ActiveConfiguration->Engine.SleepAnimations);
	xmlEngine.setAttribute("SleepFPS",
	ActiveConfiguration->Engine.SleepFPS);
	xmlEngine.setAttribute("SleepThreads",
	ActiveConfiguration->Engine.SleepThreads);
	xmlEngine.setAttribute("SmoothTimeout",
	ActiveConfiguration->Engine.SmoothTimeout);
	
	xmlIcons.setAttribute("EnableThumbnail",
	ActiveConfiguration->Icons.EnableThumbnail);
	xmlIcons.setAttribute("FontBlue",
	ActiveConfiguration->Icons.OverTextFont.FontBlue);
	xmlIcons.setAttribute("FontFamily",
	ActiveConfiguration->Icons.OverTextFont.FontFamily);
	xmlIcons.setAttribute("FontGreen",
	ActiveConfiguration->Icons.OverTextFont.FontGreen);
	xmlIcons.setAttribute("FontRed",
	ActiveConfiguration->Icons.OverTextFont.FontRed);
	xmlIcons.setAttribute("FontSize",
	ActiveConfiguration->Icons.OverTextFont.FontSize);

	xmlIcons.setAttribute("FontBold",
	ActiveConfiguration->Icons.OverTextFont.Bold);
	xmlIcons.setAttribute("FontItalic",
	ActiveConfiguration->Icons.OverTextFont.Italic);
	xmlIcons.setAttribute("FontOtherBinaryValue",
	ActiveConfiguration->Icons.OverTextFont.OtherBinaryValue);
	xmlIcons.setAttribute("FontWeight",
	ActiveConfiguration->Icons.OverTextFont.Weight);
	xmlIcons.setAttribute("FontOther",
	ActiveConfiguration->Icons.OverTextFont.Other);
	xmlIcons.setAttribute("FontAlias",
	ActiveConfiguration->Icons.OverTextFont.Alias);


	// 0.36
	xmlIcons.setAttribute("miniFontBlue",
	ActiveConfiguration->Icons.MiniTextFont.FontBlue);
	xmlIcons.setAttribute("miniFontFamily",
	ActiveConfiguration->Icons.MiniTextFont.FontFamily);
	xmlIcons.setAttribute("miniFontGreen",
	ActiveConfiguration->Icons.MiniTextFont.FontGreen);
	xmlIcons.setAttribute("miniFontRed",
	ActiveConfiguration->Icons.MiniTextFont.FontRed);
	xmlIcons.setAttribute("miniFontSize",
	ActiveConfiguration->Icons.MiniTextFont.FontSize);

	xmlIcons.setAttribute("miniFontBold",
	ActiveConfiguration->Icons.MiniTextFont.Bold);
	xmlIcons.setAttribute("miniFontItalic",
	ActiveConfiguration->Icons.MiniTextFont.Italic);
	xmlIcons.setAttribute("miniFontOtherBinaryValue",
	ActiveConfiguration->Icons.MiniTextFont.OtherBinaryValue);
	xmlIcons.setAttribute("miniFontWeight",
	ActiveConfiguration->Icons.MiniTextFont.Weight);
	xmlIcons.setAttribute("miniFontOther",
	ActiveConfiguration->Icons.MiniTextFont.Other);
	xmlIcons.setAttribute("miniFontAlias",
	ActiveConfiguration->Icons.MiniTextFont.Alias);



	xmlIcons.setAttribute("Horiz",
	ActiveConfiguration->Icons.Horiz);
	xmlIcons.setAttribute("Raise",
	ActiveConfiguration->Icons.Raise);
	xmlIcons.setAttribute("Separation",
	ActiveConfiguration->Icons.Separation);
	xmlIcons.setAttribute("Separation",
	ActiveConfiguration->Icons.Separation);
	xmlIcons.setAttribute("Size",
	ActiveConfiguration->Icons.SizePrefer);
	xmlIcons.setAttribute("SizeBig",
	ActiveConfiguration->Icons.SizeBig);
	xmlIcons.setAttribute("Design",
	ActiveConfiguration->Matrix.Design);


	xmlWindow.setAttribute("Align",
	ActiveConfiguration->Window.Align);
	xmlWindow.setAttribute("Height",
	ActiveConfiguration->Window.Height);
	xmlWindow.setAttribute("HeightDesktop",
	ActiveConfiguration->Window.HeightDesktop);
	xmlWindow.setAttribute("HideMouseEdge",
	ActiveConfiguration->Window.HideMouseEdge);
	xmlWindow.setAttribute("AutoHideTimeout",
	ActiveConfiguration->Window.HideTimeout);
	xmlWindow.setAttribute("FastHide",
	ActiveConfiguration->Window.FastHide);
	xmlWindow.setAttribute("SendToForgroundTimeout",
	ActiveConfiguration->Window.SendToForgroundTimeout);
	
	xmlWindow.setAttribute("HideMouseCornerLeft",
	ActiveConfiguration->Window.HideMouseCornerLeft);
	xmlWindow.setAttribute("HideMouseCornerRight",
	ActiveConfiguration->Window.HideMouseCornerRight);
	
	
	xmlWindow.setAttribute("RaiseOnEvents",
	ActiveConfiguration->Window.RaiseOnEvents);
	xmlWindow.setAttribute("SendToBackground",
	ActiveConfiguration->Window.SendToBackground);
	xmlWindow.setAttribute("Left",
	ActiveConfiguration->Window.Left);
	xmlWindow.setAttribute("LeftForce",
	ActiveConfiguration->Window.LeftForce);
	xmlWindow.setAttribute("Top",
	ActiveConfiguration->Window.Top);
	xmlWindow.setAttribute("TopForce",
	ActiveConfiguration->Window.TopForce);
	xmlWindow.setAttribute("Width",
	ActiveConfiguration->Window.Width);
	xmlWindow.setAttribute("Width",
	ActiveConfiguration->Window.Width);
	xmlWindow.setAttribute("borderLeft",
	ActiveConfiguration->Window.borderLeft);
	xmlWindow.setAttribute("borderTop",
	ActiveConfiguration->Window.borderTop);

	xmlTheme.setAttribute("ArrowsPath",
	ActiveConfiguration->Theme.ArrowsPath);
	xmlTheme.setAttribute("BackgroundPath",
	ActiveConfiguration->Theme.BackgroundPath);
	xmlTheme.setAttribute("PillowPath",
	ActiveConfiguration->Icons.OverTextFont.BackgroundPath);
	xmlTheme.setAttribute("MiniPillowPath",
	ActiveConfiguration->Icons.MiniTextFont.BackgroundPath);
	xmlTheme.setAttribute("PoofPath",
	ActiveConfiguration->Theme.PoofPath);
	
	for(uint i=0; i<ActiveConfiguration->Theme.IconsPaths.count();i++)
	{
		QDomElement 	xmlIconsPath=doc.createElement("iconspaths");
		xmlGeneral.appendChild(xmlIconsPath);
		xmlIconsPath.setAttribute("Path",
		ActiveConfiguration->Theme.IconsPaths[i]
		);
	}
	QDomElement 	xmlBackground=doc.createElement("background");
	xmlTheme.appendChild(xmlBackground);
	xmlBackground.setAttribute("Tiled",
		ActiveConfiguration->Theme.Background.Tiled
		);
	xmlBackground.setAttribute("Desaturate",
		ActiveConfiguration->Theme.Background.Desaturate
		);
	xmlBackground.setAttribute("imgBackgroundCenter",
		ActiveConfiguration->Theme.Background.imgBackgroundCenter
		);
	xmlBackground.setAttribute("imgBackgroundLeft",
		ActiveConfiguration->Theme.Background.imgBackgroundLeft
		);
	xmlBackground.setAttribute("imgBackgroundOver",
		ActiveConfiguration->Theme.Background.imgBackgroundOver
		);
	xmlBackground.setAttribute("imgBackgroundRight",
		ActiveConfiguration->Theme.Background.imgBackgroundRight
		);
	xmlBackground.setAttribute("imgBackgroundSeparator",
		ActiveConfiguration->Theme.Background.imgBackgroundSeparator
		);
	for(uint i=0; i<ActiveConfiguration->Plugins.Plugin.count();i++)
	{
		QDomElement 	xmlPlugin=doc.createElement("plugin");
		xmlPlugins.appendChild(xmlPlugin);
		xmlPlugin.setAttribute("name",
		ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name
		);
		for(uint k=0;k<
ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count();
		k++)
		{
			QDomNode childcopy=ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(k).cloneNode();
			xmlPlugin.appendChild(childcopy);
		}
	}
	for(uint i=0; i<ActiveConfiguration->Plugins.PluginsPaths.count();i++)
	{
		QDomElement 	xmlPluginPath=doc.createElement("pluginspath");
		xmlPlugins.appendChild(xmlPluginPath);
		xmlPluginPath.setAttribute("Path",
		ActiveConfiguration->Plugins.PluginsPaths[i]
		);
	}	
}




/*!
    \fn XEPlugin_XMLConf::xXMLExplode()
 */
void XEPlugin_XMLConf::xXMLExplode()
{
	// explode general plugin configurations
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count();i++)
	{
		QObject *pf=XEObject::xFindObject(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name);
		if(!pf)continue;
		if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())continue;
		ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=makeNodeList(pf);
	}
	// explode icon plugin configurations
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		QObject *pf=XEObject::xFindObject(ActiveConfiguration->RollingIcons.at(i)->Info.className);
		if(!pf)continue;
		if(ActiveConfiguration->RollingIcons.at(i)->PluginConfiguration.count())continue;
		ActiveConfiguration->RollingIcons.at(i)->PluginConfiguration=makeNodeList(pf);	
	}
	// matches
	for(uint i=0;i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		QObject *pf=XEObject::xFindObject(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Info.className);
		if(!pf)continue;
		if(ActiveConfiguration->Plugins.Matches.at(i)->Icon->PluginConfiguration.count())continue;
		ActiveConfiguration->Plugins.Matches.at(i)->Icon->PluginConfiguration=makeNodeList(pf);	
	}
}


/*!
    \fn XEPlugin_XMLConf::makeNodeList(QObject *)
 */
QDomNodeList XEPlugin_XMLConf::makeNodeList(QObject *newplugin)
{
//	if(newplugin==NULL)return NULL;
	//if(XEObject::xFindObject(newplugin->Name)==NULL)return NULL;

	connect(this, SIGNAL(clientGetParameterList(QStringList *)),
		newplugin,
		SLOT(xGetParameterList(QStringList *)));
	
		

	// Creating fake document
	QDomDocument 	doc( "KXDocker_Conf" );
	// the fake root
	QDomElement fakeRoot=doc.createElement("FakeRoot");
	// appending childs
	doc.appendChild(fakeRoot);
	// now creating the configuration
	QDomElement CreatingCfg=doc.createElement("pluginconf");
	// Ok this is a plugin Configuration
	QStringList	a;
	// Creating the Attributes via the standard plugin interface
	clientGetParameterList(&a);
	disconnect(this, SIGNAL(clientGetParameterList(QStringList *)),
		newplugin,
		SLOT(xGetParameterList(QStringList *)));
	connect(this, SIGNAL(clientGetParameter(const QString,QString&)),
		newplugin,
		SLOT(xGetParameter(const QString,QString&)));
	
	for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
	{
		QString returnValue;
		clientGetParameter(a[istoringXML],returnValue);
		CreatingCfg.setAttribute(a[istoringXML],returnValue);
	}
	
	disconnect(this, SIGNAL(clientGetParameter(const QString,QString&)),
		newplugin,
		SLOT(xGetParameter(const QString,QString&)));
	
	// Now appending to the configuration
	fakeRoot.appendChild(CreatingCfg);
	return fakeRoot.childNodes();
}


/*!
    \fn XEPlugin_XMLConf::xImportXMLs()
 */
void XEPlugin_XMLConf::xImportXMLs()
{
	for(uint i=0;i<ActiveConfiguration->ConfigurationsPaths.count();i++)
	{
		//qWarning(ActiveConfiguration->ConfigurationsPaths[i]);
		QString xmlsPath=::locate("data",ActiveConfiguration->ConfigurationsPaths[i]);
		
		//qWarning(xmlsPath);
		if(xmlsPath.isNull()||xmlsPath=="")continue;
		QDir d(xmlsPath);
        	//d.setFilter( QDir::Files | QDir::Hidden | QDir::NoSymLinks );
        	d.setFilter( QDir::Files | QDir::Hidden );
        	//d.setSorting( QDir::Size | QDir::Reversed );
	        const QFileInfoList *list = d.entryInfoList();
        	QFileInfoListIterator it( *list );
        	QFileInfo *fi;
		while ( (fi = it.current()) != 0 ) {
            		//printf( "%10li %s\n", fi->size(), fi->fileName().latin1() );
			// loading all xmls into the directory
			qWarning(i18n(QString("loading external xml configurations: %1").arg(fi->fileName())));
			QString rfn=xmlsPath+fi->fileName();
			xLoadXML(rfn);
			
            	++it;
        	}
	}
}


/*!
    \fn XEPlugin_XMLConf::xLoadXML(const QString)
 */
void XEPlugin_XMLConf::xLoadXML(const QString XMLConf)
{
	xmlFile.setName(XMLConf);

#ifndef ENABLE_FINAL
	qWarning(XMLConf);
#endif
	QDomDocument doc( "KXDocker_Conf" );
	if ( !xmlFile.open( IO_ReadOnly ) )
	{
#ifndef ENABLE_FINAL
		qWarning("Error while searching for kxdocker_conf.xml");
#endif
		//exit(1);
		return;
	}
	if ( !doc.setContent( &xmlFile) ) {
#ifndef ENABLE_FINAL
		qWarning("error while parsing xml");
#endif
		xmlFile.close();
		//exit(1);
		return;
	}
	xmlFile.close();
#ifndef ENABLE_FINAL
	qWarning("XMLConf::xSetup()");
#endif
	// Searching from XML
	// Document Root
	QDomElement docElem = doc.documentElement();
	//QDomNodeList xmlGeneral=docElem.elementsByTagName("kxdocker");
	//if(xmlGeneral.count()>0)
	if(ActiveConfiguration->Version.isNull() ||ActiveConfiguration->Version==""){
		// that's ok ive find the first tag
		ActiveConfiguration->Version=docElem.attribute("version");

	// XML Configuration version is not the same of kxdocker
	if(ActiveConfiguration->Version!=KXDOCKERVERSION)
	{
		// we are going to warn the user!
		if(ActiveConfiguration->Version=="")ActiveConfiguration->Version="unknown";
		QString str;
        	str = QString( "You are going to load an XML Configuration wrote by KXDocker (%1) but your are running KXDocker (%1)\nMay be many settings may be lost" )
		.arg(ActiveConfiguration->Version)
		.arg(KXDOCKERVERSION);
		
		QMessageBox::warning (NULL,name(),str,
		QMessageBox::Ok,QMessageBox::NoButton);
	}
	}
	ActiveConfiguration->Version=KXDOCKERVERSION;
	// .general
	QDomNodeList xmlGeneral=docElem.elementsByTagName("general");
	if(xmlGeneral.count()>0)
	{
		// We have .general
		// .general.engine
#ifndef ENABLE_FINAL
		qWarning(".general");
#endif
		QDomNodeList xmlEngine=xmlGeneral.item(0).toElement().elementsByTagName("engine");
		if(xmlEngine.count()>0)
		{
#ifndef ENABLE_FINAL
			qWarning(".general.engine");
#endif
			QString sValue=xmlEngine.item(0).toElement().attribute(
			 	"xmlconf",
			 	ActiveConfiguration->Engine.XMLConf);
			// new engine configurator 20040426
			//ActiveConfiguration->Engine.XMLConf=sValue;
			//************************************************************************
			/*
			sValue=sValue.setNum(ActiveConfiguration->Engine.SmoothTimeout);
			sValue=xmlEngine.item(0).toElement().attribute( "smoothtimeout",sValue);
			bool okRet=false;
			qWarning(sValue);
			ActiveConfiguration->Engine.SmoothTimeout=sValue.toInt(&okRet);
			*/
			xmlFetch("SmoothTimeout",ActiveConfiguration->Engine.SmoothTimeout,xmlEngine);
			xmlFetch("SleepAnimations",ActiveConfiguration->Engine.SleepAnimations,xmlEngine);
			xmlFetch("MaxIconsShowed",ActiveConfiguration->Engine.MaxIconsShowed,xmlEngine);
			xmlFetch("SleepFPS",ActiveConfiguration->Engine.SleepFPS,xmlEngine);
			xmlFetch("AutoResize",ActiveConfiguration->AutoResize,xmlEngine);

			xmlFetch("SleepThreads",ActiveConfiguration->Engine.SleepThreads,xmlEngine);
			xmlFetch("AndZoomCache",ActiveConfiguration->Engine.AndZoomCache,xmlEngine);
#ifdef ENABLE_SPECIALENGINE2
			xmlFetch("InterpolationValue",ActiveConfiguration->Engine.InterpolationValue,xmlEngine);
#endif
			//************************************************************************
			//************************************************************************
		}
		xmlEngine=xmlGeneral.item(0).toElement().elementsByTagName("icons");
		if(xmlEngine.count()>0)
		{
#ifndef ENABLE_FINAL
			qWarning(".general.icons");
#endif
			xmlFetch("Horiz",ActiveConfiguration->Icons.Horiz,xmlEngine);
			xmlFetch("Size",ActiveConfiguration->Icons.SizePrefer,xmlEngine);
			//0.30
			ActiveConfiguration->Icons.Size=ActiveConfiguration->Icons.SizePrefer;
			
			xmlFetch("SizeBig",ActiveConfiguration->Icons.SizeBig,xmlEngine);

			xmlFetch("Raise",ActiveConfiguration->Icons.Raise,xmlEngine);
			xmlFetch("Separation",ActiveConfiguration->Icons.Separation,xmlEngine);
			xmlFetch("EnableThumbnail",ActiveConfiguration->Icons.EnableThumbnail,xmlEngine);
			ActiveConfiguration->Matrix.Design=xmlEngine.item(0).toElement().attribute(
			 					"Design",
			 					ActiveConfiguration->Matrix.Design);
			xmlFetch("FontSize",ActiveConfiguration->Icons.OverTextFont.FontSize,xmlEngine);
			if(ActiveConfiguration->Icons.OverTextFont.FontSize<4)ActiveConfiguration->Icons.OverTextFont.FontSize=8;
			xmlFetch("FontRed",ActiveConfiguration->Icons.OverTextFont.FontRed,xmlEngine);
			xmlFetch("FontGreen",ActiveConfiguration->Icons.OverTextFont.FontGreen,xmlEngine);
			xmlFetch("FontBlue",ActiveConfiguration->Icons.OverTextFont.FontBlue,xmlEngine);
			ActiveConfiguration->Icons.OverTextFont.FontFamily=xmlEngine.item(0).toElement().attribute(
			 	"FontFamily",
			 	ActiveConfiguration->Icons.OverTextFont.FontFamily);

			xmlFetch("FontBold",ActiveConfiguration->Icons.OverTextFont.Bold,xmlEngine);
			xmlFetch("FontItalic",ActiveConfiguration->Icons.OverTextFont.Italic,xmlEngine);
			xmlFetch("FontOtherBinaryValue",ActiveConfiguration->Icons.OverTextFont.OtherBinaryValue,xmlEngine);
			xmlFetch("FontWeight",ActiveConfiguration->Icons.OverTextFont.Weight,xmlEngine);
			ActiveConfiguration->Icons.OverTextFont.Alias=xmlEngine.item(0).toElement().attribute(
			 	"FontAlias",
			 	ActiveConfiguration->Icons.OverTextFont.Alias);




			// 0.36
			xmlFetch("miniFontSize",ActiveConfiguration->Icons.MiniTextFont.FontSize,xmlEngine);
			if(ActiveConfiguration->Icons.MiniTextFont.FontSize<4)ActiveConfiguration->Icons.MiniTextFont.FontSize=8;
			xmlFetch("miniFontRed",ActiveConfiguration->Icons.MiniTextFont.FontRed,xmlEngine);
			xmlFetch("miniFontGreen",ActiveConfiguration->Icons.MiniTextFont.FontGreen,xmlEngine);
			xmlFetch("miniFontBlue",ActiveConfiguration->Icons.MiniTextFont.FontBlue,xmlEngine);
			ActiveConfiguration->Icons.MiniTextFont.FontFamily=xmlEngine.item(0).toElement().attribute(
			 	"miniFontFamily",
			 	ActiveConfiguration->Icons.MiniTextFont.FontFamily);


			xmlFetch("miniFontBold",ActiveConfiguration->Icons.MiniTextFont.Bold,xmlEngine);
			xmlFetch("miniFontItalic",ActiveConfiguration->Icons.MiniTextFont.Italic,xmlEngine);
			xmlFetch("miniFontOtherBinaryValue",ActiveConfiguration->Icons.MiniTextFont.OtherBinaryValue,xmlEngine);
			xmlFetch("miniFontWeight",ActiveConfiguration->Icons.MiniTextFont.Weight,xmlEngine);
			ActiveConfiguration->Icons.MiniTextFont.Alias=xmlEngine.item(0).toElement().attribute(
			 	"miniFontAlias",
			 	ActiveConfiguration->Icons.MiniTextFont.Alias);




		}
		xmlEngine=xmlGeneral.item(0).toElement().elementsByTagName("window");
		if(xmlEngine.count()>0)
		{
#ifndef ENABLE_FINAL
			qWarning(".general.window");
#endif
			ActiveConfiguration->Window.Align=xmlEngine.item(0).toElement().attribute(
			 					"Align",
			 					ActiveConfiguration->Window.Align);
			xmlFetch("Height",ActiveConfiguration->Window.Height,xmlEngine);
			xmlFetch("Left",ActiveConfiguration->Window.Left,xmlEngine);
			xmlFetch("Top",ActiveConfiguration->Window.Top,xmlEngine);
			xmlFetch("Width",ActiveConfiguration->Window.Width,xmlEngine);
			xmlFetch("borderLeft",ActiveConfiguration->Window.borderLeft,xmlEngine);
			xmlFetch("borderTop",ActiveConfiguration->Window.borderTop,xmlEngine);
			xmlFetch("HeightDesktop",ActiveConfiguration->Window.HeightDesktop,xmlEngine);
			
			xmlFetch("LeftForce",ActiveConfiguration->Window.LeftForce,xmlEngine);
			xmlFetch("TopForce",ActiveConfiguration->Window.TopForce,xmlEngine);
			xmlFetch("AutoHideTimeout",ActiveConfiguration->Window.HideTimeout,xmlEngine);
			xmlFetch("FastHide",ActiveConfiguration->Window.FastHide,xmlEngine);
			xmlFetch("SendToBackground",ActiveConfiguration->Window.SendToBackground,xmlEngine);
			xmlFetch("HideMouseCornerLeft",ActiveConfiguration->Window.HideMouseCornerLeft,xmlEngine);
			xmlFetch("HideMouseCornerRight",ActiveConfiguration->Window.HideMouseCornerRight,xmlEngine);
			xmlFetch("SendToForgroundTimeout",ActiveConfiguration->Window.SendToForgroundTimeout,xmlEngine);
			xmlFetch("RaiseOnEvents",ActiveConfiguration->Window.RaiseOnEvents,xmlEngine);
			xmlFetch("HideMouseEdge",ActiveConfiguration->Window.HideMouseEdge,xmlEngine);
			
		}
		xmlEngine=xmlGeneral.item(0).toElement().elementsByTagName("theme");
		if(xmlEngine.count()>0)
		{
#ifndef ENABLE_FINAL
			qWarning(".general.theme");
#endif
//			xmlFetch("Align",ActiveConfiguration->Window.Align,xmlEngine);
			ActiveConfiguration->Theme.BackgroundPath=xmlEngine.item(0).toElement().attribute(
			 		"BackgroundPath",
			 		ActiveConfiguration->Theme.BackgroundPath);
			ActiveConfiguration->Icons.OverTextFont.BackgroundPath=xmlEngine.item(0).toElement().attribute(
			 		"PillowPath",
			 		ActiveConfiguration->Icons.OverTextFont.BackgroundPath);


			ActiveConfiguration->Icons.MiniTextFont.BackgroundPath=xmlEngine.item(0).toElement().attribute(
			 		"MiniPillowPath",
			 		ActiveConfiguration->Icons.MiniTextFont.BackgroundPath);


			ActiveConfiguration->Theme.PoofPath=xmlEngine.item(0).toElement().attribute(
			 		"PoofPath",
			 		ActiveConfiguration->Theme.PoofPath);
					
			ActiveConfiguration->Theme.ArrowsPath=xmlEngine.item(0).toElement().attribute(
			 		"ArrowsPath",
			 		ActiveConfiguration->Theme.ArrowsPath);

			QDomNodeList xmlSubClass=xmlGeneral.item(0).toElement().elementsByTagName("background");
			if(xmlSubClass.count()>0)
			{
				xmlFetch("Tiled",ActiveConfiguration->Theme.Background.Tiled,xmlSubClass);
				xmlFetch("Desaturate",ActiveConfiguration->Theme.Background.Desaturate,xmlSubClass);
				ActiveConfiguration->Theme.Background.imgBackgroundCenter=
					xmlSubClass.item(0).toElement().attribute(
					"imgBackgroundCenter",
					ActiveConfiguration->Theme.Background.imgBackgroundCenter);
				ActiveConfiguration->Theme.Background.imgBackgroundOver=
					xmlSubClass.item(0).toElement().attribute(
					"imgBackgroundOver",
					ActiveConfiguration->Theme.Background.imgBackgroundOver);
				ActiveConfiguration->Theme.Background.imgBackgroundLeft=
					xmlSubClass.item(0).toElement().attribute(
					"imgBackgroundLeft",
					ActiveConfiguration->Theme.Background.imgBackgroundLeft);
				ActiveConfiguration->Theme.Background.imgBackgroundRight=
					xmlSubClass.item(0).toElement().attribute(
					"imgBackgroundRight",
					ActiveConfiguration->Theme.Background.imgBackgroundRight);
				ActiveConfiguration->Theme.Background.imgBackgroundSeparator=
					xmlSubClass.item(0).toElement().attribute(
					"imgBackgroundSeparator",
					ActiveConfiguration->Theme.Background.imgBackgroundSeparator);
			}
			xmlSubClass=xmlGeneral.item(0).toElement().elementsByTagName("iconspaths");
			if(xmlSubClass.count()>0)xmlFetchPathsIcons(xmlSubClass);
		}

#ifdef ENABLE_STATS
	// 0.36
		xmlEngine=xmlGeneral.item(0).toElement().elementsByTagName("statistics");
		if(xmlEngine.count()>0)
		{
#ifndef ENABLE_FINAL
			qWarning(".general.statistics");
#endif
			xmlFetch("dockerStarts",ActiveConfiguration->Statistics.dockerStarts,xmlEngine);
			xmlFetch("startedConfigurator",ActiveConfiguration->Statistics.startedConfigurator,xmlEngine);
			xmlFetch("avgCounter",ActiveConfiguration->Statistics.avgCounter,xmlEngine);
			xmlFetch("changedBackgroundTheme", ActiveConfiguration->Statistics.changedBackgroundTheme,xmlEngine);
			xmlFetch("avgIconsDisplayed",ActiveConfiguration->Statistics.avgIconsDisplayed,xmlEngine);
			xmlFetch("maxIconsDisplayed",ActiveConfiguration->Statistics.maxIconsDisplayed,xmlEngine);
			xmlFetch("dockerFirstStart",ActiveConfiguration->Statistics.dockerFirstStart,xmlEngine);
			xmlFetch("dockerSecondsRunning",ActiveConfiguration->Statistics.dockerSecondsRunning,xmlEngine);
			xmlFetch("dockerMinutesRunning",ActiveConfiguration->Statistics.dockerMinutesRunning,xmlEngine);
			xmlFetch("dockerHoursRunning",ActiveConfiguration->Statistics.dockerHoursRunning,xmlEngine);
			xmlFetch("dockerDaysRunning",ActiveConfiguration->Statistics.dockerDaysRunning,xmlEngine);
		}
#endif

		xmlEngine=xmlGeneral.item(0).toElement().elementsByTagName("plugins");
#ifndef ENABLE_FINAL
		qWarning("xeplugin_xmlconf.cpp:230");
#endif
		if(xmlEngine.count()>0)
		{
			QDomNodeList xmlSubClass=xmlGeneral.item(0).toElement().elementsByTagName("plugin");
			if(xmlSubClass.count()>0)xmlFetchPlugins(xmlSubClass);
			
			xmlSubClass=xmlGeneral.item(0).toElement().elementsByTagName("pluginspath");
			if(xmlSubClass.count()>0)xmlFetchPathsPlugins(xmlSubClass);
		}
	}
	
	QDomNodeList xmlIcons=docElem.elementsByTagName("objects");
	if(xmlIcons.count()>0)
	{
		xmlIcons=xmlIcons.item(0).toElement().elementsByTagName("objectsicons");
#ifndef ENABLE_FINAL
		qWarning(".objectsicons");
#endif
		xmlFetchObjectsIcons(xmlIcons);
	}
	
	QDomNodeList xmlPlugins=docElem.elementsByTagName("objectsplugins");
	if(xmlPlugins.count()>0)
	{
		xmlFetchObjectsPlugins(xmlPlugins);
	}
	// Here we append a new element to the end of the document
	//QDomElement elem = doc.createElement( "img" );
	//elem.setAttribute( "src", "myimage.png" );
	//docElem.appendChild( elem );
    
}
