/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xgicon.h"

#include <qimage.h>
#include <qbitmap.h>
#include <qwmatrix.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <kpixmapeffect.h>
#include <kpixmapio.h>
#include <kpixmap.h>
#include <kimageeffect.h>
#include <qdrawutil.h> 
#include <kstandarddirs.h>
#include <kpopupmenu.h>
#include <qfile.h>
#include <qpainter.h>
#include <qfontmetrics.h> 

#include "xeplugin_gapplet.h"

#include <kxdocker_setup_sources.h>

#include <xeplugin_gepillow.h>

//#undef ENABLE_FINAL

XSConfigurations * XGIcon::ActiveConfiguration;
XSConfigurations * XGIconTextMaker::ActiveConfiguration;


XGIcon::XGIcon(QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	xPillow=NULL;
	xAndZoomCache=0; 	// by default i will not use cache
	xExclude=0;		// its always showed
	xIconTextPillow.xSetFontStyle(&ActiveConfiguration->Icons.OverTextFont);
	xIconTextMini.xSetFontStyle(&ActiveConfiguration->Icons.MiniTextFont);
	hidden=0;
	wExternal=NULL;
}


XGIcon::~XGIcon()
{
}


#include "xgicon.moc"


/*!
    \fn XGIcon::xLoadIcon(const QString &)
 */
void XGIcon::xLoadIcon(const QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xSetZoom(int,int)
 */
inline void XGIcon::xSetZoom(int newZoomX,int newZoomY)
{
	if(newZoomX==newZoomY)
	{
		xSetZoom(newZoomX);
	}
	else
	{
		// Ok we have to enable the double zoom
		xZoom=-1;
		xZoomX=newZoomX;
		xZoomY=newZoomY;
		xSetUpdate=1;
	}
}

/*!
    \fn XGIcon::xSetZoom(int)
 */
void XGIcon::xSetZoom(int newZoom)
{
	if(newZoom==xZoom)return;
	xZoom=newZoom;
	
	if(xImgCachedZoom[xZoom]>0)
	{
			xImgShowed=xImgCached[xZoom];
			xSetUpdate=xImgCachedZoom[xZoom];
			/*
			char errore[50];
			sprintf(errore,"Cache: (%d)",xZoom);
			qWarning(errore);
			*/
			return;
			
	}
	
	// Perfomance test QImage::ScaleMin is not good
	//xImgShowed=xImgSource.scale(xZoom,xZoom,QImage::ScaleMin);
	//xImgShowed=KImageEffect::sample(xImgSource,xZoom,xZoom);
	xImgShowed=xImgSource.scale(xZoom,xZoom);
	if(xZoom & xAndZoomCache)
	{
		xImgCached[xZoom]=xImgShowed;
		xImgCachedZoom[xZoom]=1;
	}
	xSetUpdate=1;
}


/*!
    \fn XGIcon::xSetHotSpot(const QPoint &)
 */
void XGIcon::xSetHotspot(const QPoint &newPoint)
{
	xHotspot=newPoint;
}


/*!
    \fn XGIcon::xReset()
 */
void XGIcon::xReset()
{
	// Will reset ALL DATA!!!!!
	// do this at startup or when you have to clear this icon
	
	cachePurge();	
	xHotspot.setX(0);
	xHotspot.setY(0);
	xImgShowed.reset();
	xImgSource.reset();
	xPosDefault.setX(0);
	xPosDefault.setY(0);
	xPosition.setX(0);
	xPosition.setY(0);
	xSetUpdate=0;
	xTransparency.resize(0,0);
	xZoom=-1;
	xZoomY=-1;
	xZoomX=-1;
}


/*!
    \fn XGIcon::xSetImage(const QString &)
 */
void XGIcon::xSetImage(const QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xSetImage(const QPixmap &)
 */
void XGIcon::xSetImage(const QPixmap &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xRepeat(int rWidth,int rHeight)
 */
void XGIcon::xRepeat(int rWidth,int rHeight)
{
/*
#ifdef HAS_KDE31
	xImgSource=xImgSource.smoothScale(rWidth,rHeight);
#else
	KPixmapIO kImgConverter;
	KPixmap pTiled=kImgConverter.convertToPixmap(xImgSource);
	pTiled=KPixmapEffect::createTiled(pTiled,QSize(rWidth,rHeight));
	xImgSource=kImgConverter.convertToImage(pTiled);
	xZoom=-1;
	xZoomY=-1;
	xZoomX=-1;
#endif
*/
	// 0.29
	// does not work!!! transparency is very ugly
	QImage newImage;
		newImage.create(
			rWidth,
			rHeight,
			32);
		
		newImage.setAlphaBuffer(false);
		//TBuffer.fill(QColor(255,0,0).pixel());
		newImage.fill(0);
		newImage.setAlphaBuffer(true);
	for(int wy=0;wy<rHeight/xImgSource.height();wy++)
	{
	for(int wx=0;wx<rWidth/xImgSource.width();wx++)
	{
		bitBlt(&newImage,
			wx*xImgSource.width(),
			wy*xImgSource.height(),
			&xImgSource,0,Qt::CopyROP);
	}
	}
	xImgSource=newImage;
}


/*!
    \fn XGIcon::xSetIntensity(float)
 */
void XGIcon::xSetIntensity(float ratio)
{
	if(xImgCachedZoom[xZoom]<3)
	{
		xImgShowed=KImageEffect::intensity(xImgShowed, ratio);
		xImgCachedZoom[xZoom]=3;
	}
}


/*!
    \fn XGIcon::xResetIntensity()
 */
void XGIcon::xResetIntensity()
{
		xImgShowed=KImageEffect::intensity(xImgShowed,100);
		xImgCachedZoom[xZoom]=0;
}


/*!
    \fn XGIcon::xSetSmoothZoom(int)
 */
inline void XGIcon::xSetSmoothZoom(int newZoom)
{
	xZoom=newZoom;
	if(xImgCachedZoom[xZoom]<2)
	{
//		xImgShowed=KImageEffect::sample(xImgSource,xZoom,xZoom);
		xImgShowed=xImgSource.smoothScale(xZoom,xZoom);//,QImage::ScaleMin);
		xImgCached[xZoom]=xImgShowed;
		xImgCachedZoom[xZoom]=2;
		return;
	}
	xImgShowed=xImgCached[xZoom];
}


/*!
    \fn XGIcon::cachePurge()
 */
void XGIcon::cachePurge()
{
	/*
	for(int i=0;i<MAX_CACHE_ICONS;i++)
	{
		xImgCachedZoom[i]=0;
		xImgCached[i].reset();
	}
	*/
	memset(xImgCachedZoom,0 , MAX_CACHE_ICONS*sizeof(int));
}


/*!
    \fn XGIcon::xSetClass(QObject *)
 */
void XGIcon::xSetClass(QObject *newClassManager)
{
	xClassManager=newClassManager;
	connect(this,SIGNAL(xAttach(QObject *)),newClassManager,SLOT(xAttach(QObject *)));
	//XEPlugin_GApplet *GApplet=(XEPlugin_GApplet *)xClassManager;
	//GApplet->xAttach(this);
	xAttach(this);
}


/*!
    \fn XGIcon::xSetText(const QString &)
 */
void XGIcon::xSetText(const QString &newText)
{
	xIconTextPillow.pillowText=newText;
	xIconTextPillow.isTextDrawed=0;
	xIconTextPillow.isPixmapTextDrawed=0;
}


/*!
    \fn XGIcon::xGetFontHeight()
 */
int XGIcon::xGetFontHeight()
{
	QFont	overTextFont;
	
	overTextFont.setFamily(ActiveConfiguration->Icons.OverTextFont.FontFamily);
	overTextFont.setPointSize(ActiveConfiguration->Icons.OverTextFont.FontSize);
	
	QFontMetrics fm( overTextFont);
	
//	int pixelsWide = fm.width("test")+10;
	int pixelsHigh = fm.height();
	return pixelsHigh;
}


/*!
    \fn XGIcon::xGetImage(QImage *&)
 */
void XGIcon::xGetImage(QImage *&pluginimg)
{
    pluginimg=&xImgSource;
}


/*!
    \fn XGIcon::xSetSmoothZoom()
 */
void XGIcon::xSetSmoothZoom()
{
	int oldZoom=xZoom;
	xImgCachedZoom[xZoom]=0;
	xZoom=0;
	xSetSmoothZoom(oldZoom);
}


/*!
    \fn XGIcon::xGetConfiguration(XSGObjectIcon *&)
 */
void XGIcon::xGetConfiguration(const XSGObjectIcon *&a)
{
	a=iconConfiguration;
}


/*!
    \fn XGIcon::xGetPluginConfiguration(QDomNodeList *&)
 */
void XGIcon::xGetPluginConfiguration(const QDomNodeList *&a)
{
    	a=&iconConfiguration->PluginConfiguration;
}




/*!
    \fn XGIcon::xRedraw()
 */
void XGIcon::xRedraw()
{
    xRefresh(this);
}


/*!
    \fn XGIcon::xSetZoom()
 */
void XGIcon::xSetZoom()
{
	int oldZoom=xZoom;
	xImgCachedZoom[xZoom]=0;
	xZoom=0;
	xSetZoom(oldZoom);
}


/*!
    \fn XGIcon::xStartAnimating()
 */
void XGIcon::xStartAnimating()
{
	xEventStartAnimating();
}


/*!
    \fn XGIcon::xStopAnimating()
 */
void XGIcon::xStopAnimating()
{
    xEventStopAnimating();
}


/*!
    \fn XGIcon::createPopup()
 */
void XGIcon::createPopup()
{
	// TODO: make XEConfiguration more complex!!!!!!!!
	// by moving this functions to it
	//iconConfiguration->PluginPopupMenu=new KPopupMenu();
	
}


/*!
    \fn XGIcon::getPopupMenu(KPopupMenu *&)
 */
void XGIcon::getPopupMenu(KPopupMenu *&)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xStartClass()
 */
void XGIcon::xStartClass()
{
    // emit signal
    xStart();
}


/*!
    \fn XGIcon::xSetupClass()
 */
void XGIcon::xSetupClass()
{
    // emit signal
    xSetup();
}


/*!
    \fn XGIcon::xGetPluginPopupMenu(KPopupMenu *&)
 */
void XGIcon::xGetPluginPopupMenu(KPopupMenu *&a)
{
	a=iconConfiguration->PluginPopupMenu;
	
}


/*!
    \fn XGIcon::xEnabledClickClass()
 */
int XGIcon::xEnabledClickClass()
{
	int a=0;
	xEnabledClick(a);
	return a;
}


/*!
    \fn XGIcon::xEventClickClass(int,int,int)
 */
void XGIcon::xEventClickClass(int x ,int y,int b)
{
    xEventClick(this,x,y,b,ActiveConfiguration->Icons.Size);
}


/*!
    \fn XGIcon::xStopClass()
 */
void XGIcon::xStopClass()
{
//	qWarning("void XGIcon::xStopClass()");
	xStop();
}


/*!
    \fn XGIcon::xRunConfiguratorClass()
 */
void XGIcon::xRunConfiguratorClass()
{
	xRunConfigurator();
}



/*!
    \fn XGIcon::xSetIconEXE(const QString &)
 */
void XGIcon::xSetIconEXE(const QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xGetIconEXE(QString &)
 */
void XGIcon::xGetIconEXE(QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xGetIconImgFile(QString &)
 */
void XGIcon::xGetIconImgFile(QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xGetIconName(QString &)
 */
void XGIcon::xGetIconName(QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xSetIconImgFile(const QString &)
 */
void XGIcon::xSetIconImgFile(const QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xSetIconName(const QString &)
 */
void XGIcon::xSetIconName(const QString &)
{
    /// @todo implement me
}


/*!
    \fn XGIcon::xSetOverText(const QString &)
 */
void XGIcon::xSetOverText(const QString &)
{
    /// @todo implement me
//iconConfiguration
}


/*!
    \fn XGIcon::xDesaturate(float)
 */
void XGIcon::xDesaturate(float i)
{
	QImage lavoro=xImgSource;
	/*
	QImage lavoro;
		lavoro.create(
			rWidth,
			rHeight,
			32);
		
		lavoro.setAlphaBuffer(false);
		//TBuffer.fill(QColor(255,0,0).pixel());
		lavoro.fill(0);
		lavoro.setAlphaBuffer(true);
	*/

	//lavoro=lavoro.convertDepth(32);
	//lavoro.setAlphaBuffer(true);
	
/*
	const float RGB2GRAY_Red=0.2989/1.0;
	const float RGB2GRAY_Green=0.5870/1.0;
	const float RGB2GRAY_Blue=0.1140/1.0;
*/

	uint width=lavoro.width();
	uint height=lavoro.height();

	for(uint x=0;x<height;x++)
	{
		uint *riga=(uint *)lavoro.scanLine(x);
		for(uint y=0;y<width;y++)
		{
			uint *p =  (uint *)riga+y;
//			int h,s,v;
			uint Red=qRed(*p);
			uint Green=qGreen(*p);
			uint Blue=qBlue(*p);
			uint alfa=qAlpha(*p);
	uint maxColor=0;
	if(maxColor<Red)maxColor=Red;
	if(maxColor<Green)maxColor=Green;
	if(maxColor<Blue)maxColor=Blue;

	float RGB2GRAY_Red=(maxColor-Red);
	float RGB2GRAY_Green=(maxColor-Green);
	float RGB2GRAY_Blue=(maxColor-Blue);


			//alfa=uint((((float)alfa)/(float)100)*(float)i);
			*p =qRgba((int)((Red)+(float)RGB2GRAY_Red*i),
				(int)((Green)+(float)RGB2GRAY_Green*i),
				(int)((Blue)+(float)RGB2GRAY_Blue*i),
				alfa);
		}
	}
	
	xImgSource=lavoro;

}


/*!
    \fn XGIcon::xFade(int)
 */
void XGIcon::xFade(int i)
{
	QImage lavoro=xImgSource;
	/*
	QImage lavoro;
		lavoro.create(
			rWidth,
			rHeight,
			32);
		
		lavoro.setAlphaBuffer(false);
		//TBuffer.fill(QColor(255,0,0).pixel());
		lavoro.fill(0);
		lavoro.setAlphaBuffer(true);
	*/

	//lavoro=lavoro.convertDepth(32);
	//lavoro.setAlphaBuffer(true);
	uint width=lavoro.width();
	uint height=lavoro.height();

	for(uint x=0;x<height;x++)
	{
		uint *riga=(uint *)lavoro.scanLine(x);
		for(uint y=0;y<width;y++)
		{
			uint *p =  (uint *)riga+y;
			uint alfa=qAlpha(*p);
			//alfa=(int)((float)alfa*gi);
			alfa=uint((((float)alfa)/(float)100)*(float)i);
//qWarning(QString("[%1][%1][%1][%1]").arg(*p).arg(alfa).arg(x).arg(y));
//qWarning(QString("[%1][%1][%1][%1]").arg(qAlpha(*p)).arg(alfa).arg(x).arg(y));
			*p =qRgba(qRed(*p),qGreen(*p),qBlue(*p),alfa);
			//*p =qRgba(220,100,x,128);
		}
	}
	
	xImgSource=lavoro;

}


/*!
    \fn XGIcon::xEventPostSetIconPos(int,int,int,int)
 */
void XGIcon::xEventPostSetIconPos(int N,int X,int Y,int Size)
{
	emit xEventSetIconPos(N,X,Y,Size);
}

XGIconTextMaker::XGIconTextMaker()
{
	PillowIsLoaded=0;
	BackgroundPath="";
	FontStyle=&ActiveConfiguration->Icons.OverTextFont;
}
XGIconTextMaker::~XGIconTextMaker()
{
}
void XGIconTextMaker::xDrawText()
{
	// this will create a QImage image to draw the text on the screen
	
	
	xImgText.resize(0,0);
	
	// (martind@pirack.com) This avoids the big red box when no text is assigned to the OverText
	TBuffer.create(
			800,
			30,
			32);
		
		TBuffer.setAlphaBuffer(false);
		//TBuffer.fill(QColor(255,0,0).pixel());
		TBuffer.fill(0);
		TBuffer.setAlphaBuffer(true);
		
	

	//overTextBuffer.convertFromImage(TBuffer);
	overTextBuffer.resize(800,30);
	overTextMask.resize(800,30);
	//overTextBuffer.fill(Qt::color0);
	overTextBuffer.fill(Qt::white);
	overTextMask.fill(Qt::color0);
	
	if(pillowText.length() && FontStyle!=NULL)
	{

		isTextDrawed=1;
		QPainter Pencil;
		QFont	overTextFont;
		QColor	overTextColor;

		// load how to draw
		/*QString FontFamily;
		if(FontStyle->FontFamily=="")FontFamily="Bitstream Vera Sans Mono";
		else FontFamily=FontStyle->FontFamily;
		*/
		int FontSize;
		if(FontStyle->FontSize<4)FontSize=10;
		else FontSize=FontStyle->FontSize;

		overTextFont.setFamily(FontStyle->FontFamily);
		overTextColor.setRgb(
			FontStyle->FontRed,
			FontStyle->FontGreen,
			FontStyle->FontBlue
			);
		overTextFont.setBold(FontStyle->Bold);
		overTextFont.setItalic(FontStyle->Italic);
		overTextFont.setWeight(FontStyle->Weight);
		overTextFont.setPointSize(FontSize);
		overTextFont.setStyleStrategy(QFont::PreferAntialias );

		// starting draw the text on the pillow
		Pencil.begin(&overTextBuffer);
			// load up the font
			Pencil.setFont(overTextFont);
			// text align
			QRect overTextRect;
			// the rectangle of text
			QFontMetrics fm( overTextFont);
			int pixelsWide = fm.width( pillowText )+10;
			int pixelsHigh = fm.height();
			overTextRect.setLeft(0);
			overTextRect.setRight(pixelsWide);
			overTextRect.setTop(0);
			overTextRect.setBottom(pixelsHigh);
			//QRect rTesto=Pencil.boundingRect(overTextRect,Qt::AlignHCenter,pillowText);
		// Ok got the right rect
		Pencil.end();

		if(!PillowIsLoaded)xPreparePillow(overTextRect);
		/*
		if(PillowIsLoaded!=overTextRect.left())
		{
			PPillow_Center=PPillow_Center.smoothScale(pixelsWide+20,pixelsHigh+10);
			PillowIsLoaded=pixelsWide;
		}
		*/
		
	//0.27
/*  	xTextDecentre=(ActiveConfiguration->Icons.SizeBig-
  			rTesto.right()-rTesto.left())/2;
  */		
 	//xTextDecentre=(rTesto.right()-rTesto.left())/2;
	const int xTextSx=20;
	const int xTextEx=pixelsWide+20;
	const int xTextSy=0;
	const int xTextEy=pixelsHigh+7;

	
	overTextRect.setLeft(xTextSx+1);
	overTextRect.setTop(xTextSy+1);
	overTextRect.setRight(xTextEx+1);
	overTextRect.setBottom(xTextEy+1);
	// starting drawing the text
  	Pencil.begin(&overTextBuffer);
  		Pencil.setFont(overTextFont);
  		Pencil.setPen(Qt::gray);
  		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
  			pillowText
  			);
		overTextRect.setLeft(xTextSx);
		overTextRect.setTop(xTextSy);
		overTextRect.setRight(xTextEx);
		overTextRect.setBottom(xTextEy);

		Pencil.setPen(overTextColor);

  		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
  			pillowText);
	Pencil.end();

	overTextRect.setLeft(xTextSx+1);
	overTextRect.setTop(xTextSy+1);
	overTextRect.setRight(xTextEx+1);
	overTextRect.setBottom(xTextEy+1);

  	Pencil.begin(&overTextMask);
  		Pencil.setFont(overTextFont);
  		Pencil.setPen(Qt::color1);

  		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
  			pillowText
  			);

		overTextRect.setLeft(xTextSx);
		overTextRect.setTop(xTextSy);
		overTextRect.setRight(xTextEx);
		overTextRect.setBottom(xTextEy);

  		Pencil.drawText (overTextRect ,Qt::AlignHCenter,
  			pillowText);
  	Pencil.end();

	// now setup the transparency
	overTextBuffer.setMask(overTextMask);
		//0.34
		// the new pillow engine
/*
		if(pillowText.length()>1)
		{
		bitBlt(&TBuffer,0,0,&PPillow_Left,Qt::CopyROP);
		bitBlt(&TBuffer,pixelsHigh+10,0,&PPillow_Center,0,0,pixelsWide,pixelsHigh+10,Qt::CopyROP);
		bitBlt(&TBuffer,pixelsWide+pixelsHigh+10,0,&PPillow_Right,Qt::CopyROP);

		QImage ITextBuffer;
		ITextBuffer=overTextBuffer.convertToImage();
		bitBlt(&TBuffer,9,3,&ITextBuffer,Qt::CopyROP);
		}
		else
		{

		bitBlt(&TBuffer,7+pixelsWide-pixelsHigh,0,&PPillow_Left,Qt::CopyROP);
		bitBlt(&TBuffer,7+pixelsWide+10,0,&PPillow_Center,Qt::CopyROP);
		bitBlt(&TBuffer,7+pixelsWide+10+3,0,&PPillow_Right,Qt::CopyROP);

		QImage ITextBuffer;
		ITextBuffer=overTextBuffer.convertToImage();
		bitBlt(&TBuffer,7,3,&ITextBuffer,Qt::CopyROP);
		}

*/
		xTextDecentre=pixelsWide/2+(pixelsHigh+10);
		int xPPCW=pixelsWide-10-6;
		int xPPLS;
		if(xPPCW<1){
			xPPCW=2;
		}
		xPPLS=xTextDecentre-(xPPCW)/2-(pixelsHigh+10);
		int xPPCS=xPPLS+(pixelsHigh+10);
		bitBlt(&TBuffer,xPPLS,0,&PPillow_Left,Qt::CopyROP);
		bitBlt(&TBuffer,xPPCS,0,&PPillow_Center,0,0,xPPCW,pixelsHigh+7,Qt::CopyROP);
		bitBlt(&TBuffer,xPPCS+xPPCW,0,&PPillow_Right,Qt::CopyROP);

		QImage ITextBuffer;
		ITextBuffer=overTextBuffer.convertToImage();
		bitBlt(&TBuffer,7,3,&ITextBuffer,Qt::CopyROP);

		// moved to XGIconTextMaker::xGetPixmapText()
		//xImgText.convertFromImage(TBuffer);
		xImageText=TBuffer;
	}

	//overTextMask=overTextBuffer;
	// 0.34
	
	//bitBlt(&overTextMask,0,0,&overTextBuffer,Qt::CopyROP);
	//
	//xImgText=overTextBuffer2;
}

inline void XGIconTextMaker::xPreparePillow(QRect &overTextRect)
{

		// get the pillow image
		QString PPath="";
		if(FontStyle==NULL)PPath=ActiveConfiguration->Icons.OverTextFont.BackgroundPath;
		else PPath=FontStyle->BackgroundPath;
		if(BackgroundPath!="")PPath=BackgroundPath;
		QString CuscinoName=PPath;
		// TODO: any icon can have a pillow
		CuscinoName=CuscinoName+"/background-center.png";
		// find resources
		QFile a(::locate("data",CuscinoName));
		if(!a.exists() || CuscinoName==QString::null)
		{
			CuscinoName="kxdocker/themes/pillow/default/background-center.png";
		}
		// load base image pillow
		PPillow_Center.load(::locate("data",CuscinoName));
		/**/
		CuscinoName=PPath;
		CuscinoName=CuscinoName+"/background-left.png";
		a.setName(::locate("data",CuscinoName));
		if(!a.exists() || CuscinoName==QString::null)
		{
			CuscinoName="kxdocker/themes/pillow/default/background-left.png";
		}
		// load base image pillow
		PPillow_Left.load(::locate("data",CuscinoName));
		/**/
		CuscinoName=PPath;
		CuscinoName=CuscinoName+"/background-right.png";
		a.setName(::locate("data",CuscinoName));
		if(!a.exists() || CuscinoName==QString::null)
		{
			CuscinoName="kxdocker/themes/pillow/default/background-right.png";
		}
		// load base image pillow
		PPillow_Right.load(::locate("data",CuscinoName));

		// 0.36 if the text is around 2 chars...
		//PPillow_Center=PPillow_Center.smoothScale(800,overTextRect.bottom()+7);
		QImage PPillow_Center2=PPillow_Center.smoothScale(800,overTextRect.bottom()+7,QImage::ScaleMin);
		if(PPillow_Center2.width()<1)PPillow_Center=PPillow_Center.smoothScale(1,overTextRect.bottom()+7);
		else PPillow_Center=PPillow_Center2;
		if(PPillow_Center.width()<1)
		{
			QImage newImage;
			newImage.create(1,1,32);
			newImage.setAlphaBuffer(false);
			//TBuffer.fill(QColor(255,0,0).pixel());
			newImage.fill(0);
			newImage.setAlphaBuffer(true);
			PPillow_Center=newImage;
			PPillow_Left=newImage;
			PPillow_Right=newImage;
		}
		else
		{
			// tiling background to allow lwp using themes
			QImage newImage;
			const int rWidth=800;
			const int rHeight=overTextRect.bottom()+7;
	
			newImage.create(
				rWidth,
				overTextRect.bottom()+7,
				32);
			
			newImage.setAlphaBuffer(false);
			//TBuffer.fill(QColor(255,0,0).pixel());
			newImage.fill(0);
			newImage.setAlphaBuffer(true);
			for(int wy=0;wy<rHeight/PPillow_Center.height();wy++)
			{
				for(int wx=0;wx<rWidth/PPillow_Center.width();wx++)
				{
					bitBlt(&newImage,
						wx*PPillow_Center.width(),
						wy*PPillow_Center.height(),
						&PPillow_Center,0,Qt::CopyROP);
				}
			}
			PPillow_Center=newImage;
			//******************************************/
	
			PPillow_Left=PPillow_Left.smoothScale(overTextRect.bottom()+10,overTextRect.bottom()+7);
	
			PPillow_Right=PPillow_Right.smoothScale(overTextRect.bottom()+10,overTextRect.bottom()+7);
		}
/*
		if(pillowText.length()>1 ||pillowText=="")
		{
		PPillow_Center=PPillow_Center.smoothScale(800,overTextRect.bottom()+7);
		PPillow_Left=PPillow_Left.smoothScale(overTextRect.bottom()+10,overTextRect.bottom()+7);

		PPillow_Right=PPillow_Right.smoothScale(overTextRect.bottom()+10,overTextRect.bottom()+7);
		}
		else
		{
		PPillow_Center=PPillow_Center.smoothScale(3,overTextRect.bottom()+7);
		PPillow_Left=PPillow_Left.smoothScale(overTextRect.bottom()+10,overTextRect.bottom()+7);
		PPillow_Right=PPillow_Right.smoothScale(overTextRect.bottom()+10,overTextRect.bottom()+7);
		}
*/

		/*
		qWarning(QString("Pillow [%1][%1][%1]")
			.arg(PPillow_Left.width())
			.arg(PPillow_Center.width())
			.arg(PPillow_Right.width())
			);
		*/
	PillowIsLoaded=1;
}

inline void XGIconTextMaker::xSetFontStyle(const XSCfgTextFont *style)
{
	FontStyle=style;
}


/*!
    \fn XGIconTextMaker::xSetText(const QString &)
 */
void XGIconTextMaker::xSetText(const QString &newText)
{
	pillowText=newText;
	isTextDrawed=0;
	isPixmapTextDrawed=0;
}


/*!
    \fn XGIcon::xSetText(const QString &,int)
 */
void XGIcon::xSetText(const QString &newText,int idx)
{
	switch(idx)
	{
		case 0:
		xSetText(newText);
		break;
		case 1:
		xSetMiniText(newText);
		break;
	}
}


/*!
    \fn XGIcon::xSetMiniText(const QString &)
 */
void XGIcon::xSetMiniText(const QString &newText)
{
	xIconTextMini.pillowText=newText;
	xIconTextMini.isTextDrawed=0;
	xIconTextMini.isPixmapTextDrawed=0;
}


/*!
    \fn XGIcon::xSetTextManagedBy(int,int)
 */
void XGIcon::xSetTextManagedBy(int idText,int intManager)
{
	int idx=ActiveConfiguration->ObjectsIcons.find(iconConfiguration);

	if(idx<0)return;
	XSGObjectIcon *iConf=ActiveConfiguration->ObjectsIcons.at(idx);

	switch(idText)
	{
		case 1:
		iConf->Tasks.MiniTextShow=intManager;
		break;
	}
}


/*!
    \fn XGIconTextMaker::xSetBackgroundPath(const QString &)
 */
void XGIconTextMaker::xSetBackgroundPath(const QString &newPath)
{
	BackgroundPath=newPath;
	PillowIsLoaded=0;
	isPixmapTextDrawed=0;
}


inline QPixmap *XGIconTextMaker::xGetPixmapText()
{
	if(isPixmapTextDrawed==0)
	{
		isPixmapTextDrawed=1;
		xImgText.convertFromImage(xImageText);
	}
	return &xImgText;
}


void XGIcon::xMouseMoved(int xMouse,int yMouse,int xDocker,int yDocker,int iconIndex,int iconSize)
{
	emit xEventMouseMoved(xMouse,yMouse,xDocker,yDocker,iconIndex,iconSize);
}


/*!
    \fn XGIcon::xSetOverlayImage(int,int,const QPixmap &)
 */
void XGIcon::xSetOverlayImage(int x,int y,const QPixmap &pp)
{
	QImage pi=pp.convertToImage();
	setOverlay(x,y,pi);
}


/*!
    \fn XGIcon::xSetOverlayImage(int,int,const QImage &)
 */
void XGIcon::xSetOverlayImage(int x,int y,const QImage &pi)
{
	setOverlay(x,y,pi);
}


/*!
    \fn XGIcon::xSetOverlayImage(int,int,const QString &)
 */
void XGIcon::xSetOverlayImage(int x,int y,const QString &ps)
{
	QImage pi;
	if(ps==QString::null || ps=="")pi.reset();
	else if(!pi.load(ps))pi.reset();
	setOverlay(x,y,pi);

}


/*!
    \fn XGIcon::setOverlay(int,int,const QImage &)
 */
inline void XGIcon::setOverlay( int x,int y,const QImage &pi)
{
	if(pi.isNull() || pi.width()<1)
	{
		xImgSource=xImgOriginal.copy();
		//qWarning("xImgSource=xImgOriginal;");
	}
	else
	{
		bitBlt(&xImgSource,x,y,&pi,0,Qt::CopyROP);
		//qWarning("bitBlt(&xImgSource,x,y,&pi,0,Qt::CopyROP);");
	}
	cachePurge();
	xSetSmoothZoom();

}


/*!
    \fn XGIcon::xGetHidden()
 */
int XGIcon::xGetHidden()
{
    return hidden;
}


/*!
    \fn XGIcon::xSetHidden()
 */
void XGIcon::xSetHidden()
{
	hidden=1;
}


/*!
    \fn XGIcon::xSetHidden(int)
 */
void XGIcon::xSetHidden(int i)
{
    hidden=i;
}
