/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XKTRAY_H
#define XKTRAY_H

#include <ksystemtray.h>
#include <kpixmap.h>
#include <qtimer.h>


/**
@author Stefano
*/
class XKTray : public KSystemTray
{
Q_OBJECT
public:
    XKTray(QWidget *parent = 0, const char *name = 0);

    ~XKTray();
protected:
	class XSConfigurations *ActiveConfiguration;
	KPixmap xActiveIcon;
	int idShowAll;
	QString trobbler;
	QTimer 		trobblerAnimator;
	QStringList	trobblerList;
	int		trobblerlastStep;
	QString		trobblerLastabsolutePath;

public slots:
    void xWarning(const QString &);
    void xWarningMsg(const QObject *, const QString &);
    void xSetup();
    void xStart();
    void xStop();
    void xToggleShowAll();
    void xGetParameter(const QString,QString&);
    void xGetParameterList(QStringList*);
    void xAbout();
    void step();
    void xSetupParameter(const QString,const QString);
signals:
    void xTaskMgr_GetParameter(const QString, int&);
    void xToggleShowAllDispatch();
    void xFindResource(const QString, QString&);;
protected:
    void xFindTrobbler(const QString, QString &, int);
    void fetchDefaultParameters();
};

#endif
