/***************************************************************************
 *   Copyright (C) 2004 by stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_garp.h"

#include <kmountpoint.h>
#include <kpopupmenu.h>


#include "xeconfiguration.h"
#include "xgdocker.h"
#include "xgicon.h"


#include "xeplugin_garp.moc"

//#undef ENABLE_FINAL

XEPlugin_GARP::XEPlugin_GARP(QObject *parent, const char *name)
 : QObject(parent, name)
{
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GARP");
	#endif
	XEObject::xPluginAdd(this);
	KDEWatch	=new KDirWatch();
}


XEPlugin_GARP::~XEPlugin_GARP()
{
}






void XEPlugin_GARP::xSetup()
{

#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GARP::xSetup()");
#endif
	XEConfiguration *Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	qWarning("error while searching for plugin");
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();

	// reload xml
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
			if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
			{
			xSetupParameter("AutoAddMounts",
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("AutoAddMounts"));
			// Only 1 configuration
			}
			else
			{
		// Ok, You don't have specified the xml configuration, we have to create it!!
			
			// Creating fake document
			QDomDocument 	doc( "KXDocker_Conf" );
			// the fake root
			QDomElement fakeRoot=doc.createElement("FakeRoot");
			// appending childs
			doc.appendChild(fakeRoot);
			// now creating the configuration
			QDomElement CreatingCfg=doc.createElement("pluginconf");
			// Ok this is a plugin Configuration
			QStringList	a;
			// Creating the Attributes via the standard plugin interface
			xGetParameterList(&a);
			for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
			{
				QString returnValue;
				xGetParameter(a[istoringXML],returnValue);
				CreatingCfg.setAttribute(a[istoringXML],returnValue);
			}
			// Now appending to the configuration
			fakeRoot.appendChild(CreatingCfg);
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
			
			}
			break;
		}
	}



}


void XEPlugin_GARP::xStart()
{
	
	#ifndef ENABLE_FINAL
	qWarning("void XEPlugin_GARP::xStart()");
	#endif
	KDEWatch->addFile("/proc/net/arp");
	connect(KDEWatch, SIGNAL(dirty(const QString &)),this,SLOT(dirty(const QString &)));
	KDEWatch->startScan();
	//QTimer *PollingTimer=new QTimer();
	//connect(PollingTimer,SIGNAL(),this,SLOT(polling()));
	QTimer::singleShot( 60*1000, this, SLOT(polling()) );
}


void XEPlugin_GARP::xStop()
{
    /// @todo implement me
}


void XEPlugin_GARP::MountAdded(const QString &newMount)
{
	for(unsigned int i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(i)->SystemName==newMount)
		{
#ifndef ENABLE_FINAL
			qWarning("Matched icon for this mountpoint");
#endif
			// searching if it's being showed
			for(unsigned int iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
			{
#ifndef ENABLE_FINAL
				qWarning("xeplugin_gmounts.cpp:108");
#endif
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)==NULL)qWarning("void XEPlugin_GMounts::MountAdded(const QString &newMount) [125] Cazzo e' null");
#ifndef ENABLE_FINAL
				qWarning("NON e' null");
				qWarning(ActiveConfiguration->ObjectsIcons.at(iconIndex)->OverText);
#endif
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==newMount)return;
			}
			// copy the informations
#ifndef ENABLE_FINAL
			qWarning("xeplugin_gmounts.cpp:115");
#endif
		// is disabled?
		if(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Info.className=="disabled")return;

	// if there are too icons, we can exit because no more will be added
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;

			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//			XSGObjectIcon *addedCfg=new XSGObjectIcon;
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			ActiveConfiguration->ObjectsIcons.append(addedCfg);
			ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=ActiveConfiguration->Plugins.Matches.at(i)->Icon->OverText;
			addedCfg->Info.fileName=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Name=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Group=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			//addedCfg->Info.className=name();
			addedCfg->Info.className="xARP";
			
			addedCfg->Tasks.Proces.clear();
			addedCfg->Tasks.TaskInfo=NULL;
			addedCfg->Tasks.MiniTextShow=2;

			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskInfo;
			addedCfg->Tasks.TaskName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskName;
			addedCfg->Tasks.WindowTitle=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle;
			addedCfg->Images=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images;

			//network_local
			QString networkName=addedCfg->Images.imgFileName;
			xGDocker->xFindResource("icon",networkName);
			if(networkName=="")addedCfg->Images.imgFileName="network_local";
			else addedCfg->Images.imgFileName=networkName;

			addedCfg->Actions=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions;
//			ActiveConfiguration->ObjectsIcons.count()++;
			xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
			return;
		}
	}
	// 0.34
	// check if we like to auto attach
	if(AutoAddMounts!="no")
	{
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;

			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)qWarning(name());
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//			XSGObjectIcon *addedCfg=new XSGObjectIcon;
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			//ActiveConfiguration->ObjectsIcons.append(addedCfg);
			//ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=newMount;
			addedCfg->Info.fileName=newMount;
			addedCfg->Info.Name=newMount;
			addedCfg->Info.Group=newMount;
			addedCfg->Info.className="GARP";
			
			addedCfg->Tasks.Proces.clear();
			addedCfg->Tasks.TaskInfo=NULL;
			addedCfg->Tasks.MiniTextShow=1;
			addedCfg->Tasks.ShowThumbnail=0;
			//addedCfg->Tasks.TaskInfo=0;
			//addedCfg->Tasks.TaskName=newMount;
			//addedCfg->Tasks.WindowTitle=newMount;
			addedCfg->Images.imgFileName=newMount;
			addedCfg->Actions.onClickExec=QString("konqueror %1%1").arg("lan://localhost/").arg(newMount);
//			ActiveConfiguration->ObjectsIcons.count()++;
			//xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);


			XSCfgMatchIcons *addedCfgMatch=new XSCfgMatchIcons;
			addedCfgMatch->Icon=addedCfg;
			addedCfgMatch->SystemName=newMount;
			ActiveConfiguration->Plugins.Matches.append(addedCfgMatch);
			return;
	}

}


void XEPlugin_GARP::dirty(const QString &)
{
/*
	KMountPoint::List devList=KMountPoint::currentMountPoints();
	KMountPoint *DeviceMounted=NULL;
	for (int i=0;i<devList.count();i++)
	{
		DeviceMounted=devList[i];
		if(DeviceMounted==NULL)break;
		qWarning(DeviceMounted->mountPoint());
		
		MountAdded(DeviceMounted->mountPoint());
		
	}
*/
//qWarning("qfile");
	QFile f("/proc/net/arp");
	QStringList devList;
        if(f.open( IO_ReadOnly)!=false)
	{
//qWarning("read");
		char bufferLine[257];
		for(int i=0;;i++)
		{
//qWarning("loop");
			memset(bufferLine,0,257);
			if(f.readLine(bufferLine,256)<1)break;
			QString textLine(bufferLine);
			if(textLine.find("Device")>=0 ||textLine.find("00:00:00:00:00:00")>=0)
			{
				i--;
				continue;
			}
			int tspace=textLine.find(" ");
			QString sIP=textLine.left(tspace);
			textLine.truncate(tspace);
			
			devList.append(sIP);
			MountAdded(sIP);
			
			//qWarning(sIP);
		}
		
		f.close();
	}
	
	
	// ok now removing the old one
	int indexfind;
	for(unsigned int iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className==name())
		{
			indexfind=-1;
			for (unsigned int i=0;i<devList.count();i++)
			{
				
if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==devList[i]){
					indexfind=i;
					break;
				}
			}
			if(indexfind<0)
			{
				// remove it
				xGDocker->iconRemove(iconIndex);
			}
		}
	}
	
}


void XEPlugin_GARP::xGetParameter(const QString vname,QString& vvalue)
{
	if(vname=="AutoAddMounts")vvalue=(AutoAddMounts);
}


void XEPlugin_GARP::xGetParameterList(QStringList* a)
{
	a->append("AutoAddMounts");

}

/*!
    \fn XEPlugin_GARP::polling
 */
void XEPlugin_GARP::polling()
{
    /// @todo implement me
	dirty("ciao");
	QTimer::singleShot( 60*1000, this, SLOT(polling()) );
}


/*!
    \fn XEPlugin_GARP::xGetInfo(QStringList &)
 */
void XEPlugin_GARP::xGetInfo(QStringList &a)
{
	QStringList PluginInformations;
	QString Version=KXDOCKERVERSION;
	Version=Version+"-0.4";
	PluginInformations.append("KXDocker GARP");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append(KXDOCKERDATE); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=manual");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download")); // url update
	
	a=PluginInformations;
}



/*!
    \fn XEPlugin_GARP::xSetupParameter(const QString , const QString )
 */
void XEPlugin_GARP::xSetupParameter(const QString sName, const QString sValue)
{
/*
	bool okRet=false;
	if(sName=="desktopPreview")
	{
		desktopPreview=sValue.toInt(&okRet);
		if(okRet==false)
		{
			desktopPreview=0;
		}
	}
*/
	if(sName=="AutoAddMounts")
	{
		AutoAddMounts=sValue;
	}
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
		// update xml configuration
			ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("AutoAddMounts",AutoAddMounts);
		}
	}	

}

