/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_CONFIGURATOR_H
#define XEPLUGIN_CONFIGURATOR_H

#include <kmainwindow.h>
#include <kxdocker_setup_sources.h>

class	QTabWidget;
class	KToolBar;
class	QLineEdit;    
class	QCheckBox;
class	QComboBox;
class	QListBox;
class	QRadioButton;
class	KIntSpinBox;
class	QSlider;
class	KFontRequester;
class	KColorButton;
class 	KListView;
class 	QListViewItem;
class	QLabel;
class	QTextEdit;
class 	KIconButton;
class 	KComboBox;

#include <kdialog.h>

struct XSConfiguration;
class XGDocker;

#define KX_CFG_VERSION		"0.0.7"

/**
@author Stefano
*/
class XEPlugin_Configurator : public KMainWindow
{
Q_OBJECT
public:
    XEPlugin_Configurator(QWidget *parent = 0, const char *name = 0);

    ~XEPlugin_Configurator();
    void show();
    bool queryClose();
    void addIcon();
    void downIcon();
    void upIcon();
protected:
	struct XSConfigurations *ActiveConfiguration;
	class XGDocker	*xGDocker;
	//QListViewItem *LastItem;

public slots:
    void xSetup();
    void xConfigure();
    void xStart();
    void xStop();
    void guiRefreshValues();
    void itemRenamed(QListViewItem *, int, const QString &);
    void selectionChanged(QListViewItem *);
    void objectToolBar_clicked(int);
    void xRemoveIcon();
    void saveTo();
    void openCfg();
    void apply();
    void saveDefault();
    void imgFile_iconChanged(QString);
    void slot_oClassName_textChanged ( const QString & );
    void slot_oGroup_textChanged ( const QString & );
    void slot_oImgDrop_textChanged ( const QString & );
    void slot_oImgFileName_textChanged ( const QString & );
    void slot_oName_textChanged ( const QString & );
    void slot_oOnClickExec_textChanged ( const QString & );
    void slot_oOverText_textChanged ( const QString & );
    void aimgFile_iconChanged(QString);
    void slot_aClassName_textChanged ( const QString & );
    void slot_aGroup_textChanged ( const QString & );
    void slot_aImgArrow_textChanged ( const QString & );
    void slot_aImgFileName_textChanged ( const QString & );
    void slot_aName_textChanged ( const QString & );
    void slot_aOnClickExec_textChanged ( const QString & );
    void slot_aOverText_textChanged ( const QString & );
    void addIconPath();
    void slot_BackgroundPath_textChanged( const QString & newt);
    void alias_selectionChanged(QListViewItem *);
    void iconsListTasks_itemRenamed(QListViewItem *, int, const QString &);
    void pluginsList_selectionChanged(QListViewItem *);
    void PluginsList_itemRenamed(QListViewItem *, int, const QString &);
    void slot_aSystem_textChanged ( const QString & newt);
    void backgroundChangePath();
    void removePlugin();
    void slot_aOnDropExec_textChanged(const QString&);
    void slot_oOnDropExec_textChanged(const QString&);
    void slot_oImgArrow_textChanged ( const QString &);
    void slot_aImgDrop_textChanged (const QString &);
    void xGetInfo(QStringList &);
//    void xGetParameter(const QString,QString&);
//    void xGetParameterList(QStringList*);
protected:

#ifdef ENABLE_STATS
	void update_statistics();
	void create_statistics(class QVBox*);
	QLabel * dockerStarts;
	QLabel * dockerDaysRunning;
	QLabel * dockerHoursRunning;
	QLabel * dockerMinutesRunning;
	QLabel * dockerSecondsRunning;
	QLabel * dockerFirstStart;
	QLabel * maxIconsDisplayed;
	QLabel * avgIconsDisplayed;
	QLabel * changedBackgroundTheme;
	QLabel * startedConfigurator;
#endif

	QCheckBox	*AutoSave;
	QTabWidget 	*tabs;
	
	KToolBar	*ToolBar;
	
	KListView 	*PluginsList;
	KToolBar	*PluginsToolBar;
	QLineEdit	*pName;
	KListView	*pXMLConf;
	class XSGObjectPlugin *LastPlugin;
	
	KListView	*pXMLActionList;
	
	QLineEdit	*BackgroundPath;    
	QLineEdit	*PillowPath;
	QLineEdit	*PillowPath2;
	QLineEdit	*PoofPath;
	QLineEdit	*ArrowPath;
	QStatusBar	*statusBar;
	QCheckBox	*FastHide;
	KIntSpinBox 	*imgBackground_Desaturate;
	QCheckBox	*SendToBackground;
	QLineEdit	*imgBackgroundLeft;
	QLineEdit	*imgBackgroundCenter;
	QLineEdit	*imgBackgroundRight;
	QLineEdit	*imgBackgroundOver;
	QLineEdit	*imgBackgroundSeparator;
	QCheckBox	*imgBackground_Tiled;
	KToolBar	*iconsPathToolBar;
	QPushButton	*pBackgroundPath;
	QPushButton	*pPillowPath;
	QPushButton	*pPillowPath2;

	
	  
	KIntSpinBox 	*SendToForgroundTimeout;
	QCheckBox 	*RaiseOnEvents;
	QCheckBox 	*HideMouseCornerLeft;
	QCheckBox 	*HideMouseCornerRight;
	

	
	QListBox 	*iconsPaths;
	QListBox 	*pluginsPaths;
	KListView 	*iconsList;
	KListView 	*iconsListDCOP;
	KListView 	*iconsListTasks;
	KToolBar	*objectsToolBarTasks;
	KToolBar	*pluginsPathToolBar;
	
	KListView 	*aliasListTasks;
	KToolBar	*aliasToolBarTasks;
	
	KListView 	*aliasListDCOP;
	KToolBar	*aliasToolBarDCOP;
	
	QLineEdit	*oName;
	QLineEdit	*oGroup;
	KComboBox	*oclassName;
	QLineEdit	*oOverText;
	KToolBar	*objectsToolBar;
	QLineEdit	*oimgFileName;
	KIconButton	*ioimgFileName;
	QLineEdit	*oimgFileArrow;
	QLineEdit	*oimgFileDrop;
	QLineEdit	*aimgFileDrop;
	QLineEdit	*oonClickExec;
	QLineEdit	*oonDropExec;
	//0.29
	QLineEdit	*odcopClose;
	QLineEdit	*odcopRaise;
	QLineEdit	*odcopNewWindow;
	KListView 	*odcopName;
	KListView 	*objectsListDCOP;
	KToolBar	*objectsToolBarDCOP;

	
	
	KListView 	*oPluginCfg;
	
	// Project name
	// version
	// date
	// Author
	// Author mail
	// url download
	// url documentation
	// url update
	QPushButton	*oPluginConfigure;
	QLabel		*oPluginName;
	QLabel		*oPluginVersion;
	QLabel		*oPluginDate;
	QLabel		*oPluginAuthor;
	QLabel		*oPluginAuthorMail;
	QLabel		*oPluginUrlDownload;
	QLabel		*oPluginUrlDocumentation;
	QLabel		*oPluginUrlUpdate;
	
	

	QLineEdit	*aSystem;
	QLineEdit	*aName;
	QLineEdit	*aGroup;
	KComboBox	*aclassName;
	QLineEdit	*aOverText;
	QLineEdit	*aimgFileName;
	KIconButton	*iaimgFileName;
	QLineEdit	*aimgFileArrow;
	QLineEdit	*aonClickExec;
	QLineEdit	*aonDropExec;
	KListView 	*aliasList;
	KToolBar	*aliasToolBar;

	QCheckBox	*AutoResize;

	class XSCfgMatchIcons *LastAlias;
		
	QRadioButton	*rAlignTop;
	QRadioButton	*rAlignLeft;
	QRadioButton	*rAlignRight;
	QRadioButton	*rAlignBottom;
	
	KIntSpinBox	*HideTimeout;
	KIntSpinBox	*borderLeft;
	KIntSpinBox	*borderTop;
	KIntSpinBox	*TopForce;
	KIntSpinBox	*LeftForce;
	KIntSpinBox	*HeightDesktop;
	KIntSpinBox	*MaxIconsShowed;
	QSlider 	*sHeightDesktop;
	QSlider 	*sSendToForgroundTimeout;
	QSlider 	*sHideTimeout;
	QSlider 	*sSeparation;
	QSlider 	*sLeftForce;
	QSlider 	*sTopForce;

	KIntSpinBox	*Size;
	KIntSpinBox	*SizeBig;
	QSlider 	*sSizeBig;
	QSlider 	*sSize;
	KIntSpinBox	*Separation;
	QComboBox	*Design;
	KIntSpinBox	*Raise;
	KIntSpinBox	*Horiz;
#ifdef ENABLE_SPECIALENGINE2
	KIntSpinBox	*InterpolationValue;
#endif	
	QSlider 	*sHoriz;
	QSlider 	*sRaise;
	
	QCheckBox	*EnableThumbnail;
	KFontRequester	*FontFamily;
	KFontRequester	*FontFamilyMini;
	KColorButton	*FontColor;
	KColorButton	*FontColorMini;
	
	KIntSpinBox	*AndZoomCache;
	KIntSpinBox	*SleepFPS;
	KIntSpinBox	*SmoothTimeout;
	KIntSpinBox	*SleepThreads;
	KIntSpinBox	*SleepAnimations;
protected:
    void guiCreate();
    void guiDefault();
    void guiPrepare();
    void apply_tasks();
    void tasks_add();
    void tasks_remove();
    void aapply_tasks();
    void atasks_add();
    void atasks_remove();
    void apply_plugins();
    void refreshPluginscfg(class XSGObjectIcon *, KListView *);
    void apply_objectsplugin();
    class XSGObjectIcon *LastIcon;
signals:
    void xCfgWrite(const QString &);
    void xGetParameterList(QStringList *);
    void xGetParameter(const QString,QString&);
    void xSetupParameter(const QString,const QString);
    void xFetchGetInfo(QStringList &);
    void xUpdateMatrix();
    void xPluginRunConfigurator();
protected:
    void add_alias();
    void remove_alias();
protected:
    void create_about(class QVBox	*);
protected:
    void AddPluginPath();
    void addPlugin();
protected slots:
    void xRunCfg();

protected:
    void object_dcop_apply();
    void object_dcop_remove();
    void object_dcop_add();
};

#endif
