/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XGICON_H
#define XGICON_H

#include "xeconfiguration.h"


#include <qwidget.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qwmatrix.h>
#include <qpoint.h>
#include <qpixmap.h>

class XEPlugin_GEPillow;

// 0.32
//const int MAX_CACHE_ICONS=129;
// 256 + 1 + 16 273
const int MAX_CACHE_ICONS=257+16;
class XGIconTextMaker
{
public:
	XGIconTextMaker();
	virtual ~XGIconTextMaker();
	virtual void xSetFontStyle(const XSCfgTextFont *);
	virtual void xSetText(const QString &);
	virtual void xDrawText();
	virtual QPixmap *xGetPixmapText();
	int isPixmapTextDrawed;
	int xTextDecentre;
	int isTextDrawed;
	int PillowIsLoaded;
	QString	pillowText;
	QImage PPillow_Center;
	QImage PPillow_Left;
	QImage PPillow_Right;
	QImage TMiniBuffer;
	QImage TBuffer;
	QPixmap xImgText;
	QImage xImageText;
	QPixmap	overTextBuffer;
	QBitmap	overTextMask;
	static XSConfigurations * ActiveConfiguration;
	const XSCfgTextFont *FontStyle;
	QString BackgroundPath;
	void xSetBackgroundPath(const QString &);
protected:
	virtual void xPreparePillow(QRect &);
};
/**
@author Stefano
*/
class XGIcon : public QWidget
{
Q_OBJECT
public:
    XGIcon(QWidget *parent = 0, const char *name = 0);

    ~XGIcon();
    void xSetHotspot(const QPoint &);
    void xRepeat(int rWidth,int rHeight);
    void xSetIntensity(float);
    void xResetIntensity();
    static int xGetFontHeight();
    void xSetSmoothZoom(int);
    void xStartAnimating();
    void xStopAnimating();
    int xEnabledClickClass();
    void xEventClickClass(int,int,int);
    void xEventPostSetIconPos(int,int,int,int);
	XGIconTextMaker xIconTextPillow;
	XGIconTextMaker xIconTextMini;


public slots:
    void xRedraw();
    void cachePurge();
    void xSetImage(const QString &);
    void xLoadIcon(const QString &);
    void xSetZoom(int,int);
    void xSetZoom(int);
    void xReset();
    void xSetImage(const QPixmap &);
    void xSetClass(QObject *);
    void xSetText(const QString &);
    void xGetImage(QImage *&);
    void xSetSmoothZoom();
    void xGetConfiguration(const XSGObjectIcon *&);
    void xGetPluginConfiguration(const QDomNodeList *&);
    void xSetZoom();
    void createPopup();
    void getPopupMenu(KPopupMenu *&);
    void xStartClass();
    void xSetupClass();
    void xGetPluginPopupMenu(KPopupMenu *&);
    void xStopClass();
    void xRunConfiguratorClass();
    void xSetIconEXE(const QString &);
    void xGetIconEXE(QString &);
    void xGetIconImgFile(QString &);
    void xGetIconName(QString &);
    void xSetIconImgFile(const QString &);
    void xSetIconName(const QString &);
    void xSetOverText(const QString &);
    void xDesaturate(float);
    void xFade(int);
    void xSetText(const QString &,int);
    void xSetMiniText(const QString &);
    void xSetTextManagedBy(int,int);

    void xMouseMoved(int,int,int,int,int,int);
protected:
    //---------------------------------------------------------
    // Cache DATA
    // Will have the Coords for cached Zooms
    // Zoom are cached only if z(x==y)
    //int 	xCachedZoom[MAX_CACHE_ICONS];
    // Transparency channel
    //QBitmap 	xChachedTransparency[MAX_CACHE_ICONS];
    // RGB Image
    //QImage 	xCachedimgShowed[MAX_CACHE_ICONS];
    int		xImgCachedZoom[MAX_CACHE_ICONS];
    QImage	xImgCached[MAX_CACHE_ICONS];
    QObject	*xClassManager;
    
public:
    //---------------------------------------------------------
    // User DATA
    // User Click    
    QPoint 	xHotspot;
    const XSGObjectIcon *iconConfiguration;
    //XSGObjectIcon *iconConfiguration;
    
    short int	xExclude;
    
    int	xAndZoomCache;
    static XSConfigurations * ActiveConfiguration;

    
    //---------------------------------------------------------
    // Paint DATA
    // Current Zoom x=y
    int 	xZoom;
    int 	xZoomX;
    int 	xZoomY;
    // Invalidate Content
    int		xSetUpdate;
    // Showed Image
    QImage 	xImgShowed;
    QImage 	xImgArrow;
    QImage 	xImgDrop;
    QImage 	xImgArrowSource;

    // Paint Position
    QPoint 	xPosition;
    QImage	Poof;
    //---------------------------------------------------------
    // Original DATA
    // Source Position
    QPoint 	xPosDefault;
    // Source Transparency
    QBitmap 	xTransparency;
    // Source Image
    QImage 	xImgSource;
    QImage 	xImgOriginal;
    XEPlugin_GEPillow *xPillow;
signals:
    void xAttach(QObject *);
    void xRefresh(QObject *);
    void xEventStartAnimating();
    void xEventStopAnimating();
    void xStart();
    void xSetup();
    void xEventClick(void *,int,int,int,int);
    void xEnabledClick(int &);
    void xStop();
    void xRunConfigurator();
    void xEventSetIconPos(int,int,int,int);
    void xEventMouseMoved(int,int,int,int,int,int);
};

#endif
