/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XGDOCKER_H
#define XGDOCKER_H

#include <kxdocker_setup_sources.h>

#include "xeobject.h"
#include "xeconfiguration.h"
#include "xgicon.h"
#include "xematrix.h"

#include <qtimer.h>

class QTime;
class QWidget;
class QPixmap;
class QPainter;
class QFont;
class QColor;
class QDragEnterEvent;
//class QMutex;
#include <qmutex.h>
#include <qdatetime.h>
// Fix for NetBSD
#include <qimage.h>
#include <qbitmap.h>
#include <qpixmap.h>

#include <sys/times.h>


#include <kiconloader.h>
#include <kpixmapio.h>

class KRootPixmap;
class KSharedPixmap;
class KMainWindow;
class KPopup;


#define		LONBOTTOM	0
#define		LONTOP		1
#define		LONLEFT		2
#define		LONRIGHT	3


//const int MAX_DISPLAYED_ICONS=50;

/**
@author Stefano
*/
class XGDocker : public QWidget//KMainWindow 
{
Q_OBJECT

friend class XEObject;

public:
	float Desaturate;
	int HasComposite;
	QString xFindIconFile(const QString &logicName);
	void wheelEvent(QWheelEvent * e );
	XGDocker(QWidget *parent = 0, const char *name = 0);
	~XGDocker();
	void mouseMoveEvent( QMouseEvent *e );
	void paintEvent( QPaintEvent *e);
	XGIcon * getObjectIcon(int i);
	void xBliz(int isDesktop=0);
	int getRaised();
	void mouseMoveSoftware(int,int);
	void reloadIcon(int icon);
	void dropEvent(QDropEvent* event);
	void dragMoveEvent( QDragMoveEvent * );
	void mouseReleaseEvent ( QMouseEvent * e );
	int xLastX,xLastY;
	QMutex Busy;
	QMutex cacheBusy;
	int isAnimating;
		QValueList<int> xcache;
		QValueList<int> ycache;
	void mouseMoveEventSW(int x,int y,int force=0,Qt::ButtonState button=Qt::NoButton);
    int xGetLayout();
    void xUpdateRepaint(int myIndex);
    void xUpdateRepaintFast(int myIndex);
public slots:
    void xUpdateMatrix();
	void xCfgChanged(QObject *XECfgObject=NULL);
	void xReset();
	void xSetup();
	void xStart();
	void xStop();
	void xUpdate(int EnableTransparency=0, int pass=0);
	void backgroundUpdated(const QPixmap &);
	void xIRQ_MouseTimeout();
	void mousePressEvent( QMouseEvent *e );
	void iconAdd(const XSGObjectIcon *, int index=-1);
	void iconRemove(int index,int noanimation=0);
	void changeBackground(const QString basePath);
	void xEventTaskAppend(int);
	void xIRQ_Reset();
	void xRestore();
	void polish();
	void xHide();
	void xDrawPillow();
	void hide();
	void show();
	void purgeCacheMovements();
	void xMoveWidgetCenter();

    void xGetWidget(QWidget *&);
    void xMouseMoveSoftware(int,int);
    void iconAddSeparator();
    void xDockerRedraw();
    void xDockerRedraw(QObject *);
    void xDockerRedrawFast(QObject *);
    void xSendToBackground();
    void createPopup(KPopupMenu *&,const QObject *);
    void getPopupMenu(KPopupMenu *&, const QObject *);
    void showRaised();
    void xFindResource(const QString, QString &);
    void backgroundPostDone(bool);
    void backgroundUpdatedbyKDE(const QPixmap &);
    void xBackgroundMove(int,int);
    void xBackgroundGetCoords(int &,int &);
    void xPostStart();
    void xEventTaskAppendPost();
    void lower();
    void showRaisePost();
    int xGetIconIndex(const QObject*);
    void xUpdateSense();
    void backgroundCicle();
    void xStopAnimateBackground();
    void xStartAnimateBackground();
    void xSetDesaturate(float);
	signals:
	void xWarningMsg(const QObject *, const QString &);
	void xEventMouseMoved(int,int);
	void xEventMouseClick(int,int,int,int);
	void xEventReset(int,int);
	void xEventAnimateTo(int,int,int,int);
	void xEventMouseWheel(int,int,int,int);
	void xEventRemoveIcon(int);
	void xEventDockerHidden();
	void xEventWidgetMoved(int,int,int,int,int,int);
	void xEventDockerShowed();
    void xEventDockerSendToBackground();
    void dropIcon(int,QDropEvent*);
protected:
	int isLowering;
	float lastDesaturate;
    	void setUnShadowed();
	int isDropping;
	int m_Desk;
	int fakeHeightDesktop;
	int alternativeHeightDesktop;
	QRect m_Rect;
	QPoint p1;
	QPoint p2;
	
	QString pattern;

	#ifdef ENABLE_SPECIALENGINE2
		int xLastX_notmanaged;
		int xLastY_notmanaged;
	#endif
	int AxisAreInverted;
	int xLastY_real;
	int xLastX_real;
	QTime mouseMoveTimeElapsed;
	void (XGDocker::*funz1)(int,int,int,Qt::ButtonState);
	Qt::ButtonState lastButtonStatus;
	int isRaised,xDesignVirtualYMatrix, lastRaise, lastIcon;
	int lastIconActivated;
	uint 		activeIconsCounter;
	//long int 	activeIconsCounterLast;
	int 		RefreshMask;
	QTimer		*tMouseMoved;
	QTimer		*tAutoHideTimer;
	QTimer		*tPostIconAdd;
	QTimer		*tPostShowRaise;
	QTimer		*tAutoSendBGTimer;
	QTimer		*tAnimateBackground;
//	QTime	*tAutoSendFGTimer;
	
//	QTimer		*tDrawPillow;
	QImage		imgWindow;
	QImage		imgFakeBackground;
	QImage		imgFakeBackgroundGlobal;
	timespec 	req,   rem;
	
	
	KIconLoader	KDEIconLoader;
	
	KRootPixmap	*KDesktopBackground;
	
	XSConfigurations * ActiveConfiguration;
	// Off screen buffers
	QImage 		imgBackground;
	QImage 		paintBuffer;
	QBitmap 	maskBackground;
	QBitmap 	maskBuffer;
	QBitmap		maskFull;
	
	QBitmap		fakeDesktop;
	
	class XEMatrix *	Matrix;
	
	// arrays
	XGIcon 		*activeIcons[MAX_ICONS];
	XGIcon 		*lastIconDrag;
	XGIcon		backgroundBar;

	XGIcon		backgroundBarAni[64];

	XGIcon		backgroundBarLeft;
	XGIcon		backgroundBarRight;
	XGIcon		backgroundBarOver;

	QString lastBackgroundPath;
	XGIcon		OriginalbackgroundBar;
	XGIcon		OriginalbackgroundBarLeft;
	XGIcon		OriginalbackgroundBarRight;
	XGIcon		OriginalbackgroundBarOver;
	int backgroundBarAniFrame;
	float maxDesaturate;


	KPixmapIO	PixmapConverter;
	
	KSharedPixmap 	*m_pPixmap;
	
	XEConfiguration *Configurator;
	
	void applyCfg();
	void maskGenerareBigFake();
	//inline void mouseMoveEventSW(int x,int y,int force=0);
	void dragEnterEvent(QDragEnterEvent* event);
    void checkBackgroundSeparators();
    void xUpdateSmooth();
    QWidget *xPillow;
    void xUpdateDrawBackground();
    void xUpdateDrawBackgroundPass2();

    int xBar;
    int yBar;
    int dxBar;
    int dyBar;
    int LayoutPosition;
    void dragLeaveEvent (QDragLeaveEvent * );
    void drawVeryFakeBackground();
    void xUpdateBackgroundCoords();
    int mayRequireDoChangeBackground;
    void changeBackgroundForce(const QString basePath);
    void createBackgroundSeparators();
    void updateBackgroundSeparator(int);
protected:
    void xUpdateRepaintInline(int);
    void xDrawPillow2();
protected:
    void xUpdateRepaintMiniTextInline(int);
};

#endif
