/***************************************************************************
 *   Copyright (C) 2004 by stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xgtaskbar.h"
#include "xeobject.h"

#include <kwin.h>
#include <netwm.h>
#include <krootpixmap.h>
#include "xgdocker.h"
#include "xgicon.h"

XGTaskBar::XGTaskBar(QWidget *parent, const char *name)
 : QWidget(0, name)
{
	if(parent);
	XEObject::xPluginAdd(this);

	//xApplyCfg();
}


XGTaskBar::~XGTaskBar()
{
}


#include "xgtaskbar.moc"




/*!
    \fn XGTaskBar::xStart()
 */
void XGTaskBar::xStart()
{
	show();
}


/*!
    \fn XGTaskBar::xApplyCfg()
 */
void XGTaskBar::xApplyCfg()
{
	XEConfiguration *NewConfigurator=(XEConfiguration *)XEObject::xGetConfiguration();
	if(NewConfigurator==NULL)
	{
		// return;
	}
	else
	{
		ActiveConfiguration=NewConfigurator->xGetConfiguration();
	}
	
	// We draw the taskbar on left screen edge
	
	
	ObjectTaskWidth=16;
	ObjectTaskHeight=32;
	
	
	ObectCounter=0;
	TaskBarWidth=16;
	TaskBarY=32;
	TaskBarX=QApplication::desktop()->width()-TaskBarWidth;
	TaskBarHeight=QApplication::desktop()->height()-64;
	//

	setBackgroundMode(Qt::NoBackground,Qt::NoBackground);
	KWin::setType(winId(), NET::Dock);
	KWin::setType(winId(), NET::Override);
//	KWin::setType(winId(), NET::SkipTaskbar);
	
	//KWin::setState( winId(), NET::StaysOnTop );
	NETWinInfo* info;
	info = new NETWinInfo( qt_xdisplay(), winId(), qt_xrootwin(), NET::WMState );
	info->setDesktop( NETWinInfo::OnAllDesktops);
	// Enable the mouseMoveEvent( QMouseEvent *e )
	setMouseTracking (true);
	setFocusPolicy(QWidget::StrongFocus);
	setSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
	
	//
	
	KDesktopBackground=new KRootPixmap((QWidget*)this);
	connect(KDesktopBackground,
		SIGNAL(backgroundUpdated(const QPixmap &)), 
		this, SLOT(backgroundUpdated(const QPixmap &)));
	KDesktopBackground->setCustomPainting(true);
	
	
	// attach to the event system
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	QObject *TaskManager=XEObject::xFindObject("xTaskManager");
	
	connect(xGDocker,SIGNAL(xEventRemoveIcon(int)),
		this,SLOT(xEventRemoveIcon(int)));
	connect(TaskManager,SIGNAL(xEventRemoveIcon(int)),
		this,SLOT(xEventRemoveIcon(int)));
	connect(TaskManager,SIGNAL(xEventTaskOpen(int)),
		this,SLOT(xEventTaskOpen(int)));

	
	
	// now apply the new style
	imgFakeBackgroundGlobal.resize(TaskBarWidth,TaskBarHeight);
	imgFakeBackgroundGlobal.fill(Qt::black);
	paintBuffer.resize(TaskBarWidth,TaskBarHeight);
	paintBuffer.fill(Qt::black);
	objectBuffer.resize(ObjectTaskWidth,ObjectTaskHeight);
	objectBuffer.fill(Qt::color1);
	maskBuffer.resize(TaskBarWidth,TaskBarHeight);
	maskBuffer.fill(Qt::color0);
	move(TaskBarX,TaskBarY);
	resize(TaskBarWidth,TaskBarHeight);
	KDesktopBackground->start();
	//xUpdate();

	KWin::setStrut( winId(),0,16,0,0);
}


/*!
    \fn XGTaskBar::paintEvent( QPaintEvent *e)
 */
void XGTaskBar::paintEvent( QPaintEvent *e)
{
	QRect rect = e->rect();
	int l=rect.left();
	int t=rect.top();
	int w=rect.width();
	int h=rect.height();
	bitBlt(this,
		l,
		t,
		&paintBuffer,
		l,t,w,h,
		Qt::CopyROP);
}


/*!
    \fn XGTaskBar::xEventRemoveIcon(int)
 */
void XGTaskBar::xEventRemoveIcon(int)
{
	xUpdate();
}


/*!
    \fn XGTaskBar::xEventTaskOpen(int)
 */
void XGTaskBar::xEventTaskOpen(int)
{
	xUpdate();
}


/*!
    \fn XGTaskBar::xUpdate()
 */
void XGTaskBar::xUpdate()
{
	maskBuffer.fill(Qt::color0);
	ObectCounter=ActiveConfiguration->ObjectsIcons.count();
	
	// fake transparency	
	bitBlt(&paintBuffer,
			0,
			0,
			&imgFakeBackgroundGlobal,
			0,0,
			TaskBarWidth,
			TaskBarHeight,Qt::CopyROP);
	
	for(uint i=0;i<ObectCounter;i++)
	{
	
		// load the icon
		XGIcon *Icon=xGDocker->getObjectIcon(i);
		if(Icon==NULL)continue;
		QImage xImgShowed=Icon->xImgSource.smoothScale(16,16);
		
		bitBlt(&paintBuffer,
			0,
			i*ObjectTaskHeight,
			&xImgShowed,
			0,0,
			ObjectTaskWidth,
			ObjectTaskHeight,Qt::CopyROP);
		
		
		// update the text
	
	
	
		// apply the Mask
		bitBlt(&maskBuffer,
			0,
			i*ObjectTaskHeight,
			&objectBuffer,
			0,0,
			ObjectTaskWidth,
			ObjectTaskHeight,Qt::CopyROP);
	}
	/*
	for(uint i =0; i<ObectCounter;i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name
		==iconName)return i;
	}
	*/
	setMask(maskBuffer);
	repaint();
}


/*!
    \fn XGTaskBar::backgroundUpdated(const QPixmap &pm)
 */
void XGTaskBar::backgroundUpdated(const QPixmap &imgBackground)
{
	bitBlt(&imgFakeBackgroundGlobal,
				0,
				0,
				&imgBackground,0,0,
				TaskBarWidth,
				TaskBarHeight,Qt::CopyROP);
	xUpdate();
	repaint();

}


/*!
    \fn XGTaskBar::xSetup()
 */
void XGTaskBar::xSetup()
{
	xApplyCfg();
}


/*!
    \fn XGTaskBar::xStop()
 */
void XGTaskBar::xStop()
{
	hide();
}
