/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XECONFIGURATION_H
#define XECONFIGURATION_H

#include <qobject.h>

#include <qstring.h>
#include <qstringlist.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>

#include <kxdocker_setup_sources.h>


const uint MAX_STRING_NAME 	= 50;
//const int MAX_FILE_LENGTH 	= 1024;
const uint MAX_ICONS		= 50;


struct XSGObject
{
	QString className;
	QString fileName;
	QString Name;
	QString Group;
};
struct XSGObjectIconImages
{
	QString imgFileName;
	QString imgFileArrow;
	QString imgFileDrop;
	
};

#ifdef ENABLE_STATS
struct XSGObjectIconStatistics
{
	int onClickExec;
	int onDropExec;
	int onBounce;
	int dockerIndexSum;
};
struct XSCfgStatistics
{
	int dockerStarts;
	int dockerDaysRunning;
	int dockerHoursRunning;
	int dockerMinutesRunning;
	int dockerSecondsRunning;
	int dockerFirstStart;
	int maxIconsDisplayed;
	int avgIconsDisplayed;
	int avgCounter;
	int changedBackgroundTheme;
	int startedConfigurator;
	uint lastStart;

};
#endif

struct XSGObjectIconActions
{
	QString onClickExec;
	QString onDropExec;
	QDomNodeList		ActionList;

};
struct XSCfgTextFont
{
	int FontRed;
	int FontGreen;
	int FontBlue;
	QString FontFamily;
	int	FontSize;
	QString BackgroundPath;
	int	Bold;
	int	Italic;
	int	OtherBinaryValue;
	int	Weight;
	int	Other;
	QString	Alias;
	int	XPercentageDisplacement;
	int	YPercentageDisplacement;

};

struct XSCfgTasks
{
	void 		*TaskInfo;
	int		ShowThumbnail;
	QImage		Thumbnail;
	QStringList	WindowTitle;
	QStringList	TaskName;
	QStringList	ClassName;
	QPtrList<QObject> Proces;
	class KPopupMenu	*PopupMenu;
	QStringList	dcopName;
	QString		dcopRestore;
	QString		dcopClose;
	QString		dcopNewWindow;
	int		dcopReady;
	int		forceRunning;
	//int		forceNumber;
	//int		forceString;
	//int		Number;
	QString		MiniText;
	int		MiniTextShow;
	XSCfgTextFont	MiniTextProperty;
};

struct XSGObjectIcon
{
	XSGObject		Info;
	XSGObjectIconImages	Images;
	XSGObjectIconActions	Actions;
	XSCfgTasks		Tasks;
	QString			OverText;
	QDomNodeList		PluginConfiguration;
	//QImage			Poof;
	QString			PoofName;
	class KPopupMenu	*PluginPopupMenu;
#ifdef ENABLE_STATS
	XSGObjectIconStatistics	Statistics;
#endif
};
struct XSCfgMatchIcons
{
	QString				SystemName;
	XSGObjectIcon			*Icon;
};
struct XSGObjectPlugin
{
	XSGObject			Info;
	QDomNodeList			xmlConfiguration;
};
struct XSCfgPlugins
{
	QPtrList<XSCfgMatchIcons> 	Matches;
	QStringList			PluginsPaths;
	QPtrList<XSGObjectPlugin>	Plugin;
};
struct XSCfgIcons
{
	int Size;
	int SizePrefer;
	int SizeBig;
	int Raise;
	int Separation;
	int Horiz;
	int EnableThumbnail;
	XSCfgTextFont	OverTextFont;
	XSCfgTextFont	MiniTextFont;
	
};

struct XSGCfgBackground
{
	QString			imgBackgroundCenter;
	QString			imgBackgroundLeft;
	QString			imgBackgroundRight;
	QString			imgBackgroundOver;
	int			Tiled;
	QString			imgBackgroundSeparator;
	int			Desaturate;
};
struct XSCfgTheme
{
	XSGObject		Info;
	QString			BackgroundPath;
	XSGCfgBackground	Background;
	QString			ArrowsPath;
//	QString			PillowPath;
//	QString			MiniPillowPath;
	QString			PoofPath;
	QImage			Poof;
	QStringList		IconsPaths;
	QPixmap			DefaultIcon;
};

struct XSCfgWindow
{
	int borderLeft;
	int borderTop;
	int Width;
	int Height;
	int Top;
	int Left;
	//char Align[MAX_STRING_NAME];
	QString Align;
	int HeightDesktop;
	int LeftForce;
	int TopForce;
	
	int HideTimeout;
	int FastHide;
	int HideMouseEdge;
	
	int SendToForgroundTimeout;
	int RaiseOnEvents;
	
	int SendToBackground;
	
	int HideMouseCornerLeft;
	int HideMouseCornerRight;
};

struct XSDesignMatrix
{
	// number of elements
	int sizeMatrix;
	// 2d X Axis displace on mouse over
	int *XMatrix;
	// 2d Y Axis displace on mouse over
	int *YMatrix;
	// 2d Zoom on mouse over
	int *ZMatrix;
	// 3d Dinamic Axis displace on mouse over
	int **DMatrix;
	// 2d X+ Axis displace on mouse over
	int *KMatrix;

	int DesignDMoltiplier;
	int DesignYMoltiplier;
	int DesignXMoltiplier;
	
	QString Design;
};

struct XSEngine
{
	int SmoothTimeout;
	//char XMLConf[512];
	QString XMLConf;
	int SleepFPS;
	//int IconsShowed;
	int SleepThreads;
	int SleepAnimations;
	int MaxIconsShowed;
//	int StaticIconsShowed;
	int AndZoomCache;
#ifdef ENABLE_SPECIALENGINE2
	int InterpolationValue;
#endif
};

struct XSConfigurations
{
	QString		Version;
	int		AutoSave;
	int		AutoResize;
	XSCfgIcons	Icons;
	XSCfgWindow	Window;
	XSDesignMatrix	Matrix;
	XSEngine	Engine;
	//XSGObjectIcon	ObjectsIcon[MAX_ICONS];
	QPtrList<XSGObjectIcon> ObjectsIcons;
	QPtrList<XSGObjectIcon> RollingIcons;
	XSCfgTheme	Theme;
	XSCfgPlugins	Plugins;
#ifdef ENABLE_STATS
	XSCfgStatistics	Statistics;
#endif	
	QStringList	ConfigurationsPaths;
};



/**
@author Stefano
*/
class XEConfiguration : public QObject
{
Q_OBJECT
public:
    XEConfiguration(QObject *parent = 0, const char *name = 0);

    ~XEConfiguration();
    XSConfigurations * xGetConfiguration();
public slots:
    void xReset();
    void xCfgDefault();
    void xSetup();
    void iconRemove(int);
    void xLoadModules();
    void xLoadModule(const QString moduleName);
    void pluginRemove(const QString);
    void pluginAdd(const QString);
    void xGetConfiguration(void *&,const QString, int);
    void xGetConfigurationVersion(int &, QString &);
    void xGetConfigurationValue(const QString, QStringList &);
    void xGetConfigurationValue(const QString, int &);
    void xGetConfigurationValue(const QString, QString &);
    XSGObjectIcon * iconAdd();
    void xSetConfigurationValue(const QString, QString &);
    void xEventConfigurationUpdated(const QString);
    void xSetConfigurationValue(const QString, int &);
protected:
    XSConfigurations ActiveConfiguration;
signals:
    void xCfgChanged(QObject *);
protected:
    void * xGetConfigurationPointer(const QString);
    void * getConfigurationPointerObject(const QStringList,int,XSGObjectIcon *);
};

#endif
