/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GNETIO__H
#define GNETIO__H

#include <qobject.h>
#include <qstring.h>
#include <qimage.h>
#include <qxml.h>
#include <qdom.h>
#include <qtimer.h>
    
#include "ktn_proc.h"
    
    

class GNetIO : public QObject
{
  Q_OBJECT
public:
	GNetIO(QObject *parent = 0, const char *name = 0);
	~GNetIO();
	static void printStatus();
	
protected:
	QObject			*xGDocker;
	QObject			*xGIcon;
	QImage			*xImgSource;
	const QDomNodeList	*xXMLIconConfig;
	QString			IconsPath;
	QString			ToolTip;
	int 			lastPercentage;
	int 			Percentage;
	QPixmap			BasePixmap;
	QPixmap			BufferPixmap;
private:
	void updateNet();
	void cleanup();
	QTimer *m_timer;
	bool m_firstTime;
	KTN_Proc proc;
	QString		netWorkDevice;
	QStringList devicesList;
	float rateIn;
	float rateOut;
	float totalIn[10];
	float totalOut[10];
	float Scale;
	int PollingRate;
	
	

public:

signals:
    virtual void xGetImage(QImage *&);
    void xSetSmoothZoom();
    void cachePurge();
    void xDockerRedraw();
    void xDockerRedraw(QObject *);
    void xGetDocker(QObject *&);
    void xGetPluginConfiguration(const QDomNodeList *&);
    void xSetText(const QString &);
    
public slots:
    virtual void xSetup();
    virtual void xRefresh();
    virtual void xStart();
    virtual void xStop();
    virtual void xAttach(QObject *);
    virtual void xRefreshIcon(QObject *);
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void pollCpu();
    virtual void pollCpuStart();
    virtual void drawPixmap(int);
protected:
    virtual void xPaint();
    void createXMLTree();
    QString tryFindIcon(int,QString, QString);
    bool asKXDocker021;
};


#endif
