//
// C++ Implementation: gmail
//
// Description: 
//
//
// Author: Stefano <stefano@xiaprojects.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gmail.h"
#include "gmail.moc"

#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>

#include <stdio.h>
#include <string.h>

int main()
{
	qWarning("You cannot run this plugin, lets KXDocker load it");
	return 0;
}

extern "C" QObject *xeplugin_register(QObject *parent)
{
	qWarning("GMail xeplugin_register()");
	return new GMail(parent,"GMail");
}


GMail::GMail(QObject *parent, const char *name)
 : QObject(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="KMail";
	lastNum=0;
	eNum=0;
	internalStatus=1;
	seconds=60;
	folderName="/inbox";
	NotebookLED=0;
}


GMail::~GMail()
{
}




/*!
    \fn GMail::xGetParameterList(QStringList *a)
 */
void GMail::xGetParameterList(QStringList *a)
{
	a->append("baseIcon");
	a->append("incomingIcon");
	a->append("SecondsRefresh");
	a->append("folderName");
	a->append("NotebookLEDKind");
	
}


/*!
    \fn GMail::xAttach(QObject *newIcon)
 */
void GMail::xAttach(QObject *newIcon)
{
	if(xGIcon==NULL)
	{
		// unique instance
		xGIcon=newIcon;
		connect(this,SIGNAL(xGetImage(QImage *&)),xGIcon,SLOT(xGetImage(QImage *&)));
		connect(this,SIGNAL(cachePurge()),xGIcon,SLOT(cachePurge()));
		connect(this,SIGNAL(xSetSmoothZoom()),xGIcon,SLOT(xSetSmoothZoom()));
		connect(this,SIGNAL(xSetText(const QString &)),xGIcon,SLOT(xSetText(const QString &)));
		connect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)),xGIcon,SLOT(xGetPluginConfiguration(const QDomNodeList *&)));
		
		xGetPluginConfiguration(xXMLIconConfig);
		
		if(xXMLIconConfig->count()>0)
		{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("baseIcon");
			incomingIcon=xXMLIconConfig->item(0).toElement().attribute("incomingIcon");
			folderName=xXMLIconConfig->item(0).toElement().attribute("folderName");
			
			bool okRet=false;
			seconds=xXMLIconConfig->item(0).toElement().attribute("SecondsRefresh").toInt(&okRet);
			if(okRet==false)
			{
				seconds=60;
			}
			
			
			
			// Loading Notebook kind led-lid
			okRet=false;
			NotebookLED=xXMLIconConfig->item(0).toElement().attribute("NotebookLEDKind").toInt(&okRet);
			if(okRet==false)
			{
				NotebookLED=0;
			}
			
		}
		
		
		xGetImage(xImgSource);
		
		connect(this,SIGNAL(xDockerRedraw()),xGDocker,SLOT(xDockerRedraw()));
		connect(this,SIGNAL(xDockerRedraw(QObject *)),xGDocker,SLOT(xDockerRedraw(QObject *)));
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIcon(QObject *)));
		
		BasePixmap.convertFromImage(*xImgSource);
		
		loadImages();
		return;
	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
	}
}


/*!
    \fn GMail::xGetParameter(const QString vname, QString&vvalue)
 */
void GMail::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="baseIcon")
	{
		vvalue=IconsPath;
	}
	if(vname=="SecondsRefresh")
	{
		vvalue.setNum(seconds);
	}
	if(vname=="incomingIcon")
	{
		vvalue=incomingIcon;
	}
	if(vname=="folderName")
	{
		vvalue=folderName;
	}
	
	if(vname=="NotebookLEDKind")
	{
		vvalue.setNum(NotebookLED);
	}

}


/*!
    \fn GMail::xRefresh()
 */
void GMail::xRefresh()
{
	if(xGIcon==NULL)return;
	
	if(lastNum!=eNum)
	{
		drawPixmap(eNum);
		if(eNum)ToolTip=QString("You have %1 unreads").arg(eNum);
		else ToolTip=QString("KMail");
		xSetText(ToolTip);
		cachePurge();
		xSetSmoothZoom();
		lastNum=eNum;
	}
	//xDockerRedraw();
	// New engine 20040602
	// to avoid the full redraw
	xDockerRedraw(xGIcon);
}


/*!
    \fn GMail::xRefreshIcon(QObject *newIcon)
 */
void GMail::xRefreshIcon(QObject *newIcon)
{
    /// @todo implement me
}


/*!
    \fn GMail::xSetup()
 */
void GMail::xSetup()
{
	qWarning("GMail::xSetup()");
	connect(this,SIGNAL(xGetDocker(QObject *&)),parent(),SLOT(xGetDocker(QObject *&)));
	xGetDocker(xGDocker);
}


/*!
    \fn GMail::xSetupParameter(const QString vname, const QString vvalue)
 */
void GMail::xSetupParameter(const QString vname, const QString vvalue)
{
	bool okRet=false;


	if(vname=="incomingIcon")
	{
		incomingIcon=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("incomingIcon",incomingIcon);
		}
		loadImages();
	}
	if(vname=="folderName")
	{
		folderName=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("folderName",folderName);
		}
	}

	if(vname=="baseIcon")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("baseIcon",IconsPath);
		}
		loadImages();
	}
	if(vname=="SecondsRefresh")
	{
		seconds=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			seconds=60;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("SecondsRefresh",seconds);
		}
	}
	
	if(vname=="NotebookLEDKind")
	{
		NotebookLED=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			NotebookLED=0;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("NotebookLEDKind",NotebookLED);
		}
	}
	
	
}


/*!
    \fn GMail::xStart()
 */
void GMail::xStart()
{
	qWarning("GMail::xStart()");
	QTimer::singleShot(1000, this, SLOT(pollMails()));
	// Threads!
	xRefresh();
}


/*!
    \fn GMail::xStop()
 */
void GMail::xStop()
{
	internalStatus=0;
}


/*!
    \fn GMail::drawPixmap(int)
 */
void GMail::drawPixmap(int nEmails)
{
	if(!nEmails)
	{
		// we restore the base Image
		*xImgSource=BasePixmap.convertToImage();
	}
	else
	{
		*xImgSource=IncomingPixmap.convertToImage();
	}
}

/*!
    \fn GMail::pollMails()
 */
void GMail::pollMails()
{
    eNum=0;
        
    DCOPClient *client= new DCOPClient();
    client->attach();
    if(client->isApplicationRegistered("kmail")){
        QByteArray data;
        QByteArray replyData /* data1 */,
                replyData2;
        QCString replyType /*datas*/,
                replyType2;
        QDataStream arg(data, IO_WriteOnly);
        int unread=0;
            
        if(client->call("kmail",             // the remote application's id
                        "KMailIface",        // the remote object id
                        "folderList()",        // the remote function id 
                        data,                // the data to send
                        replyType,           // the type of the reply will be written here
                        replyData,           // the data of the reply will be written here 
                        false)){             
            QDataStream reply(replyData, IO_ReadOnly);
            if (replyType == "QStringList") {
                QStringList result;
                reply >> result;
                for ( QStringList::Iterator it = ++result.begin(); it != result.end(); ++it ) {
                    QByteArray outgoingData;
                    QDataStream outgoingStream( outgoingData, IO_WriteOnly );
                    outgoingStream << *it;
                    if(client->call("kmail",             // the remote application's id
                                    "KMailIface",        // the remote object id
                                    "getFolder(QString)",        // the remote function id  
                                    outgoingData,                // the data to send
                                    replyType2,           // the type of the reply will be written here
                                    replyData2,           // the data of the reply will be written here 
                                    false)){
                        if(replyType2=="DCOPRef"){
                            QDataStream argIn( replyData2, IO_ReadOnly );
                            DCOPRef ref;
                            argIn >> ref;
                            DCOPReply dcopReply=ref.call("unreadMessages()",QString::null);
                            if(dcopReply.isValid())
                                unread+=(int)dcopReply;
                            else
                                qWarning("DCOPReply: data not valid");
                        }else
                            qWarning("DCOP kmail KMailIface getfolder: reply type not valid");
                    }else
                        qWarning("DCOP kmail KMailIface getfolder: call error");
                }
            } else
                qWarning("DCOP kmail KMailIface folderlist: reply type not valid");
            // From here we have the number of unread messeages
	    if(NotebookLED==1)
	    {
//#ifdef WITH_ASUS_SUPPORT
            // This section enables the Asus notebooks email led support
            // unread=0 no messages => led off
            // unread!=0 led on
            QFile *mailFile = new QFile("/proc/acpi/asus/mled");
            if(unread==0){
                if(mailFile->open(IO_WriteOnly)){
                    mailFile->putch('0');
                    mailFile->close();
                }else{
                    qWarning("GMail::pollMails() Unable to reset mail led");
                }
            }else{
                if(mailFile->open(IO_WriteOnly)){
                    mailFile->putch('1');
                    mailFile->close();
                }else{
                    qWarning("GMail::pollMails() Unable to set mail led");
                }
            }
//#endif
		}
            eNum=unread;
            xRefresh();
            qWarning(QString("GMail::pollMails() There are %1 unread messages").arg(eNum));
        }else
            qWarning("DCOP kmail KMailIface folderlist: call error");
    }
    if(internalStatus)QTimer::singleShot(seconds*1000, this, SLOT(pollMails()));
}


/*!
    \fn GMail::loadImages()
 */
void GMail::loadImages()
{
	QString kdeshare="kxdocker/plugins/gmail/";
	QString iPaths=IconsPath;
	iPaths=::locate("data",iPaths);
	QFile a(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"kmail.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
	}
	else
	{
		BasePixmap.load(iPaths);
	}

	iPaths=incomingIcon;
	iPaths=::locate("data",iPaths);
	a.setName(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"kmail_incoming.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
		IncomingPixmap=BasePixmap;
	}
	else
	{
		IncomingPixmap.load(iPaths);
		if(IncomingPixmap.isNull())IncomingPixmap=BasePixmap;
	}
	
	

}
