//
// C++ Implementation: gmail
//
// Description: 
//
//
// Author: Stefano <stefano@xiaprojects.com>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gmail.h"
#include "gmail.moc"

#include <qregexp.h>
#include <qbitmap.h>
#include <qstringlist.h>
#include <kstandarddirs.h>
#include <kapp.h>
#include <qimage.h>
#include <dcopref.h>
#include <dcopclient.h>

#include <stdio.h>
#include <string.h>

int main()
{
	qWarning("You cannot run this plugin, lets KXDocker load it");
	return 0;
}

extern "C" QObject *xeplugin_register(QObject *parent)
{
	qWarning("GMail xeplugin_register()");
	return new GMail(parent,"GMail");
}


GMail::GMail(QObject *parent, const char *name)
 : QObject(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="KMail";
	lastNum=0;
	eNum=0;
	internalStatus=1;
	seconds=60;
	folderName="/inbox";
}


GMail::~GMail()
{
}




/*!
    \fn GMail::xGetParameterList(QStringList *a)
 */
void GMail::xGetParameterList(QStringList *a)
{
	a->append("baseIcon");
	a->append("incomingIcon");
	a->append("SecondsRefresh");
	a->append("folderName");
}


/*!
    \fn GMail::xAttach(QObject *newIcon)
 */
void GMail::xAttach(QObject *newIcon)
{
	if(xGIcon==NULL)
	{
		// unique instance
		xGIcon=newIcon;
		connect(this,SIGNAL(xGetImage(QImage *&)),xGIcon,SLOT(xGetImage(QImage *&)));
		connect(this,SIGNAL(cachePurge()),xGIcon,SLOT(cachePurge()));
		connect(this,SIGNAL(xSetSmoothZoom()),xGIcon,SLOT(xSetSmoothZoom()));
		connect(this,SIGNAL(xSetText(const QString &)),xGIcon,SLOT(xSetText(const QString &)));
		connect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)),xGIcon,SLOT(xGetPluginConfiguration(const QDomNodeList *&)));
		
		xGetPluginConfiguration(xXMLIconConfig);
		
		if(xXMLIconConfig->count()>0)
		{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("baseIcon");
			incomingIcon=xXMLIconConfig->item(0).toElement().attribute("incomingIcon");
			folderName=xXMLIconConfig->item(0).toElement().attribute("folderName");
			
			bool okRet=false;
			seconds=xXMLIconConfig->item(0).toElement().attribute("SecondsRefresh").toInt(&okRet);
			if(okRet==false)
			{
				seconds=60;
			}
			
		}
		
		
		xGetImage(xImgSource);
		
		connect(this,SIGNAL(xDockerRedraw()),xGDocker,SLOT(xDockerRedraw()));
		connect(this,SIGNAL(xDockerRedraw(QObject *)),xGDocker,SLOT(xDockerRedraw(QObject *)));
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIcon(QObject *)));
		
		BasePixmap.convertFromImage(*xImgSource);
		
		loadImages();
		return;
	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
	}
}


/*!
    \fn GMail::xGetParameter(const QString vname, QString&vvalue)
 */
void GMail::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="baseIcon")
	{
		vvalue=IconsPath;
	}
	if(vname=="SecondsRefresh")
	{
		vvalue.setNum(seconds);
	}
	if(vname=="incomingIcon")
	{
		vvalue=incomingIcon;
	}
	if(vname=="folderName")
	{
		vvalue=folderName;
	}
	

}


/*!
    \fn GMail::xRefresh()
 */
void GMail::xRefresh()
{
	if(xGIcon==NULL)return;
	
	if(lastNum!=eNum)
	{
		drawPixmap(eNum);
		if(eNum)ToolTip=QString("You have %1 unreads").arg(eNum);
		else ToolTip=QString("KMail");
		xSetText(ToolTip);
		cachePurge();
		xSetSmoothZoom();
		lastNum=eNum;
	}
	//xDockerRedraw();
	// New engine 20040602
	// to avoid the full redraw
	xDockerRedraw(xGIcon);
}


/*!
    \fn GMail::xRefreshIcon(QObject *newIcon)
 */
void GMail::xRefreshIcon(QObject *newIcon)
{
    /// @todo implement me
}


/*!
    \fn GMail::xSetup()
 */
void GMail::xSetup()
{
	qWarning("GMail::xSetup()");
	connect(this,SIGNAL(xGetDocker(QObject *&)),parent(),SLOT(xGetDocker(QObject *&)));
	xGetDocker(xGDocker);
}


/*!
    \fn GMail::xSetupParameter(const QString vname, const QString vvalue)
 */
void GMail::xSetupParameter(const QString vname, const QString vvalue)
{
	bool okRet=false;


	if(vname=="incomingIcon")
	{
		incomingIcon=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("incomingIcon",incomingIcon);
		}
		loadImages();
	}
	if(vname=="folderName")
	{
		folderName=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("folderName",folderName);
		}
	}

	if(vname=="baseIcon")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("baseIcon",IconsPath);
		}
		loadImages();
	}
	if(vname=="SecondsRefresh")
	{
		seconds=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			seconds=60;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("SecondsRefresh",seconds);
		}
	}
}


/*!
    \fn GMail::xStart()
 */
void GMail::xStart()
{
	qWarning("GMail::xStart()");
	QTimer::singleShot(1000, this, SLOT(pollMails()));
	// Threads!
	xRefresh();
}


/*!
    \fn GMail::xStop()
 */
void GMail::xStop()
{
	internalStatus=0;
}


/*!
    \fn GMail::drawPixmap(int)
 */
void GMail::drawPixmap(int nEmails)
{
	if(!nEmails)
	{
		// we restore the base Image
		*xImgSource=BasePixmap.convertToImage();
	}
	else
	{
		*xImgSource=IncomingPixmap.convertToImage();
	}
}

/*!
    \fn GMail::pollMails()
 */
void GMail::pollMails()
{
	eNum=0;
	
	/*
echo 'You have ' | tr -d '\n'; dcop kmail KMailIface getFolder /inbox > /dev/null; dcop 'DCOPRef(kmail,FolderIface)' unreadMessages | tr -d '\n'; echo ' new e-mail messages'
	*/
	/*
	QByteArray data;
	QByteArray data1;
	QCString datas;
	QDataStream arg(data, IO_WriteOnly);
	
	arg << QString("/inbox");
	bool okkmail=kapp->dcopClient()->call(
		"kmail",
		"KMailIface",
		"getFolder(QString)"
		,data,datas,data1,false);

	if(okkmail)
	{
		QDataStream argIn( data1, IO_ReadOnly );
		DCOPRef	remoteref;
		argIn>> remoteref;
		qWarning("DCOPRef	*remoteref;");
		
		QByteArray data2;
		QDataStream arg2(data2, IO_WriteOnly);
		
		DCOPReply reply=remoteref.callInternal("(kmail,FolderIface)","unreadMessages",data2);
		
		xRefresh();
	}
	*/
	
	
	char dcopstring[512];
	memset(dcopstring,0,512);
	
	if(folderName=="")folderName="/inbox";
	strcpy(dcopstring,"dcop |grep -iq kmail &&dcop kmail KMailIface getFolder ");
	strcat(dcopstring,folderName);
	strcat(dcopstring," > /dev/null; dcop 'DCOPRef(kmail,FolderIface)' unreadMessages | tr -d '\n'");
	FILE *fp=popen(dcopstring,"r");
	
	if(fp)
	{
		//if(fread(&eNum, sizeof(int), 1,fp))
		char buff[512];
		memset(buff,0,512);
		
		fgets(buff, 511, fp);
		if(strlen(buff))
		{
			eNum=QString(buff).toInt();
			xRefresh();
		}
		pclose(fp);
	}
	qWarning(QString("New emails: %1").arg(eNum));
	
	
	if(internalStatus)QTimer::singleShot(seconds*1000, this, SLOT(pollMails()));
}


/*!
    \fn GMail::loadImages()
 */
void GMail::loadImages()
{
	QString kdeshare="kxdocker/plugins/gmail/";
	QString iPaths=IconsPath;
	iPaths=::locate("data",iPaths);
	QFile a(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"kmail.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
	}
	else
	{
		BasePixmap.load(iPaths);
	}

	iPaths=incomingIcon;
	iPaths=::locate("data",iPaths);
	a.setName(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=kdeshare+"kmail_incoming.png";
		iPaths=::locate("data",iPaths);
		a.setName(iPaths);
	}
	
	if(!a.exists() || iPaths==QString::null)
	{
		// what can we do if i cannot find noting?
		IncomingPixmap=BasePixmap;
	}
	else
	{
		IncomingPixmap.load(iPaths);
		if(IncomingPixmap.isNull())IncomingPixmap=BasePixmap;
	}
	
	

}
