/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include <gbattery.h>
#include "portable.h"
#include <kstandarddirs.h>
#include "gbattery.moc"


extern "C" QObject *xeplugin_register(QObject *parent)
//extern "C" void xeplugin_register()
{
	qWarning("GBattery xeplugin_register()");
	return new GBattery(parent,"GBattery");
}

int main()
{
	qWarning("You cannot run this plugin, let's kxdocker load it");
	return 0;
}


GBattery::GBattery(QObject *parent, const char *name)
 : QObject(parent, name)
{
	xGIcon=NULL;
	xGDocker=NULL;
	ToolTip="Battery";
}


GBattery::~GBattery()
{
}




/*!
    \fn XEPlugin_GApplet::xSetup()
 */
void GBattery::xSetup()
{
	qWarning("GBattery::xSetup()");
	connect(this,SIGNAL(xGetDocker(QObject *&)),parent(),SLOT(xGetDocker(QObject *&)));
	xGetDocker(xGDocker);
}


/*!
    \fn XEPlugin_GApplet::xRefresh()
 */
void GBattery::xRefresh()
{
	if(xGIcon==NULL)return;
	xSetText(ToolTip);
	xPaint();
	cachePurge();
	xSetSmoothZoom();
	xDockerRedraw();
}


/*!
    \fn XEPlugin_GApplet::xStart()
 */
void GBattery::xStart()
{
    /// @todo implement me
	qWarning("GBattery::xStart()");
    xRefresh();
}


/*!
    \fn XEPlugin_GApplet::xStop()
 */
void GBattery::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_GApplet::xAttach(XGIcon *)
 */
void GBattery::xAttach(QObject *newIcon)
{
	// ok have to write the buffer into
	if(xGIcon==NULL)
	{
		// unique instance
		xGIcon=newIcon;
		connect(this,SIGNAL(xGetImage(QImage *&)),xGIcon,SLOT(xGetImage(QImage *&)));
		connect(this,SIGNAL(cachePurge()),xGIcon,SLOT(cachePurge()));
		connect(this,SIGNAL(xSetSmoothZoom()),xGIcon,SLOT(xSetSmoothZoom()));
		connect(this,SIGNAL(xSetText(const QString &)),xGIcon,SLOT(xSetText(const QString &)));
		connect(this,SIGNAL(xGetPluginConfiguration(const QDomNodeList *&)),xGIcon,SLOT(xGetPluginConfiguration(const QDomNodeList *&)));
		
		xGetPluginConfiguration(xXMLIconConfig);
		
		if(xXMLIconConfig->count()>0)
		{
			IconsPath=xXMLIconConfig->item(0).toElement().attribute("path");
		}
		
		
		xGetImage(xImgSource);
		connect(this,SIGNAL(xDockerRedraw()),xGDocker,SLOT(xDockerRedraw()));
		
		connect(xGIcon,SIGNAL(xRefresh(QObject *)),this,SLOT(xRefreshIcon(QObject *)));
		//xRefresh();
		pollBattery();
		return;
	}
	else
	{
		// ok, we have to manage more icons :)
		// create new instance for new icon
	}
}


void GBattery::xPaint()
{
}
void GBattery::xRefreshIcon(QObject *newIcon)
{

	if(newIcon==xGIcon)
	{
		pollBattery();
		xPaint();
		cachePurge();
		xSetSmoothZoom();
		// xGDocker will auto - repaint
	}
}


void GBattery::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="path")
	{
		IconsPath=vvalue;
	}
	// refreshing XML Data
	if(xXMLIconConfig->count()>0)
	{
		xXMLIconConfig->item(0).toElement().setAttribute("path",IconsPath);
	}
	else
	{
		createXMLTree();
	}
}

void GBattery::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="path")
	{
		vvalue=IconsPath;
	}
}
void GBattery::xGetParameterList(QStringList *a)
{
	a->append("path");
}

void GBattery::createXMLTree()
{
// Ok, You don't have specified the xml configuration, we have to create it!!
	// Creating fake document
	QDomDocument 	doc( "KXDocker_Conf" );
	// the fake root
	QDomElement fakeRoot=doc.createElement("FakeRoot");
	// appending childs
	doc.appendChild(fakeRoot);
	// now creating the configuration
	QDomElement CreatingCfg=doc.createElement("pluginconf");
	// Ok this is a plugin Configuration
	QStringList	a;
	// Creating the Attributes via the standard plugin interface
	xGetParameterList(&a);
	for(int istoringXML=0;istoringXML<a.count();istoringXML++)
	{
		QString returnValue;
		xGetParameter(a[istoringXML],returnValue);
		CreatingCfg.setAttribute(a[istoringXML],returnValue);
	}
	// Now appending to the configuration
	fakeRoot.appendChild(CreatingCfg);
	// this will do a right cast;
	QDomNodeList pfx=(QDomNodeList)*xXMLIconConfig;
	pfx=fakeRoot.childNodes();
//	*xXMLIconConfig=&fx;
	//xXMLIconConfig->appendChild(fakeRoot.childNodes());
	if(pfx.count()<1)
	{
		qWarning("Error! XML Plugin configuration will not be stored.");
	}
	else
		qWarning("GBattery Version 0.0.1 with kxdocker 0.19 will not store correctly the configuration, you have to add the path on pluginconf manually, please upgrade to kxdocker 0.20");
}

void GBattery::pollBattery()
{
	if(laptop_portable::has_power_management())
	{
		int num_batteries;
		QStringList names;
		QStringList state;
		QStringList values;
		laptop_portable::get_battery_status(num_batteries, names, state, values);
		struct power_result binfo=laptop_portable::poll_battery_state();
		//int ac=laptop_portable::get_acpi_ac();
		int ac=binfo.powered;
		ToolTip="Monitoring...";
		if(ac>0)
		{
			// external power
			//TODO: plugged without battery
			drawPixmap(1,binfo.percentage);
			if(binfo.percentage>0)ToolTip=QString("Charging... (%1%)").arg(binfo.percentage);
			else ToolTip="AC On-line";
			// we have to check if it's charging
		}
		else
		{
			if(num_batteries<1)return;
			drawPixmap(0,binfo.percentage);
			if(binfo.time>0)
			{
			int h=binfo.time/60;
			int m=binfo.time-h*60;
			ToolTip=QString("%1: %1:%1 left (%1%)").arg(names[0]).arg(h).arg(m).arg(values[0]);
			}
			else
			{
				ToolTip=QString("%1: (%1%)").arg(names[0]).arg(values[0]);
			}
		}
		xRefresh();
		QTimer::singleShot( 60*1000, this, SLOT(pollBattery()));
	}
	else
	{
		// you dont have ACPI installed than we can put a plug?
		ToolTip="AC On-line";
		drawPixmap(1,-1);
		xRefresh();
		// i don't want update more
	}
}


void GBattery::drawPixmap(int AC, int B)
{
	if(lastAC==AC and lastB == B)return;
	lastAC=AC;
	lastB=B;
	// base Image
	QString kdeshare="kxdocker/plugins/gbattery/";
	QString batteryPaths=IconsPath;
	batteryPaths=batteryPaths+"/0.png";
	QFile a(batteryPaths);
	if(!a.exists() || batteryPaths==QString::null)
	{
		batteryPaths=kdeshare+"na.png";
	}
	QPixmap Pixmap;
	Pixmap.load(::locate("data",batteryPaths));
	*xImgSource=Pixmap.convertToImage();
	QString iconName, Bstring;
	iconName="";
	// ACOnline without battery
	if(AC>0 && B<1)
	{
		//iconName=tryFindIcon(0,"charged",IconsPath);
		//if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",kdeshare);
	}

	// try theme c98.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),IconsPath);
	// try theme c9.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),IconsPath);
	// try kde c98.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),kdeshare);
	// try kde c9.png
	if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),kdeshare);
	// try >8 
	if(iconName==NULL or iconName.isEmpty())
	{
		if(B>80)
		{
			if(AC>0)
			{
				iconName=tryFindIcon(0,"charged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_plugged",IconsPath);
				if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_plugged",kdeshare);
			}
			else 
			{
				B=80;
			}
		}
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),IconsPath);
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),IconsPath);
		// try kde c98.png
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B,2),kdeshare);
		// try kde c9.png
		if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(AC,QString("%1").arg(B/10),kdeshare);

		
		if(B>=70)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_full",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_full",kdeshare);
		}
		if(B<70 && B>40)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_two_thirds",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_two_thirds",kdeshare);
		}
		if(B<40 && B>10)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_low",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_low",kdeshare);
		}
		if(B<10 && B>0)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_empty",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"battery_empty",kdeshare);
		}
		if(B<=0)
		{
			if(AC>0)
			{
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"externalpower",kdeshare);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"charged",kdeshare);
			}
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"na",IconsPath);
			if(iconName==NULL or iconName.isEmpty())iconName=tryFindIcon(0,"na",kdeshare);
		}
		
		
	}
	if(iconName==NULL or iconName.isEmpty())return;
	Pixmap.load(iconName);
	*xImgSource=Pixmap.convertToImage();
	
}


QString GBattery::tryFindIcon(int AC ,QString B, QString themePath)
{
	// search for theme/c95.png
	QString basePath=themePath;
//qWarning(B);
	QString batteryPaths=B;
	//batteryPaths.setNum(B);
	if(AC>0)
	{
	batteryPaths="c"+batteryPaths;
	}
	else
	{
	
	}
	batteryPaths=basePath+batteryPaths;
	batteryPaths=batteryPaths+".png";
	
	batteryPaths=::locate("data",batteryPaths);
//qWarning(batteryPaths);
	QFile a(batteryPaths);
	qWarning(QString("Alimentazione: %1 %1 %1 %1").arg(AC).arg(B).arg(themePath).arg(batteryPaths));
	if(!a.exists() || batteryPaths==QString::null)
	{
		return NULL;
	}
	return batteryPaths;	
}
