#!/bin/bash

KXDRSCVER="GAnimator 0.0.1"
KXLIB="GAnimations.so"

echo "KXDocker Resource installer for" $KXDRSCVER

find_KDE_global()
{
	MYKDE="$1"

	if ! [ "$MYKDE" == "" ];
	then
		echo "$MYKDE";
		return;
	fi

	if ! [ "$KDEDIR" == "" ];
	then
		MYKDE="$KDEDIR";
	echo "$MYKDE"
		return;
	fi

	MYKDE=`kde-config --prefix`
	echo "$MYKDE"
	return;
}

find_KDE_local()
{
	MYKDE="$1"

	if ! [ "$MYKDE" == "" ];
	then
		echo "$MYKDE";
		return;
	fi

	MYKDE=`kde-config --localprefix`
	echo "$MYKDE"
	return;
}

checkcompile()
{
	if [ ! -f $KXLIB ];
	then
		SURE3=`kdialog --yesno "Do you like to compile the plugin ? (pass 1/2)" && echo "yes"`;
		if [ "$SURE3" == "yes" ];
		then
			./compile.sh
		fi
		
	fi
	if [ ! -f $KXLIB ];
	then
		kdialog --error "Error while compiling the plugin! you must do manually" && exit 1
	fi

	SURE2=`kdialog --yesno "Do you like to install the plugin into: ${KXDPREFIX}/share/apps/kxdocker/plugins/${KXLIB}? (pass 2/2)" && echo "yes"`;
	if [ "$SURE2" == "yes" ];
	then
		! cp ${KXLIB} ${KXDPREFIX}/share/apps/kxdocker/plugins && kdialog --error "Error while installing configuration: ${KXDPREFIX}/share/apps/kxdocker/plugins/${KXLIB}" && exit 1
		
		kdialog --msgbox "Installation successfully into: ${KXDPREFIX}/share/apps/kxdocker"
	fi

}

pass3()
{
		 case "$1" in
			 yes)
				checkcompile
			 
			 ;;
			 *)
		echo "Installation aborted";
		exit 1;

			 ;;
		 esac
}

pass2()
{
	KXDPREFIX=`kdialog --inputbox "Please insert PREFIX where install resources (pass 2/3)" "$KXDPREFIX"`
	if ! [ "$KXDPREFIX" == "" ];
	then
		SURE=`kdialog --yesno "Are you sure to install KXDocker resources in ${KXDPREFIX}/share/apps/kxdocker? (pass 3/3)" && echo "yes"`;
		pass3 $SURE;
	else
              echo "Installation aborted";
              exit 1;
	fi
}


if ! [ "$DISPLAY" == "" ];
then
	kdialog --msgbox "KXDocker Resource installer $KXDRSCVER";
	ISLOCAL=`kdialog --radiolist "Where do you like to install resources (pass 1/3)" local "Local user directory (HOME)" 0 global "Global MultiUser install (KDEDIR)" 0`

	case "$ISLOCAL" in
		global)
			KXDPREFIX=`find_KDE_global "$1"`
			pass2
		;;
		local)
			KXDPREFIX=`find_KDE_local "$1"`
			pass2
		;;
		*)
		echo "Installation aborted";
		exit 1;
		;;
	esac

else
	echo "You have to run this script under X environment with KDE correctly installed";
	exit 1;
fi

