#!/bin/bash

KXDRSCVER="KTrayNetworker Resources 0.2"
TARGET=""
TARGETPD="themes"

echo "XIA Projects Resource installer for" $KXDRSCVER

find_KDE_global()
{
	MYKDE="$1"

	if ! [ "$MYKDE" == "" ];
	then
		echo "$MYKDE";
		return;
	fi

	if ! [ "$KDEDIR" == "" ];
	then
		MYKDE="$KDEDIR";
	echo "$MYKDE"
		return;
	fi

	MYKDE=`kde-config --prefix`
	echo "$MYKDE"
	return;
}

find_KDE_local()
{
	MYKDE="$1"

	if ! [ "$MYKDE" == "" ];
	then
		echo "$MYKDE";
		return;
	fi

	MYKDE=`kde-config --localprefix`
	echo "$MYKDE"
	return;
}

pass3()
{
		 case "$1" in
			 yes)
			 ! mkdir -p ${KXDPREFIX}/share/apps/ktraynetworker/${TARGETPD} && kdialog --error "Error while creating: ${KXDPREFIX}/share/apps/ktraynetworker/${TARGETPD}" && exit 1
			 ! tar -jxf themes.tar.bz2 -C ${KXDPREFIX}/share/apps/ktraynetworker/${TARGETPD} && kdialog --error "Error while decompressing resources" && exit 1
			 
			 kdialog --msgbox "Installation successfully into: ${KXDPREFIX}/share/apps/kxdocker"
		 
			 ;;
			 *)
		echo "Installation aborted";
		exit 1;

			 ;;
		 esac
}

pass2()
{
	KXDPREFIX=`kdialog --inputbox "Please insert PREFIX where install resources (pass 2/3)" "$KXDPREFIX"`
	if ! [ "$KXDPREFIX" == "" ];
	then
		SURE=`kdialog --yesno "Are you sure to install resources in ${KXDPREFIX}/share/apps/ktraynetworker/? (pass 3/3)" && echo "yes"`;
		pass3 $SURE;
	else
              echo "Installation aborted";
              exit 1;
	fi
}


if ! [ "$DISPLAY" == "" ];
then
	kdialog --msgbox "XIA Projects Resource installer $KXDRSCVER";
	ISLOCAL=`kdialog --radiolist "Where do you like to install resources (pass 1/3)" local "Local user directory (HOME)" 0 global "Global MultiUser install (KDEDIR)" 0`

	case "$ISLOCAL" in
		global)
			KXDPREFIX=`find_KDE_global "$1"`
			pass2
		;;
		local)
			KXDPREFIX=`find_KDE_local "$1"`
			pass2
		;;
		*)
		echo "Installation aborted";
		exit 1;
		;;
	esac

else
	echo "You have to run this script under X environment with KDE correctly installed";
	exit 1;
fi

