/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTRAYNETICON_H
#define KTRAYNETICON_H

#include <ksystemtray.h>
#include <kiconloader.h>
#include <kpixmap.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qwmatrix.h>
#include <qpaintdevice.h>
#include <qimage.h>


/**
@author Stefano
*/
class KTrayNetIcon : public KSystemTray
{
Q_OBJECT
public:
    KTrayNetIcon(QWidget *parent = 0, const char *name = 0, QWidget *newp=0);

    ~KTrayNetIcon();
    const QPixmap  getActiveIcon();
    const QPixmap  getBaseIcon();
    const QPixmap  & getDeviceImage();
    const QPixmap & createIcon(int,int);
    void enableBase(int isEnabled=1);
    bool isEnabledBase();
    bool isEnabledScale();
    void enableScaleIcon(int isEnable=1);
    void removeMenu();
    QStringList linkCmd;
protected:
    KIconLoader KDEIconLoader;
    QPixmap ActiveIcon;
    QPixmap libIcons[7];
    QPixmap libIconsScale[2][11];
    //QPixmap libIconsScaleTX[11];
    
    int isRed;
    int isGreen;
    int isOff;
    int haveBaseIcon;
    int haveScaleIcon;
    QWidget *MainWnd;
    
    int fixSize;

public slots:
    void IconShow();
    void IconHide();
    void setIconReceived(int);
    void setIconTrasmit(int);
    void Step();
    void LoadTheme(const QString &newTheme= QString::null, const QString &newbase=QString::null);
    void setIconOff();
    void menuAction(int);
    void menuAction0();
    void menuAction1();
    void menuAction2();
    void menuAction3();
    void menuAction4();
    void setSize(int);
signals:
    void themeChange(const QString &NewName);
protected:
    void contextMenuAboutToShow(KPopupMenu *menu);
};

#endif
