/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ktn_names.h"
#include <kstandarddirs.h>
#include <klocale.h>

KTN_Names *ktnNames;

KTN_Names::KTN_Names(QObject *parent, const char *name)
 : QObject(parent, name)
{
	bnep=i18n("Bluetooth PAN connection");
	eth=i18n("Ethernet connection");
	ppp=i18n("Dialup connection");
	ippp=i18n("ISDN Dialup connection");
	wlan=i18n("Wireless connection");
	irda=i18n("Infrared port");
	tap=i18n("Virtual device");
	tun=i18n("Tunnel connection");
	usb=i18n("USB networking");
	sit=i18n("Ethernet IPV6 connection");
	lo=i18n("Loopback connection");
	unknow=i18n("Unknown network device");
	tbnep="/bnep/";
	teth="/eth/";
	tppp="/ppp/";
	tippp="/ippp/";
	twlan="/wifi/";
	tirda="/irda/";
	ttap="/tun/";
	ttun="/tun/";
	tusb="/usb/";
	tsit="/eth/";
	tlo="/lo/";
	tunknow="/lo/";
	bbnep="kdebluetooth";
	beth="kcmpci";
	bsit="package_network";
	blo="package_network";
	bunknow="kcmpci";
	bppp="kppp";
	bippp="kppp";
	bwlan="wifi";
	birda="irda";
	btap="pipe";
	btun="pipe";
	busb="usb";
	
	icieth.append("Enable Ethernet connection");
	icieth.append("Disable Ethernet connection");
	icieth.append("Enable IP Forwarding");
	icieth.append("Disable IP Forwarding");
	icieth.append("Run YaST");
	
	icibnep.append("");
	icibnep.append("");
	icibnep.append("");
	icibnep.append("");
	icibnep.append("");
	
	icisit.append("Enable Ethernet connection");
	icisit.append("Disable Ethernet connection");
	icisit.append("Enable IP Forwarding");
	icisit.append("Disable IP Forwarding");
	
	icisit.append("Run YaST");
	
	icilo.append("Run YaST");
	
	iciunknow.append("Run YaST");
	
	iciippp.append("Connect");
	iciippp.append("Disconnect");
	iciippp.append("Enable NAT");
	iciippp.append("Disable NAT");
	iciippp.append("Run YaST");
	
	iciiippp=iciippp;
	//iciiippp.append();
	iciwlan.append("Enable Wireless connection");
	iciwlan.append("Disable Wireless connection");
	iciwlan.append("Run KWifiManager");
	iciwlan.append("Restart WIFI Networking");
	iciwlan.append("Run YaST");
	
	iciirda.append("Receive from Winzoz");
	iciirda.append("Send file to Winzoz");
	iciirda.append("Enable Discovery");
	iciirda.append("Disable Discovery");
	iciirda.append("Start Wireless LAN");
	
	icitap=icilo;
	icitun=icitap;
	iciusb=icisit;

	cieth.append("ok");
	cieth.append("stop");
	cieth.append("up");
	cieth.append("down");
	cieth.append("kcontrol");
	
	cibnep.append("ok");
	cibnep.append("ok");
	cibnep.append("ok");
	cibnep.append("ok");
	cibnep.append("ok");
	
	
	cisit=cieth;
	cilo.append("kcontrol");
	ciunknow=cilo;
	ciippp.append("connect_creating");
	ciippp.append("connect_no");
	ciippp.append("up");
	ciippp.append("down");
	ciippp.append("kcontrol");
	ciiippp=ciippp;
	
	ciwlan.append("ok");
	ciwlan.append("stop");
	ciwlan.append("kwifimanager");
	ciwlan.append("reload");
	ciwlan.append("kcontrol");
	
	ciirda.append("mail_get");
	ciirda.append("mail_send");
	ciirda.append("viewmag+.png");
	ciirda.append("stop");
	ciirda.append("ok");
	citap=cilo;
	citun=cilo;
	ciusb=cilo;

	ceth.append("/sbin/ifup ");
	ceth.append("/sbin/ifdown ");
	ceth.append("/etc/rc.d/init.d/iptables start");
	ceth.append("/etc/rc.d/init.d/iptables stop");
	ceth.append("YaSTadminSession");
	
	cbnep.append("");
	cbnep.append("");
	cbnep.append("");
	cbnep.append("");
	cbnep.append("");
	
	csit=ceth;	
	clo.append("YaSTadminSession");
	cunknow=clo;
	cppp=ceth;
	cippp=cppp;
	cwlan.append("/sbin/ifup ");
	cwlan.append("/sbin/ifdown ");
	cwlan.append("kwifimanager");
	cwlan.append("/etc/rc.d/init/wifi restart;");
	cwlan.append("YaSTadminSession");
	cirda.append("irxfer");
	cirda.append("irxfer `kdialog --getopenurl $HOME \"*\"`");
	cirda.append("echo 1 > /proc/sys/net/irda/discovery");
	cirda.append("echo 0 > /proc/sys/net/irda/discovery");
	cirda.append("/sbin/ifup irlan0 ;");
	ctap=clo;
	ctun=clo;
	cusb=clo;
	
}


KTN_Names::~KTN_Names()
{
}


#include "ktn_names.moc"


/*!
    \fn KTN_Names::makeDeviceName(const QString &)
 */
const QString & KTN_Names::makeDeviceName(const QString &eth0)
{
	//qWarning(eth0);
	QString devname=eth0;
	QString number;
	bool returncode=false;
	if(devname.length()<1)return QString::null;
	//qWarning("makeDeviceName");
	number=devname[devname.length()-1];
	int ndev=number.toInt(&returncode);
	if(returncode==true)
	{
		devname.truncate(devname.length()-1);
	}
	if(devname=="eth")return eth;
	if(devname=="sit")return sit;
	if(devname=="lo")return lo;
	if(devname=="bnep")return bnep;
	if(devname=="ppp")return ppp;
	if(devname=="ippp")return ippp;
	if(devname=="wlan")return wlan;
	if(devname=="irda")return irda;
	if(devname=="tap")return tap;
	if(devname=="tun")return tun;
	if(devname=="usb")return usb;

	return unknow;

}


/*!
    \fn KTN_Names::makeDeviceTheme(const QString &)
 */
const QString & KTN_Names::makeDeviceTheme(const QString &eth0)
{
	//qWarning(eth0);
	QString devname=eth0;
	QString number;
	bool returncode=false;
	if(devname.length()<1)return QString::null;
	//qWarning(QString("makeDeviceTheme %1").arg(eth0));
	number=devname[devname.length()-1];
	int ndev=number.toInt(&returncode);
	if(returncode==true)
	{
		devname.truncate(devname.length()-1);
	}
	//qWarning(QString("DeviceType %1").arg(devname));
	filename="ktraynetworker/themes/";
	if(devname=="eth")filename=filename+teth;
	if(devname=="sit")filename=filename+tsit;
	if(devname=="lo")filename=filename+tlo;
	if(devname=="bnep")filename=filename+tbnep;
	if(devname=="ppp")filename=filename+tppp;
	if(devname=="ippp")filename=filename+tippp;
	if(devname=="wlan")filename=filename+twlan;
	if(devname=="irda")filename=filename+tirda;
	if(devname=="tap")filename=filename+ttap;
	if(devname=="tun")filename=filename+ttun;
	if(devname=="usb")filename=filename+tusb;
	//qWarning(filename);
	filename=::locate("data",filename );
	if(filename==QString::null)
	{
	filename="ktraynetworker/themes/default/";//netactivity_none.png";
	filename=::locate("data",filename );
	}
	if(filename==QString::null)return QString::null;
	return filename;
}


/*!
    \fn KTN_Names::makeDeviceBase(const QString &)
 */
const QString & KTN_Names::makeDeviceBase(const QString &eth0)
{
	//qWarning(eth0);
	QString devname=eth0;
	QString number;
	bool returncode=false;
	if(devname.length()<1)return QString::null;
	//qWarning("makeDeviceName");
	number=devname[devname.length()-1];
	int ndev=number.toInt(&returncode);
	if(returncode==true)
	{
		devname.truncate(devname.length()-1);
	}
	if(devname=="eth")return beth;
	if(devname=="sit")return bsit;
	if(devname=="lo")return blo;
	if(devname=="bnep")return bnep;
	if(devname=="ppp")return bppp;
	if(devname=="ippp")return bippp;
	if(devname=="wlan")return bwlan;
	if(devname=="irda")return birda;
	if(devname=="tap")return btap;
	if(devname=="tun")return btun;
	if(devname=="usb")return busb;
	
	return unknow;
}



/*!
    \fn KTN_Names::getResourcePath()
 */
const QString & KTN_Names::getResourcePath()
{
    /// @todo implement me
}


/*!
    \fn KTN_Names::getLinkCmd(const QString &iName,int index)
 */
const QString & KTN_Names::getLinkCmd(const QString &eth0,int index)
{
	//qWarning(eth0);
	QString devname=eth0;
	QString number;
	bool returncode=false;
	if(devname.length()<1)return QString::null;
	//qWarning("makeDeviceName");
	number=devname[devname.length()-1];
	int ndev=number.toInt(&returncode);
	if(returncode==true)
	{
		devname.truncate(devname.length()-1);
	}

	if(index<0)index=0;
	if(index>4)index=4;
	if(devname=="eth")
	{
		temp=ceth[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="sit")
	{
		temp=csit[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="lo")
	{
		temp=clo[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="ppp")
	{
		temp=cppp[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="bnep")
	{
		temp=cbnep[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="ippp")
	{
		temp=cippp[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="wlan")
	{
		temp=cwlan[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="irda")
	{
		temp=cirda[index];
		//temp=temp+eth0;
		return temp;
	}
	if(devname=="tap")
	{
		temp=ctap[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="tun")
	{
		temp=ctun[index];
		temp=temp+eth0;
		return temp;
	}
	if(devname=="usb")
	{
		temp=cusb[index];
		temp=temp+eth0;
		return temp;
	}
	
}


/*!
    \fn KTN_Names::getiLinkCmd(const QString &, int index)
 */
const QString & KTN_Names::getiLinkCmd(const QString &eth0, int index)
{
	//qWarning(eth0);
	QString devname=eth0;
	QString number;
	bool returncode=false;
	if(devname.length()<1)return QString::null;
	//qWarning("makeDeviceName");
	number=devname[devname.length()-1];
	int ndev=number.toInt(&returncode);
	if(returncode==true)
	{
		devname.truncate(devname.length()-1);
	}

	if(index<0)index=0;
	if(index>4)index=4;
	if(devname=="eth")return cieth[index];
	if(devname=="sit")return cisit[index];
	if(devname=="lo")return cilo[index];
	if(devname=="ppp")return ciippp[index];
	if(devname=="bnep")return cibnep[index];
	if(devname=="ippp")return ciiippp[index];
	if(devname=="wlan")return ciwlan[index];
	if(devname=="irda")return ciirda[index];
	if(devname=="tap")return citap[index];
	if(devname=="tun")return citun[index];
	if(devname=="usb")return ciusb[index];
}


/*!
    \fn KTN_Names::getLink(const QString &, int index)
 */
const QString & KTN_Names::getLink(const QString &eth0, int index)
{
	//qWarning(eth0);
	QString devname=eth0;
	QString number;
	bool returncode=false;
	if(devname.length()<1)return QString::null;
	//qWarning("makeDeviceName");
	number=devname[devname.length()-1];
	int ndev=number.toInt(&returncode);
	if(returncode==true)
	{
		devname.truncate(devname.length()-1);
	}

	if(index<0)index=0;
	if(index>4)index=4;
	if(devname=="eth")return icieth[index];
	if(devname=="sit")return icisit[index];
	if(devname=="lo")return icilo[index];
	if(devname=="bnep")return icibnep[index];
	if(devname=="ppp")return iciippp[index];
	if(devname=="ippp")return iciiippp[index];
	if(devname=="wlan")return iciwlan[index];
	if(devname=="irda")return iciirda[index];
	if(devname=="tap")return icitap[index];
	if(devname=="tun")return icitun[index];
	if(devname=="usb")return iciusb[index];

}
