/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ktrayneticon.h"
#include <qbitmap.h>
#include <kpopupmenu.h>
#include <krun.h>
#include <kpixmapio.h>
#include <kpixmap.h>
#include <kimageeffect.h>


KTrayNetIcon::KTrayNetIcon(QWidget *parent, const char *name, QWidget *newp)
 : KSystemTray(parent, name)
{
	isRed=0;
	isGreen=0;
	isOff=0;
	haveBaseIcon=0;
	KPopupMenu *Menu=contextMenu();
	MainWnd=newp;
	Menu->insertItem(
		QIconSet(KDEIconLoader.loadIcon("wizard",KIcon::Small)),
		"Wizard...", 
		MainWnd, 
		SLOT(runWizardAgain()));
	//connect(Menu->contextMenu(),SIGNAL(activated(int)),this,SLOT(menuAction(int )));
	//connect(Menu->contextMenu(),SIGNAL(highlighted(int)),this,SLOT(menuAction(int )));
	linkCmd.append("");
	linkCmd.append("");
	linkCmd.append("");
	linkCmd.append("");
	linkCmd.append("");
	linkCmd.append("");
	linkCmd.append("");
	fixSize=KIcon::Small;
}


KTrayNetIcon::~KTrayNetIcon()
{
}


#include "ktrayneticon.moc"


/*!
    \fn KTrayNetIcon::IconShow()
 */
void KTrayNetIcon::IconShow()
{
    show();
}


/*!
    \fn KTrayNetIcon::IconHide()
 */
void KTrayNetIcon::IconHide()
{
    hide();
}


/*!
    \fn KTrayNetIcon::setIconReceived()
 */
void KTrayNetIcon::setIconReceived(int delta)
{
	isGreen=delta;
	if(haveBaseIcon>0 or haveScaleIcon>0)
	{
		ActiveIcon=createIcon(isGreen,isRed);

	}
	else
	{
		if(isRed>0)ActiveIcon = libIcons[3];
		else ActiveIcon = libIcons[1];
//		QBitmap maskera=QBitmap(*ActiveIcon.mask());
		//QBitmap maskera=ActiveIcon.createHeuristicMask();
		//setMask(maskera);

	}
	isOff=0;
}


/*!
    \fn KTrayNetIcon::setIconTrasmit()
 */
void KTrayNetIcon::setIconTrasmit(int delta)
{
	isRed=delta;
	if(haveBaseIcon>0 or haveScaleIcon>0)createIcon(isGreen,isRed);
	else
	{
		if(isGreen==1)ActiveIcon = libIcons[3];
		else ActiveIcon = libIcons[2];
		//QBitmap maskera=QBitmap(*ActiveIcon.createHeuristicMask());
		//QBitmap maskera=ActiveIcon.createHeuristicMask();
		//setMask(maskera);

	}
	isOff=0;
}


/*!
    \fn KTrayNetIcon::Step()
 */
void KTrayNetIcon::Step()
{
	// 0.9
	// setPixmap(ActiveIcon);
	
	if(isOff==0){
		//bitBlt(this,0,0,&ActiveIcon,0,Qt::CopyROP);
		 setPixmap(ActiveIcon);
		ActiveIcon = libIcons[0];
	}
	else
	{
		setPixmap(ActiveIcon);
	}
	isRed=0;
	isGreen=0;
}


/*!
    \fn KTrayNetIcon::getActiveIcon()
 */
const QPixmap KTrayNetIcon::getActiveIcon()
{
	return ActiveIcon;
}


/*!
    \fn KTrayNetIcon::LoadTheme(const QString &newTheme)
 */
void KTrayNetIcon::LoadTheme(const QString &newTheme,const QString &newBaseIcon)
{
    if(newTheme=="")
    {
        if(newBaseIcon!="")
    {
    	libIcons[5]=loadIcon(newBaseIcon);
    	//haveBaseIcon=1;
    }

	libIcons[0]=loadIcon("netactivity_none");
    	libIcons[1]=loadIcon("netactivity_rx");
    	libIcons[2]=loadIcon("netactivity_tx");
    	libIcons[3]=loadIcon("netactivity_full");
    	libIcons[4]=loadIcon("netactivity_off");
	libIcons[6]=loadIcon("netactivity_image");

	for(int iscale=0; iscale<11;iscale++)
	{
		char createName[50];
		//strcpy(createName,"netactivity_scale_");
		sprintf(createName,"netactivity_scalerx%d",iscale);
		qWarning(createName);
		libIconsScale[0][iscale]=loadIcon(createName);
	}
	for(int iscale=0; iscale<11;iscale++)
	{
		char createName[50];
		//strcpy(createName,"netactivity_scale_");
		sprintf(createName,"netactivity_scaletx%d",iscale);
		qWarning(createName);
		libIconsScale[1][iscale]=loadIcon(createName);
	}
    }
    else
    {
    // we have the path where load icons
    QString iconName=newTheme+"netactivity_none.png";
    qWarning(iconName);
    if(newBaseIcon!="")
    {
    	libIcons[5]=loadIcon(newBaseIcon);//KDEIconLoader.,KIcon::Small);
    	//haveBaseIcon=1;
    }
   if(
    libIcons[0].load(iconName)
    ==
    false)libIcons[0]=loadIcon("netactivity_none");
    iconName=newTheme+"netactivity_rx.png";
    qWarning(iconName);
    if(libIcons[1].load(iconName)==false)libIcons[1]=loadIcon("netactivity_rx");
    iconName=newTheme+"netactivity_tx.png";
    qWarning(iconName);
    if(libIcons[2].load(iconName)==false)libIcons[2]=loadIcon("netactivity_tx");
    iconName=newTheme+"netactivity_full.png";
    qWarning(iconName);
    if(libIcons[3].load(iconName)==false)libIcons[3]=loadIcon("netactivity_full");
    iconName=newTheme+"netactivity_off.png";
    qWarning(iconName);
    if(libIcons[4].load(iconName)==false)libIcons[4]=loadIcon("netactivity_off");
    iconName=newTheme+"netactivity_image.png";    
    if(libIcons[6].load(iconName)==false)
    {
    	libIcons[6]=loadIcon("netactivity_image");
    	qWarning("errore nel caricamento image");
	
    }
    
    	for(int iscale=0; iscale<11;iscale++)
	{
		char createName[50];
		//strcpy(createName,"netactivity_scale_");
		sprintf(createName,"netactivity_scalerx%d.png",iscale);
		iconName=newTheme+createName;
		qWarning(iconName);
		if(libIconsScale[0][iscale].load(iconName)==false)
		{
		qWarning("errore nel caricamento");
		}
	}

    	for(int iscale=0; iscale<11;iscale++)
	{
		char createName[50];
		//strcpy(createName,"netactivity_scale_");
		sprintf(createName,"netactivity_scaletx%d.png",iscale);
		iconName=newTheme+createName;
		qWarning(iconName);
		if(libIconsScale[1][iscale].load(iconName)==false)
		{
		qWarning("errore nel caricamento");
		}
	}
    
    
    }
	// 22 is standard small iconset?
	for (int iremax=0;iremax<7;iremax++)
	{
	if(fixSize!=KIcon::Small)
	{
		KPixmapIO kImgConverter;
		QImage xImgSource=kImgConverter.convertToImage(libIcons[iremax]);
		xImgSource=xImgSource.smoothScale(fixSize,fixSize);
		libIcons[iremax]=kImgConverter.convertToPixmap(xImgSource);
		//qWarning(QString("fixed size %1").arg(fixSize));
	}
	}
    setIconOff();
    Step();
	setPixmap(ActiveIcon);
    themeChange(newTheme);
}


/*!
    \fn KTrayNetIcon::setIconOff()
 */
void KTrayNetIcon::setIconOff()
{
	ActiveIcon = libIcons[4];
	isRed=0;
	isGreen=0;
	isOff=1;
}


/*!
    \fn KTrayNetIcon::getBaseIcon()
 */
const QPixmap KTrayNetIcon::getBaseIcon()
{
	if(haveBaseIcon)return libIcons[5];
	return libIcons[0];
}

/*!
    \fn KTrayNetIcon::createIcon(int,int)
 */
const QPixmap & KTrayNetIcon::createIcon(int RXScale,int TXScale)
{
	// this function load the base icon
	// and add the 2 scale
	// 0->10



	QPixmap createdIcon;
	if(haveBaseIcon>0)createdIcon=libIcons[5];
	else createdIcon=libIcons[0];
	//QBitmap maskera=QBitmap(*createdIcon.mask());
	if(RXScale>10)RXScale=10;
	if(RXScale<0)RXScale=0;
	if(TXScale>10)TXScale=10;
	if(TXScale<0)TXScale=0;
		
	//QImage merge;
	//merge.=libIconsScale[0][RXScale];
	//QPaintDevice pm(&createdIcon);
	//createdIcon.bitBlt(pm, 0,0,merge, 0, 0, -1, -1, Qt::CopyROP,false);     
	//bitBlt(&pm,QPoint(0,0),&libIconsScale[0][RXScale],QRect(0,0,-1,-1),Qt::CopyROP);
	//pm.end();
	//char pippo[59];
	//sprintf(pippo,"%d %d",RXScale,TXScale);
	//qWarning(pippo);
	bitBlt(&createdIcon,0,0,&libIconsScale[0][RXScale],0,Qt::CopyROP);
	bitBlt(&createdIcon,0,0,&libIconsScale[1][TXScale],0,Qt::CopyROP);
//	copyBlt(&createdIcon,0,0,&libIconsScale[0][RXScale]);
//	copyBlt(&createdIcon,0,0,&libIconsScale[1][TXScale]);
	//maskera.fill(Qt::color0);
	//QBitmap maskera=createdIcon.createHeuristicMask();
	//setMask(maskera);
	ActiveIcon=createdIcon;
	// 22 is standard small iconset?
	if(fixSize!=KIcon::Small)
	{
		KPixmapIO kImgConverter;
		QImage xImgSource=kImgConverter.convertToImage(ActiveIcon);
		xImgSource=xImgSource.smoothScale(fixSize,fixSize);
		ActiveIcon=kImgConverter.convertToPixmap(xImgSource);
		//qWarning(QString("fixed size %1").arg(fixSize));
	}
/*
	if(isOff)
	{
		createIcon(10,10);
		QBitmap maskera=QBitmap(*createdIcon.mask());
		setMask(maskera);
		//setPixmap(ActiveIcon);
		//createIcon();
	}*/

	return ActiveIcon;
}


/*!
    \fn KTrayNetIcon::enableBase()
 */
void KTrayNetIcon::enableBase(int isEnable)
{
	haveBaseIcon=isEnable;
}


/*!
    \fn KTrayNetIcon::contextMenuAboutToShow 
( 
KPopupMenu * 
menu 
 ) 
 */
void KTrayNetIcon::contextMenuAboutToShow 
( 
KPopupMenu * 
menu 
 ) 
{
}


/*!
    \fn KTrayNetIcon::isEnabledBase()
 */
bool KTrayNetIcon::isEnabledBase()
{
    if(haveBaseIcon>0)return true;
    return false;
}


/*!
    \fn KTrayNetIcon::isEnabledScale()
 */
bool KTrayNetIcon::isEnabledScale()
{
    if(haveScaleIcon>0)return true;
    return false;
}


/*!
    \fn KTrayNetIcon::enableScaleIcon(int isEnable=1)
 */
void KTrayNetIcon::enableScaleIcon(int isEnable)
{
	haveScaleIcon=isEnable;
}


/*!
    \fn KTrayNetIcon::getDeviceImage()
 */
const QPixmap & KTrayNetIcon::getDeviceImage()
{
	return libIcons[6];
}


/*!
    \fn KTrayNetIcon::menuAction()
 */
void KTrayNetIcon::menuAction(int id)
{
}


/*!
    \fn KTrayNetIcon::menuAction0()
 */
void KTrayNetIcon::menuAction0()
{
    qWarning(linkCmd[0]);
	KRun::runCommand(linkCmd[0]);
}


/*!
    \fn KTrayNetIcon::menuAction1()
 */
void KTrayNetIcon::menuAction1()
{
    qWarning(linkCmd[1]);
	KRun::runCommand(linkCmd[1]);
}


/*!
    \fn KTrayNetIcon::menuAction2()
 */
void KTrayNetIcon::menuAction2()
{
    qWarning(linkCmd[2]);
	KRun::runCommand(linkCmd[2]);
}


/*!
    \fn KTrayNetIcon::menuAction3()
 */
void KTrayNetIcon::menuAction3()
{
    qWarning(linkCmd[3]);
	KRun::runCommand(linkCmd[3]);
}


/*!
    \fn KTrayNetIcon::menuAction4()
 */
void KTrayNetIcon::menuAction4()
{
    qWarning(linkCmd[4]);
	KRun::runCommand(linkCmd[4]);
}


/*!
    \fn KTrayNetIcon::removeMenu()
 */
void KTrayNetIcon::removeMenu()
{
	//return;
	//contextMenu()->clear();
	//return;
	int k=2;
	for(int i=0;i<linkCmd.count();i++)
	{
		if(linkCmd[i]!="")
		{
			//k++;
			contextMenu()->removeItemAt(k);
			qWarning(linkCmd[i]);
		}
	}
	
}


/*!
    \fn KTrayNetIcon::setSize(int)
 */
void KTrayNetIcon::setSize(int ns)
{
	qWarning("fixSize setup");
    fixSize=ns;
}
