/*
 * Copyright (C) 2004 Stefano <stefano@xiaprojects.com>
 */

#include "ktraynetworker2.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include "ktn_names.h"

static const char description[] =
    I18N_NOOP("A KDE Tray Network activity monitor");

static const char version[] = "0.5";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
{ "theme <directory>", I18N_NOOP("Directory where I can find themed icons"), 0 },
{ "device <netdev>", I18N_NOOP("Device monitored"), 0 },
{ "speed <ms>", I18N_NOOP("Refresh time in ms"), 0 },
{ "netsession <name>", I18N_NOOP("Set the Name for this icon to store and load ex: modem1 or localnet"), 0 },
    KCmdLineLastOption
};

KTrayNetworker2 *mainWin ;

bool KSessionManaged::saveState( QSessionManager& sm ) {
  //mainWin->saveConfig(mainWin->appSessionConfig);
  mainWin->saveConfig();
  return true;
}

bool KSessionManaged::commitData( QSessionManager& sm ) {
 
  return true;
}


int main(int argc, char **argv)
{
    KAboutData about("ktraynetworker", I18N_NOOP("KTrayNetworker"), version, description,
                     KAboutData::License_GPL, "(C) 2004 Stefano", 0, 0, "stefano@xiaprojects.com");
    about.addAuthor( "Stefano", 0, "stefano@xiaprojects.com" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    mainWin = 0;
    ktnNames= new KTN_Names();
    //app.enableSessionManagement();
    //if(app.sessionSaving()==true)qWarning("Session will be restored");
    KSessionManaged ksm;
 /*
    if (app.isRestored())
    {
        //RESTORE(KTrayNetworker);
	qWarning("KTrayNetworker Restoring...");
	
	QStringList sInstances=KGlobal::config()->groupList();
	//QStringList sInstances=app.config()->groupList();
	
	for(int nInstances=0;nInstances<sInstances.count();nInstances++)
	{
		qWarning(sInstances[nInstances]);
		KConfig *localconfig=KGlobal::config();
		localconfig->setGroup(sInstances[nInstances]);
		if(localconfig->readEntry("KTrayNetworkerStart")=="yes")
		{
			qWarning("it will be showed");
	        	mainWin = new KTrayNetworker();
			mainWin->loadSession(sInstances[nInstances]);
        		//app.setMainWidget(mainWin);
			//mainWin->readConfig();
//			mainWin->appSessionConfig=app.sessionConfig();
			mainWin->workStart();
			break;
		}
	}
	if(mainWin==0)
	{
		return 0;
	}
	
    }
    else
    */
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        mainWin = new KTrayNetworker2();
	//mainWin->show();
        app.setMainWidget( mainWin );
//	mainWin->appSessionConfig=app.sessionConfig();
	QString anotherOptionArg = args->getOption("netsession");
	if(anotherOptionArg!="")
	{
		qWarning(anotherOptionArg);
		// ok we have to load this theme
		mainWin->loadSession(anotherOptionArg);
	}
	else mainWin->readConfig();
	anotherOptionArg = args->getOption("theme");
	if(anotherOptionArg!="")
	{
		qWarning(anotherOptionArg);
		// ok we have to load this theme
		mainWin->changeTheme(anotherOptionArg);
	}
	 /*
	 anotherOptionArg = args->getOption("device");
	if(anotherOptionArg!="")
	{
		qWarning(anotherOptionArg);
		// ok we have to load this theme
		mainWin->updateDev(anotherOptionArg);
	}
	*/
	 anotherOptionArg = args->getOption("speed");
	if(anotherOptionArg!="")
	{
		qWarning(anotherOptionArg);
		// ok we have to load this theme
		mainWin->updateSpeed(anotherOptionArg);
	}
	//mainWin->show();
	mainWin->workStart();
        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

