/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTRAYNETWORKER2_H
#define KTRAYNETWORKER2_H

#include <qwidget.h>

#include <kmainwindow.h>
#include <qlabel.h>

#include <qtimer.h>
#include <qcombobox.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <kconfig.h>
#include <qcheckbox.h>
#include <klistview.h>
#include <qlistview.h>
#include <kicondialog.h>
#include <kiconview.h>
#include <qbuttongroup.h>
#include <qdatetime.h>
#include <qradiobutton.h>

#include "ktn_proc.h"
#include "proc.h"
#include "ktrayneticon.h"


/**
@author Stefano
*/
class KTrayNetworker2  : public KMainWindow
{
Q_OBJECT
public:
    KTrayNetworker2();

    ~KTrayNetworker2();
    void readConfig(KConfig *Restoring=NULL);
    void saveConfig(KConfig *Restoring=NULL);
    void readProperties(KConfig* config);
    void loadSession(const QString &);
    void resetStatics();
    void createTray(int index);
    KConfig 	*Restore;
    KTrayNetIcon *TrayIcons[10];
    class KTN_User	*UserGUI[10];
    
    QTimer *ElapsedTime;
    long int Status;
    //Proc proc;
    KTN_Proc proc;
    
    float totalIn[10];
    float totalOut[10];
    float scaleTX[10];
    float scaleRX[10];
    float deltaRX[10];
    float deltaTX[10];
    float lastValueTX[10];
    float lastValueRX[10];
    int hideIfOff[10];
    QTime deviceTime[10];
    
    QStringList		devicesLink0;
    QStringList		devicesLink1;
    QStringList		devicesLink2;
    QStringList		devicesLink3;
    QStringList		devicesLink4;

    QStringList		devicesLinkCmd0;
    QStringList		devicesLinkCmd1;
    QStringList		devicesLinkCmd2;
    QStringList		devicesLinkCmd3;
    QStringList		devicesLinkCmd4;
    
    QStringList		devicesiLink0;
    QStringList		devicesiLink1;
    QStringList		devicesiLink2;
    QStringList		devicesiLink3;
    QStringList		devicesiLink4;
    
    QStringList		devicesAutoScale;
    QStringList		devicesList;
    QStringList		devicesName;
    QStringList		devicesTheme;
    QStringList		devicesBase;
    QStringList		devicesType;
    QStringList		devicesScale;
    
    int			devicesThemeType[10];    

public slots:
    void Step();
    void updateSpeed(const QString &);
    void changeTheme(const QString &,const QString &a=QString::null);
    void workStart();
    bool queryClose();
    void askClose();
    void updateTXScale(int);
    void updateRXScale(int);
    bool queryExit();
    void TrayPopupClick(int id);
    void runWizardAgain();
    void userGUIConfigure(const KTN_User *);
protected:
    void saveProperties(KConfig* config);
    void runWizard();
    void createTrays();
    int cSpeed;

};

#endif
