#if 0
# -----------------------------------------------------------------------
# freevo_config.py - System configuration
# -----------------------------------------------------------------------
# $Id: local_conf.py.example,v 1.37.2.4 2005/01/09 10:45:55 dischi Exp $
#
# Notes:
#    This file contains the freevo settings. To change the settings
#    you can edit this file, or better, put a file named local_conf.py
#    # in the same directory and add your changes there.  E.g.: when
#    you # want a alsa as mplayer audio out, just put
#    "MPLAYER_AO_DEV = # 'alsa9'" in local_conf.py
#
#    This is no normal config file, it's Python code. Because of that, you 
#    need to follow some rules to avoid crashes. The examples should explain
#    the settings, but make sure a line starting with a variable has 
#    NO SPACES OR TABS at the beginning.
#
#
# -----------------------------------------------------------------------
# Freevo - A Home Theater PC framework
# Copyright (C) 2002 Krister Lagerstrom, et al. 
# Please see the file freevo/Docs/CREDITS for a complete list of authors.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MER-
# CHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# -----------------------------------------------------------------------
#endif




CONFIG_VERSION = 5.15

# ======================================================================
# General freevo settings:
# ======================================================================

AUDIO_DEVICE        = '/dev/sound/dsp'      # e.g.: /dev/dsp0, /dev/audio, /dev/alsa/?
AUDIO_INPUT_DEVICE  = '/dev/sound/audio'     # e.g.: /dev/dsp0, /dev/audio, /dev/alsa/?
MAJOR_AUDIO_CTRL    = 'VOL'           # Freevo takes control over one audio ctrl
                                        # 'VOL', 'PCM' 'OGAIN' etc.
CONTROL_ALL_AUDIO   = 0               # Should Freevo take complete control of audio
MAX_VOLUME          = 100              # Set what you want maximum volume level to be.
DEFAULT_VOLUME      = 40              # Set default volume level.
# TV_IN_VOLUME        = 60              # Set this to your preferred level 0-100.
# VCR_IN_VOLUME       = 90              # If you use different input from TV
DEV_MIXER           = '/dev/sound/mixer'    # mixer device 

START_FULLSCREEN_X  = 0               # Start in fullscreen mode if using x11 or xv.

CONFIRM_SHUTDOWN    = 0               # ask before shutdown

#
# Physical ROM drives, multiple ones can be specified
# by adding comma-seperated and quoted entries.
#
# Format [ ('mountdir1', 'devicename1', 'displayed name1'),
#          ('mountdir2', 'devicename2', 'displayed name2'), ...]
#
# Set to None to autodetect drives in during startup from /etc/fstab,
# set to [] to disable rom drive support at all
#
# ROM_DRIVES = None

#
# Hide discs from the wrong menu (e.g. VCDs in audio menu) and empty discs.
#
HIDE_UNUSABLE_DISCS = 1               

#
# Attempt to set the speed of the ROM drive. A good value for keeping the
# drive silent while playing movies is 8.
#
# ROM_SPEED = 0                

#
# Perform a whole system shutdown at SHUTDOWN! Useful for standalone boxes.
#
# ENABLE_SHUTDOWN_SYS = 0

#
# You can add more keybindings by adding them to the correct hash. 
# e.g. If you want to send 'contrast -100' to mplayer by pressing the '1' key, 
# just add the following line: 
#
# EVENTS['video']['1'] = Event(VIDEO_SEND_MPLAYER_CMD, arg='contrast -100')
#
# See src/event.py for a list of all possible events.

#
# Use arrow keys for back and select (alternate way of navigating)
#
# MENU_ARROW_NAVIGATION = 0

#
# Keymap to map keyboard keys to event strings. You can also add new keys
# here, e.g. KEYMAP[key.K_x] = 'SUBTITLE'. The K_-names are defined by pygame.
#

#
# Use Internet resources to fetch information?
# For example, Freevo can use CDDB for album information,
# the IMDB movie database for movie info, and Amazon for cover searches. 
# Set this to 0 if your computer isn't connected to a network.
#
USE_NETWORK = 1

#
# Directory location to save files when the normal filesystem
# doesn't allow saving. This directory can save covers and fxd files
# for read only filesystems like ROM drives. Set this variable to your
# old MOVIE_DATA_DIR if you have one. It needs to be set to a directory
# Freevo can write to.
#
# OVERLAY_DIR = os.path.join(FREEVO_CACHEDIR, 'vfs')

#
# Umask setting for all files.
# 022 means only the user has write access. If you share your Freevo
# installation with different users, set this to 002
#
# UMASK = 022

#
# Suffix for playlist files
#
# PLAYLIST_SUFFIX = [ 'm3u' ]

#
# Use md5 in mmpython to create unique disc ids. Enable this if you have
# problems with different discs having the same id.
#
# MMPYTHON_CREATE_MD5_ID = 0

#
# Keep metadata in memory
# Setting this variable will keep all cache files in memory. Startup will be
# slower, but for large directories, this will speed up the display.
# 0 = Only keep current dir in memory. Use this if you have too much data
#     and not enough RAM
# 1 = Once loaded, keep cachefile for directory in memory
# 2 = Load all cachefiles on startup
#
# WARNING: you should not run 'freevo cache' when freevo is running.
#
MEDIAINFO_USE_MEMORY   = 1

#
# Cache images. This uses a lot of disc space but it's a huge speed
# enhancement. The images will be cached in OVERLAY_DIR
#
CACHE_IMAGES = 1


# ======================================================================
# Plugins:
# ======================================================================

# Remove undesired plugins by setting plugin.remove(code). 
# You can also use the name to remove a plugin. But if you do that, 
# all instances of this plugin will be removed.
#
# Examples:
# plugin.remove(plugin_tv) or
# plugin.remove('tv') will remove the tv module from the main menu
# plugin.remove(rom_plugins['image']) will remove the rom drives from the
#   image main menu,
# plugin.remove('rom_drives.rom_items') will remove the rom drives from all
#   menus
#
# See freevo_config.py for a list of loaded plugins
#plugin.activate('record.dvb', args='dvb0')

plugin.activate('weather', level=45)
PLUGIN_WEATHER_LOCATIONS = [ ("ITXX0059", 1, "Pisa"), ("ITXX0031", 1, "SEM")]

#
# Use ivtv_record instead if you have an ivtv based card (PVR-250/350)
# and want freevo to do everthing for you. TV_SETTINGS must be set 
# correctly. To use you need to set the following two lines:
#
# plugin.remove('tv.generic_record')
# plugin_record = plugin.activate('tv.ivtv_record')

#
# Enable this for joystick support:
plugin.activate('joy')
plugin.activate('idlebar')
plugin.activate('idlebar.volume')
plugin.activate('idlebar.system.procstats')
#plugin.activate('idlebar.system.sensors ')
plugin.activate('idlebar.MultiMail.MultiMail')
plugin.activate('idlebar.clock')
plugin.activate('idlebar.cdstatus')
#plugin.activate('idlebar.mail')
plugin.activate('idlebar.holidays')
#plugin.activate('idlebar.weather')
#plugin.activate('audio.coversearch')
plugin.activate('audio.playlist')
#plugin.activate('video.details')
#plugin.activate('freevoscreensaver')
#plugin.activate('audio.radioplayer')
#plugin.activate('audio.radio')
#plugin.activate('image.apod','/video')
#plugin.activate('image.gphoto')
#plugin.activate('mediamenu')
#plugin.activate('usbstorage')
SKIN_XML_FILE = 'noia'

plugin.remove('audio.xine')
plugin.remove('video.xine')

# ======================================================================
# Freevo directory settings:
# ======================================================================

# You can change all this variables in the folder.fxd on a per folder
# basis
#
# Example:
# <freevo>
#   <folder title="Title of the directory" img-cover="nice-cover.png">
#     <setvar name="directory_autoplay_single_item" val="0"/>
#     <info>
#       <content>A small description of the directory</content>
#     </info>
#   </folder>
# </freevo>

#
# Should directories sorted by date instead of filename?
# 0 = No, always sort by filename.
# 1 = Yes, sort by date
# 2 = No, don't sory by date for normal directories, 
#     but sort by date for TV_RECORD_DIR.
#
DIRECTORY_SORT_BY_DATE = 2

#
# Should directory items be sorted in reverse order?
#
# DIRECTORY_REVERSE_SORT = 0

#
# Should we use "smart" sorting?
# Smart sorting ignores the word "The" in item names.
#
DIRECTORY_SMART_SORT = 1

#
# Should Freevo autoplay an item if only one item is in the directory?
#
DIRECTORY_AUTOPLAY_SINGLE_ITEM = 1

#
# Force the skin to use a specific layout number. -1 == no force. The layout
# toggle with DISPLAY will be disabled
#
# DIRECTORY_FORCE_SKIN_LAYOUT = -1

#
# Format string for the audio item names. 
#
# Possible strings:
# a = artist, n = tracknumber, t = title, y = year, f = filename
#
# Example:
# This will show the title and the track number:
# DIRECTORY_AUDIO_FORMAT_STRING = '%(n)s - %(t)s'
#
# DIRECTORY_AUDIO_FORMAT_STRING = '%(t)s'

#
# Use media id tags to generate the name of the item. This should be
# enabled all the time. It should only be disabled for directories with 
# broken tags.
#
DIRECTORY_USE_MEDIAID_TAG_NAMES = 1

#
# The following settings determine which features are available for
# which media types.
#
# If you set this variable in a folder.fxd, the value is 1 (enabled)
# or 0 (disabled).
# 
# Examples:
# To enable autoplay for audio and image files:
# DIRECTORY_AUTOPLAY_ITEMS = [ 'audio', 'image' ]
# To disable autoplay entirely:
# DIRECTORY_AUTOPLAY_ITEMS = []

# Make all items a playlist. So when one is finished, the next one will
# start. It's also possible to browse through the list with UP and DOWN
#
# DIRECTORY_CREATE_PLAYLIST      = [ 'audio', 'image' ]

# Add playlist files ('m3u') to the directory
#
# DIRECTORY_ADD_PLAYLIST_FILES   = [ 'audio', 'image' ]

# Add the item 'Random Playlist' to the directory
#
# DIRECTORY_ADD_RANDOM_PLAYLIST  = [ 'audio' ]

# Make 'Play' not 'Browse' the default action when only items and not
# subdirectories are in the directory
#
# DIRECTORY_AUTOPLAY_ITEMS       = [ ]


# ======================================================================
# Freevo movie settings:
# ======================================================================

#
# Where the movie files can be found.
# This is a list of items (e.g. directories, fxd files). The items themselves
# can also be a list of (title, file)
#
VIDEO_ITEMS = [ ('divx movies', '/mnt/ripping/divx'),
                 ('net movies', '/mnt/backup/tmp'),
		 ('Buffy', '/mnt/backup/buffy')]
#
# Some people access movies on a different machine using an automounter.
# To avoid timeouts, you can specify the machine name in the directory
# to check if the machine is alive first
# Directory myserver:/files/server-stuff will show the item for the
# directory /files/server-stuff if the computer myserver is alive.

#
# The list of filename suffixes that are used to match the files that
# are played wih MPlayer.
# 
# VIDEO_MPLAYER_SUFFIX = [ 'avi', 'mpg', 'mpeg', 'wmv', 'bin', 'rm',
#                          'divx', 'ogm', 'vob', 'asf', 'm2v', 'm2p',
#                          'mp4', 'viv', 'nuv', 'mov', 'iso',
#                          'nsv', 'mkv' ]

#
# The list of filename suffixes that are used to match the files that
# are played wih Xine.
# 
# VIDEO_XINE_SUFFIX = [ 'avi', 'mpg', 'mpeg', 'rm', 'divx', 'ogm',
#                       'asf', 'm2v', 'm2p', 'mp4', 'mov', 'cue' ]

#
# Preferred video player
#
VIDEO_PREFERED_PLAYER = 'mplayer'


VIDEO_SHOW_DATA_DIR = '/mnt/ripping/divx'

#
# Only scan OVERLAY_DIR and VIDEO_SHOW_DATA_DIR for fxd files containing
# information about a disc. If you only have the fxd files for discs in
# one of this directories (and subdirectories), set this to 1, it will
# speed up startup, 0 may be needed if you have fxd files with disc links
# in your normal movie tree.
#
# VIDEO_ONLY_SCAN_DATADIR = 1


# ======================================================================
# Freevo audio settings:
# ======================================================================

#
# Where the Audio (mp3, ogg) files can be found.
# This is a list of items (e.g. directories, fxd files). The items themselves
# can also be a list of (title, file)
#
# To add webradio support, add fxd/webradio.fxd to this list
#
AUDIO_ITEMS = [ ('Salvati', '/mnt/ripping/mp3/'),
                 'fxd/webradio.fxd' ]

#
# The list of filename suffixes that are used to match the files that
# are played as audio.
# 
# AUDIO_SUFFIX     = [ 'mp3', 'ogg', 'wav','m4a', 'wma', 'aac', 'flac', 'mka' ]

#
# Regular expression used to recognize filenames which are likely to be 
# covers for an album 
#
# This will match front.jpg and cover-f.jpg, but not back.jpg nor cover-b.jpg:
# AUDIO_COVER_REGEXP = 'front|-f'

#
# Preferred audio player
#
AUDIO_PREFERED_PLAYER = 'mplayer'

#
# Show video files in the audio menu (for music-videos)
#
# AUDIO_SHOW_VIDEOFILES = False

# ======================================================================
# Freevo image viewer settings:
# ======================================================================

#
# Where image files can be found.
# This is a list of items (e.g. directories, fxd files). The items itself
# can also be a list of (title, file)
#
IMAGE_ITEMS = [('Sfondi','/mnt/ripping/documenti/stefano/Immagini/'),('Foto','/foto')]

#
# The list of filename suffixes that are used to match the files that
# are used for the image viewer.
# 
# IMAGE_SUFFIX = [ 'jpg','gif','png', 'jpeg','bmp','tiff','psd' ]

#
# The viewer now supports a new type of menu entry, a slideshow file.
# It also has the slideshow alarm signal handler for automated shows.
# It uses a new configuration option:
#
# IMAGE_SSHOW_SUFFIX = [ 'ssr' ]

#
# Mode of the blending effect in the image viewer between two images
# Possible values are:
#
# None: no blending
# -1    random effect
#  0    alpha blending
#  1    wipe effect
#
IMAGEVIEWER_BLEND_MODE = -1
    


# ======================================================================
# Freevo games settings:
# ======================================================================

#
# MAME is an emulator for old arcade video games. It supports almost
# 2000 different games! The actual emulator is not included in Freevo,
# you'll need to download and install it separately. The main MAME
# website is at http://www.mame.net, but the version that is used here
# is at http://x.mame.net since the regular MAME is for Windows.
#
# SNES stands for Super Nintendo Entertainment System. Freevo relies
# on other programs that are not included in Freevo to play these games.
# 
# NEW GAMES SYSTEM :
# =================
# The GAMES_ITEMS structure is now build as follows :
# <NAME>, <FOLDER>, (<TYPE>, <COMMAND_PATH>, <COMMAND_ARGS>, <IMAGE_PATH>, \
# [<FILE_SUFFIX_FOR_GENERIC>])
# where :
#              - <TYPE> : Internal game types (MAME or SNES) or
#                         generic one (GENERIC)
#              - <COMMAND_PATH> : Emulator command
#              - <COMMAND_ARGS> : Arguments for the emulator
#              - <IMAGE_PATH>   : Optionnal path to the picture
#              - <FILE_SUFFIX_FOR_GENERIC> : If the folder use the GENERIC
#                                            type, then you must specify here
#                                        the file suffix used by the emulator
# GAMES_ITEMS = [ ('MAME', '/home/media/games/xmame/roms',     
#                ('MAME', '/usr/local/bin/xmame.SDL', '-fullscreen -modenumber 6', 
#                 '/home/media/games/xmame/shots', None)),
#               ('SUPER NINTENDO', '/home/media/games/snes/roms', 
#                ('SNES', '/usr/local/bin/zsnes', '-m -r 3 -k 100 -cs -u', '', None )),
#               ('Visual Boy Advance', '/home/media/games/vba/roms/',
#                ('GENERIC', '/usr/local/vba/VisualBoyAdvance', ' ', '', [ 'gba' ] )),
#               ('MEGADRIVE', '/home/media/games/megadrive/roms', 
#                ('GENESIS', '/usr/local/bin/generator-svgalib', '', '', '' )) ]
#
# GAMES_ITEMS = None

#
# These settings are used for the MAME arcade emulator:
#

# Priority of the game process
# 0 = Don't change the priority
# >0 - Lower priority
# <0 - Higher priority
#
# GAMES_NICE = -20

# 
# MAME cache directory
#
# GAMES_MAME_CACHE = '%s/romlist-%s.pickled' % (FREEVO_CACHEDIR, os.getuid())

# ======================================================================
# Freevo SKIN settings:
# ======================================================================

#
# Select a way when to switch to text view even if a image menu is there
# 
# 1 = Force text view when all items have the same image and there are no
#     directories
# 2 = Ignore the directories, always switch to text view when all images
#     are the same
#
# SKIN_FORCE_TEXTVIEW_STYLE = 1

#
# Force text view for the media menu
# (The media menu is the first menu displayed for video, audio, images 
# and games). 
#
# SKIN_MEDIAMENU_FORCE_TEXTVIEW = 0


# ======================================================================
# Freevo OSD settings:
# ======================================================================

#
# System Path to search for fonts not included in the Freevo distribution
#
# OSD_EXTRA_FONT_PATH  = [ '/usr/X11R6/lib/X11/fonts/truetype/' ]
OSD_EXTRA_FONT_PATH  = [ '/usr/share/fonts/TTF2005/' ]

#
# Font aliases 
# All names must be lowercase! All alternate fonts must be in './share/fonts/'
#
# OSD_FONT_ALIASES = { 'arial_bold.ttf' : 'VeraBd.ttf' }

#
# Number of seconds to wait until the busy icon is shown in the menu.
# Busy icon can also be shown right away when there is more than a certain
# number of files in a directory.
# 
# Set this to None to disable this.
# (seconds, files)
#
# OSD_BUSYICON_TIMER = (0.7, 200)

# OSD_OVERSCAN_X = 0
# OSD_OVERSCAN_Y = 0

#
# Execute a script on OSD startup.
#
# OSD_SDL_EXEC_AFTER_STARTUP = ""

#
# Execute a script on OSD close.
#
# OSD_SDL_EXEC_AFTER_CLOSE = ""

#
# Stop the osd before playing a movie with xine or mplayer. Some output
# devices need this. After playback, the osd will be restored
#
# OSD_STOP_WHEN_PLAYING = 0

#
# Dim text that doesn't fit instead of using ellipses. 
# OSD_DIM_TEXT = 1
    
# ======================================================================
# Freevo remote control settings:
# ======================================================================

#
# Location of the lircrc file
#
# For remote control support, Freevo needs a lircrc file, like this:
#
# begin
#       prog = freevo
#       button = select
#       config = SELECT
# end
#
# Check contrib/lirc for examples and helpers/freevo2lirc.pl for a converter
# script.
#
# LIRCRC = '/etc/freevo/lircrc'

#
# Joystick support
# 0 = Disable joystick support 
# 1 = Use js0, 
# 2 = Use js1, 
#  ... etc
#
JOY_DEV = 1

# Freevo can support as many buttons as your controller has
# as long as there is a corresponding entry in JOY_CMDS.
# You will also need to plugin.activate('joy').
# FYI: new kernels use /dev/input/jsX, but joy.py will fall back on /dev/jsX
#
JOY_CMDS = {
     'up'             : 'UP',
     'down'           : 'DOWN',
     'left'           : 'LEFT',
     'right'          : 'RIGHT',
     'button 1'       : 'PLAY',
     'button 2'       : 'PAUSE',
     'button 3'       : 'STOP',
     'button 4'       : 'ENTER',
     }


# ======================================================================
# TVtime settings:
# ======================================================================

#
# Location of the TV time program
# Default: Use the value in freevo.conf
# 
# TVTIME_CMD = CONF.tvtime


# ======================================================================
# MPlayer settings:
# ======================================================================

MPLAYER_VERSION = '1.0'
MPLAYER_AO_DEV       = 'alsa'  # e.g.: oss,sdl,alsa, see mplayer docs
#MPLAYER_AO_DEV       = 'alsa:hw:1,1'  # e.g.: oss,sdl,alsa, see mplayer docs

MPLAYER_VO_DEV_OPTS  = 'xv'	         # e.g.: ':some_var=vcal'

DVD_LANG_PREF        = 'it,en,se,no'      # Order of preferred languages on DVD.
# DVD_SUBTITLE_PREF    = ''              # Order of preferred subtitles on DVD.

# Priority of mplayer process. 0 is unchanged, <0 is higher prio, >0 lower prio.
# prio <0 has no effect unless run as root.
# MPLAYER_NICE         = -20             

#
# Mplayer options to use the software scaler. If your CPU is fast enough, you
# might try a software scaler. You can disable it later for some larger files
# with the mplayer option '-nosws'. If you have -framedrop or -hardframedrop
# as mplayer option, the software scaler will also not be used.
# A good value for this variable is:
# MPLAYER_SOFTWARE_SCALER = "-subfont-text-scale 5 -fs -sws 2 -vf scale=%s:-3,"\
#                           "expand=%s:%s " % ( CONF.width, CONF.width, CONF.height )
# older versions of mplayer may need
# MPLAYER_SOFTWARE_SCALER = '-xy %s -sws 2 -vop scale:-1:-1:-1:100' % CONF.width
#
#MPLAYER_SOFTWARE_SCALER = ' -vf scale=320::1 '

#
# Mplayer arguments for different media formats. (eg DVDs, CDs, AVI files, etc)
# Uses a default value if nothing else matches.
#
MPLAYER_ARGS = {  'dvd'    : '-cache 8192 -vf scale=320::1 ',
                  'vcd'    : '-cache 4096 -vf scale=320::1 ',
                  'cd'     : '-cache 1024 -cdda speed=2',
                  'tv'     : '-cache 1024 -vf scale=320::1 -vf pp=md/de/hb/vb/dr/al/lb,phase=U',
                  'ivtv'   : '-cache 8192',
                  'avi'    : '-cache 5000 -idx -vf scale=320::1 -vf pp=md/de/hb/vb/dr/al/lb,phase=U',
                  'rm'     : '-cache 5000 -forceidx -vf scale=320::1 ',
                  'rmvb'   : '-cache 5000 -forceidx -vf scale=320::1 ',
                  'webcam' : 'tv:// -tv driver=v4l:width=352:height=288:outfmt=yuy2:device=/dev/video1',
                  'default': '-cache 5000 -vf scale=320::1 -vf pp=md/de/hb/vb/dr/al/lb,phase=U',
		  'dvb'    : '-cache 1024 -vf scale=320::1 -vf pp=md/de/hb/vb/dr/al/lb,phase=U'
               }

#
# Number of seconds before seek value times out. This is used when
# seeking a specified number of minutes into a movie. If you make
# a mistake or change your mind, the seek value will timeout after
# this many seconds.
#
# MPLAYER_SEEK_TIMEOUT = 8

#
# Autocrop files when playing. This is useful for files in 4:3 with black
# bars on a 16:9 tv
#
# MPLAYER_AUTOCROP = 0

#
# Try to set correct 'delay' and 'mc' values for mplayer based on the delay
# from mmpython. 
#
# This should correct av sync problems with mplayer for some files, but 
# may also break things. (I don't know, that's why it's disabled by default). 
# WARNING: When seeking, the playback is out of sync for some seconds! 
#
# MPLAYER_SET_AUDIO_DELAY = 0

#
# Mplayer video filter for interlaced or progressive videos. If you have
# a slow pc, do not use post processing
# MPLAYER_VF_INTERLACED  = ''
# MPLAYER_VF_PROGRESSIVE = 'pp=fd'
# For pal and dvb-t recordings, the following looks good
# MPLAYER_VF_INTERLACED  = 'pp=md/de,phase=U'
#
# MPLAYER_VF_INTERLACED  = 'pp=de/fd'
# MPLAYER_VF_PROGRESSIVE = 'pp=de'
#MPLAYER_VF_INTERLACED  = 'pp=md/de,phase=U'

# ======================================================================
# Xine settings:
# ======================================================================

# You need xine-ui version greater 0.9.21 to use the all the features
# of the xine plugin

# XINE_VO_DEV  = 'xv'
# XINE_COMMAND = '%s --hide-gui -pq -g -B --geometry %sx%s+0+0 --no-splash' % \
#                  (CONF.xine, CONF.width, CONF.height)

# XINE_ARGS_DEF = '--no-lirc --post=pp:quality=10,expand'

XINE_AO_DEV = 'alsa'                     # alsa or oss


# ======================================================================
# Freevo TV settings:
# ======================================================================

#
# This is where recorded video is written.
#
# XXX the path doesn't work from the www cgi scripts!
TV_RECORD_DIR = '/video'

#
# Watching TV
#
# XXX You must change this to fit your local conditions!
#
# NORM: ntsc, pal, secam
# INPUT: television, composite1
# CHANLIST: One of the following:
#
# us-bcast, us-cable, us-cable-hrc, japan-bcast, japan-cable, europe-west,
# europe-east, italy, newzealand, australia, ireland, france, china-bcast,
# southafrica, argentina, canada-cable, russia
#
# TV_SETTINGS  = 'NORM INPUT CHANLIST DEVICE'
TV_SETTINGS  = 'pal Television italy /dev/video0'

#
# Video input device
#
# Usually /dev/video0, but might be /dev/video1 instead for multiple boards.
#
# FreeBSD uses the Brooktree TV-card driver, not V4L.
#
TV_DRIVER = 'v4l'
TV_DEVICE = '/dev/video0'
TV_INPUT = 'Television'
#CHANLIST = {
#     "us-bcast"         : dict(NTSC_BCAST),
#     "us-cable"         : dict(NTSC_CABLE),
#     "us-cable-hrc"     : dict(NTSC_HRC),
#     "japan-bcast"      : dict(NTSC_BCAST_JP),
#     "japan-cable"      : dict(NTSC_CABLE_JP),
#     "europe-west"      : dict(PAL_EUROPE),
#     "europe-east"      : dict(PAL_EUROPE_EAST),
#     "italy"            : dict(PAL_ITALY),
#     "newzealand"       : dict(PAL_NEWZEALAND),
#     "australia"        : dict(PAL_AUSTRALIA),
#     "ireland"          : dict(PAL_IRELAND),
#     "france"           : dict(SECAM_FRANCE),
#     "china-bcast"      : dict(PAL_CHINA),
#     "canada-cable"     : dict(NTSC_CABLE_CAN),
#     "southafrica"      : dict(PAL_BCAST_ZA),
#     "argentina"        : dict(ARGENTINA),
#     }

#
# Additional options to pass to mplayer in TV mode.
#
# eg. To turn off deinterlacing:
#TV_OPTS = '-vop pp=ci'
#
# TV_OPTS = ''

# TV_SETTINGS = '%s television %s %s' % (CONF.tv, CONF.chanlist, TV_DEVICE)

#
# Size (in MB) of the timeshift buffer. (ie: how long you can pause tv for.)  
# This is set to a low default because the default buffer location is 
# under FREEVO_CACHEDIR and we don't want to blow /var or /tmp.
# TIMESHIFT_BUFFER_SIZE = 128

# TIMESHIFT_ENCODE_CMD = 'mp1e -m3 -c%s -p%s -r14,100' % \
#                        (TV_SETTINGS.split()[3], AUDIO_INPUT_DEVICE) 

# TIMESHIFT_BUFFER = '%s/timeshift.mpeg' % FREEVO_CACHEDIR

TV_CHANNEL_PROG = 'v4lctl setstation %(channel)s'

#  TV_CHANNEL_PROG = './chchan %(channel)s %(norm)s %(freqtable)s'

# TV_DATEFORMAT = '%e-%b' # Day-Month: 11-Jun
# TV_TIMEFORMAT = '%H:%M' # Hour-Minute 14:05
# TV_DATETIMEFORMAT = '%A %b %d %I:%M %p' # Thursday September 24 8:54 am

# This is the filename format for files recorded using Freevo.
# You can use any of the strftime variables in it, provided you
# put two '%%' at the beginning. 
# 
# Some examples:
# %%A - Full weekday name.
# %%H - Hour (24-hour clock) as a decimal number [00,23].
# %%M - Minute as a decimal number [00,59].
# %%m - Month as a decimal number [01,12].
# %%d - Day of the month as a decimal number [01,31].
# %%p - Locale's equivalent of either AM or PM.
# 
# More can be found at: http://www.python.org/doc/current/lib/module-time.html

# TV_RECORDFILE_MASK = '%%m-%%d %%H:%%M %(progname)s - %(title)s'


# if using the persitant recordserver
# TV_RECORD_SCHEDULE = '%s/record_schedule.xml' % FREEVO_CACHEDIR

# TV_RECORD_SERVER_IP = 'localhost'
# TV_RECORD_SERVER_PORT = 18001

# start every recording X minutes before scheduled,
# and stop X minutes after scheduled - default to zero minutes.
# This must be a value in seconds although at the moment only has
# the percision of one minute.
TV_RECORD_PADDING = 0 * 60

# VCR_AUDIO = (':adevice=%s' % AUDIO_DEVICE +
#              ':audiorate=32000' +         # 44100 for better sound
#              ':forceaudio:forcechan=1:' + # Forced mono for bug in my driver
#              'buffersize=64')             # 64MB capture buffer, change?

# TV capture size for viewing and recording. Max 768x480 for NTSC,
# 768x576 for PAL. Set lower if you have a slow computer!
#
# For the 'tvtime' TV viewing application, only the horizontal size is used.
# Set the horizontal size to 400 or 480 if you have a slow (~500MHz) computer,
# it still looks OK, and the picture will not be as jerky.
# The vertical size is always either fullscreen or 480/576 (NTSC/PAL)
# for tvtime.
TV_VIEW_SIZE = (1024, 768)
# TV_REC_SIZE = (320, 240)   # Default for slower computers

# Input formats for viewing and recording. The format affect viewing
# and recording performance. It is specific to your hardware, so read
# the MPlayer docs and experiment with mplayer to see which one fits
# your computer best.
# TV_VIEW_OUTFMT = 'yuy2'   # Better quality, slower on pure FB/X11
# TV_REC_OUTFMT = 'yuy2'

# XXX Please see the mencoder docs for more info about the settings
# XXX below. Some stuff must be changed (adevice), others probably
# XXX should be ("Change"), or could be in some cases ("change?")
# VCR_CMD = (CONF.mencoder + ' ' +
#            'tv:// ' +                      # New mplayer requires this.
#            '-tv driver=%s:input=%d' % (TV_DRIVER, TV_INPUT) +
#            ':norm=%s' % CONF.tv +
#            ':channel=%(channel)s' +        # Filled in by Freevo
#            ':chanlist=%s' % CONF.chanlist +
#            ':width=%d:height=%d' % (TV_REC_SIZE[0], TV_REC_SIZE[1]) +
#            ':outfmt=%s' % TV_REC_OUTFMT +
#            ':device=%s' % TV_DEVICE +
#            VCR_AUDIO +                     # set above
#            ' -ovc lavc -lavcopts ' +       # Mencoder lavcodec video codec
#            'vcodec=mpeg4' +                # lavcodec mpeg-4
#            ':vbitrate=1200:' +             # Change lower/higher, bitrate
#            'keyint=30 ' +                  # Keyframe every 10 secs, change?
#            '-oac mp3lame -lameopts ' +     # Use Lame for MP3 encoding, must be enabled in mencoder!
#            'br=128:cbr:mode=3 ' +          # MP3 const. bitrate, 128 kbit/s
#            '-ffourcc divx ' +              # Force 'divx' ident, better compat.
#            '-endpos %(seconds)s ' +        # only mencoder uses this so do it here.
#            '-o %(filename)s')         # Filled in by Freevo

VCR_CMD = (CONF.mencoder + ' ' +
            '%(channel)s ' +
            '%(filename)s')         # Filled in by Freevo



#VCR_CMD = ('mencoder "$1" -vf scale=768:576  -o "$2"  -ovc lavc -lavcopts vcodec=mpeg4:vhq -oac mp3lame -lameopts vbr=0 -tv driver=v4l2:device=/dev/video0:norm=PAL:chanlist=italy:channels="D-RAI 1,22-Italia 7,26-Rete A,27-RAI 2,43-RAI 3,46-Italia 7Gold,47-1G,52,Canale 5,55-SI,58-Italia 1,59-MTV,62-Rete 4":alsa

#
# Settings for ivtv based cards such as the WinTV PVR-250/350.
#
# XXX TODO: Add descriptions and valid settings for each option.
# bitrate in bps
# stream type
# Options are: 0 (mpeg2_ps), 1 (mpeg2_ts), 2 (mpeg1), 3 (mpeg2_pes_av),
#              5 (mpeg2_pes_v), 7 (mpeg2_pes_a), 10 (dvd)

# TV_IVTV_OPTIONS = {
#     'input'         : 4,
#     'resolution'    : '720x480',
#     'aspect'        : 2,
#     'audio_bitmask' : 233,
#     'bframes'       : 3,
#     'bitrate_mode'  : 1,
#     'bitrate'       : 4000000,
#     'bitrate_peak'  : 4000000,
#     'dnr_mode'      : 0,
#     'dnr_spatial'   : 0,
#     'dnr_temporal'  : 0,
#     'dnr_type'      : 0,
#     'framerate'     : 0,
#     'framespergop'  : 15,
#     'gop_closure'   : 1,
#     'pulldown'      : 0,
#     'stream_type'   : 10,
# }

#
# FREQUENCY_TABLE - This is only used when Freevo changes the channel natively.
# This is only the case if you are using V4L2 and any of the following plugins:
# timeshift, ivtv_record, ivtv_basic_tv.
# For the standard frequancy tables see src/tv/freq.py.  To add your own just 
# replace tuner_id in the following example with a valid tuner id (ie: '5' or
# 'BBC1') and a frequency in KHz.  You may have as many entries as you like,
# anything here will simply override a corresponding entry in your standard
# frequency table and you can also have entries here that are not present in
# there.

# FREQUENCY_TABLE = {
#     'tuner_id'   :    55250,
# }


# VIDEO_GROUPS is a new setting to handle multiple arbitrary groups of devices
# for viewing or recording.  It will be possible to have different Freevo
# channels use different Video Groups.

# VIDEO_GROUPS = [
#     VideoGroup(vdev=TV_DEVICE,
#                adev=AUDIO_DEVICE,
#                input_type='tuner',
#                tuner_norm=CONF.tv,
#                tuner_chanlist=CONF.chanlist,
#                desc='Default Video Group',
#                recordable=True),
# ]


VIDEO_GROUPS = [
     VideoGroup(vdev='/dev/video0',
                 adev='/dev/dsp',
                 input_type='tuner',
                 input_num=4,
                 tuner_norm='PAL',
                 tuner_chanlist='italy',
                 tuner_type='internal',
                 desc='TV kaart',
                 group_type='tvpippo',
                 recordable=True),
     VideoGroup(vdev='/dev/video0',
                 adev='/dev/dsp',
                 input_type='tuner',
                 input_num=4,
                 tuner_type='internal',
                 desc='DVB',
                 group_type='dvb',
                 recordable=True),
     VideoGroup(vdev='/dev/video1',
                 adev=None,
                 input_type='webcam',
                 desc='Logitech Quickcam',
                 group_type='webcam',
                 recordable=True),
#     VideoGroup(vdev='/dev/video0',
#                adev='/dev/dsp',
#                input_type='T)evision',
#                tuner_norm=CONF.tv,
#                tuner_chanlist=CONF.chanlist,
#                desc='Default Video Group',
#                recordable=True),
#     VideoGroup(vdev='/dev/dvb/adapter0/frontend0',
#                adev='/dev/dsp',
#                input_type='dvb',
#                tuner_norm=CONF.tv,
#               tuner_chanlist=CONF.chanlist,
#                desc='Digital Video Group',
#                recordable=True)
]

#VIDEO_GROUPS[0].group_type = 'dvb'
#VIDEO_GROUPS[1].group_type = 'tv'


#
# TV Channels. This list contains a mapping from the displayed channel name
# to the actual channel name as used by the TV watching application.
# The display name must match the names from the XMLTV guide,
# and the TV channel name must be what the tuner expects (usually a number).
#
# The TV menu is supposed to be supported by the XMLTV application for
# up to date listings, but can be used without it to just display
# the available channels.
#
# This list also determines the order in which the channels are displayed!
# N.B.: You must delete the XMLTV cache file (e.g. /var/cache/freevo/TV.xml.pickled)
#       if you make changes here and restart!
#
# Format: [('xmltv channel id', 'freevo display name', 'tv channel name'), ...]
#
# If this variable is set to None (default), Freevo will try to auto-detect
# the channel list based on the xmltv file. This doesn't work for all
# xmltv grabber, e.g. the German list doesn't contain station lists. In this
# case Freevo will output the possible list for you to add them manually.
#
# If auto-detection doesn't work or you want to edit the list, run
# freevo tv_grab -query.
#
# Setting this variable to [] will deactivate the tv guide. If you don't have
# a tv card, you may also want to add plugin.remove('tv') to remove the whole
# tv menu.
#
# All channels listed here will be displayed on the TV menu, even if they're
# not present in the XMLTV listing.
# 
#
# Timedependent channels:
#
#            chan_info = config.TV_CHANNELS[i]
#            if chan_info[2] == chan:
#                try:
#                    group = int(chan_info[4])
# The TV_CHANNELS-list can look like this:
TV_CHANNELS = [	('RAI1','RAI1','RAI1',0,1),
		('RAI2','RAI2','RAI2',0,1),
		('RAI3','RAI3','RAI3',0,1),
		('Retequattro','Retequattro','Retequattro',0,1),
		('Canale 5','Canale 5','Canale 5',0,1),
		('Italia 1','Italia 1','Italia 1',0,1),
		('Rai 1','Rai 1','Rai 1'),
		('Rai 2','Rai 2','Rai 2'),
		('Rai 3','Rai 3','Rai 3'),
		('Rete 4','Rete 4','Rete 4'),
		('Canale 6','aCanale 6','Canale 6'),
		('Italia 2','Italia 2','Italia 2'),
		('MTV','MTV','MTV'),
		('Granducato','Granducato','Granducato'),
		('Telecampione','Telecampione','Telecampione'),
		('tv1','tv1','tv1'),
		('TVL','TVL','TVL'),
		('Telemondo','Telemondo','Telemondo'),
		('Toscana','Toscana','Toscana'),
		('Odeon','Odeon','Odeon'),
		('Rete A','Rete A','Rete A'),
		('La 7','La 7','La 7'),
		('tv2','tv2','tv2'),
		('tv3','tv3','tv3'),
		('Italia 7','Italia 7','Italia 7'),
		('1G','1G','1G'),
		('TV 9','TV 9','TV 9'),
		('Canale 50','Canale 50','Canale 50'),
		('Rete 37','Rete 37','Rete 37'),
		('Sport Italia','Sport Italia','Sport Italia'),
		('tv4','tv4','tv4'),
		('102.5 HIT CH','102.5 HIT CH','102.5 HIT CH',0,1),
		('JAZZY LOVE','JAZZY LOVE','JAZZY LOVE',0,1),
		('HIT CHANNEL','HIT CHANNEL','HIT CHANNEL',0,1),
		('NEW HITS radio','NEW HITS radio','NEW HITS radio',0,1),
		('CINE POLAR','CINE POLAR','CINE POLAR',0,1),
		('WRN\'B','WRN\'B','WRN\'B',0,1),
		('Hit Radio','Hit Radio','Hit Radio',0,1),
		('CNN','CNN','CNN',0,1),
		('Extasi','Extasi','Extasi',0,1),
		('TOSCANA CHANNEL','TOSCANA CHANNEL','TOSCANA CHANNEL',0,1),
		('Radio Venera','Radio Venera','Radio Venera',0,1),
		('Kiss Kiss Radio','Kiss Kiss Radio','Kiss Kiss Radio',0,1),
		('TIZIANA SAT','TIZIANA SAT','TIZIANA SAT',0,1),
		('Italiasat/Luxuria','Italiasat/Luxuria','Italiasat/Luxuria',0,1),
		('Sex View','Sex View','Sex View',0,1),
		('Sex View Plus','Sex View Plus','Sex View Plus',0,1),
		('Tecnologia','Tecnologia','Tecnologia',0,1),
		('Discovery','Discovery','Discovery',0,1),
		('HIT MIX FM','HIT MIX FM','HIT MIX FM',0,1),
		('CNN Int.','CNN Int.','CNN Int.',0,1),
		('TV Puls','TV Puls','TV Puls',0,1),
		('Playboy','Playboy','Playboy',0,1),
		('Notturno italiano','Notturno italiano','Notturno italiano',0,1),
		('FD leggera','FD leggera','FD leggera',0,1),
		('RaiMed','RaiMed','RaiMed',0,1),
		('Senato','Senato','Senato',0,1),
		('RaiEdu2','RaiEdu2','RaiEdu2',0,1),
		('RaiNettunoSat1','RaiNettunoSat1','RaiNettunoSat1',0,1),
		('RaiNettunoSat2','RaiNettunoSat2','RaiNettunoSat2',0,1),
		('Camera Deputati','Camera Deputati','Camera Deputati',0,1),
		('BLUSAT2000','BLUSAT2000','BLUSAT2000',0,1),
		('RaiNotizie24','RaiNotizie24','RaiNotizie24',0,1),
		('Isoradio','Isoradio','Isoradio',0,1),
		('RaiUtile','RaiUtile','RaiUtile',0,1),
		('GR Parlam.','GR Parlam.','GR Parlam.',0,1),
		('SAT2000','SAT2000','SAT2000',0,1),
		('MTV','MTV','MTV',0,1),
		('Deejay TV','Deejay TV','Deejay TV',0,1),
		('Kiss Radio','Kiss Radio','Kiss Radio',0,1),
		('RDS','RDS','RDS',0,1),
		('BBC World','BBC World','BBC World',0,1),
		('DISCORADIO','DISCORADIO','DISCORADIO',0,1),
		('MTV Hits','MTV Hits','MTV Hits',0,1),
		('MTV Brand New','MTV Brand New','MTV Brand New',0,1),
		('MTV Portugal','MTV Portugal','MTV Portugal',0,1),
		('MTV Polska','MTV Polska','MTV Polska',0,1),
		('Game One','Game One','Game One',0,1),
		('MTV Classic','MTV Classic','MTV Classic',0,1),
		('MTV H','MTV H','MTV H',0,1),
		('MTV 1','MTV 1','MTV 1',0,1),
		('MTV F','MTV F','MTV F',0,1),
		('MTV 5','MTV 5','MTV 5',0,1),
		('ZIK / XXL','ZIK / XXL','ZIK / XXL',0,1),
		('XXL','XXL','XXL',0,1),
		('RTL9','RTL9','RTL9',0,1),
		('XXL PL','XXL PL','XXL PL',0,1),
		('RaiSportSat','RaiSportSat','RaiSportSat',0,1),
		('Rai Edu1','Rai Edu1','Rai Edu1',0,1),
		('RaiDoc','RaiDoc','RaiDoc',0,1),
		('RADIOUNO','RADIOUNO','RADIOUNO',0,1),
		('RADIODUE','RADIODUE','RADIODUE',0,1),
		('RADIOTRE','RADIOTRE','RADIOTRE',0,1),
		('Radio Vaticana','Radio Vaticana','Radio Vaticana',0,1),
		('Love Radio','Love Radio','Love Radio',0,1),
		('247Sex','247Sex','247Sex',0,1),
		('Erotic TV','Erotic TV','Erotic TV',0,1),
		('Sex.tv','Sex.tv','Sex.tv',0,1),
		('SexPlus.tv','SexPlus.tv','SexPlus.tv',0,1),
		('Musicam 1','Musicam 1','Musicam 1',0,1),
		('Musicam 2','Musicam 2','Musicam 2',0,1),
		('Musicam 3','Musicam 3','Musicam 3',0,1),
		('Musicam 4','Musicam 4','Musicam 4',0,1),
		('Musicam 5','Musicam 5','Musicam 5',0,1),
		('Musicam 6','Musicam 6','Musicam 6',0,1),
		('SKYPLEX TXP91','SKYPLEX TXP91','SKYPLEX TXP91',0,1),
		('SKY MEDIO','SKY MEDIO','SKY MEDIO',0,1),
		('Network','Network','Network',0,1),
		('MEDIOLANUM','MEDIOLANUM','MEDIOLANUM',0,1),
		('skygateTDA','skygateTDA','skygateTDA',0,1),
		('CANAL ALGERIE','CANAL ALGERIE','CANAL ALGERIE',0,1),
		('A3','A3','A3',0,1),
		('SKYGATE ERTU','SKYGATE ERTU','SKYGATE ERTU',0,1),
		('Nile TV International','Nile TV International','Nile TV International',0,1),
		('Nile News','Nile News','Nile News',0,1),
		('El Shark El Awsat','El Shark El Awsat','El Shark El Awsat',0,1),
		('Al moagehat','Al moagehat','Al moagehat',0,1),
		('Sports test','Sports test','Sports test',0,1),
		('Skygate 10.2','Skygate 10.2','Skygate 10.2',0,1),
		('HitCast S.Amer.','HitCast S.Amer.','HitCast S.Amer.',0,1),
		('HitCast Data 1','HitCast Data 1','HitCast Data 1',0,1),
		('PMT_5387_14-10-04','PMT_5387_14-10-04','PMT_5387_14-10-04',0,1),
		('PMT_5389_12-11-2004','PMT_5389_12-11-2004','PMT_5389_12-11-2004',0,1),
		('PMT_5391_18-11-04','PMT_5391_18-11-04','PMT_5391_18-11-04',0,1),
		('Skygate 600','Skygate 600','Skygate 600',0,1),
		('Bulgaria TV','Bulgaria TV','Bulgaria TV',0,1),
		('Bulgaria Radio','Bulgaria Radio','Bulgaria Radio',0,1),
		('Pelha Setmax','Pelha Setmax','Pelha Setmax',0,1),
		('Pelha NDTV 24x7','Pelha NDTV 24x7','Pelha NDTV 24x7',0,1),
		('RTPi','RTPi','RTPi',0,1),
		('MTA INTL','MTA INTL','MTA INTL',0,1),
		('10.722 H','10.722 H','10.722 H',0,1),
		('Deepam TV','Deepam TV','Deepam TV',0,1),
		('NPR','NPR','NPR',0,1),
		('ETBC Tamil','ETBC Tamil','ETBC Tamil',0,1),
		('Pehla ATN Bangla','Pehla ATN Bangla','Pehla ATN Bangla',0,1),
		('Pehla Sony TV','Pehla Sony TV','Pehla Sony TV',0,1),
		('Pehla GEO TV','Pehla GEO TV','Pehla GEO TV',0,1),
		('DIYAR-ARABESQUE','DIYAR-ARABESQUE','DIYAR-ARABESQUE',0,1),
		('RDPi Radio','RDPi Radio','RDPi Radio',0,1),
		('Radio A1','Radio A1','Radio A1',0,1),
		('Aviano','Aviano','Aviano',0,1),
		('Hessen','Hessen','Hessen',0,1),
		('Guide/Newswheel','Guide/Newswheel','Guide/Newswheel',0,1),
		('Backhaul to Bagdad','Backhaul to Bagdad','Backhaul to Bagdad',0,1),
		('Guide/Bright AC','Guide/Bright AC','Guide/Bright AC',0,1),
		('Guide/Country','Guide/Country','Guide/Country',0,1),
		('Guide/Adult Rock','Guide/Adult Rock','Guide/Adult Rock',0,1),
		('Guide/NPR','Guide/NPR','Guide/NPR',0,1),
		('Guide/Voice/UIVoice/SplitUI','Guide/Voice/UIVoice/SplitUI','Guide/Voice/UIVoice/SplitUI',0,1),
		('Guide/UI Voiceline/SplitUI/Voi','Guide/UI Voiceline/SplitUI/Voi','Guide/UI Voiceline/SplitUI/Voi',0,1),
		('Guide/The Touch','Guide/The Touch','Guide/The Touch',0,1),
		('Guide/Pure Gold','Guide/Pure Gold','Guide/Pure Gold',0,1),
		('Guide/Hot AC','Guide/Hot AC','Guide/Hot AC',0,1),
		('Guide/Z-rock ABC Hard Rock','Guide/Z-rock ABC Hard Rock','Guide/Z-rock ABC Hard Rock',0,1),
		('Guide/Fox Sports Talk','Guide/Fox Sports Talk','Guide/Fox Sports Talk',0,1),
		('Guide/ESPN Radio','Guide/ESPN Radio','Guide/ESPN Radio',0,1),
		('Guide/UI Split/UIVoice/Voice','Guide/UI Split/UIVoice/Voice','Guide/UI Split/UIVoice/Voice',0,1),
		('Guide/SMPTE Time Code','Guide/SMPTE Time Code','Guide/SMPTE Time Code',0,1),
		('Guide/AFNE Power Radio','Guide/AFNE Power Radio','Guide/AFNE Power Radio',0,1),
		('Guide/Contingency','Guide/Contingency','Guide/Contingency',0,1),
		('Guide/AFNE Z-Rock','Guide/AFNE Z-Rock','Guide/AFNE Z-Rock',0,1),
		('Guide/Bavcaria Z-FM','Guide/Bavcaria Z-FM','Guide/Bavcaria Z-FM',0,1),
		('Guide/Bavaria PowerNet AM','Guide/Bavaria PowerNet AM','Guide/Bavaria PowerNet AM',0,1),
		('CANAL+','CANAL+','CANAL+',0,1),
		('CANAL+ FILM','CANAL+ FILM','CANAL+ FILM',0,1),
		('ALE KINO!','ALE KINO!','ALE KINO!',0,1),
		('ZigZap','ZigZap','ZigZap',0,1),
		('TVP 1','TVP 1','TVP 1',0,1),
		('TVP 2','TVP 2','TVP 2',0,1),
		('CANAL+ SPORT','CANAL+ SPORT','CANAL+ SPORT',0,1),
		('tech','tech','tech',0,1),
		('CYFRA+ RADIO','CYFRA+ RADIO','CYFRA+ RADIO',0,1),
		('CYFRA+MIKS','CYFRA+MIKS','CYFRA+MIKS',0,1),
		('CYFRA+ RADIO','CYFRA+ RADIO','CYFRA+ RADIO',0,1),
		('FOX KIDS','FOX KIDS','FOX KIDS',0,1),
		('DTV CABLE','DTV CABLE','DTV CABLE',0,1),
		('tech 2','tech 2','tech 2',0,1),
		('VOX CH','VOX CH','VOX CH',0,1),
		('NBC','NBC','NBC',0,1),
		('ZDF','ZDF','ZDF',0,1),
		('RTL Television','RTL Television','RTL Television',0,1),
		('RTL CH','RTL CH','RTL CH',0,1),
		('Testkanal','Testkanal','Testkanal',0,1),
		('RTL2 AUSTRIA','RTL2 AUSTRIA','RTL2 AUSTRIA',0,1),
		('F.A.Z. 93.6 Berlin','F.A.Z. 93.6 Berlin','F.A.Z. 93.6 Berlin',0,1),
		('EVENT','EVENT','EVENT',0,1),
		('Big FM','Big FM','Big FM',0,1),
		('EVENT2','EVENT2','EVENT2',0,1),
		('TV 8 Mont Blanc','TV 8 Mont Blanc','TV 8 Mont Blanc',0,1),
		('Olisat VV Cont','Olisat VV Cont','Olisat VV Cont',0,1),
		('Olisat TV Chile','Olisat TV Chile','Olisat TV Chile',0,1),
		('Olisat TV Colombia','Olisat TV Colombia','Olisat TV Colombia',0,1),
		('Olisat Servhisp','Olisat Servhisp','Olisat Servhisp',0,1),
		('Olisat Cubavision','Olisat Cubavision','Olisat Cubavision',0,1),
		('Defence TV','Defence TV','Defence TV',0,1),
		('Mediterraneo Sat 2','Mediterraneo Sat 2','Mediterraneo Sat 2',0,1),
		('DW-TV','DW-TV','DW-TV',0,1),
		('DW-TV Feed','DW-TV Feed','DW-TV Feed',0,1),
		('Jazz Radio Berlin','Jazz Radio Berlin','Jazz Radio Berlin',0,1),
		('RNW-4','RNW-4','RNW-4',0,1),
		('tv.nrw','tv.nrw','tv.nrw',0,1),
		('VIVA polska','VIVA polska','VIVA polska',0,1),
		('RTL 2 CH','RTL 2 CH','RTL 2 CH',0,1),
		('Super RTL CH','Super RTL CH','Super RTL CH',0,1),
		('hellaslive.com','hellaslive.com','hellaslive.com',0,1),
		('Bloomberg French TV','Bloomberg French TV','Bloomberg French TV',0,1),
		('Bloomberg Italian TV','Bloomberg Italian TV','Bloomberg Italian TV',0,1),
		('Bloomberg European TV','Bloomberg European TV','Bloomberg European TV',0,1),
		('Bloomberg German TV','Bloomberg German TV','Bloomberg German TV',0,1),
		('Bloomberg English TV','Bloomberg English TV','Bloomberg English TV',0,1),
		('SNI','SNI','SNI',0,1),
		('Test','Test','Test',0,1),
		('Miracle TV','Miracle TV','Miracle TV',0,1),
		('Channel Nine','Channel Nine','Channel Nine',0,1),
		('AB MOTEURS','AB MOTEURS','AB MOTEURS',0,1),
		('ACTION','ACTION','ACTION',0,1),
		('AB 1','AB 1','AB 1',0,1),
		('ZIK / XXL','ZIK / XXL','ZIK / XXL',0,1),
		('XXL','XXL','XXL',0,1),
		('\'ZIK','\'ZIK','\'ZIK',0,1),
		('XXL PL','XXL PL','XXL PL',0,1),
		('RFM-TV','RFM-TV','RFM-TV',0,1),
		('MUSIQUE CLASSIQUE','MUSIQUE CLASSIQUE','MUSIQUE CLASSIQUE',0,1),
		('ANIMAUX','ANIMAUX','ANIMAUX',0,1),
		('ESCALES','ESCALES','ESCALES',0,1),
		('ENCYCLOPEDIA','ENCYCLOPEDIA','ENCYCLOPEDIA',0,1),
		('MANGAS','MANGAS','MANGAS',0,1),
		('RTL9','RTL9','RTL9',0,1),
		('Mega Extra','Mega Extra','Mega Extra',0,1),
		('Greek Church','Greek Church','Greek Church',0,1),
		('Skai Radio','Skai Radio','Skai Radio',0,1),
		('Melodi Radio','Melodi Radio','Melodi Radio',0,1),
		('RR3','RR3','RR3',0,1),
		('RR1','RR1','RR1',0,1),
		('JETIX','JETIX','JETIX',0,1),
		('FILM NET','FILM NET','FILM NET',0,1),
		('SuperSport1','SuperSport1','SuperSport1',0,1),
		('MEGA','MEGA','MEGA',0,1),
		('ANT-1','ANT-1','ANT-1',0,1),
		('STAR','STAR','STAR',0,1),
		('ALTER','ALTER','ALTER',0,1),
		('SSExtra1','SSExtra1','SSExtra1',0,1),
		('R13','R13','R13',0,1),
		('ALPHA TV','ALPHA TV','ALPHA TV',0,1),
		('R11','R11','R11',0,1),
		('R12','R12','R12',0,1),
		('Travel','Travel','Travel',0,1),
		('Fame Story','Fame Story','Fame Story',0,1),
		('R2','R2','R2',0,1),
		('RTVi','RTVi','RTVi',0,1),
		('RTVi NASHE KINO','RTVi NASHE KINO','RTVi NASHE KINO',0,1),
		('RTVi DETSKY MIR / TELECLUB','RTVi DETSKY MIR / TELECLUB','RTVi DETSKY MIR / TELECLUB',0,1),
		('Suroyo TV','Suroyo TV','Suroyo TV',0,1),
		('BH-TV1','BH-TV1','BH-TV1',0,1),
		('BH-Radio1','BH-Radio1','BH-Radio1',0,1),
		('Al Balagh Radio','Al Balagh Radio','Al Balagh Radio',0,1),
		('Kalifa TV','Kalifa TV','Kalifa TV',0,1),
		('Election Monitor Iraq','Election Monitor Iraq','Election Monitor Iraq',0,1),
		('ART VARIETY / EUROPE - ARABESQUE','ART VARIETY / EUROPE - ARABESQUE','ART VARIETY / EUROPE - ARABESQUE',0,1),
		('ART CHILDREN/TARAB - ARABESQUE','ART CHILDREN/TARAB - ARABESQUE','ART CHILDREN/TARAB - ARABESQUE',0,1),
		('ART MOVIES - ARABESQUE','ART MOVIES - ARABESQUE','ART MOVIES - ARABESQUE',0,1),
		('TEST ART MOVIES2 - ARABESQUE','TEST ART MOVIES2 - ARABESQUE','TEST ART MOVIES2 - ARABESQUE',0,1),
		('NILE DRAMA - ARABESQUE','NILE DRAMA - ARABESQUE','NILE DRAMA - ARABESQUE',0,1),
		('LBC EUROPE - ARABESQUE','LBC EUROPE - ARABESQUE','LBC EUROPE - ARABESQUE',0,1),
		('ART SPORT 1 - ARABESQUE','ART SPORT 1 - ARABESQUE','ART SPORT 1 - ARABESQUE',0,1),
		('IQRAA - ARABESQUE','IQRAA - ARABESQUE','IQRAA - ARABESQUE',0,1),
		('ALGERIAN TV - ARABESQUE','ALGERIAN TV - ARABESQUE','ALGERIAN TV - ARABESQUE',0,1),
		('ART SPORT INTERNATIONAL','ART SPORT INTERNATIONAL','ART SPORT INTERNATIONAL',0,1),
		('MBC - ARABESQUE','MBC - ARABESQUE','MBC - ARABESQUE',0,1),
		('ART SPORT 2 - ARABESQUE','ART SPORT 2 - ARABESQUE','ART SPORT 2 - ARABESQUE',0,1),
		('ART SPORT 3 - ARABESQUE','ART SPORT 3 - ARABESQUE','ART SPORT 3 - ARABESQUE',0,1),
		('ART SPORT 4 - ARABESQUE','ART SPORT 4 - ARABESQUE','ART SPORT 4 - ARABESQUE',0,1),
		('ART HEKAYAT - ARABESQUE','ART HEKAYAT - ARABESQUE','ART HEKAYAT - ARABESQUE',0,1),
		('FUTURE TV - ARABESQUE','FUTURE TV - ARABESQUE','FUTURE TV - ARABESQUE',0,1),
		('Bolsa','Bolsa','Bolsa',0,1),
		('Telesierra','Telesierra','Telesierra',0,1),
		('Reform Radio','Reform Radio','Reform Radio',0,1),
		('DPTV','DPTV','DPTV',0,1),
		('Maharaji','Maharaji','Maharaji',0,1),
		('Satisfaction SCT','Satisfaction SCT','Satisfaction SCT',0,1),
		('R9','R9','R9',0,1),
		('SuperSport2','SuperSport2','SuperSport2',0,1),
		('TCM','TCM','TCM',0,1),
		('CCTV4','CCTV4','CCTV4',0,1),
		('R10','R10','R10',0,1),
		('R8','R8','R8',0,1),
		('Cartoon','Cartoon','Cartoon',0,1),
		('Promo','Promo','Promo',0,1),
		('GBC','GBC','GBC',0,1),
		('ET-3','ET-3','ET-3',0,1),
		('ERA1','ERA1','ERA1',0,1),
		('ERA2','ERA2','ERA2',0,1),
		('ERA SPORT','ERA SPORT','ERA SPORT',0,1),
		('R7','R7','R7',0,1),
		('GAMES','GAMES','GAMES',0,1),
		('Mad Music Hits GR','Mad Music Hits GR','Mad Music Hits GR',0,1),
		('Mad Music Lounge   TV','Mad Music Lounge   TV','Mad Music Lounge   TV',0,1),
		('Mad Music Greek','Mad Music Greek','Mad Music Greek',0,1),
		('Mad Music Rebetico','Mad Music Rebetico','Mad Music Rebetico',0,1),
		('Mad Music  Seasonal','Mad Music  Seasonal','Mad Music  Seasonal',0,1),
		('NET','NET','NET',0,1),
		('MAD T.V','MAD T.V','MAD T.V',0,1),
		('ET-1','ET-1','ET-1',0,1),
		('ERA3','ERA3','ERA3',0,1),
		('E! Entertainment','E! Entertainment','E! Entertainment',0,1),
		('MAD MUSIC  Hits GR','MAD MUSIC  Hits GR','MAD MUSIC  Hits GR',0,1),
		('MAD MUSIC Lounge TV','MAD MUSIC Lounge TV','MAD MUSIC Lounge TV',0,1),
		('MAD MUSIC Greek','MAD MUSIC Greek','MAD MUSIC Greek',0,1),
		('MAD MUSIC Rebetico','MAD MUSIC Rebetico','MAD MUSIC Rebetico',0,1),
		('MAD MUSIC Seasonal','MAD MUSIC Seasonal','MAD MUSIC Seasonal',0,1),
		('CFI PECO PRO','CFI PECO PRO','CFI PECO PRO',0,1),
		('MCM Europe','MCM Europe','MCM Europe',0,1),
		('Radio 2000','Radio 2000','Radio 2000',0,1),
		('RCF','RCF','RCF',0,1),
		('TUA Channel','TUA Channel','TUA Channel',0,1),
		('MEZZO','MEZZO','MEZZO',0,1),
		('Res HB3-77','Res HB3-77','Res HB3-77',0,1),
		('TTN','TTN','TTN',0,1),
		('TAMIL Radio','TAMIL Radio','TAMIL Radio',0,1),
		('GRAND','GRAND','GRAND',0,1),
		('Sexysat 2','Sexysat 2','Sexysat 2',0,1),
		('GOURMET TV','GOURMET TV','GOURMET TV',0,1),
		('TELIF','TELIF','TELIF',0,1),
		('EpgOpenTV','EpgOpenTV','EpgOpenTV',0,1),
		('Polsat','Polsat','Polsat',0,1),
		('TV 4','TV 4','TV 4',0,1),
		('Polsat 2','Polsat 2','Polsat 2',0,1),
		('Discovery','Discovery','Discovery',0,1),
		('Animal Planet','Animal Planet','Animal Planet',0,1),
		('AXN','AXN','AXN',0,1),
		('02020009','02020009','02020009',0,1),
		('KINO POLSKA','KINO POLSKA','KINO POLSKA',0,1),
		('Fox Kids','Fox Kids','Fox Kids',0,1),
		('TVP1','TVP1','TVP1',0,1),
		('Test2','Test2','Test2',0,1),
		('TVP2','TVP2','TVP2',0,1),
		('Test6','Test6','Test6',0,1),
		('01 27 01 02','01 27 01 02','01 27 01 02',0,1),
		('01 32 01 06','01 32 01 06','01 32 01 06',0,1),
		('02010011','02010011','02010011',0,1),
		('Sa mm ux 10','Sa mm ux 10','Sa mm ux 10',0,1),
		('eMail','eMail','eMail',0,1),
		('Gra1','Gra1','Gra1',0,1),
		('SMSChat','SMSChat','SMSChat',0,1),
		('EDCPS','EDCPS','EDCPS',0,1),
		('Cartoon Net./TCM','Cartoon Net./TCM','Cartoon Net./TCM',0,1),
		('Europa Europa','Europa Europa','Europa Europa',0,1),
		('Club','Club','Club',0,1),
		('Info/Teleuniwersytet','Info/Teleuniwersytet','Info/Teleuniwersytet',0,1),
		('Polsat Sport','Polsat Sport','Polsat Sport',0,1),
		('Reality TV','Reality TV','Reality TV',0,1),
		('Test5','Test5','Test5',0,1),
		('Zdrowie i Uroda','Zdrowie i Uroda','Zdrowie i Uroda',0,1),
		('Travel','Travel','Travel',0,1),
		('Science','Science','Science',0,1),
		('Civilisation','Civilisation','Civilisation',0,1),
		('RMF FM','RMF FM','RMF FM',0,1),
		('RADIO PLUS','RADIO PLUS','RADIO PLUS',0,1),
		('RMF Classic','RMF Classic','RMF Classic',0,1),
		('Radio Polonia','Radio Polonia','Radio Polonia',0,1),
		('Jedynka - PR','Jedynka - PR','Jedynka - PR',0,1),
		('Portal ITV','Portal ITV','Portal ITV',0,1),
		('TEST12322','TEST12322','TEST12322',0,1),
		('Przewodnik','Przewodnik','Przewodnik',0,1),
		('Pogoda','Pogoda','Pogoda',0,1),
		('Test','Test','Test',0,1),
		('Gra2','Gra2','Gra2',0,1),
		('Gra3','Gra3','Gra3',0,1),
		('TV Banking','TV Banking','TV Banking',0,1),
		('GETKEY','GETKEY','GETKEY',0,1),
		('SF1','SF1','SF1',0,1),
		('SRG-DRS 1','SRG-DRS 1','SRG-DRS 1',0,1),
		('SRG-DRS 2','SRG-DRS 2','SRG-DRS 2',0,1),
		('SRG-DRS 3','SRG-DRS 3','SRG-DRS 3',0,1),
		('SF2','SF2','SF2',0,1),
		('SRG-DRS Virus','SRG-DRS Virus','SRG-DRS Virus',0,1),
		('SRG-DRS MW531','SRG-DRS MW531','SRG-DRS MW531',0,1),
		('SRG-Rumantsch','SRG-Rumantsch','SRG-Rumantsch',0,1),
		('SFi','SFi','SFi',0,1),
		('SSR-La 1ere','SSR-La 1ere','SSR-La 1ere',0,1),
		('SSR-Espace 2','SSR-Espace 2','SSR-Espace 2',0,1),
		('SSR-Couleur3','SSR-Couleur3','SSR-Couleur3',0,1),
		('TSR1','TSR1','TSR1',0,1),
		('SSR-Option Musique','SSR-Option Musique','SSR-Option Musique',0,1),
		('SSR-Rete Uno','SSR-Rete Uno','SSR-Rete Uno',0,1),
		('SSR-Rete Due','SSR-Rete Due','SSR-Rete Due',0,1),
		('TSR2','TSR2','TSR2',0,1),
		('SSR-Rete Tre','SSR-Rete Tre','SSR-Rete Tre',0,1),
		('Swiss Classic','Swiss Classic','Swiss Classic',0,1),
		('Swiss Pop','Swiss Pop','Swiss Pop',0,1),
		('TSI1','TSI1','TSI1',0,1),
		('Swiss Jazz','Swiss Jazz','Swiss Jazz',0,1),
		('TSI2','TSI2','TSI2',0,1),
		('SRG SSR SAT Access','SRG SSR SAT Access','SRG SSR SAT Access',0,1),
		('INT1 FAMILY RADIO','INT1 FAMILY RADIO','INT1 FAMILY RADIO',0,1),
		('RADIO 74','RADIO 74','RADIO 74',0,1),
		('AMITIE 74','AMITIE 74','AMITIE 74',0,1),
		('FAMILY Radio','FAMILY Radio','FAMILY Radio',0,1),
		('Eviva Radio','Eviva Radio','Eviva Radio',0,1),
		('RVi 1 (VRT)','RVi 1 (VRT)','RVi 1 (VRT)',0,1),
		('ALMAHABBA','ALMAHABBA','ALMAHABBA',0,1),
		('RVi 2 (VRT )','RVi 2 (VRT )','RVi 2 (VRT )',0,1),
		('EbS','EbS','EbS',0,1),
		('metv','metv','metv',0,1),
		('DENGE MEZOPOTAMIA','DENGE MEZOPOTAMIA','DENGE MEZOPOTAMIA',0,1),
		('TOP TWO','TOP TWO','TOP TWO',0,1),
		('INT2 FAMILY RADIO','INT2 FAMILY RADIO','INT2 FAMILY RADIO',0,1),
		('Framboise','Framboise','Framboise',0,1),
		('Xstream','Xstream','Xstream',0,1),
		('Zee TV','Zee TV','Zee TV',0,1),
		('Zee Cinema','Zee Cinema','Zee Cinema',0,1),
		('Alpha ETC Punjabi','Alpha ETC Punjabi','Alpha ETC Punjabi',0,1),
		('2M Maroc','2M Maroc','2M Maroc',0,1),
		('Radio 2M Maroc','Radio 2M Maroc','Radio 2M Maroc',0,1),
		('ARY DIGITAL','ARY DIGITAL','ARY DIGITAL',0,1),
		('B4U Movies','B4U Movies','B4U Movies',0,1),
		('Jupisat','Jupisat','Jupisat',0,1),
		('Kaon OTA','Kaon OTA','Kaon OTA',0,1),
		('Opentech','Opentech','Opentech',0,1),
		('Eagle','Eagle','Eagle',0,1),
		('Allsatcom4','Allsatcom4','Allsatcom4',0,1),
		('Manhattan','Manhattan','Manhattan',0,1),
		('SKY Prima Fila','SKY Prima Fila','SKY Prima Fila',0,1),
		('Prima Fila 1','Prima Fila 1','Prima Fila 1',0,1),
		('Prima Fila 2','Prima Fila 2','Prima Fila 2',0,1),
		('Prima Fila 3','Prima Fila 3','Prima Fila 3',0,1),
		('Prima Fila 4','Prima Fila 4','Prima Fila 4',0,1),
		('Prima Fila 20','Prima Fila 20','Prima Fila 20',0,1),
		('Prima Fila 21','Prima Fila 21','Prima Fila 21',0,1),
		('Prima Fila 22','Prima Fila 22','Prima Fila 22',0,1),
		('Prima Fila 23','Prima Fila 23','Prima Fila 23',0,1),
		('SKY Prima Fila','SKY Prima Fila','SKY Prima Fila',0,1),
		('Dl951','Dl951','Dl951',0,1),
		('Dl952','Dl952','Dl952',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('Sharjah','Sharjah','Sharjah',0,1),
		('Qatar','Qatar','Qatar',0,1),
		('Saudi 1','Saudi 1','Saudi 1',0,1),
		('Kuwait','Kuwait','Kuwait',0,1),
		('Libya','Libya','Libya',0,1),
		('Sudan','Sudan','Sudan',0,1),
		('Oman','Oman','Oman',0,1),
		('ESC','ESC','ESC',0,1),
		('Test','Test','Test',0,1),
		('Test','Test','Test',0,1),
		('Sharjah   R1','Sharjah   R1','Sharjah   R1',0,1),
		('Qatar R1','Qatar R1','Qatar R1',0,1),
		('Saudi1 R1','Saudi1 R1','Saudi1 R1',0,1),
		('Kuwait R1','Kuwait R1','Kuwait R1',0,1),
		('Sudan R1','Sudan R1','Sudan R1',0,1),
		('Oman R1','Oman R1','Oman R1',0,1),
		('ESC R1','ESC R1','ESC R1',0,1),
		('Sharjah R2','Sharjah R2','Sharjah R2',0,1),
		('Saudi1 R2','Saudi1 R2','Saudi1 R2',0,1),
		('Kuwait R2','Kuwait R2','Kuwait R2',0,1),
		('Sudan R2','Sudan R2','Sudan R2',0,1),
		('Oman R2','Oman R2','Oman R2',0,1),
		('ESC R2','ESC R2','ESC R2',0,1),
		('Oman R3','Oman R3','Oman R3',0,1),
		('ESC R3','ESC R3','ESC R3',0,1),
		('ASTON DOWNLOAD','ASTON DOWNLOAD','ASTON DOWNLOAD',0,1),
		('CINE FX','CINE FX','CINE FX',0,1),
		('TERRA NOVA','TERRA NOVA','TERRA NOVA',0,1),
		('AB SAT PROMO','AB SAT PROMO','AB SAT PROMO',0,1),
		('PASSIONS','PASSIONS','PASSIONS',0,1),
		('DAN JAYA TV','DAN JAYA TV','DAN JAYA TV',0,1),
		('DAN RAJ TV','DAN RAJ TV','DAN RAJ TV',0,1),
		('DAN TRT','DAN TRT','DAN TRT',0,1),
		('DAN TAMIL ALAI','DAN TAMIL ALAI','DAN TAMIL ALAI',0,1),
		('DAN CEYLON TV','DAN CEYLON TV','DAN CEYLON TV',0,1),
		('DAN CINEMA','DAN CINEMA','DAN CINEMA',0,1),
		('DAN MUSIC','DAN MUSIC','DAN MUSIC',0,1),
		('Radio du Monde','Radio du Monde','Radio du Monde',0,1),
		('NationalGeo','NationalGeo','NationalGeo',0,1),
		('History','History','History',0,1),
		('Boomerang','Boomerang','Boomerang',0,1),
		('Hallmark','Hallmark','Hallmark',0,1),
		('Fox','Fox','Fox',0,1),
		('Fox Kids +1','Fox Kids +1','Fox Kids +1',0,1),
		('Cartoon +1','Cartoon +1','Cartoon +1',0,1),
		('Universal','Universal','Universal',0,1),
		('Roma Channel','Roma Channel','Roma Channel',0,1),
		('Dl1011','Dl1011','Dl1011',0,1),
		('Dl1012','Dl1012','Dl1012',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('TV BIZNES','TV BIZNES','TV BIZNES',0,1),
		('DISCOVERY','DISCOVERY','DISCOVERY',0,1),
		('TV 4','TV 4','TV 4',0,1),
		('4fun.TV','4fun.TV','4fun.TV',0,1),
		('EUSP NEWS PL','EUSP NEWS PL','EUSP NEWS PL',0,1),
		('PLANETE','PLANETE','PLANETE',0,1),
		('MINIMINI','MINIMINI','MINIMINI',0,1),
		('CLUB','CLUB','CLUB',0,1),
		('XtraMusicSwiat','XtraMusicSwiat','XtraMusicSwiat',0,1),
		('ESP','ESP','ESP',0,1),
		('EXTREME SPORTS','EXTREME SPORTS','EXTREME SPORTS',0,1),
		('MTV POLSKA','MTV POLSKA','MTV POLSKA',0,1),
		('XtraMusicSwiat','XtraMusicSwiat','XtraMusicSwiat',0,1),
		('XtraMusicKlasyka','XtraMusicKlasyka','XtraMusicKlasyka',0,1),
		('XtraMusicKlasyka','XtraMusicKlasyka','XtraMusicKlasyka',0,1),
		('Xtramusic1','Xtramusic1','Xtramusic1',0,1),
		('Xtramusic2','Xtramusic2','Xtramusic2',0,1),
		('AXN','AXN','AXN',0,1),
		('PILOT','PILOT','PILOT',0,1),
		('EPG','EPG','EPG',0,1),
		('TPR','TPR','TPR',0,1),
		('TPS star','TPS star','TPS star',0,1),
		('TPS Cinextreme','TPS Cinextreme','TPS Cinextreme',0,1),
		('TPS Cinefamily','TPS Cinefamily','TPS Cinefamily',0,1),
		('TPS Evasion','TPS Evasion','TPS Evasion',0,1),
		('Boutique Votre Abonnement','Boutique Votre Abonnement','Boutique Votre Abonnement',0,1),
		('INFO EXPRESS','INFO EXPRESS','INFO EXPRESS',0,1),
		('Appli MI 2','Appli MI 2','Appli MI 2',0,1),
		('Notification Dbits','Notification Dbits','Notification Dbits',0,1),
		('TPR','TPR','TPR',0,1),
		('Infosport','Infosport','Infosport',0,1),
		('Fun TV','Fun TV','Fun TV',0,1),
		('Teva','Teva','Teva',0,1),
		('Festival','Festival','Festival',0,1),
		('PIWI','PIWI','PIWI',0,1),
		('MULTIVISION 8','MULTIVISION 8','MULTIVISION 8',0,1),
		('M6 Music','M6 Music','M6 Music',0,1),
		('M6 Boutique La Chane','M6 Boutique La Chane','M6 Boutique La Chane',0,1),
		('France bleu','France bleu','France bleu',0,1),
		('France Info','France Info','France Info',0,1),
		('France Inter','France Inter','France Inter',0,1),
		('Hector','Hector','Hector',0,1),
		('Beur FM','Beur FM','Beur FM',0,1),
		('quizz_Satisfaction','quizz_Satisfaction','quizz_Satisfaction',0,1),
		('PUSH_PVR','PUSH_PVR','PUSH_PVR',0,1),
		('CHAINE FI','CHAINE FI','CHAINE FI',0,1),
		('TV MAIL','TV MAIL','TV MAIL',0,1),
		('LCI','LCI','LCI',0,1),
		('FRANCE 5','FRANCE 5','FRANCE 5',0,1),
		('FRANCE 2','FRANCE 2','FRANCE 2',0,1),
		('ENGLISH PREMIER LEAGUE','ENGLISH PREMIER LEAGUE','ENGLISH PREMIER LEAGUE',0,1),
		('FRANCE 3','FRANCE 3','FRANCE 3',0,1),
		('PARIS PREMIERE','PARIS PREMIERE','PARIS PREMIERE',0,1),
		('ARTE','ARTE','ARTE',0,1),
		('I TELE','I TELE','I TELE',0,1),
		('Mathilda','Mathilda','Mathilda',0,1),
		('Mon Bazar','Mon Bazar','Mon Bazar',0,1),
		('RADIO2000','RADIO2000','RADIO2000',0,1),
		('Votre_Contrat','Votre_Contrat','Votre_Contrat',0,1),
		('TFOU','TFOU','TFOU',0,1),
		('Maillon Faible','Maillon Faible','Maillon Faible',0,1),
		('X X L','X X L','X X L',0,1),
		('SAILING CHANNEL','SAILING CHANNEL','SAILING CHANNEL',0,1),
		('Quizz_TF1','Quizz_TF1','Quizz_TF1',0,1),
		('FRANCAISE DES JEUX','FRANCAISE DES JEUX','FRANCAISE DES JEUX',0,1),
		('GAME AVENUE','GAME AVENUE','GAME AVENUE',0,1),
		('Equidia Alpha','Equidia Alpha','Equidia Alpha',0,1),
		('Quitte ou double','Quitte ou double','Quitte ou double',0,1),
		('M6 Music Rock','M6 Music Rock','M6 Music Rock',0,1),
		('M6 Music Black','M6 Music Black','M6 Music Black',0,1),
		('EQUIDIA','EQUIDIA','EQUIDIA',0,1),
		('ESPN CLASSIC SPORT','ESPN CLASSIC SPORT','ESPN CLASSIC SPORT',0,1),
		('SIC','SIC','SIC',0,1),
		('BBC PRIME','BBC PRIME','BBC PRIME',0,1),
		('TV BREIZH','TV BREIZH','TV BREIZH',0,1),
		('LA CHAINE PARLEMENTAIRE','LA CHAINE PARLEMENTAIRE','LA CHAINE PARLEMENTAIRE',0,1),
		('Europe 1','Europe 1','Europe 1',0,1),
		('Europe 2','Europe 2','Europe 2',0,1),
		('RFM','RFM','RFM',0,1),
		('RTL','RTL','RTL',0,1),
		('NRJ','NRJ','NRJ',0,1),
		('Radio Classique','Radio Classique','Radio Classique',0,1),
		('Chrie FM','Chrie FM','Chrie FM',0,1),
		('Fun Radio','Fun Radio','Fun Radio',0,1),
		('RTL 2','RTL 2','RTL 2',0,1),
		('RMC','RMC','RMC',0,1),
		('MFM','MFM','MFM',0,1),
		('Nostalgie','Nostalgie','Nostalgie',0,1),
		('HITWEST','HITWEST','HITWEST',0,1),
		('01 46 04 54','01 46 04 54','01 46 04 54',0,1),
		('GUIDE','GUIDE','GUIDE',0,1),
		('BANDIAGARA','BANDIAGARA','BANDIAGARA',0,1),
		('EUROSPORT','EUROSPORT','EUROSPORT',0,1),
		('HISTOIRE','HISTOIRE','HISTOIRE',0,1),
		('TF1','TF1','TF1',0,1),
		('TFOU','TFOU','TFOU',0,1),
		('Odysse','Odysse','Odysse',0,1),
		('TF6','TF6','TF6',0,1),
		('RFO SAT','RFO SAT','RFO SAT',0,1),
		('Tltoon+1','Tltoon+1','Tltoon+1',0,1),
		('France Musiques','France Musiques','France Musiques',0,1),
		('FIP','FIP','FIP',0,1),
		('France Culture','France Culture','France Culture',0,1),
		('Le Mouv','Le Mouv','Le Mouv',0,1),
		('BFM','BFM','BFM',0,1),
		('RFI','RFI','RFI',0,1),
		('Skyrock','Skyrock','Skyrock',0,1),
		('Radio Courtoisie','Radio Courtoisie','Radio Courtoisie',0,1),
		('Contact FM','Contact FM','Contact FM',0,1),
		('Zi-One','Zi-One','Zi-One',0,1),
		('PLAYIN TV','PLAYIN TV','PLAYIN TV',0,1),
		('Mto Express','Mto Express','Mto Express',0,1),
		('STATIC','STATIC','STATIC',0,1),
		('Mto Express','Mto Express','Mto Express',0,1),
		('CCTV9','CCTV9','CCTV9',0,1),
		('Euronews france','Euronews france','Euronews france',0,1),
		('KTO','KTO','KTO',0,1),
		('God TV','God TV','God TV',0,1),
		('Boomerang','Boomerang','Boomerang',0,1),
		('DEMAIN','DEMAIN','DEMAIN',0,1),
		('Tl Mlody','Tl Mlody','Tl Mlody',0,1),
		('RTR','RTR','RTR',0,1),
		('TFJ','TFJ','TFJ',0,1),
		('Berbre Tlvision','Berbre Tlvision','Berbre Tlvision',0,1),
		('RADIO BERBERE','RADIO BERBERE','RADIO BERBERE',0,1),
		('PINK TV','PINK TV','PINK TV',0,1),
		('Nickelodeon Euro','Nickelodeon Euro','Nickelodeon Euro',0,1),
		('MTV Portugal','MTV Portugal','MTV Portugal',0,1),
		('MTV Polska','MTV Polska','MTV Polska',0,1),
		('Game One','Game One','Game One',0,1),
		('MTV Classic','MTV Classic','MTV Classic',0,1),
		('MTV H','MTV H','MTV H',0,1),
		('MTV 1','MTV 1','MTV 1',0,1),
		('VH1','VH1','VH1',0,1),
		('MTV F','MTV F','MTV F',0,1),
		('MTV 5','MTV 5','MTV 5',0,1),
		('Service 8','Service 8','Service 8',0,1),
		('Multivision NOOS','Multivision NOOS','Multivision NOOS',0,1),
		('TPR','TPR','TPR',0,1),
		('MULTIVISION 1','MULTIVISION 1','MULTIVISION 1',0,1),
		('MULTIVISION 2','MULTIVISION 2','MULTIVISION 2',0,1),
		('MULTIVISION 3','MULTIVISION 3','MULTIVISION 3',0,1),
		('MULTIVISION 4','MULTIVISION 4','MULTIVISION 4',0,1),
		('MULTIVISION 5','MULTIVISION 5','MULTIVISION 5',0,1),
		('MULTIVISION 6','MULTIVISION 6','MULTIVISION 6',0,1),
		('MULTIVISION 7','MULTIVISION 7','MULTIVISION 7',0,1),
		('MULTIVISION','MULTIVISION','MULTIVISION',0,1),
		('PPV_OPTV','PPV_OPTV','PPV_OPTV',0,1),
		('RADIO ORIENT','RADIO ORIENT','RADIO ORIENT',0,1),
		('FD auditorium','FD auditorium','FD auditorium',0,1),
		('Chillout','Chillout','Chillout',0,1),
		('Gold','Gold','Gold',0,1),
		('Old Gold','Old Gold','Old Gold',0,1),
		('SoulClassics','SoulClassics','SoulClassics',0,1),
		('Love Songs','Love Songs','Love Songs',0,1),
		('Easy Listening','Easy Listening','Easy Listening',0,1),
		('I Classici','I Classici','I Classici',0,1),
		('Lirica','Lirica','Lirica',0,1),
		('Jazz','Jazz','Jazz',0,1),
		('Modern Jazz','Modern Jazz','Modern Jazz',0,1),
		('RitmoLatino','RitmoLatino','RitmoLatino',0,1),
		('Blues','Blues','Blues',0,1),
		('Country','Country','Country',0,1),
		('New Country','New Country','New Country',0,1),
		('Freq Italia','Freq Italia','Freq Italia',0,1),
		('Caccia e Pesca','Caccia e Pesca','Caccia e Pesca',0,1),
		('Mosaico Audio','Mosaico Audio','Mosaico Audio',0,1),
		('Mosaico Audio','Mosaico Audio','Mosaico Audio',0,1),
		('Zona Giochi','Zona Giochi','Zona Giochi',0,1),
		('Zona Giochi','Zona Giochi','Zona Giochi',0,1),
		('Test 8','Test 8','Test 8',0,1),
		('SKY Assist','SKY Assist','SKY Assist',0,1),
		('SKY Assist','SKY Assist','SKY Assist',0,1),
		('Sky Assist','Sky Assist','Sky Assist',0,1),
		('Planet','Planet','Planet',0,1),
		('Jimmy','Jimmy','Jimmy',0,1),
		('Hit Parade','Hit Parade','Hit Parade',0,1),
		('Special Event','Special Event','Special Event',0,1),
		('Soft Rock','Soft Rock','Soft Rock',0,1),
		('ClassicRock','ClassicRock','ClassicRock',0,1),
		('Altern. Rock','Altern. Rock','Altern. Rock',0,1),
		('Hard Rock','Hard Rock','Hard Rock',0,1),
		('Dance','Dance','Dance',0,1),
		('French Hits','French Hits','French Hits',0,1),
		('Sky On Air','Sky On Air','Sky On Air',0,1),
		('Alice','Alice','Alice',0,1),
		('Leonardo','Leonardo','Leonardo',0,1),
		('Nuvolari','Nuvolari','Nuvolari',0,1),
		('Marcopolo','Marcopolo','Marcopolo',0,1),
		('Radio Mater','Radio Mater','Radio Mater',0,1),
		('OUT IP DATA TS1','OUT IP DATA TS1','OUT IP DATA TS1',0,1),
		('Business Tv','Business Tv','Business Tv',0,1),
		('Made In Italy','Made In Italy','Made In Italy',0,1),
		('Ceramicanda','Ceramicanda','Ceramicanda',0,1),
		('RADIO ARMENIA','RADIO ARMENIA','RADIO ARMENIA',0,1),
		('HB CHANNEL','HB CHANNEL','HB CHANNEL',0,1),
		('AL JAZEERA','AL JAZEERA','AL JAZEERA',0,1),
		('UNOSAT','UNOSAT','UNOSAT',0,1),
		('Coming Soon TV','Coming Soon TV','Coming Soon TV',0,1),
		('MediterraneoSat1','MediterraneoSat1','MediterraneoSat1',0,1),
		('GAY.TV','GAY.TV','GAY.TV',0,1),
		('Vietnamese PR','Vietnamese PR','Vietnamese PR',0,1),
		('SRVR7 XP70','SRVR7 XP70','SRVR7 XP70',0,1),
		('DunaTV','DunaTV','DunaTV',0,1),
		('TV7 Tunis','TV7 Tunis','TV7 Tunis',0,1),
		('AH-EMP4-DATA','AH-EMP4-DATA','AH-EMP4-DATA',0,1),
		('Khabar TV','Khabar TV','Khabar TV',0,1),
		('Kossuth','Kossuth','Kossuth',0,1),
		('Petofi','Petofi','Petofi',0,1),
		('Radio Tunis','Radio Tunis','Radio Tunis',0,1),
		('R.Citta Futura','R.Citta Futura','R.Citta Futura',0,1),
		('ReteSport','ReteSport','ReteSport',0,1),
		('Radio 6','Radio 6','Radio 6',0,1),
		('LIDER TV AZE','LIDER TV AZE','LIDER TV AZE',0,1),
		('Ecoradio','Ecoradio','Ecoradio',0,1),
		('TeleRadioStereo','TeleRadioStereo','TeleRadioStereo',0,1),
		('PROMO','PROMO','PROMO',0,1),
		('TV PIREAS','TV PIREAS','TV PIREAS',0,1),
		('RTS SAT','RTS SAT','RTS SAT',0,1),
		('TV MAGIC','TV MAGIC','TV MAGIC',0,1),
		('EXTRA 3 CHANNEL','EXTRA 3 CHANNEL','EXTRA 3 CHANNEL',0,1),
		('ERT SAT','ERT SAT','ERT SAT',0,1),
		('HOLIDAYS IN GR CHANNEL','HOLIDAYS IN GR CHANNEL','HOLIDAYS IN GR CHANNEL',0,1),
		('TELEASTY','TELEASTY','TELEASTY',0,1),
		('MKTV','MKTV','MKTV',0,1),
		('SPORT FM','SPORT FM','SPORT FM',0,1),
		('EROTIKOS FM','EROTIKOS FM','EROTIKOS FM',0,1),
		('FLASH','FLASH','FLASH',0,1),
		('SUPER STAR','SUPER STAR','SUPER STAR',0,1),
		('RADIOASTY','RADIOASTY','RADIOASTY',0,1),
		('BEST 92,6','BEST 92,6','BEST 92,6',0,1),
		('HPEIROS 94,5 FM','HPEIROS 94,5 FM','HPEIROS 94,5 FM',0,1),
		('KISS FM','KISS FM','KISS FM',0,1),
		('RADIO GOLD','RADIO GOLD','RADIO GOLD',0,1),
		('NITRO','NITRO','NITRO',0,1),
		('SFERA','SFERA','SFERA',0,1),
		('ATHINA 9,84','ATHINA 9,84','ATHINA 9,84',0,1),
		('RADIO BEOGRAD','RADIO BEOGRAD','RADIO BEOGRAD',0,1),
		('ALPHA NEWS','ALPHA NEWS','ALPHA NEWS',0,1),
		('ROCK RAD THESS','ROCK RAD THESS','ROCK RAD THESS',0,1),
		('R.GREECE','R.GREECE','R.GREECE',0,1),
		('RADIO THESSAL.','RADIO THESSAL.','RADIO THESSAL.',0,1),
		('ROCK FM','ROCK FM','ROCK FM',0,1),
		('INTERNET DATA','INTERNET DATA','INTERNET DATA',0,1),
		('SLO-TV1','SLO-TV1','SLO-TV1',0,1),
		('SLO-TV2','SLO-TV2','SLO-TV2',0,1),
		('SLO-RA1-INF','SLO-RA1-INF','SLO-RA1-INF',0,1),
		('SLO-RA2','SLO-RA2','SLO-RA2',0,1),
		('SLO-RA3','SLO-RA3','SLO-RA3',0,1),
		('MAGIC','MAGIC','MAGIC',0,1),
		('COUNTDOWN','COUNTDOWN','COUNTDOWN',0,1),
		('ITALIAN MUSIC','ITALIAN MUSIC','ITALIAN MUSIC',0,1),
		('RADIO SI','RADIO SI','RADIO SI',0,1),
		('PLEASURE TV','PLEASURE TV','PLEASURE TV',0,1),
		('BVN-TV','BVN-TV','BVN-TV',0,1),
		('OASI.TV','OASI.TV','OASI.TV',0,1),
		('CAPODISTRIA','CAPODISTRIA','CAPODISTRIA',0,1),
		('OGNJISCE SI','OGNJISCE SI','OGNJISCE SI',0,1),
		('BLU LINE TV','BLU LINE TV','BLU LINE TV',0,1),
		('DANCE TV','DANCE TV','DANCE TV',0,1),
		('NTV HAYAT SAT','NTV HAYAT SAT','NTV HAYAT SAT',0,1),
		('SAT8','SAT8','SAT8',0,1),
		('RNW-1','RNW-1','RNW-1',0,1),
		('RNW-2','RNW-2','RNW-2',0,1),
		('CAMPANIA SAT','CAMPANIA SAT','CAMPANIA SAT',0,1),
		('S24 TV','S24 TV','S24 TV',0,1),
		('www.sat-update.com','www.sat-update.com','www.sat-update.com',0,1),
		('NAPOLI INT.','NAPOLI INT.','NAPOLI INT.',0,1),
		('Telepace','Telepace','Telepace',0,1),
		('Yemen TV','Yemen TV','Yemen TV',0,1),
		('Aden Radio','Aden Radio','Aden Radio',0,1),
		('Syria Satellite Channel','Syria Satellite Channel','Syria Satellite Channel',0,1),
		('Voice of People','Voice of People','Voice of People',0,1),
		('Main General Program','Main General Program','Main General Program',0,1),
		('SAT 7','SAT 7','SAT 7',0,1),
		('TWR Radio','TWR Radio','TWR Radio',0,1),
		('Abu Dhabi TV','Abu Dhabi TV','Abu Dhabi TV',0,1),
		('Emirates FM','Emirates FM','Emirates FM',0,1),
		('EQUIDIA PRO','EQUIDIA PRO','EQUIDIA PRO',0,1),
		('EQUIDIA PRO P1','EQUIDIA PRO P1','EQUIDIA PRO P1',0,1),
		('Radio Montenegro','Radio Montenegro','Radio Montenegro',0,1),
		('RTV Montenegro','RTV Montenegro','RTV Montenegro',0,1),
		('Kol Haneshama','Kol Haneshama','Kol Haneshama',0,1),
		('Jordan TV','Jordan TV','Jordan TV',0,1),
		('Radio THOLLON','Radio THOLLON','Radio THOLLON',0,1),
		('Data Polycom (FILEAS)','Data Polycom (FILEAS)','Data Polycom (FILEAS)',0,1),
		('Service Test','Service Test','Service Test',0,1),
		('SARDEGNA UNO','SARDEGNA UNO','SARDEGNA UNO',0,1),
		('VOICE OF CRO','VOICE OF CRO','VOICE OF CRO',0,1),
		('OTVORENI','OTVORENI','OTVORENI',0,1),
		('MEDIASERVIS','MEDIASERVIS','MEDIASERVIS',0,1),
		('HNR','HNR','HNR',0,1),
		('BBC','BBC','BBC',0,1),
		('PUGLIA CHANNEL','PUGLIA CHANNEL','PUGLIA CHANNEL',0,1),
		('RKC','RKC','RKC',0,1),
		('Narodni radio','Narodni radio','Narodni radio',0,1),
		('R MIR M.','R MIR M.','R MIR M.',0,1),
		('FEED1','FEED1','FEED1',0,1),
		('DALMATIA','DALMATIA','DALMATIA',0,1),
		('ESP News Greek','ESP News Greek','ESP News Greek',0,1),
		('ESP News Test','ESP News Test','ESP News Test',0,1),
		('EUROSPORTNEWS','EUROSPORTNEWS','EUROSPORTNEWS',0,1),
		('ESP News Russia','ESP News Russia','ESP News Russia',0,1),
		('skygate24','skygate24','skygate24',0,1),
		('administra.it','administra.it','administra.it',0,1),
		('SKYPLEX TXP92','SKYPLEX TXP92','SKYPLEX TXP92',0,1),
		('SKY_5','SKY_5','SKY_5',0,1),
		('EUSP NEWS PL','EUSP NEWS PL','EUSP NEWS PL',0,1),
		('Prod ESP News','Prod ESP News','Prod ESP News',0,1),
		('ITA-MIL-30(SKY2)','ITA-MIL-30(SKY2)','ITA-MIL-30(SKY2)',0,1),
		('Statcast24','Statcast24','Statcast24',0,1),
		('Radio24','Radio24','Radio24',0,1),
		('TRX24','TRX24','TRX24',0,1),
		('Radiocor','Radiocor','Radiocor',0,1),
		('24ore.tv','24ore.tv','24ore.tv',0,1),
		('SKY_4','SKY_4','SKY_4',0,1),
		('ESP Romanian','ESP Romanian','ESP Romanian',0,1),
		('ESP Dutch','ESP Dutch','ESP Dutch',0,1),
		('ESP Polish','ESP Polish','ESP Polish',0,1),
		('ESP Russian','ESP Russian','ESP Russian',0,1),
		('ESP Hungarian','ESP Hungarian','ESP Hungarian',0,1),
		('ESP Portuguese','ESP Portuguese','ESP Portuguese',0,1),
		('Prod ESP','Prod ESP','Prod ESP',0,1),
		('ESP Czech','ESP Czech','ESP Czech',0,1),
		('ESP Greek','ESP Greek','ESP Greek',0,1),
		('ESP Cyprus','ESP Cyprus','ESP Cyprus',0,1),
		('ESP Bulgarian','ESP Bulgarian','ESP Bulgarian',0,1),
		('Skyplex Internal','Skyplex Internal','Skyplex Internal',0,1),
		('TELE PADRE PIO','TELE PADRE PIO','TELE PADRE PIO',0,1),
		('skygate25','skygate25','skygate25',0,1),
		('WebTv Ch1','WebTv Ch1','WebTv Ch1',0,1),
		('Ch Test','Ch Test','Ch Test',0,1),
		('WebTv Ch2','WebTv Ch2','WebTv Ch2',0,1),
		('JSTV 1','JSTV 1','JSTV 1',0,1),
		('JSTV 2','JSTV 2','JSTV 2',0,1),
		('WRN Russkij','WRN Russkij','WRN Russkij',0,1),
		('WRN English','WRN English','WRN English',0,1),
		('WRN Deutsch','WRN Deutsch','WRN Deutsch',0,1),
		('WRN Francais','WRN Francais','WRN Francais',0,1),
		('GBTS 2','GBTS 2','GBTS 2',0,1),
		('RCI 3','RCI 3','RCI 3',0,1),
		('ISLAH','ISLAH','ISLAH',0,1),
		('RCI 2','RCI 2','RCI 2',0,1),
		('RCI 1','RCI 1','RCI 1',0,1),
		('RTE','RTE','RTE',0,1),
		('R Sweden','R Sweden','R Sweden',0,1),
		('SedayeIran','SedayeIran','SedayeIran',0,1),
		('TBC','TBC','TBC',0,1),
		('VORJ','VORJ','VORJ',0,1),
		('GBTS 1','GBTS 1','GBTS 1',0,1),
		('eng-WRN-multi','eng-WRN-multi','eng-WRN-multi',0,1),
		('Afghan SW','Afghan SW','Afghan SW',0,1),
		('Holiday FM','Holiday FM','Holiday FM',0,1),
		('R.Assalam','R.Assalam','R.Assalam',0,1),
		('WRN Special','WRN Special','WRN Special',0,1),
		('AWR Radio 64KBit','AWR Radio 64KBit','AWR Radio 64KBit',0,1),
		('AWR Radio 128KBit','AWR Radio 128KBit','AWR Radio 128KBit',0,1),
		('YLESAT 1','YLESAT 1','YLESAT 1',0,1),
		('YLESAT 2','YLESAT 2','YLESAT 2',0,1),
		('ANN','ANN','ANN',0,1),
		('CH 1 RUS-ORTi','CH 1 RUS-ORTi','CH 1 RUS-ORTi',0,1),
		('CNNI','CNNI','CNNI',0,1),
		('EuroNews','EuroNews','EuroNews',0,1),
		('Al Arabiya','Al Arabiya','Al Arabiya',0,1),
		('BET','BET','BET',0,1),
		('MediaHW','MediaHW','MediaHW',0,1),
		('Coral Software Download','Coral Software Download','Coral Software Download',0,1),
		('Prima Fila 11','Prima Fila 11','Prima Fila 11',0,1),
		('Prima Fila 12','Prima Fila 12','Prima Fila 12',0,1),
		('Prima Fila 13','Prima Fila 13','Prima Fila 13',0,1),
		('Prima Fila 14','Prima Fila 14','Prima Fila 14',0,1),
		('Prima Fila 15','Prima Fila 15','Prima Fila 15',0,1),
		('Prima Fila 16','Prima Fila 16','Prima Fila 16',0,1),
		('Prima Fila 17','Prima Fila 17','Prima Fila 17',0,1),
		('Prima Fila 18','Prima Fila 18','Prima Fila 18',0,1),
		('Prima Fila 19','Prima Fila 19','Prima Fila 19',0,1),
		('Dl961','Dl961','Dl961',0,1),
		('Dl962','Dl962','Dl962',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('test','test','test',0,1),
		('3ABN','3ABN','3ABN',0,1),
		('Tv Moda','Tv Moda','Tv Moda',0,1),
		('Telemarket','Telemarket','Telemarket',0,1),
		('Internet data 1','Internet data 1','Internet data 1',0,1),
		('E-TV Tech C.','E-TV Tech C.','E-TV Tech C.',0,1),
		('LifeGate','LifeGate','LifeGate',0,1),
		('TRBuonconsiglio','TRBuonconsiglio','TRBuonconsiglio',0,1),
		('R-Radio','R-Radio','R-Radio',0,1),
		('R. DONNA','R. DONNA','R. DONNA',0,1),
		('Radio Eurospin','Radio Eurospin','Radio Eurospin',0,1),
		('R.Speranza','R.Speranza','R.Speranza',0,1),
		('Melodia Russia','Melodia Russia','Melodia Russia',0,1),
		('Padre Pio','Padre Pio','Padre Pio',0,1),
		('R.SPORTNTW','R.SPORTNTW','R.SPORTNTW',0,1),
		('R.KOLBE-SAT','R.KOLBE-SAT','R.KOLBE-SAT',0,1),
		('Test','Test','Test',0,1),
		('RADIO ZETA','RADIO ZETA','RADIO ZETA',0,1),
		('R.MARIA','R.MARIA','R.MARIA',0,1),
		('viaMontenapo','viaMontenapo','viaMontenapo',0,1),
		('RADIO PADANIA','RADIO PADANIA','RADIO PADANIA',0,1),
		('RADIO RADICALE','RADIO RADICALE','RADIO RADICALE',0,1),
		('Test','Test','Test',0,1),
		('Studio Europa','Studio Europa','Studio Europa',0,1),
		('Playlist Italia','Playlist Italia','Playlist Italia',0,1),
		('GAME NETWORK','GAME NETWORK','GAME NETWORK',0,1),
		('Denaro TV','Denaro TV','Denaro TV',0,1),
		('ANNI 60','ANNI 60','ANNI 60',0,1),
		('R. Reporter','R. Reporter','R. Reporter',0,1),
		('Radio Italia S.M.I.','Radio Italia S.M.I.','Radio Italia S.M.I.',0,1),
		('3ABN Radio','3ABN Radio','3ABN Radio',0,1),
		('ABC Tamil (ITR CN)','ABC Tamil (ITR CN)','ABC Tamil (ITR CN)',0,1),
		('Popolare','Popolare','Popolare',0,1),
		('SKY Meteo24','SKY Meteo24','SKY Meteo24',0,1),
		('Test 6','Test 6','Test 6',0,1),
		('SNAI Sat','SNAI Sat','SNAI Sat',0,1),
		('Test 5','Test 5','Test 5',0,1),
		('Anc1003','Anc1003','Anc1003',0,1),
		('Anc1004','Anc1004','Anc1004',0,1),
		('Anc1005','Anc1005','Anc1005',0,1),
		('SKY Focus','SKY Focus','SKY Focus',0,1),
		('SKY TG 24','SKY TG 24','SKY TG 24',0,1),
		('SKY','SKY','SKY',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('Anc1006','Anc1006','Anc1006',0,1),
		('Dl1001','Dl1001','Dl1001',0,1),
		('Dl1002','Dl1002','Dl1002',0,1),
		('Fashion TV','Fashion TV','Fashion TV',0,1),
		('Red Light Ultra','Red Light Ultra','Red Light Ultra',0,1),
		('TIN+18668336763','TIN+18668336763','TIN+18668336763',0,1),
		('Red Light Italia','Red Light Italia','Red Light Italia',0,1),
		('Test 4','Test 4','Test 4',0,1),
		('D.G KURD','D.G KURD','D.G KURD',0,1),
		('Nawa Kurd Radio','Nawa Kurd Radio','Nawa Kurd Radio',0,1),
		('Nawa Arabic Radio','Nawa Arabic Radio','Nawa Arabic Radio',0,1),
		('AFN Korea/Time Code','AFN Korea/Time Code','AFN Korea/Time Code',0,1),
		('Pentagon Channel','Pentagon Channel','Pentagon Channel',0,1),
		('AFN Family Channel','AFN Family Channel','AFN Family Channel',0,1),
		('AFN Movie Channel','AFN Movie Channel','AFN Movie Channel',0,1),
		('Vicenza','Vicenza','Vicenza',0,1),
		('Z-106  Vicenza  (audio only)','Z-106  Vicenza  (audio only)','Z-106  Vicenza  (audio only)',0,1),
		('Power 107  Vicenza  (audio only)','Power 107  Vicenza  (audio only)','Power 107  Vicenza  (audio only)',0,1),
		('AFN Vicenza Contingency','AFN Vicenza Contingency','AFN Vicenza Contingency',0,1),
		('Global Radio','Global Radio','Global Radio',0,1),
		('RadioForum','RadioForum','RadioForum',0,1),
		('ELITE SHOPPING','ELITE SHOPPING','ELITE SHOPPING',0,1),
		('Sailing Channel','Sailing Channel','Sailing Channel',0,1),
		('R.ONDA D\'URTO','R.ONDA D\'URTO','R.ONDA D\'URTO',0,1),
		('Radio Company','Radio Company','Radio Company',0,1),
		('RADIO TIME','RADIO TIME','RADIO TIME',0,1),
		('CALABRIA CH.','CALABRIA CH.','CALABRIA CH.',0,1),
		('NIS_Intesa1','NIS_Intesa1','NIS_Intesa1',0,1),
		('ContoTV','ContoTV','ContoTV',0,1),
		('ODEON SAT','ODEON SAT','ODEON SAT',0,1),
		('MTI','MTI','MTI',0,1),
		('TLC SAT','TLC SAT','TLC SAT',0,1),
		('STARSAT','STARSAT','STARSAT',0,1),
		('PLAY TV ITALIA','PLAY TV ITALIA','PLAY TV ITALIA',0,1),
		('PEOPLE TV-RETE7','PEOPLE TV-RETE7','PEOPLE TV-RETE7',0,1),
		('ROMA SAT','ROMA SAT','ROMA SAT',0,1),
		('Olisat / Telefe','Olisat / Telefe','Olisat / Telefe',0,1),
		('Radio Max','Radio Max','Radio Max',0,1),
		('R.Di per Di','R.Di per Di','R.Di per Di',0,1),
		('McDonalds','McDonalds','McDonalds',0,1),
		('R.Cooky','R.Cooky','R.Cooky',0,1),
		('RadioBaby','RadioBaby','RadioBaby',0,1),
		('RADIO FLASH','RADIO FLASH','RADIO FLASH',0,1),
		('Rock TV','Rock TV','Rock TV',0,1),
		('Discovery Sci','Discovery Sci','Discovery Sci',0,1),
		('Eurosport','Eurosport','Eurosport',0,1),
		('EurosportNews','EurosportNews','EurosportNews',0,1),
		('Discovery Civil.','Discovery Civil.','Discovery Civil.',0,1),
		('Discovery Travel','Discovery Travel','Discovery Travel',0,1),
		('Classica','Classica','Classica',0,1),
		('VideoItalia','VideoItalia','VideoItalia',0,1),
		('Fox News','Fox News','Fox News',0,1),
		('Dl571','Dl571','Dl571',0,1),
		('Dl572','Dl572','Dl572',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('MT Channel','MT Channel','MT Channel',0,1),
		('Italia Teen TV','Italia Teen TV','Italia Teen TV',0,1),
		('Happy Channel','Happy Channel','Happy Channel',0,1),
		('Duel TV','Duel TV','Duel TV',0,1),
		('Sailing Channel','Sailing Channel','Sailing Channel',0,1),
		('Dl591','Dl591','Dl591',0,1),
		('Dl592','Dl592','Dl592',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('Inter Channel','Inter Channel','Inter Channel',0,1),
		('Milan Channel','Milan Channel','Milan Channel',0,1),
		('SKY Sport 3','SKY Sport 3','SKY Sport 3',0,1),
		('ESPNClassicSp.','ESPNClassicSp.','ESPNClassicSp.',0,1),
		('SKY Canale 109','SKY Canale 109','SKY Canale 109',0,1),
		('Matchmusic','Matchmusic','Matchmusic',0,1),
		('BBC Prime','BBC Prime','BBC Prime',0,1),
		('Disney Ch. +1','Disney Ch. +1','Disney Ch. +1',0,1),
		('Toon Disney','Toon Disney','Toon Disney',0,1),
		('Bloomberg','Bloomberg','Bloomberg',0,1),
		('Dl671','Dl671','Dl671',0,1),
		('Dl672','Dl672','Dl672',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('LibertyTV  NL','LibertyTV  NL','LibertyTV  NL',0,1),
		('TELESUD','TELESUD','TELESUD',0,1),
		('LibertyTV  FR','LibertyTV  FR','LibertyTV  FR',0,1),
		('full-X1','full-X1','full-X1',0,1),
		('full-X2','full-X2','full-X2',0,1),
		('full-X2M','full-X2M','full-X2M',0,1),
		('Hope Channel','Hope Channel','Hope Channel',0,1),
		('Hope Channel 2','Hope Channel 2','Hope Channel 2',0,1),
		('AL-TAJDEED','AL-TAJDEED','AL-TAJDEED',0,1),
		('Ciel AM','Ciel AM','Ciel AM',0,1),
		('Radio BISER','Radio BISER','Radio BISER',0,1),
		('Kiss Plus','Kiss Plus','Kiss Plus',0,1),
		('Wal Fadjri','Wal Fadjri','Wal Fadjri',0,1),
		('PINK PLUS','PINK PLUS','PINK PLUS',0,1),
		('PINK EXTRA','PINK EXTRA','PINK EXTRA',0,1),
		('RADIO PINK','RADIO PINK','RADIO PINK',0,1),
		('Didar TV','Didar TV','Didar TV',0,1),
		('WORLD SAT','WORLD SAT','WORLD SAT',0,1),
		('INFOCAST MAIL','INFOCAST MAIL','INFOCAST MAIL',0,1),
		('Intellicast HB6','Intellicast HB6','Intellicast HB6',0,1),
		('worldsat-o','worldsat-o','worldsat-o',0,1),
		('Dassault HB6','Dassault HB6','Dassault HB6',0,1),
		('IRIB1 PER','IRIB1 PER','IRIB1 PER',0,1),
		('IRIB1 ENG','IRIB1 ENG','IRIB1 ENG',0,1),
		('IRIB2 PER','IRIB2 PER','IRIB2 PER',0,1),
		('IRIB2 ENG','IRIB2 ENG','IRIB2 ENG',0,1),
		('IRINN','IRINN','IRINN',0,1),
		('SAHAR1','SAHAR1','SAHAR1',0,1),
		('SAHAR2','SAHAR2','SAHAR2',0,1),
		('AL-ALAM','AL-ALAM','AL-ALAM',0,1),
		('IRIB1/QURAN','IRIB1/QURAN','IRIB1/QURAN',0,1),
		('INT1/2','INT1/2','INT1/2',0,1),
		('INT4/INT3','INT4/INT3','INT4/INT3',0,1),
		('ARABIC/5 RADIO','ARABIC/5 RADIO','ARABIC/5 RADIO',0,1),
		('Encrypted Feed','Encrypted Feed','Encrypted Feed',0,1),
		('FEED','FEED','FEED',0,1),
		('902','902','902',0,1),
		('902 FM','902 FM','902 FM',0,1),
		('Deutsche Bank','Deutsche Bank','Deutsche Bank',0,1),
		('Deutsche Bank','Deutsche Bank','Deutsche Bank',0,1),
		('BMW','BMW','BMW',0,1),
		('BW TV','BW TV','BW TV',0,1),
		('DTAG','DTAG','DTAG',0,1),
		('Wuerth','Wuerth','Wuerth',0,1),
		('Autotote-MEC','Autotote-MEC','Autotote-MEC',0,1),
		('DCTV-german','DCTV-german','DCTV-german',0,1),
		('Eli Lilly','Eli Lilly','Eli Lilly',0,1),
		('Hornbach-D','Hornbach-D','Hornbach-D',0,1),
		('Hornbach-F','Hornbach-F','Hornbach-F',0,1),
		('Kaufhof','Kaufhof','Kaufhof',0,1),
		('Sonderkanal','Sonderkanal','Sonderkanal',0,1),
		('Hornbach-NL','Hornbach-NL','Hornbach-NL',0,1),
		('Altria PMF','Altria PMF','Altria PMF',0,1),
		('TSI','TSI','TSI',0,1),
		('Hornbach-CZ','Hornbach-CZ','Hornbach-CZ',0,1),
		('Samsung2-vert','Samsung2-vert','Samsung2-vert',0,1),
		('DCTV-english','DCTV-english','DCTV-english',0,1),
		('DCTV-italy','DCTV-italy','DCTV-italy',0,1),
		('DCTV-turkish','DCTV-turkish','DCTV-turkish',0,1),
		('DCTV-spanish','DCTV-spanish','DCTV-spanish',0,1),
		('DCTV-french','DCTV-french','DCTV-french',0,1),
		('DCTV-portuguese','DCTV-portuguese','DCTV-portuguese',0,1),
		('Knorr','Knorr','Knorr',0,1),
		('AKUBIS light','AKUBIS light','AKUBIS light',0,1),
		('Hornbach-SW','Hornbach-SW','Hornbach-SW',0,1),
		('Hornbach-SLO','Hornbach-SLO','Hornbach-SLO',0,1),
		('Music Box Italia','Music Box Italia','Music Box Italia',0,1),
		('IndiaVision','IndiaVision','IndiaVision',0,1),
		('Kairali Europe','Kairali Europe','Kairali Europe',0,1),
		('Asianet','Asianet','Asianet',0,1),
		('CH 3 Arabic IBA TV','CH 3 Arabic IBA TV','CH 3 Arabic IBA TV',0,1),
		('VTV/MRTV','VTV/MRTV','VTV/MRTV',0,1),
		('CNL','CNL','CNL',0,1),
		('BK TV','BK TV','BK TV',0,1),
		('Overcomer Radio','Overcomer Radio','Overcomer Radio',0,1),
		('Somali Radio','Somali Radio','Somali Radio',0,1),
		('Radio 3','Radio 3','Radio 3',0,1),
		('Voice of Russian Jewry','Voice of Russian Jewry','Voice of Russian Jewry',0,1),
		('Christian Voice','Christian Voice','Christian Voice',0,1),
		('Hornafrik Somalia','Hornafrik Somalia','Hornafrik Somalia',0,1),
		('FBN','FBN','FBN',0,1),
		('Thai Global Network','Thai Global Network','Thai Global Network',0,1),
		('TGN Radio','TGN Radio','TGN Radio',0,1),
		('TCT','TCT','TCT',0,1),
		('Arirang TV','Arirang TV','Arirang TV',0,1),
		('KURDsat','KURDsat','KURDsat',0,1),
		('SWISS MUSIC RADIO','SWISS MUSIC RADIO','SWISS MUSIC RADIO',0,1),
		('FREE-XTV 2','FREE-XTV 2','FREE-XTV 2',0,1),
		('XDream TV','XDream TV','XDream TV',0,1),
		('Red Light TV+','Red Light TV+','Red Light TV+',0,1),
		('Free-X TV','Free-X TV','Free-X TV',0,1),
		('A1','A1','A1',0,1),
		('History +1','History +1','History +1',0,1),
		('NationalGeo +1','NationalGeo +1','NationalGeo +1',0,1),
		('Sky News','Sky News','Sky News',0,1),
		('Cartoon Network','Cartoon Network','Cartoon Network',0,1),
		('Fox Kids','Fox Kids','Fox Kids',0,1),
		('Fox Life','Fox Life','Fox Life',0,1),
		('CNBC Europe','CNBC Europe','CNBC Europe',0,1),
		('Cult','Cult','Cult',0,1),
		('TVE INTERNACIONAL','TVE INTERNACIONAL','TVE INTERNACIONAL',0,1),
		('CANAL 24 HORAS','CANAL 24 HORAS','CANAL 24 HORAS',0,1),
		('TVE INTER. ASIA','TVE INTER. ASIA','TVE INTER. ASIA',0,1),
		('LIBRE - CARTA','LIBRE - CARTA','LIBRE - CARTA',0,1),
		('CANAL CLASICO','CANAL CLASICO','CANAL CLASICO',0,1),
		('TELEDEPORTE','TELEDEPORTE','TELEDEPORTE',0,1),
		('HISPAVISION','HISPAVISION','HISPAVISION',0,1),
		('NOSTALGIA','NOSTALGIA','NOSTALGIA',0,1),
		('RADIO 1','RADIO 1','RADIO 1',0,1),
		('RADIO CLASICA','RADIO CLASICA','RADIO CLASICA',0,1),
		('RADIO 3','RADIO 3','RADIO 3',0,1),
		('RADIO 5','RADIO 5','RADIO 5',0,1),
		('RADIO EXTERIOR','RADIO EXTERIOR','RADIO EXTERIOR',0,1),
		('RADIO 4','RADIO 4','RADIO 4',0,1),
		('LIBRE 2','LIBRE 2','LIBRE 2',0,1),
		('LIBRE 3','LIBRE 3','LIBRE 3',0,1),
		('RTL 102.5','RTL 102.5','RTL 102.5',0,1),
		('Videosexy TV','Videosexy TV','Videosexy TV',0,1),
		('R.CLASSICA','R.CLASSICA','R.CLASSICA',0,1),
		('Sexysat 1','Sexysat 1','Sexysat 1',0,1),
		('Best of Shopping','Best of Shopping','Best of Shopping',0,1),
		('Channel SUN','Channel SUN','Channel SUN',0,1),
		('ARTE','ARTE','ARTE',0,1),
		('Cartomanzia LOTTO','Cartomanzia LOTTO','Cartomanzia LOTTO',0,1),
		('ITALIA CHANNEL','ITALIA CHANNEL','ITALIA CHANNEL',0,1),
		('123LIVESAT/69XTV','123LIVESAT/69XTV','123LIVESAT/69XTV',0,1),
		('Beur TV','Beur TV','Beur TV',0,1),
		('Telegenova','Telegenova','Telegenova',0,1),
		('ROJ TV','ROJ TV','ROJ TV',0,1),
		('NTD TV','NTD TV','NTD TV',0,1),
		('MAHARISHI','MAHARISHI','MAHARISHI',0,1),
		('Azadegan Radio','Azadegan Radio','Azadegan Radio',0,1),
		('ICC','ICC','ICC',0,1),
		('Majadahonda TV','Majadahonda TV','Majadahonda TV',0,1),
		('TAPESH','TAPESH','TAPESH',0,1),
		('JAAM E JAM','JAAM E JAM','JAAM E JAM',0,1),
		('IPN','IPN','IPN',0,1),
		('IRAN','IRAN','IRAN',0,1),
		('ITC','ITC','ITC',0,1),
		('PEN TV','PEN TV','PEN TV',0,1),
		('OMID E IRAN','OMID E IRAN','OMID E IRAN',0,1),
		('PODROZE TV','PODROZE TV','PODROZE TV',0,1),
		('DAYSTAR','DAYSTAR','DAYSTAR',0,1),
		('EWTN','EWTN','EWTN',0,1),
		('TV POLONIA','TV POLONIA','TV POLONIA',0,1),
		('Tele5','Tele5','Tele5',0,1),
		('CYFRA+ GRY','CYFRA+ GRY','CYFRA+ GRY',0,1),
		('CYFRA+ POGODA','CYFRA+ POGODA','CYFRA+ POGODA',0,1),
		('MAGAZYN+','MAGAZYN+','MAGAZYN+',0,1),
		('Polonia 1','Polonia 1','Polonia 1',0,1),
		('KINO POLSKA','KINO POLSKA','KINO POLSKA',0,1),
		('TRAVEL','TRAVEL','TRAVEL',0,1),
		('CIVILISATION','CIVILISATION','CIVILISATION',0,1),
		('SCIENCE','SCIENCE','SCIENCE',0,1),
		('BBC PRIME','BBC PRIME','BBC PRIME',0,1),
		('ITV','ITV','ITV',0,1),
		('TVP 3','TVP 3','TVP 3',0,1),
		('TVN','TVN','TVN',0,1),
		('TVN 24','TVN 24','TVN 24',0,1),
		('TVN Siedem','TVN Siedem','TVN Siedem',0,1),
		('TVN I Europe','TVN I Europe','TVN I Europe',0,1),
		('TVN I US','TVN I US','TVN I US',0,1),
		('MANGO 24','MANGO 24','MANGO 24',0,1),
		('TVN METEO','TVN METEO','TVN METEO',0,1),
		('TVN TURBO','TVN TURBO','TVN TURBO',0,1),
		('TVN Style','TVN Style','TVN Style',0,1),
		('SuperSport3','SuperSport3','SuperSport3',0,1),
		('VH1','VH1','VH1',0,1),
		('MTV','MTV','MTV',0,1),
		('MGM','MGM','MGM',0,1),
		('AnimalPlanet','AnimalPlanet','AnimalPlanet',0,1),
		('FILMNET2','FILMNET2','FILMNET2',0,1),
		('Nat. Geo','Nat. Geo','Nat. Geo',0,1),
		('CNBC','CNBC','CNBC',0,1),
		('Ant1 Gold','Ant1 Gold','Ant1 Gold',0,1),
		('LTV','LTV','LTV',0,1),
		('ALFA','ALFA','ALFA',0,1),
		('SSport Special','SSport Special','SSport Special',0,1),
		('IPE 3','IPE 3','IPE 3',0,1),
		('Nova Scope','Nova Scope','Nova Scope',0,1),
		('Erotic      Xtra','Erotic      Xtra','Erotic      Xtra',0,1),
		('ERT 9','ERT 9','ERT 9',0,1),
		('Extra2','Extra2','Extra2',0,1),
		('Sports Search','Sports Search','Sports Search',0,1),
		('SS FM','SS FM','SS FM',0,1),
		('NOVA SCOPE','NOVA SCOPE','NOVA SCOPE',0,1),
		('Eepg','Eepg','Eepg',0,1),
		('FILMNET X-MAS','FILMNET X-MAS','FILMNET X-MAS',0,1),
		('Mediatel','Mediatel','Mediatel',0,1),
		('Tele Lumiere','Tele Lumiere','Tele Lumiere',0,1),
		('Islah TV','Islah TV','Islah TV',0,1),
		('Adjara TV','Adjara TV','Adjara TV',0,1),
		('Suryan Radio','Suryan Radio','Suryan Radio',0,1),
		('IRN','IRN','IRN',0,1),
		('Sun KTV','Sun KTV','Sun KTV',0,1),
		('ANB','ANB','ANB',0,1),
		('Sun TV +442083356780','Sun TV +442083356780','Sun TV +442083356780',0,1),
		('Al Mustakillah','Al Mustakillah','Al Mustakillah',0,1),
		('Cartoon Network','Cartoon Network','Cartoon Network',0,1),
		('DMC TV','DMC TV','DMC TV',0,1),
		('Prime TV','Prime TV','Prime TV',0,1),
		('Motors TV','Motors TV','Motors TV',0,1),
		('TV5 FBS','TV5 FBS','TV5 FBS',0,1),
		('TV5 EUROPE','TV5 EUROPE','TV5 EUROPE',0,1),
		('Roma Uno','Roma Uno','Roma Uno',0,1),
		('ANN','ANN','ANN',0,1),
		('Videolook','Videolook','Videolook',0,1),
		('Kurdistan TV','Kurdistan TV','Kurdistan TV',0,1),
		('Videolina','Videolina','Videolina',0,1),
		('Telegenova','Telegenova','Telegenova',0,1),
		('RTB','RTB','RTB',0,1),
		('starMarket','starMarket','starMarket',0,1),
		('RTB Crypted','RTB Crypted','RTB Crypted',0,1),
		('Kurdistan Radio','Kurdistan Radio','Kurdistan Radio',0,1),
		('Sisal TV','Sisal TV','Sisal TV',0,1),
		('SA OS download','SA OS download','SA OS download',0,1),
		('GBR','GBR','GBR',0,1),
		('HB CH 2','HB CH 2','HB CH 2',0,1),
		('Diva Futura','Diva Futura','Diva Futura',0,1),
		('Gospel Channel','Gospel Channel','Gospel Channel',0,1),
		('SICILIA CHANNEL','SICILIA CHANNEL','SICILIA CHANNEL',0,1),
		('Nostradamus','Nostradamus','Nostradamus',0,1),
		('Napoli Nova','Napoli Nova','Napoli Nova',0,1),
		('TirrenoSat','TirrenoSat','TirrenoSat',0,1),
		('Al Hayat','Al Hayat','Al Hayat',0,1),
		('NEW TELEVISION','NEW TELEVISION','NEW TELEVISION',0,1),
		('TV_SRI','TV_SRI','TV_SRI',0,1),
		('LoveWorld','LoveWorld','LoveWorld',0,1),
		('C5 DTT','C5 DTT','C5 DTT',0,1),
		('I1 DTT','I1 DTT','I1 DTT',0,1),
		('LCI Dfree','LCI Dfree','LCI Dfree',0,1),
		('Si Dfree','Si Dfree','Si Dfree',0,1),
		('Radio Italia tv','Radio Italia tv','Radio Italia tv',0,1),
		('Prima','Prima','Prima',0,1),
		('R4 DTT','R4 DTT','R4 DTT',0,1),
		('SKY Sport 1','SKY Sport 1','SKY Sport 1',0,1),
		('SKY Sport 2','SKY Sport 2','SKY Sport 2',0,1),
		('SKY DirettaGol','SKY DirettaGol','SKY DirettaGol',0,1),
		('Test 7','Test 7','Test 7',0,1),
		('Sports Active 2','Sports Active 2','Sports Active 2',0,1),
		('Sports Active 3','Sports Active 3','Sports Active 3',0,1),
		('Sports Active 4','Sports Active 4','Sports Active 4',0,1),
		('Disney Channel','Disney Channel','Disney Channel',0,1),
		('SKY On Air','SKY On Air','SKY On Air',0,1),
		('SKY On Air','SKY On Air','SKY On Air',0,1),
		('SKY On Air','SKY On Air','SKY On Air',0,1),
		('SKY On Air','SKY On Air','SKY On Air',0,1),
		('SKY On Air','SKY On Air','SKY On Air',0,1),
		('SKY On Air','SKY On Air','SKY On Air',0,1),
		('SKY On Air','SKY On Air','SKY On Air',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('SKY On Air','SKY On Air','SKY On Air',0,1),
		('Dl641','Dl641','Dl641',0,1),
		('Dl642','Dl642','Dl642',0,1),
		('Test 3','Test 3','Test 3',0,1),
		('Test 4','Test 4','Test 4',0,1),
		('Anc642','Anc642','Anc642',0,1),
		('Anc643','Anc643','Anc643',0,1),
		('Anc644','Anc644','Anc644',0,1),
		('SKYCinema 1','SKYCinema 1','SKYCinema 1',0,1),
		('SKY Autore','SKY Autore','SKY Autore',0,1),
		('SKYCinema 3','SKYCinema 3','SKYCinema 3',0,1),
		('SKY Sport 1','SKY Sport 1','SKY Sport 1',0,1),
		('SKY Calcio 1','SKY Calcio 1','SKY Calcio 1',0,1),
		('Discovery','Discovery','Discovery',0,1),
		('SKY Max','SKY Max','SKY Max',0,1),
		('La7','La7','La7',0,1),
		('Dl661','Dl661','Dl661',0,1),
		('Dl662','Dl662','Dl662',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('Prima Fila 24','Prima Fila 24','Prima Fila 24',0,1),
		('Prima Fila 25','Prima Fila 25','Prima Fila 25',0,1),
		('Prima Fila 26','Prima Fila 26','Prima Fila 26',0,1),
		('Prima Fila 27','Prima Fila 27','Prima Fila 27',0,1),
		('Prima Fila 28','Prima Fila 28','Prima Fila 28',0,1),
		('Prima Fila 29','Prima Fila 29','Prima Fila 29',0,1),
		('Prima Fila 30','Prima Fila 30','Prima Fila 30',0,1),
		('SKY Calcio 2','SKY Calcio 2','SKY Calcio 2',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('Test 1','Test 1','Test 1',0,1),
		('SKY Calcio 3','SKY Calcio 3','SKY Calcio 3',0,1),
		('SKY Calcio 4','SKY Calcio 4','SKY Calcio 4',0,1),
		('SKY Calcio 5','SKY Calcio 5','SKY Calcio 5',0,1),
		('SKY Calcio 6','SKY Calcio 6','SKY Calcio 6',0,1),
		('SKY Calcio 7','SKY Calcio 7','SKY Calcio 7',0,1),
		('SKY Calcio 8','SKY Calcio 8','SKY Calcio 8',0,1),
		('Dl681','Dl681','Dl681',0,1),
		('Dl682','Dl682','Dl682',0,1),
		('Prima Fila 5','Prima Fila 5','Prima Fila 5',0,1),
		('Prima Fila 6','Prima Fila 6','Prima Fila 6',0,1),
		('Prima Fila 7','Prima Fila 7','Prima Fila 7',0,1),
		('Prima Fila 8','Prima Fila 8','Prima Fila 8',0,1),
		('Prima Fila 9','Prima Fila 9','Prima Fila 9',0,1),
		('Prima Fila 10','Prima Fila 10','Prima Fila 10',0,1),
		('SKY Calcio 9','SKY Calcio 9','SKY Calcio 9',0,1),
		('SKY Calcio 10','SKY Calcio 10','SKY Calcio 10',0,1),
		('SKY Calcio 11','SKY Calcio 11','SKY Calcio 11',0,1),
		('SKY Calcio 12','SKY Calcio 12','SKY Calcio 12',0,1),
		('SKY Calcio 13','SKY Calcio 13','SKY Calcio 13',0,1),
		('SKY Calcio 14','SKY Calcio 14','SKY Calcio 14',0,1),
		('In Arrivo','In Arrivo','In Arrivo',0,1),
		('Paramount Comedy','Paramount Comedy','Paramount Comedy',0,1),
		('Nickelodeon','Nickelodeon','Nickelodeon',0,1),
		('Dl821','Dl821','Dl821',0,1),
		('Dl822','Dl822','Dl822',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('RaisatExtra','RaisatExtra','RaisatExtra',0,1),
		('Raisat Premium','Raisat Premium','Raisat Premium',0,1),
		('Raisat CineWorld','Raisat CineWorld','Raisat CineWorld',0,1),
		('Raisat Ragazzi','Raisat Ragazzi','Raisat Ragazzi',0,1),
		('Raisat Gambero','Raisat Gambero','Raisat Gambero',0,1),
		('CNN Intl.','CNN Intl.','CNN Intl.',0,1),
		('SKYCinema 2','SKYCinema 2','SKYCinema 2',0,1),
		('SKY Classics','SKY Classics','SKY Classics',0,1),
		('SKY 16 9','SKY 16 9','SKY 16 9',0,1),
		('Dl861','Dl861','Dl861',0,1),
		('Dl862','Dl862','Dl862',0,1),
		('IEPG Data','IEPG Data','IEPG Data',0,1),
		('Punto Sat','Punto Sat','Punto Sat',0,1),
		('Test for Puntosat','Test for Puntosat','Test for Puntosat',0,1),
		('Kiss Kiss Radio','Kiss Kiss Radio','Kiss Kiss Radio',0,1),
		('Kurdsat','Kurdsat','Kurdsat',0,1),
		('Spice Platinum','Spice Platinum','Spice Platinum',0,1),
		('Tele A','Tele A','Tele A',0,1),
		('MI-TV','MI-TV','MI-TV',0,1),
		('eurotic TV','eurotic TV','eurotic TV',0,1),
		('INXTC TV','INXTC TV','INXTC TV',0,1),
		('XPLUS TV','XPLUS TV','XPLUS TV',0,1),
		('Suton Radio','Suton Radio','Suton Radio',0,1),
		('EUMETCAST','EUMETCAST','EUMETCAST',0,1),
		('BTV-IP','BTV-IP','BTV-IP',0,1),
		('Tenfore','Tenfore','Tenfore',0,1),
		('HBO','HBO','HBO',0,1),
		('HALLMARK','HALLMARK','HALLMARK',0,1),
		('ANIMAL PLANET','ANIMAL PLANET','ANIMAL PLANET',0,1),
		('test','test','test',0,1),
		('NATIONAL GEO','NATIONAL GEO','NATIONAL GEO',0,1),
		('TVN 24','TVN 24','TVN 24',0,1),
		('REALITY TV','REALITY TV','REALITY TV',0,1),
		('MTV CLASSIC','MTV CLASSIC','MTV CLASSIC',0,1),
		('XtraMusicPop','XtraMusicPop','XtraMusicPop',0,1),
		('MAGAZYN+','MAGAZYN+','MAGAZYN+',0,1),
		('HBO2','HBO2','HBO2',0,1),
		('CNBC','CNBC','CNBC',0,1),
		('XtraMusicRythm','XtraMusicRythm','XtraMusicRythm',0,1),
		('XtraMusicPop','XtraMusicPop','XtraMusicPop',0,1),
		('XtraMusicRythm','XtraMusicRythm','XtraMusicRythm',0,1),
		('XtraMusic3','XtraMusic3','XtraMusic3',0,1),
		('XtraMusic4','XtraMusic4','XtraMusic4',0,1),
		('tech 3','tech 3','tech 3',0,1),
		('Test 1','Test 1','Test 1',0,1),
		('Fashion TV','Fashion TV','Fashion TV',0,1),
		('TAXI channel','TAXI channel','TAXI channel',0,1),
		('TIN+18668336763','TIN+18668336763','TIN+18668336763',0,1),
		('IndiaVision','IndiaVision','IndiaVision',0,1),
		('Test 4','Test 4','Test 4',0,1),
		('Red Light Ultra','Red Light Ultra','Red Light Ultra',0,1),
		('Red Light Italia','Red Light Italia','Red Light Italia',0,1),
		('D.G KURD','D.G KURD','D.G KURD',0,1),
		('Nawa Kurd Radio','Nawa Kurd Radio','Nawa Kurd Radio',0,1),
		('Nawa Arabic Radio','Nawa Arabic Radio','Nawa Arabic Radio',0,1),
		('NUOVASPAZIORADIO','NUOVASPAZIORADIO','NUOVASPAZIORADIO',0,1),
		('TBN ITALY','TBN ITALY','TBN ITALY',0,1),
		('CHURCH CHANNEL','CHURCH CHANNEL','CHURCH CHANNEL',0,1),
		('JCTV','JCTV','JCTV',0,1),
		('INSPIRATION','INSPIRATION','INSPIRATION',0,1),
		('TBN EURO','TBN EURO','TBN EURO',0,1),
		('TBNEspain','TBNEspain','TBNEspain',0,1),
		('TBN ARABIC','TBN ARABIC','TBN ARABIC',0,1),
		('Urdu Europe','Urdu Europe','Urdu Europe',0,1),
		('Bangla Europe','Bangla Europe','Bangla Europe',0,1),
		('Tamil Europe','Tamil Europe','Tamil Europe',0,1),
		('Hindi Europe','Hindi Europe','Hindi Europe',0,1),
		('La Locale','La Locale','La Locale',0,1),
		('Zagros','Zagros','Zagros',0,1),
		('Al Maghribia','Al Maghribia','Al Maghribia',0,1),
		('SET','SET','SET',0,1),
		('Sardegna Uno','Sardegna Uno','Sardegna Uno',0,1),
		('Fox Kids','Fox Kids','Fox Kids',0,1),
		('Channel 1 - Enc. 1','Channel 1 - Enc. 1','Channel 1 - Enc. 1',0,1),
		('Bloomberg French TV','Bloomberg French TV','Bloomberg French TV',0,1),
		('Bloomberg Italian TV','Bloomberg Italian TV','Bloomberg Italian TV',0,1),
		('Bloomberg European TV','Bloomberg European TV','Bloomberg European TV',0,1),
		('Bloomberg German TV','Bloomberg German TV','Bloomberg German TV',0,1),
		('Bloomberg English TV','Bloomberg English TV','Bloomberg English TV',0,1),
		('Miracle TV','Miracle TV','Miracle TV',0,1),
		('Channel Nine','Channel Nine','Channel Nine',0,1),
		('Nickelodeon Euro','Nickelodeon Euro','Nickelodeon Euro',0,1),
		('Service 8','Service 8','Service 8',0,1),
		('HBO','HBO','HBO',0,1),
		('HALLMARK','HALLMARK','HALLMARK',0,1),
		('ANIMAL PLANET','ANIMAL PLANET','ANIMAL PLANET',0,1),
		('NATIONAL GEO','NATIONAL GEO','NATIONAL GEO',0,1),
		('TVN 24','TVN 24','TVN 24',0,1),
		('REALITY TV','REALITY TV','REALITY TV',0,1),
		('MTV CLASSIC','MTV CLASSIC','MTV CLASSIC',0,1),
		('XtraMusicPop','XtraMusicPop','XtraMusicPop',0,1),
		('MAGAZYN+','MAGAZYN+','MAGAZYN+',0,1),
		('HBO2','HBO2','HBO2',0,1),
		('CNBC','CNBC','CNBC',0,1),
		('XtraMusicRythm','XtraMusicRythm','XtraMusicRythm',0,1),
		('XtraMusicPop','XtraMusicPop','XtraMusicPop',0,1),
		('XtraMusicRythm','XtraMusicRythm','XtraMusicRythm',0,1),
		('XtraMusic3','XtraMusic3','XtraMusic3',0,1),
		('XtraMusic4','XtraMusic4','XtraMusic4',0,1),
		('TEST AUDIO','TEST AUDIO','TEST AUDIO',0,1),
		('tech 3','tech 3','tech 3',0,1),
		('AB MOTEURS','AB MOTEURS','AB MOTEURS',0,1),
		('ACTION','ACTION','ACTION',0,1),
		('AB 1','AB 1','AB 1',0,1),
		('RFM-TV','RFM-TV','RFM-TV',0,1),
		('MUSIQUE CLASSIQUE','MUSIQUE CLASSIQUE','MUSIQUE CLASSIQUE',0,1),
		('ANIMAUX','ANIMAUX','ANIMAUX',0,1),
		('ESCALES','ESCALES','ESCALES',0,1),
		('ENCYCLOPEDIA','ENCYCLOPEDIA','ENCYCLOPEDIA',0,1),
		('Webcam','Webcam','Webcam',0,2)]
#
# TV_CHANNELS = [('21', 'SVT1',              'E5'),
#                ('22', 'SVT2',              'E3'),
#                ('26', 'TV3',               'E10'),
#                ('27', 'TV4',               'E6'),
#                ('10', 'Kanal 5',           'E7'),
#                ('60', 'Fox Kids',          'E8', ('1234567','0600','1659')),
#                ('16', 'TV6',               'E8', ('1234567','1700','2359'), 
#                                                  ('1234567','0000','0300')),
#                ('14', 'MTV Europe',        'E11') ]
#
# As you can see the list takes optional tuples:
# ( 'DAYS', 'START','END')
#
# 1234567 in days means all days.
# 12345 would mean monday to friday.
#
# It will display "Fox Kids" from 06:00 to 16:59 and "TV6" from 17:00 to 03:00. 
# 03:00 to 06:00 it won't be displayed at all.
#

#TV_CHANNELS = None

#TV_CHANNELS = [ ('RAI1','Rai 1','RAI1',0,1),
#                ('RAI2','Rai 2','RAI2',0,1),
#                ('RAI3','Rai 3','RAI3',0,1),
#                ('R4','Retequattro','Retequattro',0,1),
#                ('C5','Canale 5','Canale 5',0,1),
#                ('I1','Italia 1','Italia 1',0,1)]
										
#
# Program to grab xmltv listings. To get a grabber, you need to download
# xmltv. A possible value for users in the USA is tv_grab_na
# Use the tv_grab helper to grab the listings and cache them. Start
# 'freevo tv_grab --help' for more informations.

XMLTV_GRABBER = '/video/tv_grab_it > /tmp/TV2.xml'

# If you want to run tv_sort on your listings add the path to tv_sort here.
# tv_sort will make sure all your programs have proper stop times, otherwise
# programs might get cut off at midnight.
#
XMLTV_SORT = 'tv_sort --output /tmp/TV.xml /tmp/TV2.xml'

#
# Number of days the grabber should get
#
# XMLTV_DAYS = 3


# ======================================================================
# Freevo builtin WWW server settings:
# ======================================================================

#
# To activate the built in web server, uncomment the following line
#
#plugin.activate('www')

#
# Web server port number. 80 is the standard port, but is often
# taken already by apache, and cannot be used unless the server
# runs as root. Port 8080 is the default, change to 80 if
# needed.
#
WWW_PORT = 8080

#
# Username / Password combinations to login to the web interface.
# 
# WWW_USERS = { "user1" : "changeme", 
#            "optional" : "changeme2" }
#

#
# Divide the TV guide into intervals of this length (in minutes)
#
# WWW_GUIDE_INTERVAL = 30

#
# Precision for TV guide (in minutes)
#
# WWW_GUIDE_PRECISION = 5 #

#
# Show this many blocks at once
#
# WWW_GUIDE_COLS = 6

# WWW_STYLESHEET = 'styles/main.css'

# WWW_JAVASCRIPT = 'scripts/display_prog-head.js'


# ======================================================================
# Internal stuff, you shouldn't change anything here unless you know
# what you are doing
# ======================================================================

#
# Config for xml support in the movie browser
# the regexp has to be with ([0-9]|[0-9][0-9]) so we can get the numbers
#
# VIDEO_SHOW_REGEXP = "s?([0-9]|[0-9][0-9])[xe]([0-9]|[0-9][0-9])[^0-9]"


#
# Remote control daemon. The server is in the Freevo main application,
# and the client is a standalone application in rc_client/
#
# ENABLE_NETWORK_REMOTE = 0
# REMOTE_CONTROL_HOST = '127.0.0.1'
# REMOTE_CONTROL_PORT = 16310


#
# XMLTV File
#
# This is the XMLTV file that can be optionally used for TV listings
#
XMLTV_FILE = '/tmp/TV.xml'

#
# XML TV Logo Location
#
# Use the "makelogos.py" script to download all the
# Station logos into a directory. And then put the path
#TV_LOGOS = OS_CACHEDIR + '/xmltv/logos' to those logos here
TV_LOGOS = '/video/xmltv/logos'


# LOCALE='latin-1'
