<?
/* ==============================================================================
 * Copyright (c) 2001-2002 Rudy S. Ingga (rudy@wita.or.id).  All rights reserved.
 *
 * wmstats.php
 *   Display visitors profile today based on file(s) created by WMCounter
 * 
 * This module is released under the GNU General Public License. See:
 *   http://www.gnu.org/copyleft/gpl.html
 * 
 * Version
 *   0.1c, Wednesday, October 16, 2002 12:37:51 PM
 *         - Split Windows NT, 2000 and XP
 *         - Add .biz, .info domain
 *         - Still got the link when page referer { CUT - TOO LONG }
 *   0.1b, Saturday, May 12, 2001 10:09:01 AM
 *         - Add "https" preg match in Domain Referer
 *   0.1a, Sunday, April 1, 2001 11:13:14 AM
 *         - Sort all sections except Hostname
 *         - Add "Googlebot" as Web Indexing Robot
 *   0.1,  Sunday, March 25, 2001 02:07:45 AM
 *         - First Release
 *
 * For latest version and example, visit:
 *   http://wartamikael.org/PHPScripts
 *
 * Notice for WMNews Users:
 *   Copy the whole functions on this file, paste it into wmlib.php, JRENG!
 *   So simple, isnt' it? Display your stats by insert the code as written
 *   on readme.html or if you want..., scroll this screen... you'll find
 *   the same code below :P
 * ==============================================================================
 */

/* Your data path, actually same with your WMCounter $base_datapath
 * Keeps all files created by script, for your security,
 * change name of this directory to be an unusual name like 'jVld0ksqQk' or 
 * something else to make it hard to find by someone who doesn't have authority
 * for the * files :). Don't forget to chmod this subdir to '777'.
 */
$XIAPREFIX="..";
$base_datapath = $XIAPREFIX . "/stats";

/* Change if you want */

$toprowcol	= "#059AEB";	// Top Row of the table
$bgcol	= "#FFFFFF";	// What is the white color?
$grey		= "#E4E4E4";	// What is the grey color?

/* DONE! Call wmstats-test.php on your browser to check if WMStats is 
   running! If you want to include WMStats on your page, copy the code
   below into your page:

	<?
	include("wmstats.php");
	echo daily_stats("");
	?>

   If you have different name of your visitors profile file, depending
   on the file you created by WMCounter, i.e. :

	echo daily_stats("name-of-my-visitor-profile.log")

   REMEMBER! WMStats display based on CSS, please take a look wm.css
   which included in wmstats.zip. Change it to match with your flavour :)

 */

/*
 * ====================================================================
 * function daily_stats($visitor_file_name)
 * Display daily status of visitors, using file created by daily_count()
 * --------------------------------------------------------------------
 */
function daily_stats($visitor_file_name){

	global $base_datapath, $bgcol, $toprowcol, $grey;

	if(!$visitor_file_name || empty($visitor_file_name)){ $visitor_file_name = "daily_visitors.wmn"; }
		$visitor_file_path = $base_datapath."/".$visitor_file_name;
		if(file_exists("$visitor_file_path")){
			$fcontents = file("$visitor_file_path");
			$i = 0;
			while(list($lineno, $row) = each($fcontents)){
				$row_content = explode("|",$row);
				$i++;
				/* Collect OS first */
				
				if(preg_match("/Windows NT [\d\.\d]+|WinNT|Windows [\d]+|Win9[\d]+|Win 9[\d]+/i",$row_content[3])){
					preg_match("/Windows NT [\d\.\d]+|WinNT|Windows [\d]+|Win9[\d]+|Win 9[\d]+/i",$row_content[3],$matches);
					while(list($key,$value) = each($matches)){
						if(preg_match("/Win9[\d]+/i",$value)){
							$version = preg_replace("/Win/","Windows ",$value);
						}elseif(preg_match("/Win 9[\d]+/i",$value)){
							$version = preg_replace("/Win /","Windows ",$value);
						}elseif(preg_match("/Windows [\d]+/i",$value)){
							$version = preg_replace("/Windows /","Windows ",$value);
						/*
						}elseif(preg_match("/WinNT|Windows 2000/i",$value)){
							$version = preg_replace("/WinNT|Windows 2000/","Windows NT/2000",$value);
						}else{
							$version = preg_replace("/NT/","NT/2000",$value);
						*/
						}else{
							if(preg_match("/NT 5.0/i",$value)){
								$version = "Windows 2000";
							}elseif(preg_match("/NT 5.1/i",$value)){
								$version = "Windows XP";
							}else{
								$version = "Windows NT";
							}
						}
					}
					$OS["$version"]++;
				}elseif(preg_match("/Mac_PowerPC/i",$row_content[3]) || preg_match("/Macintosh/i",$row_content[3])){
					$OS["Macintosh"]++;
				}elseif(preg_match("/Linux [\d\.]*|Linux/i",$row_content[3])){
						preg_match("/Linux [\d\.]*|Linux/i",$row_content[3],$matches);
						while(list($key,$value) = each($matches)){
							$version = $value;
						}
						$OS["$version"]++;
				}elseif(preg_match("/SunOS [\d\.]*|SunOS/i",$row_content[3])){
						preg_match("/SunOS [\d\.]*|SunOS/i",$row_content[3],$matches);
						while(list($key,$value) = each($matches)){
							$version = $value;
						}
						$OS["$version"]++;
				}elseif(preg_match("/FreeBSD/i",$row_content[3])){
						$OS["FreeBSD"]++;
				}elseif(preg_match("/OS\/2/i",$row_content[3])){
					$OS["OS/2"]++;
				}elseif(preg_match("/WebTV/i",$row_content[3])){
					$OS["WebTV"]++;
				}else{
					if(preg_match("/Lynx|X11|nix/i",$row_content[3])){
						$OS["Unix"]++;
					}elseif(preg_match("/ZyBorg|WebCrawler|Slurp|Googlebot|MuscatFerret|ia_archiver/i",$row_content[3])){
						$OS["Web Indexing Robot"]++;
					}else{
						//if(!empty($row_content[3])){ echo $row_content[3]; }
						//die;
						$OS["Unresolved Platform"]++;
					}
				}

				/* Then the browsers */

				if(preg_match("/Opera/i",$row_content[3])){
					preg_match("/Opera\/[\d\.]*|Opera [\d\.]*/i",$row_content[3],$matches);
					while(list($key,$value) = each($matches)){
						$version = preg_replace("/\//"," ",$value);
					}
					$browser["$version"]++;
				}elseif(preg_match("/MSIE/i",$row_content[3])){
					if(preg_match("/WebTV\/[\d.]+|WebTV [\d.]+/i",$row_content[3])){
						preg_match("/WebTV\/[\d\.]+|WebTV [\d.]+/i",$row_content[3],$matches);
						while(list($key,$value) = each($matches)){
							$version = $value;
							$version = preg_replace("/\//"," ",$version);
						}
						$browser["$version"]++;
					}else{
						preg_match("/MSIE [\d\.\w]*/",$row_content[3],$matches);
						while(list($key,$value) = each($matches)){
							$version = preg_replace("/MSIE/","",$value);
						}
						$browser["Internet Explorer $version"]++;
					}
				}elseif(preg_match("/ZyBorg|WebCrawler|Slurp|Googlebot|MuscatFerret|ia_archiver/i",$row_content[3])){
					$browser["Web Indexing Robot"]++;
				}elseif(preg_match("/Konqueror\/[a-zA-Z0-9.]+/i",$row_content[3])){
					preg_match("/Konqueror\/[a-zA-Z0-9.]+/i",$row_content[3],$matches);
					while(list($key,$value) = each($matches)){
						$version = preg_replace("/Konqueror\//","",$value);
					}
					$browser["Konqueror $version"]++;
/*				}elseif(preg_match("/Mozilla\/5/i",$row_content[3])){
					$browser["Netscape Navigator 6"]++; */
				}elseif(preg_match("/Firefox\/5/i",$row_content[3])){
					$browser["Firefox"]++;
				}elseif(preg_match("/Netscape\/[\d\.\w]*/i",$row_content[3])){
					preg_match("/Netscape\/[\d\.\w]*/i",$row_content[3],$matches);
					while(list($key,$value) = each($matches)){
						$version = preg_replace("/Netscape\//","",$value);
					}
					$browser["Netscape $version"]++;
				}elseif(preg_match("/Lynx\/[\d\.\w]*/i",$row_content[3])){
					preg_match("/Lynx\/[\d\.\w]*/i",$row_content[3],$matches);
					while(list($key,$value) = each($matches)){
						$version = preg_replace("/\//"," ",$value);
					}
					$browser["$version"]++;
				}elseif(!empty($row_content[3]) && !preg_match("/unknown/i",$row_content[3])){
					$other_browser = $row_content[3];
					$other_browser = preg_replace("/\//"," ",$other_browser);
					$browser["$other_browser"]++;
				}else{
					$browser["Unresolved Browser"]++;
				}

				/* Next step is Domain referer */

				$get_referer = chop($row_content[4]);
				if(empty($get_referer)){
					$get_referer = "No Referer";
				}else{
					//preg_match("/http:\/\/[\w\-]*\.?[\w\-]*\.?[\w\-]+\.[a-z]{2,4}|http:\/\/[\w\-]*\.?[\w\-]*\.?[\w\-]+\.[a-z]{2,4}\:\d{2}|http:\/\/\d+.\d+.\d+.\d+[\:\d]*/i",$row_content[4],$matches);
					preg_match("/http:\/\/[\w\-\d\.]*[\:\d]*|https:\/\/[\w\-\d\.]*[\:\d]*/i",$get_referer,$matches);
					while(list($key,$value) = each($matches)){
						$get_referer = $value;
					}
				}
				$referer["$get_referer"]++;

				/* Then collect Page referer */

				$get_pagereferer = chop($row_content[4]);
				if(empty($get_pagereferer)){
					$get_pagereferer = "No Referer";
/*				}else{
					if(strlen($get_pagereferer) > 80){
						$get_pagereferer = substr($get_pagereferer,0,79)." { CUT - TOO LONG }";
					}*/
				}
				$pagereferer["$get_pagereferer"]++;

				/* Next..., Visitors host */

				$get_visitorhost = chop($row_content[2]);
				if(empty($get_visitorhost)){
					$get_visitorhost = "No host logged!";
				}else{
					if(preg_match("/(^[\d\.]+\.[\d]+)/i",$get_visitorhost)){
						$get_visitorhost = "Unresolved IP";
					}elseif(preg_match("/\.[a-zA-Z_-]*\.[a-zA-Z0-9_-]+\.[A-Za-z]{2,4}$/",$get_visitorhost)){
						preg_match("/\.[a-zA-Z_-]*\.[a-zA-Z0-9_-]+\.[A-Za-z]{2,4}$/",$get_visitorhost,$matches);
						while(list($key,$value) = each($matches)){
							$get_visitorhost = $value;
						}
					}elseif(preg_match("/\.[a-zA-Z0-9_-]*\.[a-zA-Z0-9_-]+\.[A-Za-z]{2,4}$/",$get_visitorhost)){
						preg_match("/\.[a-zA-Z0-9_-]*\.[a-zA-Z0-9_-]+\.[A-Za-z]{2,4}$/",$get_visitorhost,$matches);
						while(list($key,$value) = each($matches)){
							$get_visitorhost = preg_replace("/^\.[a-zA-Z0-9_-]+|^\.[\d]+/","",$value);
						}
					}elseif(preg_match("/[a-zA-Z0-9]*\.[a-zA-Z_-]+\.[A-Za-z]{2,4}$/",$get_visitorhost)){
						preg_match("/[a-zA-Z0-9]*\.[a-zA-Z_-]+\.[A-Za-z]{2,4}$/",$get_visitorhost,$matches);
						while(list($key,$value) = each($matches)){
							$get_visitorhost = preg_replace("/^[a-zA-Z0-9]+|^[\d]+/","",$value);
						}
					}
					$get_visitorhost = preg_replace("/^\./","",$get_visitorhost);
				}
				$visitorhost["$get_visitorhost"]++;

				/* Next..., visitors country */

				$get_visitorcountry = chop($row_content[2]);
				if(empty($get_visitorcountry)){
					$get_visitorcountry = "No host logged!";
				}else{
					if(preg_match("/(^[\d\.]+\.[\d]+)/i",$get_visitorcountry)){
						$get_visitorcountry = "Unresolved IP";
					}elseif(preg_match("/\.[A-Za-z]{2,4}$/",$get_visitorcountry)){
						preg_match("/\.[A-Za-z]{2,4}$/",$get_visitorcountry,$matches);
						while(list($key,$value) = each($matches)){
							$get_visitorcountry = strtolower($value);
						}
					}
					$get_visitorcountry = preg_replace("/^\./","",$get_visitorcountry);
				}
				$visitorcountry["$get_visitorcountry"]++;

			}

			/* Open Table */

			$return = "<span class=\"bigtitle\">$i Unique Visitors Profile Today</span><p>";
			$return .= "\n<table border=0 cellspacing=0 cellpadding=0><tr><td bgcolor=$toprowcol>";
			$return .= "\n<table border=0 cellspacing=1 cellpadding=3>";

			/* Display Visitors OS */

			$arr = 0;
			while(list($key,$value) = each($OS)){
				$sort_os[$arr]['value'] = $value;
				$sort_os[$arr]['key'] = $key;
				$arr++;
			}
			usort($sort_os, sort_gnrl);

			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Operating System</td></tr>";
			while(list($key,$value) = each($sort_os)){
				$persentase = $value['value'] / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$opsy = $value['key']." (".$value['value'].")";
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$opsy</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}

			/* --- Sort on value only ---
			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Operating System</td></tr>";
			arsort($OS);
			reset($OS);
			while(list($key,$value) = each($OS)){
				$persentase = $value / $i * 100;
				$persentase = number_format($persentase,2)."%";
				$bi = get_barimage(round($persentase));
				$rn++;
				$tc = get_bgcolor($rn);
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$key ($value)</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}
			*/

			/* Display Visitors Browser */

			$arr = 0;
			while(list($key,$value) = each($browser)){
				$sort_browser[$arr]['value'] = $value;
				$sort_browser[$arr]['key'] = $key;
				$arr++;
			}
			usort($sort_browser, sort_gnrl);

			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Browser</td></tr>";
			while(list($key,$value) = each($sort_browser)){
				$persentase = $value['value'] / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$brws = $value['key']." (".$value['value'].")";
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$brws</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}

			/* --- Sort on value only ---
			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Browser</td></tr>";
			arsort($browser);
			reset($browser);
			while(list($key,$value) = each($browser)){
				$persentase = $value / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$key ($value)</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}
			*/


			/* Display Domain Referer */

			$arr = 0;
			while(list($key,$value) = each($referer)){
				$sort_referer[$arr]['value'] = $value;
				$sort_referer[$arr]['key'] = $key;
				$arr++;
			}
			usort($sort_referer, sort_gnrl);

			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Domain Referer</td></tr>";
			while(list($key,$value) = each($sort_referer)){
				if($value['key'] != "No Referer") {
					$link = "<a href=\"" . $value['key'] . "\" target=\"_blank\">" . $value['key'] . "</a>" . " (" . $value['value'] . ")";
				}else{
					$link = $value['key'] . " (" . $value['value'] . ")";
				}
				$persentase = $value['value'] / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$link</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}

			/* --- Sort on value only ---
			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Domain Referer</td></tr>";
			arsort($referer);
			reset($referer);
			while(list($key,$value) = each($referer)){
				if($key != "No Referer") {
					$link = "<a href=$key target=\"_blank\">$key</a>";
				}else{
					$link = $key;
				}
				$persentase = $value / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$link ($value)</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}
			*/

			/* Display Page Referer */

			$arr = 0;
			while(list($key,$value) = each($pagereferer)){
				$sort_preferer[$arr]['value'] = $value;
				$sort_preferer[$arr]['key'] = $key;
				$arr++;
			}
			usort($sort_preferer, sort_gnrl);

			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Page Referer</td></tr>";
			while(list($key,$value) = each($sort_preferer)){
				//if($value['key'] == "No Referer" || preg_match("/CUT - TOO LONG/",$value['key'])) {
				if($value['key'] == "No Referer") {
					$link = $value['key'] . " (" . $value['value'] . ")";
				}else{
					if(strlen($value['key']) > 80){
						$display_link = substr($value['key'],0,79) . " { CUT - TOO LONG }";
					}else{
						$display_link = $value['key'];
					}
					$link = "<a href=\"" . $value['key'] . "\" target=\"_blank\">" . $display_link . "</a>" . " (" . $value['value'] . ")";
				}
				$persentase = $value['value'] / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$link</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}

			/* --- Sort on value only ---
			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Page Referer</td></tr>";
			arsort($pagereferer);
			reset($pagereferer);
			while(list($key,$value) = each($pagereferer)){
				if($key == "No Referer" || preg_match("/CUT - TOO LONG/",$key)) {
					$link = $key;
				}else{
					$link = "<a href=$key target=\"_blank\">$key</a>";
				}
				$persentase = $value / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$link ($value)</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}
			*/

			/* Display Visitors Hostname */

			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Hostname</td></tr>";
			arsort($visitorhost);
			reset($visitorhost);
			while(list($key,$value) = each($visitorhost)){
				$persentase = $value / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$key ($value)</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}

			/* Countries Code */
			
			$negara = array(
				"ad" => "Andorra",
				"ae" => "United Arab Emirates",
				"af" => "Afghanistan",
				"ag" => "Antigua and Barbuda",
				"ai" => "Anguilla",
				"al" => "Albania",
				"am" => "Armenia",
				"an" => "Netherlands Antilles",
				"ao" => "Angola",
				"aq" => "Antarctica",
				"ar" => "Argentina",
				"as" => "American Samoa",
				"at" => "Austria",
				"au" => "Australia",
				"aw" => "Aruba",
				"az" => "Azerbaijan",
				"ba" => "Bosnia Herzegovina",
				"bb" => "Barbados",
				"bd" => "Bangladesh",
				"be" => "Belgium",
				"bf" => "Burkina Faso",
				"bg" => "Bulgaria",
				"bh" => "Bahrain",
				"bi" => "Burundi",
				"bj" => "Benin",
				"bm" => "Bermuda",
				"bn" => "Brunei Darussalam",
				"bo" => "Bolivia",
				"br" => "Brazil",
				"bs" => "Bahamas",
				"bt" => "Bhutan",
				"bv" => "Bouvet Island",
				"bw" => "Botswana",
				"by" => "Belarus",
				"bz" => "Belize",
				"ca" => "Canada",
				"cc" => "Cocos (Keeling) Islands",
				"cf" => "Central African Republic",
				"cg" => "Congo",
				"ch" => "Switzerland",
				"ci" => "Cote DIvoire",
				"ck" => "Cook Islands",
				"cl" => "Chile",
				"cm" => "Cameroon",
				"cn" => "China",
				"co" => "Colombia",
				"cr" => "Costa Rica",
				"cs" => "Czechoslovakia",
				"cu" => "Cuba",
				"cv" => "Cape Verde",
				"cx" => "Christmas Island",
				"cy" => "Cyprus",
				"cz" => "Czech Republic",
				"de" => "Germany",
				"dj" => "Djibouti",
				"dk" => "Denmark",
				"dm" => "Dominica",
				"do" => "Dominican Republic",
				"dz" => "Algeria",
				"ec" => "Ecuador",
				"ee" => "Estonia",
				"eg" => "Egypt",
				"eh" => "Western Sahara",
				"er" => "Eritrea",
				"es" => "Spain",
				"et" => "Ethiopia",
				"fi" => "Finland",
				"fj" => "Fiji",
				"fk" => "Falkland Islands (Malvinas)",
				"fm" => "Micronesia",
				"fo" => "Faroe Islands",
				"fr" => "France",
				"fx" => "France (Metropolitan)",
				"ga" => "Gabon",
				"gb" => "Great Britain (UK)",
				"gd" => "Grenada",
				"ge" => "Georgia",
				"gf" => "French Guiana",
				"gh" => "Ghana",
				"gi" => "Gibraltar",
				"gl" => "Greenland",
				"gm" => "Gambia",
				"gn" => "Guinea",
				"gp" => "Guadeloupe",
				"gq" => "Equatorial Guinea",
				"gr" => "Greece",
				"gs" => "S. Georgia and S. Sandwich Islands",
				"gt" => "Guatemala",
				"gu" => "Guam",
				"gw" => "Guinea-Bissau",
				"gy" => "Guyana",
				"hk" => "Hong Kong",
				"hm" => "Heard and McDonald Islands",
				"hn" => "Honduras",
				"hr" => "Croatia (Hrvatska)",
				"ht" => "Haiti",
				"hu" => "Hungary",
				"id" => "Indonesia",
				"ie" => "Ireland",
				"il" => "Israel",
				"in" => "India",
				"io" => "British Indian Ocean Territory",
				"iq" => "Iraq",
				"ir" => "Iran",
				"is" => "Iceland",
				"it" => "Italy",
				"jm" => "Jamaica",
				"jo" => "Jordan",
				"jp" => "Japan",
				"ke" => "Kenya",
				"kg" => "Kyrgyzstan",
				"kh" => "Cambodia",
				"ki" => "Kiribati",
				"km" => "Comoros",
				"kn" => "Saint Kitts and Nevis",
				"kp" => "North Korea",
				"kr" => "South Korea",
				"kw" => "Kuwait",
				"ky" => "Cayman Islands",
				"kz" => "Kazakhstan",
				"la" => "Laos",
				"lb" => "Lebanon",
				"lc" => "Saint Lucia",
				"li" => "Liechtenstein",
				"lk" => "Sri Lanka",
				"lr" => "Liberia",
				"ls" => "Lesotho",
				"lt" => "Lithuania",
				"lu" => "Luxembourg",
				"lv" => "Latvia",
				"ly" => "Libya",
				"ma" => "Morocco",
				"mc" => "Monaco",
				"md" => "Moldova",
				"mg" => "Madagascar",
				"mh" => "Marshall Islands",
				"mk" => "Macedonia",
				"ml" => "Mali",
				"mm" => "Myanmar",
				"mn" => "Mongolia",
				"mo" => "Macau",
				"mp" => "Northern Mariana Islands",
				"mq" => "Martinique",
				"mr" => "Mauritania",
				"ms" => "Montserrat",
				"mt" => "Malta",
				"mu" => "Mauritius",
				"mv" => "Maldives",
				"mw" => "Malawi",
				"mx" => "Mexico",
				"my" => "Malaysia",
				"mz" => "Mozambique",
				"na" => "Namibia",
				"nc" => "New Caledonia",
				"ne" => "Niger",
				"nf" => "Norfolk Island",
				"ng" => "Nigeria",
				"ni" => "Nicaragua",
				"nl" => "Netherlands",
				"no" => "Norway",
				"np" => "Nepal",
				"nr" => "Nauru",
				"nt" => "Neutral Zone",
				"nu" => "Niue",
				"nz" => "New Zealand (Aotearoa)",
				"om" => "Oman",
				"pa" => "Panama",
				"pe" => "Peru",
				"pf" => "French Polynesia",
				"pg" => "Papua New Guinea",
				"ph" => "Philippines",
				"pk" => "Pakistan",
				"pl" => "Poland",
				"pm" => "St. Pierre and Miquelon",
				"pn" => "Pitcairn",
				"pr" => "Puerto Rico",
				"pt" => "Portugal",
				"pw" => "Palau",
				"py" => "Paraguay",
				"qa" => "Qatar",
				"re" => "Reunion",
				"ro" => "Romania",
				"ru" => "Russian Federation",
				"rw" => "Rwanda",
				"sa" => "Saudi Arabia",
				"sb" => "Solomon Islands",
				"sc" => "Seychelles",
				"sd" => "Sudan",
				"se" => "Sweden",
				"sg" => "Singapore",
				"sh" => "St. Helena",
				"si" => "Slovenia",
				"sj" => "Svalbard and Jan Mayen Islands",
				"sk" => "Slovak Republic",
				"sl" => "Sierra Leone",
				"sm" => "San Marino",
				"sn" => "Senegal",
				"so" => "Somalia",
				"sr" => "Suriname",
				"st" => "Sao Tome and Principe",
				"su" => "USSR (Former)",
				"sv" => "El Salvador",
				"sy" => "Syria",
				"sz" => "Swaziland",
				"tc" => "Turks and Caicos Islands",
				"td" => "Chad",
				"tf" => "French Southern Territories",
				"tg" => "Togo",
				"th" => "Thailand",
				"tj" => "Tajikistan",
				"tk" => "Tokelau",
				"tm" => "Turkmenistan",
				"tn" => "Tunisia",
				"to" => "Tonga",
				"tp" => "East Timor",
				"tr" => "Turkey",
				"tt" => "Trinidad and Tobago",
				"tv" => "Tuvalu",
				"tw" => "Taiwan",
				"tz" => "Tanzania",
				"ua" => "Ukraine",
				"ug" => "Uganda",
				"uk" => "United Kingdom",
				"um" => "US Minor Outlying Islands",
				"us" => "United States",
				"uy" => "Uruguay",
				"uz" => "Uzbekistan",
				"va" => "Vatican City State (Holy See)",
				"vc" => "Saint Vincent and the Grenadines",
				"ve" => "Venezuela",
				"vg" => "Virgin Islands (British)",
				"vi" => "Virgin Islands (US)",
				"vn" => "Vietnam",
				"vu" => "Vanuatu",
				"wf" => "Wallis and Futuna Islands",
				"ws" => "Samoa",
				"ye" => "Yemen",
				"yt" => "Mayotte",
				"yu" => "Yugoslavia",
				"za" => "South Africa",
				"zm" => "Zambia",
				"zr" => "Zaire",
				"zw" => "Zimbabwe",
				"biz" => "Business",
				"com" => "Commercial",
				"edu" => "Educational",
				"gov" => "US Government",
				"int" => "International",
				"mil" => "US Military",
				"net" => "Network",
				"org" => "Non-Profit Organization",
				"info" => "Info",
				"arpa" => "Old-Style Arpanet",
				"nato" => "NATO Field"
				);

			/* Prepare Visitors Country Data */

			$arr = 0;
			while(list($key,$value) = each($visitorcountry)){
				$sort_visitorcountry[$arr]['refernya'] = $value;
				$sort_visitorcountry[$arr]['negaranya'] = $key;
				$sort_visitorcountry[$arr]['nama_negaranya'] = $negara["$key"];
				$arr++;
			}
			usort($sort_visitorcountry, sort_country);

			/* Display Visitors Country */

			$rn = 0;
			$return .= "\n<tr><td colspan=4 bgcolor=$toprowcol class=judulputih nowrap>Country</td></tr>";
			while(list($key,$value) = each($sort_visitorcountry)){
				if($value['negaranya'] != "Unresolved IP"){
					$kode_negara = $value['negaranya'];
					$country = $value['nama_negaranya']." - ".$value['negaranya']." (".$value['refernya'].")";
				}else{
					$country = $value['negaranya']." (".$value['refernya'].")";
				}
				$persentase = $value['refernya'] / $i * 100;
				$bi = get_barimage(round($persentase));
				$persentase = number_format($persentase,2)."%";
				$rn++;
				$tc = get_bgcolor($rn);
				$return .= "\n<tr bgcolor=$tc><td class=lead align=right>$rn</td><td class=lead>$country</td><td>$bi</td><td align=right class=lead>$persentase</td></tr>";
			}

			/* Done! Close the table and sending results */

			$return .= "\n</table>";
			$return .= "\n</td></tr></table>";
			/* Don't change or delete line below..., give us credit ok? Me, and the whole PHP Developers :), thanks */
			$return .= "\n<br><span class=\"lead\">Generated by <a href=\"http://wartamikael.org/PHPScripts/?product=WMStats\" target=\"_blank\">WMStats</a> & <a href=\"http://www.php.net\" target=\"_blank\">PHP</a>.</span>";
			return $return;
		}else{
			return "Is WMCounter already installed? Have you run it before? If not please run it now!";
		}
}


/*
 * ======================
 * function get_bgcolor()
 * Table row color
 * ----------------------
 */
function get_bgcolor($tr){
	global $bgcol, $grey;
	if(!empty($tr)){
		if($tr % 2 == 1){
			$rc = $bgcol;
		}else{
			$rc = $grey;
		}
	}else{
		$rc = "#FFFFFF";
	}
	return $rc;
}

/*
 * =================================
 * function get_barimage($prs)
 * calculate how length of image bar
 * ---------------------------------
 */
function get_barimage($p){
	if($p == 0){
		$return = "<img src=\"../images/plbar.gif\"><img src=\"../images/prbar.gif\">";
	}else{
		$return = "<img src=\"../images/plbar.gif\"><img src=\"../images/pcbar.gif\" width=\"$p\" height=\"14\"><img src=\"../images/prbar.gif\">";
	}
	return $return;
}

/*
 * =============================
 * function sort_country($a, $b)
 * to sort visitors country
 * -----------------------------
 */
function sort_country($a, $b){
	if($a['refernya'] == $b['refernya']){
		if($a['nama_negaranya'] == $b['nama_negaranya']){
			return 0;
		}elseif($a['nama_negaranya'] > $b['nama_negaranya']){
			return 1;
		}else{
			return -1;
		}
	}else{
		if($a['refernya'] > $b['refernya']){
			return -1;
		}else{
			return 1;
		}
	}
}

/*
 * =====================================
 * function sort_gnrl($a,$b)
 * sort anything except visitors country
 * -------------------------------------
 */
function sort_gnrl($a,$b){
	if($a['value'] == $b['value']){
		if($a['key'] == $b['key']){
			return 0;
		}elseif($a['key'] > $b['key']){
			return 1;
		}else{
			return -1;
		}
	}else{
		if($a['value'] > $b['value']){
			return -1;
		}else{
			return 1;
		}
	}
}

?>
