##########################################
# osXBar 1.0 20030923 - 20031001 -20031015
## This is a threaded Email checker
## GPL from stefanux @ libero .it
## created for osX Bar

import time,re,string
import math
import karamba


class osXBarAni:
	Engine=0
	Matrix=0
	# Status
	Animating=0
	Animate=0
	# Wrappers
	AniRemove=0
	AniClick=0
	AniActivate=0
	AniClose=0
	#Step Ani
	Resety=0
	ResetRatio=1
	# Step Bounce
	BounceIcon=0
	BounceY=0
	BounceDY=0
	BounceX=0
	def changeIconsTheme(self,newicontheme):
		self.Engine.Configuration["IconsTheme"]=newicontheme
		for i in range(len(self.Engine.Objects)):
			self.Engine.Objects[i].ChangeImage(self.Engine.Objects[i].imgSource)
	def changeBackground(self, newbartheme):
		locallist=[]
		if(len(self.Engine.Bar)>2):
			for i in range(3):
				karamba.hideImage(self.Engine.Widget,self.Engine.Bar[i])
				locallist.append(self.Engine.Bar[i])
		self.Engine.Configuration["BarTheme"]=newbartheme
		if(self.Engine.Configuration["BarTheme"]!=""):
				(bx,by)=self.Engine.Cfg.Matrix.MakeBarSpace(0)
				self.Engine.Bar[0]=karamba.createImage(self.Engine.Widget,bx,by,self.Engine.Configuration["pathBar"]+self.Engine.Configuration["BarTheme"]+"/background-left.png")
				(bx,by)=self.Engine.Cfg.Matrix.MakeBarSpace(1)
				self.Engine.Bar[1]=karamba.createImage(self.Engine.Widget,bx,by,self.Engine.Configuration["pathBar"]+self.Engine.Configuration["BarTheme"]+"/background-center.png")
				(bx,by)=self.Engine.Cfg.Matrix.MakeBarSpace(2)
				self.Engine.Bar[2]=karamba.createImage(self.Engine.Widget,bx,by,self.Engine.Configuration["pathBar"]+self.Engine.Configuration["BarTheme"]+"/background-right.png")

		if(len(locallist)>2):
			for i in range(3):
				karamba.deleteImage(self.Engine.Widget,locallist[i])
		self.changeIconsTheme(self.Engine.Configuration["IconsTheme"])

	def Init(self, NextStatus):
		if(NextStatus==1):
			self.ResetRatio=self.Engine.Configuration["AniSpeed"]
		if(NextStatus==2):
			self.AniRemove=self.AniRemoveNone
			self.AniClick=self.AniNone
			self.AniActivate=self.AniNone
			self.AniClose=self.AniNone

			if(self.Engine.Configuration["AniRemove"]=="slide"):
				self.AniRemove=self.AniRemoveSlide
			if(self.Engine.Configuration["AniRemove"]=="micro"):
				self.AniRemove=self.AniRemoveMicro
			if(self.Engine.Configuration["AniRemove"]=="none"):
				self.AniRemove=self.AniRemoveNone
			if(self.Engine.Configuration["AniClick"]=="bounce"):
				self.AniClick=self.AniBounce
			if(self.Engine.Configuration["AniClick"]=="micro"):
				self.AniClick=self.AniMicro
			if(self.Engine.Configuration["AniClick"]=="cicle"):
				self.AniClick=self.AniCicle
			if(self.Engine.Configuration["AniActivate"]=="bounce"):
				self.AniActivate=self.AniBounce
			if(self.Engine.Configuration["AniActivate"]=="micro"):
				self.AniActivate=self.AniMicro
			if(self.Engine.Configuration["AniActivate"]=="cicle"):
				self.AniActivate=self.AniCicle
			if(self.Engine.Configuration["AniClose"]=="bounce"):
				self.AniClose=self.AniBounce
			if(self.Engine.Configuration["AniClose"]=="micro"):
				self.AniClose=self.AniMicro
			if(self.Engine.Configuration["AniClose"]=="cicle"):
				self.AniClose=self.AniCicle
	def AniRemoveNone(self,i):
		pass
	def AniNone(self,iconNum,lastx,lasty):
		pass
	def AniReset(self,lastx,lasty):
		#for i in range(lasty,self.Matrix.SizeMatrix*2):
		#for i in range(1,lasty):
		#	print str(i)
		#	time.sleep(0.001)
		#	self.Engine.MouseMoved(lastx,lasty-i,0)
		#  This code is moved to TIME STEP Animator
		if(self.Engine.Objects[0].centerY>lasty):
			self.Resety=lasty
		else:
			self.Resety=lasty-2*(lasty-self.Engine.Objects[self.Engine.lastIcon%len(self.Engine.Objects)].centerY)
		self.Animate=self.StepReset
		self.Animating=1
		self.Resety=self.Resety-self.ResetRatio
		self.Engine.MouseMoved(self.Engine.lastx,self.Resety,0)
	def StepReset(self):
		self.Resety=self.Resety-self.ResetRatio
		# 20031018
		for i in range(len(self.Engine.Objects)):
			# Check if we have end the animation
			# antistress
			time.sleep(0.001)
			if(self.Engine.Objects[i].HasChanged!=0):
				# last cycle we had moved...
				self.Engine.MouseMoved(self.Engine.lastx,self.Resety,0)
				return
		# 20031018
		self.Animating=0
		self.Animate=0
		self.Resety=0
		#if(self.Resety<-100):
		#	# End of Reset
		#	self.Animating=0
		#	self.Animate=0
		#	self.Resety=0
		#	return
		#self.Engine.MouseMoved(self.Engine.lastx,self.Resety,0)
	def StepBounce(self):
		self.BounceCount=self.BounceCount+20
		if(self.BounceCount>360):
			self.BounceCount=0
			# End of Reset
			self.Animating=0
			self.Animate=0
			self.Resety=0
			return
		karamba.moveImage(self.Engine.Widget,self.Engine.Objects[self.BounceIcon].imgImage,self.BounceX,self.BounceY+int(math.sin((self.BounceCount*6.28)/360)*self.BounceDY))
		karamba.redrawWidget(self.Engine.Widget)
	def AniCicle(self,iconNum,lastx,lasty):
		raggio=15
		for i in range(0,628,20):
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx,lasty+raggio*math.sin((0.0-i)/100))
			karamba.redrawWidget(self.Engine.Widget)
			time.sleep(self.Engine.Configuration["SleepTime"])

	def AniBounce(self,iconNum,lastx,lasty):
		# 20031014 No blocking call
		# It's not smoooooth :(
		#self.BounceIcon=iconNum
		#self.BounceY=lasty
		#self.BounceDY=10
		#self.BounceX=lastx
		#self.BounceBounce=4
		#self.BounceCount=0
		#self.Animate=self.StepBounce
		#self.Animating=1
		# it's a blocking call ?
		#return
		for i in range(0,5):
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx,lasty-i*2)
			karamba.redrawWidget(self.Engine.Widget)
			time.sleep(self.Engine.Configuration["SleepTime"])
		for i in range(0,10):
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx,lasty-10+i*2)
			karamba.redrawWidget(self.Engine.Widget)
			time.sleep(self.Engine.Configuration["SleepTime"])
		for i in range(0,5):
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx,lasty+10-i*2)
			karamba.redrawWidget(self.Engine.Widget)
			time.sleep(self.Engine.Configuration["SleepTime"])
	def AniRemoveMicro(self,iconNum):
		# 20031018
		# Is reset?
		# yes, ok working on move icons no smooth
		#if(self.Engine.IsReset==0):
		#	return
		if(self.Engine.IsReset!=0):
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImageSmall,0,+10000)
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentX,self.Engine.Objects[iconNum].currentY)
		for i in range(0,self.Engine.Objects[iconNum].currentZ,2):
			#print str(i) + " " + str(self.Engine.Objects[iconNum].currentZ) + " " +str(self.Engine.Objects[iconNum].currentX)+ " " +str(self.Engine.Objects[iconNum].currentY)+ " " +str(self.Engine.Objects[iconNum].Command)
			karamba.resizeImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentZ-i,self.Engine.Objects[iconNum].currentZ-i)
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentX - (self.Engine.Objects[iconNum].currentZ-i)/2 + self.Engine.Objects[iconNum].currentZ/2,self.Engine.Objects[iconNum].currentY-(self.Engine.Objects[iconNum].currentZ-i)/2+self.Engine.Objects[iconNum].currentZ/2)

			karamba.redrawWidget(self.Engine.Widget)
			time.sleep(self.Engine.Configuration["SleepTime"])


	def AniRemoveSlide(self,iconNum):
		if(self.Engine.IsReset==0):
			return
		if(self.Engine.Configuration["WidgetAlign"]=="bottom"):
			# icon slide down
			for i in range(0,10):
				karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentX,self.Engine.Objects[iconNum].currentY+i*5)
				karamba.redrawWidget(self.Engine.Widget)
	def AniCreate(self,iconNum):
		if(self.Engine.IsReset==0):
			return
		if(self.Engine.Configuration["WidgetAlign"]=="bottom"):
			# icon slide down
			for i in range(0,10):
				karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentX,self.Engine.Objects[iconNum].currentY-((10-i)*5))
				karamba.redrawWidget(self.Engine.Widget)

	def AniMicro(self,iconNum,lastx,lasty):
		for i in range(0,self.Engine.Objects[iconNum].currentZ-self.Engine.Configuration["ImageSize"],8):
			karamba.resizeImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentZ-i,self.Engine.Objects[iconNum].currentZ-i)
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx-(self.Engine.Objects[iconNum].currentZ-i)/2+self.Engine.Objects[iconNum].currentZ/2,lasty-(self.Engine.Objects[iconNum].currentZ-i)/2+self.Engine.Objects[iconNum].currentZ/2)

			karamba.redrawWidget(self.Engine.Widget)
		for i in range(self.Engine.Objects[iconNum].currentZ-self.Engine.Configuration["ImageSize"],self.Engine.Objects[iconNum].currentZ,8):
			karamba.resizeImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,i,i)
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx-(i)/2+self.Engine.Objects[iconNum].currentZ/2,lasty-(i)/2+self.Engine.Objects[iconNum].currentZ/2)

			karamba.redrawWidget(self.Engine.Widget)
	def RotateMicro(self,iconNum,newSource):
		# 20031015
		lastx=self.Engine.lastIconx
		lasty=self.Engine.lastIcony
		for i in range(0,self.Engine.Objects[iconNum].currentZ-self.Engine.Configuration["ImageSize"],8):
			karamba.resizeImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentZ-i,self.Engine.Objects[iconNum].currentZ-i)
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx-(self.Engine.Objects[iconNum].currentZ-i)/2+self.Engine.Objects[iconNum].currentZ/2,lasty-(self.Engine.Objects[iconNum].currentZ-i)/2+self.Engine.Objects[iconNum].currentZ/2)

			karamba.redrawWidget(self.Engine.Widget)
		self.Engine.Objects[iconNum].ChangeImage(newSource)
		for i in range(self.Engine.Objects[iconNum].currentZ-self.Engine.Configuration["ImageSize"],self.Engine.Objects[iconNum].currentZ,8):
			karamba.resizeImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,i,i)
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx-(i)/2+self.Engine.Objects[iconNum].currentZ/2,lasty-(i)/2+self.Engine.Objects[iconNum].currentZ/2)

			karamba.redrawWidget(self.Engine.Widget)
	def RotateFlip(self,iconNum,newSource):
		# 20031015
		lastx=self.Engine.lastIconx
		lasty=self.Engine.lastIcony
		for i in range(0,self.Engine.Objects[iconNum].currentZ-self.Engine.Configuration["ImageSize"],8):
			karamba.resizeImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentZ,self.Engine.Objects[iconNum].currentZ-i)
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx,lasty-(self.Engine.Objects[iconNum].currentZ-i)/2+self.Engine.Objects[iconNum].currentZ/2)

			karamba.redrawWidget(self.Engine.Widget)
		self.Engine.Objects[iconNum].ChangeImage(newSource)
		for i in range(self.Engine.Objects[iconNum].currentZ-self.Engine.Configuration["ImageSize"],self.Engine.Objects[iconNum].currentZ,8):
			karamba.resizeImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,self.Engine.Objects[iconNum].currentZ,i)
			karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,lastx,lasty-(i)/2+self.Engine.Objects[iconNum].currentZ/2)

			karamba.redrawWidget(self.Engine.Widget)



	def RotateBounce(self,iconNum,newSource):
		# 20031015
		x=self.Engine.lastIconx
		y=self.Engine.lastIcony
		if(self.Engine.Configuration["WidgetAlign"]=="bottom"):
			# avoid flickering on change
			oldy=self.Engine.Objects[iconNum].currentY
			for i in range(0,15):
				karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,x,y+i*10)
				karamba.redrawWidget(self.Engine.Widget)
			self.Engine.Objects[iconNum].currentY=self.Engine.Objects[iconNum].currentY+1000
			self.Engine.Objects[iconNum].ChangeImage(newSource)
			self.Engine.Objects[iconNum].currentY=oldy
			for i in range(0,15):
				karamba.moveImage(self.Engine.Widget,self.Engine.Objects[iconNum].imgImage,x,y+((15-i)*10))
				karamba.redrawWidget(self.Engine.Widget)
		else:
			self.Engine.Objects[iconNum].ChangeImage(newSource)

