/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_TRAYICONLOGGER_H
#define XEPLUGIN_TRAYICONLOGGER_H

#include <ksystemtray.h>
#include <kpixmap.h>
#include <qtimer.h>
#include <qstring.h>

/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XEPlugin_TrayIconLogger : public KSystemTray
{
Q_OBJECT
public:
    XEPlugin_TrayIconLogger(QWidget *parent = 0, const char *name = 0);

    ~XEPlugin_TrayIconLogger();

public slots:
    void xParse(const QString &, int, void *);
    void xGetParameter(const QString, QString&);
    void xGetParameterList(QStringList *);
    void xSetupParameter(const QString, const QString);
    void xStart();
    void xStop();
    void xGetInfo(QStringList &);
    void xSetup();

protected:
	class XSConfigurations *ActiveConfiguration;
	KPixmap xActiveIcon;
	int idShowAll;
	QString trobbler;
	QTimer 		trobblerAnimator;
	QStringList	trobblerList;
	int		trobblerlastStep;
	QString		trobblerLastabsolutePath;
	int startupAddedCounter;
protected slots:
    void step();
    void xToggleShowAll();
    void xAbout();
    void xEventStartAnimating(const QString &);
    void xEventStopAnimating(const QString &);
protected:
    void xFindTrobbler(const QString, QString &, int);
    void fetchDefaultParameters();
signals:
    void xTaskMgr_GetParameter(const QString, int&);
    void xToggleShowAllDispatch();
    void xFindResource(const QString &, QString &);
};

#endif
