/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_gpipe.h"
#include "xeplugin_gpipe.moc"
#include "gpipethread.h"

#include <qbitmap.h>
#include <qimage.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <krun.h>
#include <qtimer.h>
#include <wmconfigurationwindow.h>


extern "C" QObject *xeplugin_register(QObject *parent)
{
	return new GPipe(parent,"GPipe");
}



GPipe::GPipe(QObject *parent, const char *name)
 : gPluginSDK(parent,name)
{
	PipeThread	=NULL;
	cmdRun="kxdocker/plugins/gpipe/scripts/example.sh";
	SpawnEvery=600;
	slideSeconds=60;
	
	QString Version="1.0.2";
	PluginInformations.append("KXDocker GPipe");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20060415"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gpipe");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=plugins#gpipe");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=update;version=%1").arg(Version)); // url update
	IconsPath="";
	// 0.40 check if already attached...
	XEObject::xPluginAdd(this);
}

GPipe::~GPipe()
{
	// 0.40 check if already attached...
	XEObject::xPluginDel(this);
}

QObject *   GPipe::Respawn(QObject *p)
{
	//0.40
	return (QObject *  )new GPipe(p,"GPipe");
}

void GPipe::xSetupParameter(const QString vname, const QString vvalue)
{
	if(vname=="background")
	{
		IconsPath=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("background",IconsPath);
		}
		else
		{
			createXMLTree();
		}
		Value=0;
		loadResources();
	}
	if(vname=="foreground")
	{
		Foreground=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("foreground",Foreground);
		}
		else
		{
			createXMLTree();
		}
		Value=0;
		loadResources();
	}
	if(vname=="cmdOpen")
	{
		cmdOpen=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("cmdOpen",cmdOpen);
		}
		else
		{
			createXMLTree();
		}
	}
	if(vname=="cmdOpen2")
	{
		cmdOpen2=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("cmdOpen2",cmdOpen2);
		}
		else
		{
			createXMLTree();
		}
	}
	if(vname=="cmdRun")
	{
		cmdRun=vvalue;
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("cmdRun",cmdRun);
		}
		else
		{
			createXMLTree();
		}
		xCheckRestart();
	}
	if(vname=="slideSeconds")
	{
		bool okRet=false;
		slideSeconds=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			slideSeconds=60;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("slideSeconds",slideSeconds);
		}
		else
		{
			createXMLTree();
		}
	}
	if(vname=="resizeimage")
	{
		bool okRet=false;
		resizeimage=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			resizeimage=100;
		}
		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("resizeimage",resizeimage);
		}
		else
		{
			createXMLTree();
		}
		Value=0;
		loadResources();

	}
	
	if(vname=="SpawnEvery")
	{
		bool okRet=false;
		SpawnEvery=vvalue.toInt(&okRet);
		
		if(okRet==false)
		{
			SpawnEvery=600;
		}

		// refreshing XML Data
		if(xXMLIconConfig->count()>0)
		{
			xXMLIconConfig->item(0).toElement().setAttribute("SpawnEvery",SpawnEvery);
		}
		else
		{
			createXMLTree();
		}


	}

	gPluginSDK::xSetupParameter(vname,vvalue);

}

void GPipe::xGetParameter(const QString vname, QString&vvalue)
{
	if(vname=="cmdRun")
	{
		vvalue=cmdRun;
	}
	if(vname=="background")
	{
		vvalue=IconsPath;
	}
	if(vname=="foreground")
	{
		vvalue=Foreground;
	}
	if(vname=="SpawnEvery")
	{
		vvalue.setNum(SpawnEvery);
	}
	if(vname=="slideSeconds")
	{
		vvalue.setNum(slideSeconds);
	}
	if(vname=="resizeimage")
	{
		vvalue.setNum(resizeimage);
	}
	if(vname=="cmdOpen")
	{
		vvalue=cmdOpen;
	}
	if(vname=="cmdOpen2")
	{
		vvalue=cmdOpen2;
	}
	gPluginSDK::xGetParameter(vname,vvalue);
	
}
void GPipe::xGetParameterList(QStringList *a)
{
	a->append("cmdRun");
	a->append("slideSeconds");
	a->append("SpawnEvery");
	a->append("background");
	a->append("foreground");
	a->append("resizeimage");
	a->append("cmdOpen");
	a->append("cmdOpen2");

	// 0.4 version with FX image
	gPluginSDK::xGetParameterList(a);
	
}

void GPipe::xPaint(int)
{
	if(isStopped){
		return;
	}
	QString targetFile=LastIcon;
	xFindResource("icon",targetFile);
	//if(targetFile!="")
	{
		Pixmap.load(::locate("data",targetFile));
		if(Pixmap.isNull())
		{
			QPixmap px;
			KIconLoader KDEIconLoader;
			px=KDEIconLoader.loadIcon(
						LastIcon,
						KIcon::NoGroup,
						128
						);
			Pixmap=px.convertToImage();
		}
		if(resizeimage>0 && Background.width()>0)
		{
			int aspectH;
			int aspectW;
			if(Pixmap.height()>Pixmap.width())
			{
				int maxAspect=(int)(((float)Background.height()/100)*resizeimage);
				aspectH=maxAspect;
				aspectW=(int)((float)Pixmap.height()/Pixmap.width()*aspectH);
			}
			else
			{
				int maxAspect=(int)(((float)Background.width()/100)*resizeimage);
				aspectW=maxAspect;
				aspectH=(int)((float)Pixmap.width()/Pixmap.height()*aspectW);
			}
			Pixmap=Pixmap.smoothScale(aspectH,aspectW);
		}
		if(IconsPath!=""&&!Background.isNull()&&Foreground!=""&&!iForeground.isNull())
		{
			QImage source;
			if(IconsPath!=""&&!Background.isNull())
			{
				source=Background.copy();
				bitBlt(&source,
					source.width()/2-Pixmap.width()/2,
					source.height()/2-Pixmap.height()/2,
					&Pixmap,
					0,
					0,
					Pixmap.width(),Pixmap.height(),Qt::CopyROP);
			}
			else
			{
				source=Pixmap.copy();
			}
			if(Foreground!=""&&!iForeground.isNull())
			{
				bitBlt(&source,0,0,
					&iForeground,
					0,
					0,
					iForeground.width(),iForeground.height(),Qt::CopyROP);
			}
			*xImgSource=source;
		}
		else
		{
			*xImgSource=Pixmap;
		}
	}
	ToolTip=LastIcon;
}

void GPipe::polling()
{
	if(isStopped){
		return;
	}
	Value++;
	xRefreshIcon(xGIcon);
/*
	QTimer::singleShot(1000, this, SLOT(polling()));
*/
}

void GPipe::xApplyCfg()
{
	//qWarning("void GPipe::xApplyCfg()");
	if(xXMLIconConfig->count()>0)
	{
		cmdRun=xXMLIconConfig->item(0).toElement().attribute("cmdRun","kxdocker/plugins/gpipe/scripts/example.sh");
		IconsPath=xXMLIconConfig->item(0).toElement().attribute("background","kxdocker/plugins/gpipe/background.png");
		Foreground=xXMLIconConfig->item(0).toElement().attribute("foreground","kxdocker/plugins/gpipe/foreground.png");
		cmdOpen=xXMLIconConfig->item(0).toElement().attribute("cmdOpen","showfoto \"%URL%\"");
		cmdOpen2=xXMLIconConfig->item(0).toElement().attribute("cmdOpen2","showfoto `dirname \"%URL%\"`/*");
		
		bool okRet=false;
		QString sOk=xXMLIconConfig->item(0).toElement().attribute("SpawnEvery","600");
		SpawnEvery=sOk.toInt(&okRet);
		
		if(okRet==false)
		{
			SpawnEvery=600;
		}
		sOk=xXMLIconConfig->item(0).toElement().attribute("slideSeconds","60");
		slideSeconds=sOk.toInt(&okRet);
		
		if(okRet==false)
		{
			slideSeconds=60;
		}		
		sOk=xXMLIconConfig->item(0).toElement().attribute("resizeimage","0");
		resizeimage=sOk.toInt(&okRet);
		if(okRet==false)resizeimage=0;
	}
	loadResources();
	// to enable the first pass
	//lastValue=-1;
	//dirty("");
}


void GPipe::dirty(const QString &newIcon)
{
	//qWarning(QString("void GPipe::dirty(const QString &%1)").arg(newIcon));
	if(LastIcon!=newIcon)
	{
		LastIcon=newIcon;
		// thread safe!
		QTimer::singleShot(100,this,SLOT(polling()));
		//Value++;
	}
	//xRefreshIcon(xGIcon);
}


void GPipe::xStop()
{
	//qWarning("void GPipe::xStop()");
	gPluginSDK::xStop();

	if(PipeThread!=NULL)
	{
		PipeThread->terminate();
		//qWarning("PipeThread->terminate();");

	}

	//qWarning("void GPipe::xStop() end");
}


void GPipe::xStart()
{
	if(xGIcon&&isStopped)
	{
		//qWarning("void GPipe::xStart()");
		if(PipeThread==NULL)
		{
			PipeThread=new GPipeThread(this);
			connect(PipeThread, SIGNAL(dirty(const QString&)),this, SLOT(dirty(const QString&)) );
			
		}
		else
		{
			xStop();
		}
		PipeThread->setCmd(::locate("data",cmdRun),SpawnEvery,slideSeconds);
		//qWarning("PipeThread->setCmd(cmdRun,SpawnEvery,slideSeconds);");
		PipeThread->start(QThread::IdlePriority);
		//qWarning("PipeThread->start(QThread::IdlePriority);");
		// 0.40
		if(ConfigurationWindow==NULL)
		{
			ConfigurationWindow=new WMConfigurationWindow(this);
		}

		gPluginSDK::xStart();
	}
	else
	{
		// Simply plugin startup
	}
}


/*!
    \fn GPipe::xCheckRestart()
 */
void GPipe::xCheckRestart()
{
	if(xGIcon&&isStopped)
	{

		if(PipeThread==NULL)
		{
			return;
		}
		else
		{
			PipeThread->terminate();
		}
		PipeThread->setCmd(::locate("data",cmdRun),SpawnEvery,slideSeconds);
		PipeThread->start(QThread::IdlePriority);
	}
}


/*!
    \fn GPipe::loadResources()
 */
void GPipe::loadResources()
{
	KIconLoader KDEIconLoader;
	QString iPaths=IconsPath;
	QFile a;
	xFindResource("icon",iPaths);
	//iPaths=::locate("data",iPaths);
	a.setName(iPaths);
	QPixmap px;
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=IconsPath;
		px=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}
	else
	{
		px=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);

	}
	Background=px.convertToImage();
	
	iPaths=Foreground;
	xFindResource("icon",iPaths);
	a.setName(iPaths);
	if(!a.exists() || iPaths==QString::null)
	{
		iPaths=Foreground;
		px=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);
	}
	else
	{
		px=KDEIconLoader.loadIcon(
				iPaths,
				KIcon::NoGroup,
				128
				);

	}
	iForeground=px.convertToImage();

}


/*!
    \fn GPipe::xGetParameterType(const QString &vname, QString &vvalue)
 */
void GPipe::xGetParameterType(const QString &vname, QString &vvalue)
{

	if(vname=="folderName")
	{
		vvalue=KXDOCKER_VARTYPE_STRING;
	}
	if(vname=="cmdRun")
	{
		vvalue=KXDOCKER_VARTYPE_STRING;
	}
	if(vname=="background")
	{
		vvalue=KXDOCKER_VARTYPE_ICON;
	}
	if(vname=="SpawnEvery")
	{
		vvalue=KXDOCKER_VARTYPE_INT;
	}
	if(vname=="slideSeconds")
	{
		vvalue=KXDOCKER_VARTYPE_INT;
	}
	
	gPluginSDK::xGetParameterType(vname,vvalue);
}


/*!
    \fn GPipe::xEnabledClick(int &a)
 */
void GPipe::xEnabledClick(int &a)
{
	a=1 | 2 | 4 | 8;
}


/*!
    \fn GPipe::xEventClick(void *pIcon,int x,int y,int button,int iconSize)
 */
void GPipe::xEventClick(void *pIcon,int x,int y,int button,int iconSize)
{
	qWarning(QString("Click![%1][%1][%1]").arg(button).arg(x).arg(y));
	if(pIcon!=this->xGIcon)return;
	if(button<3)
	{
		QString cmdToRun=cmdOpen;
		if(button==2)
		{
			cmdToRun=cmdOpen2;
		}
		cmdToRun=cmdToRun.replace("%URL%", LastIcon);
		KRun::runCommand(cmdToRun);
	}
}
