/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "wmconfigurationwindow.h"

#include <qtextedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <kfiledialog.h>
#include <qspinbox.h>
#include <kicondialog.h>
#include <qcheckbox.h>


WMConfigurationWindow::WMConfigurationWindow(QObject *parent, const char *name)
 : GPluginSDKCfg(0, name)
{
connect(this,SIGNAL(xApplyParameter(const QString, const QString)),parent,SLOT(xSetupParameter(const QString, const QString)));
}


WMConfigurationWindow::~WMConfigurationWindow()
{
}

void WMConfigurationWindow::pOK_clicked()
{
	QString stringa;
	stringa.setNum(slideSeconds->value());
	xApplyParameter("slideSeconds",stringa);
	stringa.setNum(SpawnEvery->value());
	xApplyParameter("SpawnEvery",stringa);

	xApplyParameter("cmdOpen",cmdOpen->currentText());
	xApplyParameter("cmdOpen2",cmdOpen2->currentText());


	xApplyParameter("cmdRun",cmdRun->currentText());

	if(bBackground->isChecked())xApplyParameter("background",Background->icon());
	else xApplyParameter("background","");
	if(bForeground->isChecked())xApplyParameter("foreground",Foreground->icon());
	else xApplyParameter("foreground","");

	stringa.setNum(resizeimage->value());
	if(bresizeimage->isChecked())xApplyParameter("resizeimage",stringa);
	else xApplyParameter("resizeimage","0");


	hide();
}

void WMConfigurationWindow::xSetupParameter(QString vname,QString vvalue)
{
	bool okRet=false;
	if(vname=="cmdRun")
	{
		cmdRun->setCurrentText(vvalue);
	}
	if(vname=="cmdOpen")
	{
		cmdOpen->setCurrentText(vvalue);
	}
	if(vname=="cmdOpen2")
	{
		cmdOpen2->setCurrentText(vvalue);
	}

	if(vname=="background")
	{
		Background->setIcon(vvalue);
		if(vvalue!="")
		{
			bBackground->setChecked(true);
		}
		else bBackground->setChecked(false);
	}
	if(vname=="foreground")
	{
		Foreground->setIcon(vvalue);
		if(vvalue!="")
		{
			bForeground->setChecked(true);
		}
		else bForeground->setChecked(false);
	}
	if(vname=="slideSeconds")
	{
		slideSeconds->setValue(vvalue.toInt(&okRet));
		if(!okRet)slideSeconds->setValue(60);
	}
	if(vname=="resizeimage")
	{
		resizeimage->setValue(vvalue.toInt(&okRet));
		if(!okRet)resizeimage->setValue(0);
		if(resizeimage->value()>0)
		{
			bresizeimage->setChecked(true);
		}
		else bresizeimage->setChecked(false);

	}
	if(vname=="SpawnEvery")
	{
		SpawnEvery->setValue(vvalue.toInt(&okRet));
		if(!okRet)SpawnEvery->setValue(600);
	}
}


#include "wmconfigurationwindow.moc"
