/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GAPAGER_H
#define XEPLUGIN_GAPAGER_H

#include <libkxdocker.h>
#include <qobject.h>
#include <qpixmap.h>
#include <qintdict.h>

#include <kwin.h>

class QString;
class KRootPixmap;
class KWinModule;
class QPixmap;


class GAPager : public gPluginSDK
{
  Q_OBJECT
public:
	GAPager(QObject *parent = 0, const char *name = 0);
	~GAPager();
    QObject * Respawn(QObject *);

public slots:
    virtual void xGetParameter(const QString, QString&);
    virtual void xSetupParameter(const QString, const QString);
    virtual void xGetParameterList(QStringList *);
    virtual void xPaint(int);
    virtual void polling();
    virtual void xApplyCfg();
    virtual void xStart();
    void xEventClick(void *,int,int,int,int);
    void xEnabledClick(int &);

public slots:
	void backgroundUpdated(const QPixmap &);
	void currentDesktopChanged(int);
	void slotActiveWindowChanged( WId win );
	void slotWindowAdded( WId );
	void slotWindowRemoved( WId );
	void slotWindowChanged( WId, unsigned int );
	void slotStackingOrderChanged();
	void slotRefresh();
    void xStop();
    void showDesktop();

private:
    QPixmap paintDesktop(int desk, int width, int height, bool curr=FALSE);
    KWin::WindowInfo* info( WId win );
    QIntDict<KWin::WindowInfo> windows;
    QColor bgcolor;
    int desktopPreview;
    WId active;

    protected:
	QImage		vd[2];
	QImage		paintBuffer;
	QPixmap		pixmapBackground;
	KRootPixmap	*KDesktopBackground;
	KWinModule	*KDEWM;
	int lastDesktop;
	int nRows;
	int nCols;
	int transparency;
	int iconSize;
protected:
    void xRefresh();
    void xUpdate();
};

#endif
