/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_DCOPINTERFACE_H
#define XEPLUGIN_DCOPINTERFACE_H


#include <dcopobject.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qimage.h>
class XEPlugin_DCOPBase;


class XEPlugin_DCOPInterface: public DCOPObject
{
K_DCOP
private:
	QStringList functionsList;
protected:
	static XEPlugin_DCOPBase *DockerInterface;
public:
		XEPlugin_DCOPInterface(XEPlugin_DCOPBase *);
		~XEPlugin_DCOPInterface();
k_dcop:
	QStringList list();
	bool exit();
	bool changebackground(const QString);
	void changeImage(int index,const QString newImage);
	void changeText(int index,const QString newText);
	int findIcon(const QString iconName);
	void addIcon(
		const QString newName,
		const QString newImg,
		const QString overText,
		const QString onClickExec,
		const QString className,
		const QString groupName,
		const QString fileName,
		const QString windowTitle,
		const QString taskName,
		const QString taskClass
	);
	void addAlias(const QString);
	void removeIcon(int index);
	void changeImageByName(const QString,const QString);
	void changeTextByName(const QString,const QString);
	//void changeLocal8TextByName(const QString ,const QString);
	//void changeUtf8TextByName(const QString ,const QString);
	void changeEncodedTextByName(const QString ,const QString, const QString);
	void changeEncodedMiniTextByName(const QString ,const QString, const QString);
	void bounceByName(const QString);
	void rollUpIcon(int);
	void rollDownIcon(int);
	void rollUpIconByName(const QString);
	void rollDownIconByName(const QString);
	void swapIcons(int,int);
	void removeByName(const QString);
	QStringList getPluginParameters(const QString);
	QStringList getPluginList();
	void addPlugin(const QString);
	void loadPlugin(const QString);
	void configurePlugin(const QString);
	void hide();
	void startPluginIconByName(const QString);
	void removePlugin(const QString);
	void setPluginParameter(const QString Name, const QString Parameter,const QString Value);
	void show();
	void startPlugin(const QString);
	void stopPlugin(const QString);
	void parse(const QString,const QString,int);
	void stopAnimateBackground();
	void startAnimateBackground();
	void stopBounceByName(const QString);
	void startBounceByName(const QString);
	int getRunningByName(const QString);
	void setRunningByName(const QString,int);
	void changeImage(int, QPixmap);
	void changeImageByName(const QString, QPixmap);
	void changeImage(int, QImage);
	void changeImageByName(const QString, QImage);
	void changeMiniTextByName(const QString,const QString);
	void changeTextPropertyByName(const QString,const QString, const QString);
	int getConfigurationInt(const QString);
	QString getConfigurationString(const QString);
	QStringList getConfigurationStringList(const QString);
	void setOverlayImageByName(const QString ,int ,int , const QString);
	void setConfigurationInt(const QString,int);
	void fadeByName(const QString,int);
};

#endif
