/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_dcopbase.h"
#include "xeplugin_dcopinterface.h"

#include <kstandarddirs.h>
#include <klocale.h>
#include <kpopupmenu.h>

#include <libkxdocker.h>
#include <kdebug.h>
#include <qtimer.h>


extern "C" QObject *xeplugin_register(QObject *parent)
{
	const char NOME[]="DCOP";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XEPlugin_DCOPBase(parent,NOME));
}




XEPlugin_DCOPBase::XEPlugin_DCOPBase(QObject *parent, const char *name)
 : QObject(parent, name)
{
	Configurator=NULL;
	DCOPInterface=NULL;
	xGDocker=NULL;
	XEObject::xPluginAdd(this);
}



void XEPlugin_DCOPBase::xSetup()
{
#ifndef ENABLE_FINAL
	kdWarning() << "XEPlugin_DCOPBase::xSetup\n";
#endif
	Configurator=(XEConfiguration*)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
#ifndef ENABLE_FINAL
	// Emits Signal of warning
	//xWarningMsg(this,"error while searching for plugin");
	kdWarning() << "error while searching for plugin\n";
#endif
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();


	// emit xParseTo(const QString &,const QString &, int, void *);
	QObject *xRoot=XEObject::xGetRoot();
	if(xRoot)
	{
		connect(this,SIGNAL(xParseTo( const QString&, const QString&, int, void* )),xRoot,SLOT(xParseTo( const QString&, const QString&, int, void* )));
	}

}

XEPlugin_DCOPBase::~XEPlugin_DCOPBase()
{
	xStop();
	XEObject::xPluginDel(this);
}


#include "xeplugin_dcopbase.moc"
void XEPlugin_DCOPBase::changeBackground(const QString newPath)
{
    xGDocker->xChangeBackground(::locate("data",newPath));
}


void XEPlugin_DCOPBase::removeRollingIcon(uint Index)
{
    ActiveConfiguration->RollingIcons.remove(Index);
}

void XEPlugin_DCOPBase::changeTextByName(const QString iconName,const QString newText)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==iconName)
		{
			ActiveConfiguration->RollingIcons.at(i)->OverText=newText;
			int idx=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(i)
				);
			if(idx>=0)Configurator->xEventInReloadIcon(idx);
			
			return;
		}
	}

}
void XEPlugin_DCOPBase::bounceByName(const QString iname)
{
	//qWarning("void XEPlugin_DCOPBase::bounceByName(const QString iname)");
	//XEPlugin_Animator *xAnimator=(XEPlugin_Animator *)XEObject::xFindObject("xAnimator");
	//if(!xAnimator)return;
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			XGIcon *theIcon=xGDocker->xGetPointerObjectIcon(i);
			if(!theIcon)return;
			emit xParseTo("xAnimator","xAnimateBounce",i,theIcon);
			return;
		}
	}	
}


void XEPlugin_DCOPBase::rollUpIcon(uint i)
{
	int x,y;
	//if(i<0 || i>ActiveConfiguration->ObjectsIcons.count())return;
	if(i>ActiveConfiguration->ObjectsIcons.count())return;
	XGIcon *xGIcon=xGDocker->xGetPointerObjectIcon(i);
	if(xGIcon==NULL)return;
	x=xGIcon->xHotspot.x();
	y=xGIcon->xHotspot.y();
	//xGDocker->xEventMouseWheel(i,x,y,2);
	//if(e->delta()>0)b=1;
	QWheelEvent e(QPoint(x,y),-1, 0);
	
	xGDocker->wheelEvent(&e);
}




void XEPlugin_DCOPBase::rollDownIcon(uint i)
{
	int x,y;
	if(i>ActiveConfiguration->ObjectsIcons.count())return;
	XGIcon *xGIcon=xGDocker->xGetPointerObjectIcon(i);
	if(xGIcon==NULL)return;
	x=xGIcon->xHotspot.x();
	y=xGIcon->xHotspot.y();
	//xGDocker->xEventMouseWheel(i,x,y,2);
	//if(e->delta()>0)b=1;
	QWheelEvent e(QPoint(x,y),+1, 0);
	
	xGDocker->wheelEvent(&e);
}


void XEPlugin_DCOPBase::xGetInfo(QStringList &)
{
    /// @todo implement me
}



QStringList XEPlugin_DCOPBase::getPluginParameters(const QString a)
{
	bool ok=false;
	QStringList l;
	ok=connect(this, SIGNAL(xGetTargetParameterList(QStringList *)),
		XEObject::xFindObject(a),
		SLOT(xGetParameterList(QStringList *)));
		
	if(ok==false)return l;
	xGetTargetParameterList(&l);

	disconnect(this, SIGNAL(xGetTargetParameterList(QStringList *)),
		XEObject::xFindObject(a),
		SLOT(xGetParameterList(QStringList *)));
	/*
	connect(this, SIGNAL(xGetTargetParameter(const QString,QString&)),
		XEObject::xFindObject(a),
		SLOT(xGetParameter(const QString,QString&)));
		
	for(int i=0;i<l.count();i++)
	{
		
		item->setText(0,a[i]);
		
		QString b;
		xGetParameter(a[i],b);
		
		item->setText(1,b);
		
		
		list->insertItem(item);
	
	}
	disconnect(this, SIGNAL(xGetParameter(const QString,QString&)),
		XEObject::xFindObject(icon->Info.className),
		SLOT(xGetParameter(const QString,QString&)));
	*/
	return l;
}


void XEPlugin_DCOPBase::changeImage(int index,const  QString newImage)
{
	ActiveConfiguration->ObjectsIcons.at(index)->Images.imgFileName=newImage;
	Configurator->xEventInReloadIcon(index);
}


void XEPlugin_DCOPBase::queryExit()
{
	xGDocker->close();
}


void XEPlugin_DCOPBase::changeText(int index,const QString newText)
{
	ActiveConfiguration->ObjectsIcons.at(index)->OverText=newText;
	Configurator->xEventInReloadIcon(index);
}

void XEPlugin_DCOPBase::addIcon(
	const QString newName,
	const QString newImg,
	const QString overText,
	const QString onClickExec,
	const QString className,
	const QString groupName,
	const QString fileName,
	const QString windowTitle,
	const QString taskName,
	const QString taskClass
)
{
			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)kdWarning() <<name()<<"\n";
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//	XSGObjectIcon *addedCfg=new XSGObjectIcon;
//	addedCfg->Tasks.PopupMenu=new KPopupMenu();
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;
	
	addedCfg->Tasks.Proces.clear();
	addedCfg->Tasks.MiniTextShow=1;
	addedCfg->Info.className=className;
	addedCfg->Info.fileName=fileName;
	addedCfg->Info.Name=newName;
	addedCfg->Info.Group=groupName;
	addedCfg->Actions.onClickExec=onClickExec;
	addedCfg->Actions.onDropExec=onClickExec;
	addedCfg->Actions.onDropExec+=" %1";
	addedCfg->OverText=overText;
	addedCfg->Images.imgFileName=newImg;
	
	addedCfg->Tasks.WindowTitle.append(windowTitle);
	addedCfg->Tasks.TaskName.append(taskName);
	addedCfg->Tasks.ClassName.append(taskClass);
	
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Actions.iAnimationMask=0;
	addedCfg->Tasks.TaskInfo=NULL;
	addedCfg->TimeToLive=0;

	
	// check for existent icons
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		// we add only on rolling icons
		if(addedCfg->Info.Name==ActiveConfiguration->RollingIcons.at(i)->Info.Name)
		{
			// we only update the image:
			changeImageByName(addedCfg->Info.Name,addedCfg->Images.imgFileName);
			delete addedCfg;
			return;
		}
	}
	
	ActiveConfiguration->RollingIcons.append(addedCfg);
	
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		// we add only on rolling icons
		if(addedCfg->Info.Group==ActiveConfiguration->ObjectsIcons.at(i)->Info.Group)return;
	}
	
	ActiveConfiguration->ObjectsIcons.append(addedCfg);
	xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
}
void XEPlugin_DCOPBase::rollUpIconByName(const QString ImageName)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
	if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==ImageName)
		{
			// ok than now we have to find the group displayed:
			QString grp=ActiveConfiguration->RollingIcons.at(i)->Info.Group;
		for(uint k=0;k<ActiveConfiguration->ObjectsIcons.count();k++)
		{
		if(ActiveConfiguration->ObjectsIcons.at(k)->Info.Group==grp)
		{
			// got the right icon:
			rollUpIcon(k);
		}
			
		}
		}
	}
}


/*!
    \fn XEPlugin_DCOPBase::rollDownIconByName(QString)
 */
void XEPlugin_DCOPBase::rollDownIconByName(const QString ImageName)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
	if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==ImageName)
		{
			// ok than now we have to find the group displayed:
			QString grp=ActiveConfiguration->RollingIcons.at(i)->Info.Group;
	for(uint k=0;k<ActiveConfiguration->ObjectsIcons.count();k++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(k)->Info.Group==grp)
		{
			// got the right icon:
			rollDownIcon(k);
		}
			
		}
		}
	}
}

void XEPlugin_DCOPBase::fadeByName(const QString name,int x)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==name)
		{
				XGIcon *OpenedIcon=xGDocker->xGetPointerObjectIcon(i);
				if(OpenedIcon){
					OpenedIcon->xFadeTo((double)x/(double)100);
					xGDocker->polling->start(100);
				}
			return;
		}
	}
}


void XEPlugin_DCOPBase::hide()
{
	xGDocker->hide();
}

void XEPlugin_DCOPBase::show()
{
	xGDocker->show();
}


void XEPlugin_DCOPBase::addAlias(const QString newMount)
{
	for(uint i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(i)->SystemName==newMount)
		{
			// searching if it's being showed
			for(uint iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
			{
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)==NULL)qWarning("void XEPlugin_GMounts::MountAdded(const QString &newMount) [125] Cazzo e' null");
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==newMount)return;
			}
			// copy the informations
	// if there are too icons, we can exit because no more will be added
	if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;


			// 0.35
	XEConfiguration *xEConfiguration=(XEConfiguration *)XEObject::xGetConfiguration();
	if(xEConfiguration==NULL)kdWarning() <<name()<<"\n";
	XSGObjectIcon *addedCfg=xEConfiguration->iconAdd();

//			XSGObjectIcon *addedCfg=new XSGObjectIcon;
//			addedCfg->Tasks.PopupMenu=new KPopupMenu();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			ActiveConfiguration->ObjectsIcons.append(addedCfg);
			ActiveConfiguration->RollingIcons.append(addedCfg);
			

			addedCfg->OverText=ActiveConfiguration->Plugins.Matches.at(i)->Icon->OverText;
			addedCfg->Info.fileName=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Name=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Group=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.className=name();
			
			addedCfg->Tasks.Proces.clear();
			addedCfg->Tasks.MiniTextShow=2;
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskInfo;
			addedCfg->Tasks.TaskName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskName;
			addedCfg->Tasks.WindowTitle=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle;
			addedCfg->Images=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images;
			addedCfg->Actions=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions;
//			ActiveConfiguration->ObjectsIcons.count()++;
			xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
		}
	}
}


void XEPlugin_DCOPBase::removeByName(const QString iname)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			removeIcon(i);
			//return;
		}
	}	
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==iname)
		{
			removeRollingIcon(i);
			//return;
		}
	}
}



void XEPlugin_DCOPBase::removeIcon(int index)
{
	Configurator->xEventInRemovingIcon(index,0);
}


void XEPlugin_DCOPBase::xGetParameter(const QString,QString&)
{
    /// @todo implement me
}


void XEPlugin_DCOPBase::changeImageByName(const QString ImageName,const QString newImage)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==ImageName)
		{
			ActiveConfiguration->RollingIcons.at(i)->Images.imgFileName=newImage;
			int idx=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(i)
				);
			if(idx>=0)Configurator->xEventInReloadIcon(idx);
			
			return;
		}
	}
	
}



int XEPlugin_DCOPBase::findIcon(const QString iconName)
{
	for(uint i =0; i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name
		==iconName)return i;
	}
	
	for(uint i =0; i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name
		==iconName)return -2;
	}
	
	return -1;
}
QStringList XEPlugin_DCOPBase::getPluginList()
{
/*
	QStringList a;
	for(int i=ActiveConfiguration->Plugins.Plugin.count()-1; i>=0;i--)
	{
		XSGObjectPlugin	*theplugin=ActiveConfiguration->Plugins.Plugin.at(i);
	
		a.append(theplugin->Info.Name);
	}
	return a;
*/
	return XEObject::xGetPluginListNames();
}




void XEPlugin_DCOPBase::addPlugin(const QString a)
{
		Configurator->pluginAdd(a);
}


void XEPlugin_DCOPBase::configurePlugin(const QString)
{
    /// @todo implement me
}




void XEPlugin_DCOPBase::startPluginIconByName(const QString)
{
    /// @todo implement me
}


void XEPlugin_DCOPBase::removePlugin(const QString a)
{
		Configurator->pluginRemove(a);
}


void XEPlugin_DCOPBase::setPluginParameter(const QString a, const QString b, const QString c)
{
	bool ok=false;
		// ok we are going on the same route
	ok=connect(this, SIGNAL(xTargetSetupParameter(const QString,const QString)),
		XEObject::xFindObject(a),
		SLOT(xSetupParameter(const QString,const QString)));
	if(ok)
	{
		xTargetSetupParameter(b,c);
	disconnect(this, SIGNAL(xTargetSetupParameter(const QString,const QString)),
		XEObject::xFindObject(a),
		SLOT(xSetupParameter(const QString,const QString)));
	}
}




void XEPlugin_DCOPBase::startPlugin(const QString)
{
    /// @todo implement me
}


void XEPlugin_DCOPBase::stopPlugin(const QString)
{
    /// @todo implement me
}


void XEPlugin_DCOPBase::xStopAnimateBackground()
{
	emit xParseTo("xDocker","xStopAnimateBackground",0,this);
}
void XEPlugin_DCOPBase::xStart()
{
	if(DCOPInterface==NULL)DCOPInterface=new XEPlugin_DCOPInterface(this);
}

void XEPlugin_DCOPBase::xStop()
{
	if(DCOPInterface!=NULL)
	{
		delete DCOPInterface;
		DCOPInterface=NULL;
	}
}


void XEPlugin_DCOPBase::xStartAnimateBackground()
{
	emit xParseTo("xDocker","xStartAnimateBackground",0,this);
}


void XEPlugin_DCOPBase::stopBounceByName(const QString iname)
{
//	XEPlugin_Animator *xAnimator=(XEPlugin_Animator *)XEObject::xFindObject("xAnimator");
//	if(!xAnimator)return;
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			XGIcon *theIcon=xGDocker->xGetPointerObjectIcon(i);
			if(!theIcon)return;
			//xAnimator->xStopAnimate();
			emit xParseTo("xAnimator","xStopAnimate",i,theIcon);

			return;
		}
	}
}


void XEPlugin_DCOPBase::startBounceByName(const QString iname)
{
	//XEPlugin_Animator *xAnimator=(XEPlugin_Animator *)XEObject::xFindObject("xAnimator");
	//if(!xAnimator)return;
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			XGIcon *theIcon=xGDocker->xGetPointerObjectIcon(i);
			if(!theIcon)return;
			//xAnimator->xStartAnimate(theIcon);
			emit xParseTo("xAnimator","xStartAnimate",i,theIcon);

			return;
		}
	}
}
int XEPlugin_DCOPBase::getRunningByName(const QString iname)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			return ActiveConfiguration->ObjectsIcons.at(i)->Tasks.forceRunning;
		}
	}
	return -1;
}


void XEPlugin_DCOPBase::setRunningByName(const QString iname,int isRunning)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==iname)
		{
			ActiveConfiguration->ObjectsIcons.at(i)->Tasks.forceRunning=isRunning;
			xGDocker->xUpdateRepaint(i);
			return;
		}
	}
}

void XEPlugin_DCOPBase::changeImage(int index, QPixmap newImage)
{
	XGIcon *Icona=xGDocker->xGetPointerObjectIcon(index);
	if(Icona==NULL)return;
	Icona->xImgSource=newImage.convertToImage();
	Icona->xImgOriginal=Icona->xImgSource;
	Icona->cachePurge();
	Icona->xSetSmoothZoom();
	xGDocker->xUpdateRepaint(index);
}


/*!
    \fn XEPlugin_DCOPBase::changeImage(const QString, QPixmap)
 */
void XEPlugin_DCOPBase::changeImage(const QString ImageName, QPixmap newImage)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==ImageName)
		{
			changeImage(i,newImage);
			return;
		}
	}
}


void XEPlugin_DCOPBase::changeImage(int index, QImage newImage)
{
	XGIcon *Icona=xGDocker->xGetPointerObjectIcon(index);
	if(Icona==NULL)return;
	Icona->xImgSource=newImage;
	Icona->xImgOriginal=Icona->xImgSource;
	Icona->cachePurge();
	Icona->xSetSmoothZoom();
	//xGDocker->xDockerRedraw(Icona);
	xGDocker->xUpdateRepaint(index);
}


void XEPlugin_DCOPBase::changeImage(const QString ImageName, QImage newImage)
{
	for(uint i=0;i<ActiveConfiguration->ObjectsIcons.count();i++)
	{
		if(ActiveConfiguration->ObjectsIcons.at(i)->Info.Name==ImageName)
		{
			changeImage(i,newImage);
			return;
		}
	}
}

void XEPlugin_DCOPBase::changeMiniTextByName(const QString iconName,const QString newText)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==iconName)
		{
			ActiveConfiguration->RollingIcons.at(i)->Tasks.MiniText=newText;
			int idx=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(i)
				);
			if(idx>=0)
			{
				XGIcon *OpenedIcon=xGDocker->xGetPointerObjectIcon(idx);
				if(OpenedIcon){
					OpenedIcon->xSetMiniText(ActiveConfiguration->ObjectsIcons.at(idx)->Tasks.MiniText);
					xGDocker->xUpdateRepaint(idx);
				}
			}
			//Configurator->xEventInReloadIcon(idx);
			
			return;
		}
	}
}
void XEPlugin_DCOPBase::changeTextPropertyByName(const QString iconName,const QString property,const QString value)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==iconName)
		{
			if(property=="backgroundpath")
			{
			ActiveConfiguration->RollingIcons.at(i)->Tasks.MiniTextProperty.BackgroundPath=value;
			int idx=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(i)
				);
			if(idx>=0)
			{
				XGIcon *OpenedIcon=xGDocker->xGetPointerObjectIcon(idx);
				if(OpenedIcon){
					OpenedIcon->xIconTextMini.xSetBackgroundPath(ActiveConfiguration->ObjectsIcons.at(idx)->Tasks.MiniTextProperty.BackgroundPath);
					OpenedIcon->xSetMiniText(ActiveConfiguration->ObjectsIcons.at(idx)->Tasks.MiniText);

					xGDocker->xUpdateRepaint(idx);
				}
			}
			//Configurator->xEventInReloadIcon(idx);
			}
			return;
		}
	}


/*
	// new style
	XEConfiguration *Configurator=(XEConfiguration*)XEObject::xGetConfiguration();
	if(Configurator==NULL)return;

	QString vpath=QString("rollingicons/%1/%1").arg(iconName).arg(property);
	QString svalue=value;
	if(property=="backgroundpath")
	{
		Configurator->xSetConfigurationValue(vpath,svalue);
	}
*/
}

int XEPlugin_DCOPBase::getConfigurationInt(const QString a)
{
		int i=0;
		Configurator->xGetConfigurationValue(a,i);
		return i;
}
void XEPlugin_DCOPInterface::setConfigurationInt(const QString a,int i)
{
	return DockerInterface->setConfigurationInt(a,i);
}
QString XEPlugin_DCOPBase::getConfigurationString(const QString a)
{
		QString i="";
		Configurator->xGetConfigurationValue(a,i);
		return i;
}
QStringList XEPlugin_DCOPBase::getConfigurationStringList(const QString a)
{
		QStringList i;
		Configurator->xGetConfigurationValue(a,i);
		return i;
}
void XEPlugin_DCOPBase::setOverlayImageByName(const QString name,int x,int y, const QString file)
{
	for(uint i=0;i<ActiveConfiguration->RollingIcons.count();i++)
	{
		if(ActiveConfiguration->RollingIcons.at(i)->Info.Name==name)
		{
			// store overlay fname
			ActiveConfiguration->RollingIcons.at(i)->Images.imgFileOverlay=file;
			int idx=ActiveConfiguration->ObjectsIcons.find(
				ActiveConfiguration->RollingIcons.at(i)
				);

			if(idx>=0)
			{
				XGIcon *OpenedIcon=xGDocker->xGetPointerObjectIcon(idx);
				if(OpenedIcon){
					QString filename=file;
					Configurator->xFindResource("icon",filename);
					OpenedIcon->xSetOverlayImage(x,y,filename);
					xGDocker->xUpdateRepaint(idx);
					xGDocker->polling->start(100);

				}
			}
			return;
		}
	}
}


void XEPlugin_DCOPBase::setConfigurationInt(const QString a,int i)
{
		Configurator->xSetConfigurationValue(a,i);
}


/*!
    \fn XEPlugin_DCOPBase::loadPlugin(const QString)
 */
void XEPlugin_DCOPBase::loadPlugin(const QString a)
{
	Configurator->xParse(QString("xLoadModule(%1)").arg(a),0,NULL);
}


/*!
    \fn XEPlugin_DCOPBase::parse(const QString,const QString, int)
 */
void XEPlugin_DCOPBase::parse(const QString p,const QString a, int i)
{
	emit xParseTo(p,a,i,NULL);
}


/*!
    \fn XEPlugin_DCOPBase::swapIcons(int a,int b)
 */
void XEPlugin_DCOPBase::swapIcons(int a,int b)
{
	Configurator->xSwapIcons(a,b);
	xGDocker->xSwapIcons(a,b);
	xGDocker->xUpdateRepaint(a);
	xGDocker->xUpdateRepaint(b);

}
