/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_configurator.h"
#include <libkxdocker.h>
#include <xeplugin_cfgicon.h>

#include <kled.h>
#include <kdebug.h>
#include <krun.h>
#include <qtabwidget.h>
#include <qvbox.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qsizepolicy.h>
#include <qlayout.h>
#include <qvgroupbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qvbuttongroup.h>
#include <qslider.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qgrid.h> 
#include <qlistview.h>
#include <klistview.h>
#include <qstatusbar.h>
#include <qdatetime.h> 
#include <qtextedit.h>

#include <kmainwindow.h>
#include <kfontrequester.h>
#include <kcolorbutton.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <kicondialog.h>
#include <knuminput.h> 
#include <kmainwindow.h>
#include <ktoolbar.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <klistview.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <kcombobox.h>
#include <kiconloader.h>



extern "C" QObject *xeplugin_register(QObject *)
{
	const char NOME[]="xConfigurator";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XEPlugin_Configurator(NULL,NOME));
}


XEPlugin_Configurator::XEPlugin_Configurator(QWidget *parent, const char *name)
 : ConfiguratorPanelForm(parent, name)
{
	CfgIcon=NULL;
	Configurator=NULL;
	xGDocker=NULL;
	XEObject::xPluginAdd(this);
	UpdatingFields=1;
	aliasCasella=NULL;
	pluginsCasella=NULL;
	iconsCasella=NULL;
	pAliasMenu=NULL;
	pIconsMenu=NULL;
	pPluginsMenu=NULL;
	pThemeMenu=NULL;
	themeCasella=NULL;
	pPlugin=NULL;
	cfg_setbases();
}


XEPlugin_Configurator::~XEPlugin_Configurator()
{
	XEObject::xPluginDel(this);
}


#include "xeplugin_configurator.moc"

void XEPlugin_Configurator::cfg_setbases()
{

	cfg_raiseicons->setMaxValue(QApplication::desktop()->height());
	cfg_sliding->setMaxValue(QApplication::desktop()->width());
	cfg_raiseicons->setMinValue(-QApplication::desktop()->height());
	cfg_sliding->setMinValue(0);

	
	cfg_sleft->setMaxValue(QApplication::desktop()->width());
	cfg_stop->setMaxValue(QApplication::desktop()->height());
	cfg_left->setMaxValue(QApplication::desktop()->width());
	cfg_top->setMaxValue(QApplication::desktop()->height());
	cfg_sleft->setMinValue(-QApplication::desktop()->width());
	cfg_stop->setMinValue(-QApplication::desktop()->height());
	cfg_left->setMinValue(-QApplication::desktop()->width());
	cfg_top->setMinValue(-QApplication::desktop()->height());
	
	
	
	cfg_sleep->setMaxValue(50000);
	cfg_smooth->setMaxValue(500);
	cfg_threads->setMaxValue(10000);
	cfg_animations->setMaxValue(1000);

	pluginPars->setRenameable(0,true);
	pluginPars->setRenameable(1,true);

}


void XEPlugin_Configurator::cfg_default()
{
	cfg_fill_paths(cfg_path1,"kxdocker/themes/bar/");
	cfg_fill_paths(cfg_path2,"kxdocker/themes/arrows/");
	cfg_fill_paths(cfg_path3,"kxdocker/themes/pillow/");
	cfg_fill_paths(cfg_path4,"kxdocker/themes/pillow/");
	cfg_fill_paths(cfg_path5,"kxdocker/themes/poof/");
	themes->clear();
	cfg_max->setMaxValue(MAX_ICONS);
	cfg_design->clear();
	cfg_design->insertItem("panther");
	cfg_design->setCurrentText("panther");

	aliasCasella=NULL;


	if(Configurator)
	{
		QPixmap p_s0;
		QString s_imgNameBase="kxdocker/plugins/configurator/sponsors/";
		QString s_imgName;
		s_imgName=s_imgNameBase + "sponsor00.png";
		//Configurator->xFindResource("icon", s_imgName);
		s_imgName=::locate("data",s_imgName);
		if(s_imgName!="")
		{
			p_s0.load(s_imgName);
			s0->setPixmap(p_s0);
		}
		s_imgName=s_imgNameBase + "sponsor01.png";
		s_imgName=::locate("data",s_imgName);
		if(s_imgName!="")
		{
			p_s0.load(s_imgName);
			s1->setPixmap(p_s0);
		}
	}

}


void XEPlugin_Configurator::cfg_reload()
{
	UpdatingFields=1;
	cfg_default();
/*****************************************************/
	themes->clear();
	themes->insertStringList(ActiveConfiguration->Theme.IconsPaths);
	
	KIconLoader KDEIconLoader;
	cfg_update_plugins();
	/*
	pluginsPaths->clear();
	pluginsPaths->insertStringList(ActiveConfiguration->Plugins.PluginsPaths);
	*/
	cfg_update_aliases();
	cfg_update_icons();
/*
	//; !!!!
	//ActiveConfiguration->Matrix.Design;
	
	//ActiveConfiguration->Plugins.Matches !!!!
	
	//ActiveConfiguration->Theme.ArrowsPath;

*/
	cfg_design->setCurrentText(ActiveConfiguration->Matrix.Design);
	//ActiveConfiguration->Window.Align
	cfg_size->setValue(ActiveConfiguration->Icons.SizePrefer);
	cfg_sizebig->setValue(ActiveConfiguration->Icons.SizeBig);
	cfg_ssize->setValue(ActiveConfiguration->Icons.SizePrefer);
	cfg_ssizebig->setValue(ActiveConfiguration->Icons.SizeBig);
	// background
	cfg_path1->setCurrentText(ActiveConfiguration->Theme.BackgroundPath);
	cfg_path2->setCurrentText(ActiveConfiguration->Theme.ArrowsPath);
	cfg_path3->setCurrentText(ActiveConfiguration->Icons.OverTextFont.BackgroundPath);
	cfg_path4->setCurrentText(ActiveConfiguration->Icons.MiniTextFont.BackgroundPath);
	cfg_path5->setCurrentText(ActiveConfiguration->Theme.PoofPath);
	
	if(ActiveConfiguration->Theme.Background.Tiled)cfg_tile->setChecked(true);
	else cfg_tile->setChecked(false);
	if(ActiveConfiguration->Icons.EnableThumbnail)cfg_thumbnails->setChecked(true);
	else cfg_thumbnails->setChecked(false);
	
	cfg_desktop->setValue(ActiveConfiguration->Window.HeightDesktop);
	cfg_desktop->setMaxValue(ActiveConfiguration->Icons.SizePrefer+16);
	
	//if(ActiveConfiguration->AutoSave)AutoSave->setChecked(true);

	if(ActiveConfiguration->AutoResize)cfg_autofit->setChecked(true);
	else cfg_autofit->setChecked(false);
	if(ActiveConfiguration->Window.FastHide)cfg_fasthiding->setChecked(true);
	else cfg_fasthiding->setChecked(false);
	//HeightDesktop->setEnabled(false);
	cfg_top->setValue(ActiveConfiguration->Window.TopForce);
	cfg_left->setValue(ActiveConfiguration->Window.LeftForce);
	
	
	cfg_hide->setValue(ActiveConfiguration->Window.HideTimeout);
	cfg_desaturate->setValue(ActiveConfiguration->Theme.Background.Desaturate);


	if(ActiveConfiguration->Window.HideMouseCornerRight)cfg_raiseright->setChecked(true);
	else cfg_raiseright->setChecked(false);
	if(ActiveConfiguration->Window.HideMouseCornerLeft)cfg_raiseleft->setChecked(true);
	else cfg_raiseleft->setChecked(false);

	if(ActiveConfiguration->Window.SendToBackground)cfg_autosendbackground->setChecked(true);
	else cfg_autosendbackground->setChecked(false);
	if(ActiveConfiguration->Window.RaiseOnEvents)cfg_autoraise->setChecked(true);
	else cfg_autoraise->setChecked(false);
	
	cfg_raise->setValue(ActiveConfiguration->Window.SendToForgroundTimeout);
	cfg_hide->setValue(ActiveConfiguration->Window.HideTimeout);
	
	cfg_space->setValue(ActiveConfiguration->Icons.Separation);
	cfg_raiseicons->setValue(ActiveConfiguration->Icons.Raise);
	cfg_sliding->setValue(ActiveConfiguration->Icons.Horiz);

	cfg_color1->setColor(QColor(
		ActiveConfiguration->Icons.OverTextFont.FontRed,
		ActiveConfiguration->Icons.OverTextFont.FontGreen,
		ActiveConfiguration->Icons.OverTextFont.FontBlue
			));
	cfg_color2->setColor(QColor(
		ActiveConfiguration->Icons.MiniTextFont.FontRed,
		ActiveConfiguration->Icons.MiniTextFont.FontGreen,
		ActiveConfiguration->Icons.MiniTextFont.FontBlue
			));

	QFont carattere;
	carattere.setFamily(ActiveConfiguration->Icons.OverTextFont.FontFamily);
	carattere.setPointSize(ActiveConfiguration->Icons.OverTextFont.FontSize);
	carattere.setBold(ActiveConfiguration->Icons.OverTextFont.Bold?true:false);
	carattere.setItalic(ActiveConfiguration->Icons.OverTextFont.Italic?true:false);
	carattere.setWeight(ActiveConfiguration->Icons.OverTextFont.Weight);
	
	cfg_font1->setFont(carattere);

	carattere.setFamily(ActiveConfiguration->Icons.MiniTextFont.FontFamily);
	carattere.setPointSize(ActiveConfiguration->Icons.MiniTextFont.FontSize);
	carattere.setBold(ActiveConfiguration->Icons.MiniTextFont.Bold?true:false);
	carattere.setItalic(ActiveConfiguration->Icons.MiniTextFont.Italic?true:false);
	carattere.setWeight(ActiveConfiguration->Icons.MiniTextFont.Weight);
	
	cfg_font2->setFont(carattere);



	cfg_max->setValue(ActiveConfiguration->Engine.MaxIconsShowed);
	

//#ifdef ENABLE_SPECIALENGINE2
	cfg_interpolation->setValue(ActiveConfiguration->Engine.InterpolationValue);
//#endif

	cfg_sleep->setValue(ActiveConfiguration->Engine.SleepFPS);
	cfg_smooth->setValue(ActiveConfiguration->Engine.SmoothTimeout);
	cfg_threads->setValue(ActiveConfiguration->Engine.SleepThreads);
	cfg_animations->setValue(ActiveConfiguration->Engine.SleepAnimations);
	cfg_update_stats();
/******************************************************/
	UpdatingFields=0;
}
void XEPlugin_Configurator::xParse(const QString &action, int idx, void *Pointer)
{
	if(action=="xConfigure" ||action=="show")
	{
		xConfigure();
	}
	if(action=="configure")
	{
		if(CfgIcon)
		{
			// setup form
			if(Pointer!=NULL)
			{
				CfgIcon->xUpdateForm((XSGObjectIcon *)Pointer);
			}
			else
			{
				CfgIcon->xUpdateForm(idx);
			}
			CfgIcon->show();
		}
	}
	if(action=="hide" )
	{
		if(CfgIcon)
		{
			// setup form
			CfgIcon->hide();
		}
	}
}


/*!
    \fn XEPlugin_Configurator::xStop()
 */
void XEPlugin_Configurator::xStop()
{
	if(CfgIcon!=NULL)
	{
		CfgIcon->close();
		delete CfgIcon;
		CfgIcon=NULL;
	}
}


/*!
    \fn XEPlugin_Configurator::xSetup()
 */
void XEPlugin_Configurator::xSetup()
{
	Configurator=(XEConfiguration*)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();
	QObject *xRoot=XEObject::xGetRoot();
	if(xRoot)
	{
		connect(this,SIGNAL(xParseTo( const QString&, const QString&, int, void* )),xRoot,SLOT(xParseTo( const QString&, const QString&, int, void* )));
	}

}


/*!
    \fn XEPlugin_Configurator::xStart()
 */
void XEPlugin_Configurator::xStart()
{
	if(CfgIcon==NULL)
	{
		CfgIcon=new XEPlugin_CfgIcon();
	}
}


/*!
    \fn XEPlugin_Configurator::xConfigure()
 */
void XEPlugin_Configurator::xConfigure()
{
	cfg_reload();
	show();
}

void XEPlugin_Configurator::rev_clicked()
{
	const QObject *my_Sender=sender();
	if(my_Sender==NULL)return;
}

void XEPlugin_Configurator::open_konqueror(const QString&url)
{
	KRun::runCommand(QString("konqueror \"%1\"").arg(url));
}

void XEPlugin_Configurator::sfoglia_clicked()
{
	const QObject *my_Sender=sender();
	if(my_Sender==NULL)return;

	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,i18n("Browse Theme"));
	if(cfgPath==NULL)
	{
		return;
	}
	if(my_Sender==(QObject *)sfoglia1)cfg_path1->setCurrentText(cfgPath);
	else if(my_Sender==(QObject *)sfoglia2)cfg_path2->setCurrentText(cfgPath);
	else if(my_Sender==(QObject *)sfoglia3)cfg_path3->setCurrentText(cfgPath);
	else if(my_Sender==(QObject *)sfoglia4)cfg_path4->setCurrentText(cfgPath);
	else if(my_Sender==(QObject *)sfoglia5)cfg_path5->setCurrentText(cfgPath);
}

void XEPlugin_Configurator::cfg_path1_textChanged(const QString&a)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Theme.BackgroundPath=a;
	//xGDocker->xChangeBackground(ActiveConfiguration->Theme.BackgroundPath);
	xGDocker->xUpdateSense();
}

void XEPlugin_Configurator::cfg_path2_textChanged(const QString&a)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Theme.ArrowsPath=a;

}

void XEPlugin_Configurator::cfg_path3_textChanged(const QString&a)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.OverTextFont.BackgroundPath=a;
}

void XEPlugin_Configurator::cfg_path4_textChanged(const QString&a)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.MiniTextFont.BackgroundPath=a;
}

void XEPlugin_Configurator::cfg_path5_textChanged(const QString&a)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Theme.PoofPath=a;
}

void XEPlugin_Configurator::cfg_font1_fontSelected(const QFont&f)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.OverTextFont.FontFamily=f.family();
	ActiveConfiguration->Icons.OverTextFont.FontSize=f.pointSize();
	ActiveConfiguration->Icons.OverTextFont.Bold=f.bold();
	ActiveConfiguration->Icons.OverTextFont.Italic=f.italic();
	ActiveConfiguration->Icons.OverTextFont.Weight=f.weight();
}

void XEPlugin_Configurator::cfg_font2_fontSelected(const QFont&f)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.MiniTextFont.FontFamily=f.family();
	ActiveConfiguration->Icons.MiniTextFont.FontSize=f.pointSize();
	ActiveConfiguration->Icons.MiniTextFont.Bold=f.bold();
	ActiveConfiguration->Icons.MiniTextFont.Italic=f.italic();
	ActiveConfiguration->Icons.MiniTextFont.Weight=f.weight();
}

void XEPlugin_Configurator::kColorButton1_changed(const QColor&c)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.OverTextFont.FontBlue=c.blue();
	ActiveConfiguration->Icons.OverTextFont.FontGreen=c.green();
	ActiveConfiguration->Icons.OverTextFont.FontRed=c.red();
}

void XEPlugin_Configurator::kColorButton1_2_changed(const QColor&c)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.MiniTextFont.FontBlue=c.blue();
	ActiveConfiguration->Icons.MiniTextFont.FontGreen=c.green();
	ActiveConfiguration->Icons.MiniTextFont.FontRed=c.red();
}


void XEPlugin_Configurator::cfg_tile_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(b)ActiveConfiguration->Theme.Background.Tiled=1;
	else ActiveConfiguration->Theme.Background.Tiled=0;
	xGDocker->xUpdateSense();
}

void XEPlugin_Configurator::cfg_desaturate_valueChanged(int a)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Theme.Background.Desaturate=a;
}

void XEPlugin_Configurator::buttonHelp_clicked()
{
}



void XEPlugin_Configurator::cfg_fill_paths(KComboBox *combo,const QString &fpath)
{
	QString xmlsPath=::locate("data",fpath);
	if(xmlsPath.isNull()||xmlsPath=="")
	{
		return;
	}
	{
		QDir d(xmlsPath);
        	d.setFilter( QDir::Dirs | QDir::Hidden );
	        const QFileInfoList *list = d.entryInfoList();
        	QFileInfoListIterator it( *list );
        	QFileInfo *fi;
		combo->clear();
		while ( (fi = it.current()) != 0 ) {
				if(!fi->fileName().startsWith("."))combo->insertItem(QString("%1%1").arg(fpath).arg(fi->fileName()),-1);
	            ++it;
        	}
	}
}

void XEPlugin_Configurator::aliases_rightButtonClicked(QListViewItem*casellaNuova,const QPoint&,int)
{
	KIconLoader KDEIcons;
	if(pAliasMenu==NULL){
		pAliasMenu=new KPopupMenu();
	}
	pAliasMenu->clear();
	pAliasMenu->insertItem(KDEIcons.loadIcon("add",KIcon::Small),i18n("Add new alias resource mapping"),this,SLOT(popup_alias_casella_add()));
	if(casellaNuova!=NULL){
		pAliasMenu->insertItem(KDEIcons.loadIcon("kcontrol",KIcon::Small),i18n("Configure mapping"),this,SLOT(popup_alias_casella_configura()));
		pAliasMenu->insertItem(KDEIcons.loadIcon("remove",KIcon::Small),i18n("Remove this"),this,SLOT(popup_alias_casella_del()));
		pAliasMenu->insertItem(KDEIcons.loadIcon("trashcan_empty",KIcon::Small),i18n("Do not show again in the dock"),this,SLOT(popup_alias_casella_disable()));
	}

	aliasCasella=casellaNuova;

	pAliasMenu->exec(QCursor::pos());
}



/*!
    \fn XEPlugin_Configurator::popup_alias_casella_configura()
 */
void XEPlugin_Configurator::popup_alias_casella_configura()
{
	if(aliasCasella==NULL)return;
	for(int i=ActiveConfiguration->Plugins.Matches.count()-1; i>=0;i--)
	{
		XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
		if(newalias==NULL)break;
		XSGObjectIcon *icon=newalias->Icon;
		if(icon==NULL)break;
		if(newalias->SystemName==aliasCasella->text(0))
		{
			xParse( "configure",i,(void *)icon);
		}
	}
}


/*!
    \fn XEPlugin_Configurator::popup_alias_casella_del()
 */
void XEPlugin_Configurator::popup_alias_casella_del()
{
	if(aliasCasella==NULL)return;
	for(int i=ActiveConfiguration->Plugins.Matches.count()-1; i>=0;i--)
	{
		XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
		if(newalias==NULL)break;
		XSGObjectIcon *icon=newalias->Icon;
		if(icon==NULL)break;
		if(newalias->SystemName==aliasCasella->text(0))
		{
			newalias->Icon=NULL;
			ActiveConfiguration->Plugins.Matches.remove(i);
		}
	}
	//aliases->removeItem(aliasCasella);
	UpdatingFields=1;
	cfg_update_aliases();
	UpdatingFields=0;
}


/*!
    \fn XEPlugin_Configurator::popup_alias_casella_add()
 */
void XEPlugin_Configurator::popup_alias_casella_add()
{
	if(aliasCasella==NULL)return;
	XSGObjectIcon *addedCfg=Configurator->iconAdd();
	XSCfgMatchIcons *addedCfgMatch=new XSCfgMatchIcons;
	addedCfgMatch->Icon=addedCfg;
	addedCfgMatch->SystemName=i18n("Resource ID");
	ActiveConfiguration->Plugins.Matches.append(addedCfgMatch);
	UpdatingFields=1;
	cfg_update_aliases();
	UpdatingFields=0;
}


/*!
    \fn XEPlugin_Configurator::cfg_update_aliases()
 */
void XEPlugin_Configurator::cfg_update_aliases()
{
	aliases->clear();
	KIconLoader KDEIcons;

	for(int i=ActiveConfiguration->Plugins.Matches.count()-1; i>=0;i--)
	{
		XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
		if(newalias==NULL)break;
		XSGObjectIcon *icon=newalias->Icon;
		if(icon==NULL)break;
		QString imgfn=icon->Images.imgFileName;
		Configurator->xFindResource("icon",imgfn);
		if(imgfn=="")imgfn=icon->Images.imgFileName;
		QPixmap iconImg=
		KDEIcons.loadIcon(
				imgfn,
				KIcon::NoGroup,
				32
				);

		QListViewItem	*item=new QListViewItem(
			(QListView *)aliases);

		item->setText(0,newalias->SystemName);
		item->setText(1,icon->Info.className);
		item->setText(2,newalias->SystemName);
		item->setPixmap (0,iconImg);
		aliases->insertItem(item);
	}
}


/*!
    \fn XEPlugin_Configurator::cfg_update_plugins()
 */
void XEPlugin_Configurator::cfg_update_plugins()
{
	//cfg_plugin_name->setText("");
	//cfg_plugin_so->setText("");
	//pluginPars->clear();

	plugins->clear();
	KIconLoader KDEIcons;
	for(int i=ActiveConfiguration->Plugins.Plugin.count()-1; i>=0;i--)
	{
		XSGObjectPlugin	*theplugin=ActiveConfiguration->Plugins.Plugin.at(i);

		QString imgfn=theplugin->Info.Name;
		Configurator->xFindResource("icon",imgfn);
		if(imgfn=="")imgfn=theplugin->Info.Name;
		QPixmap iconImg=
		KDEIcons.loadIcon(
				imgfn,
				KIcon::NoGroup,
				32
				);
	
		QListViewItem	*item=new QListViewItem(
			(QListViewItem *)plugins);
		
		item->setText(0,theplugin->Info.Name);
		item->setPixmap(0,iconImg);
		plugins->insertItem(item);
	}
}


/*!
    \fn XEPlugin_Configurator::cfg_update_icons()
 */
void XEPlugin_Configurator::cfg_update_icons()
{
	icons->clear();
	KIconLoader KDEIcons;

	for(int i=0; i<(int)ActiveConfiguration->RollingIcons.count();i++)
	{
		XSGObjectIcon *icon=ActiveConfiguration->RollingIcons.at(i);
		if(icon==NULL)break;
		if(icon->Info.Name.startsWith("x"))continue;
		if(icon->TimeToLive!=0)continue;
		QString imgfn=icon->Images.imgFileName;
		Configurator->xFindResource("icon",imgfn);
		if(imgfn=="")imgfn=icon->Images.imgFileName;
		QPixmap iconImg=
		KDEIcons.loadIcon(
				imgfn,
				KIcon::NoGroup,
				32
				);
		QListViewItem	*item=new QListViewItem(
			(QListView *)icons);

		item->setText(0,icon->Info.Group);
		item->setText(1,icon->Info.Name);
		item->setPixmap (0,iconImg);
		icons->insertItem(item);
	}
}


void XEPlugin_Configurator::icons_itemRenamed(QListViewItem* casella)
{
	if(UpdatingFields>0)return;
	if(casella==NULL)return;
	for(int i=0; i<(int)ActiveConfiguration->RollingIcons.count();i++)
	{
		XSGObjectIcon *icon=ActiveConfiguration->RollingIcons.at(i);
		if(icon==NULL)break;
		if(icon->Info.Name==casella->text(1))
		{
			icon->Info.Group=casella->text(0);
			break;
		}
	}
}

void XEPlugin_Configurator::icons_rightButtonClicked(QListViewItem*casellaNuova,const QPoint&,int)
{
	KIconLoader KDEIcons;
	if(pIconsMenu==NULL){
		pIconsMenu=new KPopupMenu();
	}
	pIconsMenu->clear();

	pIconsMenu->insertItem(KDEIcons.loadIcon("add",KIcon::Small),i18n("Add new icon"),this,SLOT(popup_icon_casella_aggiungi()));


	if(casellaNuova!=NULL){
		pIconsMenu->insertItem(KDEIcons.loadIcon("kcontrol",KIcon::Small),i18n("Configure"),this,SLOT(popup_icon_casella_configura()));
		pIconsMenu->insertItem(KDEIcons.loadIcon("remove",KIcon::Small),i18n("Remove this"),this,SLOT(popup_icon_casella_del()));
		pIconsMenu->insertItem(KDEIcons.loadIcon("trashcan_empty",KIcon::Small),i18n("Do not show again in the dock"),this,SLOT(popup_icon_casella_disable()));
	}

	iconsCasella=casellaNuova;

	pIconsMenu->exec(QCursor::pos());
}

void XEPlugin_Configurator::plugins_rightButtonClicked(QListViewItem*casellaNuova,const QPoint&,int)
{
	KIconLoader KDEIcons;
	if(pPluginsMenu==NULL){
		pPluginsMenu=new KPopupMenu();
	}
	pPluginsMenu->clear();
	pPluginsMenu->insertItem(KDEIcons.loadIcon("add",KIcon::Small),i18n("Add new plugin"),this,SLOT(popup_plugin_casella_add()));
	if(casellaNuova!=NULL){
		// TODO: start and stop
		pPluginsMenu->insertItem(KDEIcons.loadIcon("remove",KIcon::Small),i18n("Remove this"),this,SLOT(popup_plugin_casella_del()));
	}

	pluginsCasella=casellaNuova;

	pPluginsMenu->exec(QCursor::pos());
}


/*!
    \fn XEPlugin_Configurator::popup_plugin_casella_del()
 */
void XEPlugin_Configurator::popup_plugin_casella_del()
{
	if(pPlugin!=NULL && ActiveConfiguration->Plugins.Plugin.find(pPlugin)>=0)
	{
		ActiveConfiguration->Plugins.Plugin.remove(pPlugin);
	}
	UpdatingFields=1;
	cfg_update_plugins();
	UpdatingFields=0;
}


/*!
    \fn XEPlugin_Configurator::popup_plugin_casella_add()
 */
void XEPlugin_Configurator::popup_plugin_casella_add()
{
	XSGObjectPlugin *newPlugin=new XSGObjectPlugin;
	pPlugin=newPlugin;
	ActiveConfiguration->Plugins.Plugin.append(pPlugin);
	UpdatingFields=1;
	cfg_update_plugins();
	UpdatingFields=0;
}


/*!
    \fn XEPlugin_Configurator::popup_icon_casella_del()
 */
void XEPlugin_Configurator::popup_icon_casella_del()
{
	if(iconsCasella==NULL)return;
	for(int i=0; i<(int)ActiveConfiguration->RollingIcons.count();i++)
	{
		XSGObjectIcon *icon=ActiveConfiguration->RollingIcons.at(i);
		if(icon==NULL)break;
		if(icon->Info.Name==iconsCasella->text(1))
		{
			int idx=ActiveConfiguration->ObjectsIcons.find(icon);
			if(idx>=0)
			{
				Configurator->xEventInRemovingIcon(idx,0);
			}
			ActiveConfiguration->RollingIcons.remove(i);
			break;
		}
	}
	UpdatingFields=1;
	cfg_update_icons();
	UpdatingFields=0;
}

void XEPlugin_Configurator::popup_plugin_path_add()
{
	KFileDialog fd(QString::null,QString::null,0,"PluginPath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,i18n("Browse path to add to search plugins"));
	
	if(cfgPath==NULL)
	{
		return;
	}
		QListViewItem	*item=new QListViewItem((QListView *)pluginsPath);
		item->setText(0,cfgPath);
		pluginsPath->insertItem(item);

}
void XEPlugin_Configurator::popup_plugin_path_del()
{
    /// @todo implement me
}

void XEPlugin_Configurator::kListView15_rightButtonClicked(QListViewItem*,const QPoint&,int)
{
}

void XEPlugin_Configurator::plugins_selectionChanged(QListViewItem*item)
{
	kdWarning()<<"void XEPlugin_Configurator::plugins_selectionChanged(QListViewItem*item)\n";
	if(UpdatingFields>0)return;
	//plugin_loaded->setColor(KLed::Off);
	plugin_loaded->off();
	UpdatingFields=1;
	int i=-1;
	for(int f=0;f<(int)ActiveConfiguration->Plugins.Plugin.count();f++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(f)->Info.Name==item->text(0))
		{
			i=f;
			break;
		}
	}
	if(i<0)return;
	//plugin_loaded->setColor(KLed::On);
	plugin_loaded->on();
	kdWarning()<<"void XEPlugin_Configurator::plugins_selectionChanged(QListViewItem*item) 2\n";
	XSGObjectPlugin *newplugin=ActiveConfiguration->Plugins.Plugin.at(i);
	pPlugin=newplugin;
	
	cfg_plugin_name->setText(newplugin->Info.Name);
	cfg_plugin_so->setText(newplugin->Info.fileName);
	
	connect(this, SIGNAL(xGetParameterList(QStringList *)),
		XEObject::xFindObject(newplugin->Info.Name),
		SLOT(xGetParameterList(QStringList *)));
	QStringList a;
	a.clear();
	pluginPars->clear();
	xGetParameterList(&a);
	disconnect(this, SIGNAL(xGetParameterList(QStringList *)),
		XEObject::xFindObject(newplugin->Info.Name),
		SLOT(xGetParameterList(QStringList *)));
	
	connect(this, SIGNAL(xGetParameter(const QString,QString&)),
		XEObject::xFindObject(newplugin->Info.Name),
		SLOT(xGetParameter(const QString,QString&)));
		
	for(int i=0;i<(int)a.count();i++)
	{
		QListViewItem	*item=new QListViewItem((QListView *)pluginPars);
		item->setText(0,a[i]);
		QString b;
		xGetParameter(a[i],b);
		item->setText(1,b);
		pluginPars->insertItem(item);
	
	}
	disconnect(this, SIGNAL(xGetParameter(const QString,QString&)),
		XEObject::xFindObject(newplugin->Info.Name),
		SLOT(xGetParameter(const QString,QString&)));

	UpdatingFields=0;
}
void XEPlugin_Configurator::aliases_itemRenamed(QListViewItem*casella)
{
	if(UpdatingFields>0)return;
	if(casella==NULL)return;
	if(casella->text(2)=="")return;

	for(int i=0;i<(int)ActiveConfiguration->Plugins.Matches.count();i++)
	{
		XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
		if(newalias==NULL)break;
		if(newalias->SystemName==casella->text(2))
		{
			newalias->SystemName=casella->text(0);
			casella->text(2)=casella->text(0);
			return;
		}
	}
	casella->text(0)=casella->text(2);
}

void XEPlugin_Configurator::themes_rightButtonClicked(QListBoxItem* casellaNuova,const QPoint&)
{
	KIconLoader KDEIcons;
	if(pThemeMenu==NULL){
		pThemeMenu=new KPopupMenu();
	}
	pThemeMenu->clear();
	pThemeMenu->insertItem(KDEIcons.loadIcon("add",KIcon::Small),i18n("Add new theme"),this,SLOT(popup_theme_casella_add()));
	if(casellaNuova!=NULL){
		pThemeMenu->insertItem(KDEIcons.loadIcon("apply",KIcon::Small),i18n("Set as default"),this,SLOT(popup_theme_casella_default()));
		pThemeMenu->insertItem(KDEIcons.loadIcon("remove",KIcon::Small),i18n("Remove this"),this,SLOT(popup_theme_casella_del()));
	}

	themeCasella=casellaNuova;
	pThemeMenu->exec(QCursor::pos());
}



/*!
    \fn XEPlugin_Configurator::popup_theme_casella_default()
 */
void XEPlugin_Configurator::popup_theme_casella_default()
{
	if(themes->selectedItem())
	{
		QString a=themes->text(themes->currentItem ());
		themes->removeItem(themes->currentItem());
		themes->insertItem(a,0);
		themes->setSelected(0,true);
	}

	ActiveConfiguration->Theme.IconsPaths.clear();
	for(uint i=0;i<themes->count();i++)
	{
		ActiveConfiguration->Theme.IconsPaths.append(themes->text(i));
	}

}


/*!
    \fn XEPlugin_Configurator::popup_theme_casella_add()
 */
void XEPlugin_Configurator::popup_theme_casella_add()
{
	KFileDialog fd(QString::null,QString::null,0,"OpenThemePath",true);
	QString cfgPath=fd.getExistingDirectory(QString::null,0,i18n("Browse Theme"));
	if(cfgPath==NULL)
	{
		return;
	}
	themes->insertItem(cfgPath,0);
	themes->setSelected(0,true);


	ActiveConfiguration->Theme.IconsPaths.clear();
	for(uint i=0;i<themes->count();i++)
	{
		ActiveConfiguration->Theme.IconsPaths.append(themes->text(i));
	}
}


/*!
    \fn XEPlugin_Configurator::popup_theme_casella_del()
 */
void XEPlugin_Configurator::popup_theme_casella_del()
{
	if(themes->selectedItem ())themes->removeItem(themes->currentItem ());

	ActiveConfiguration->Theme.IconsPaths.clear();
	for(uint i=0;i<themes->count();i++)
	{
		ActiveConfiguration->Theme.IconsPaths.append(themes->text(i));
	}
}

void XEPlugin_Configurator::cfg_size_valueChanged(int i)
{
	cfg_ssize->setValue(i);
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.Size=i;
	ActiveConfiguration->Icons.SizePrefer=i;
	xGDocker->xUpdateSense();

}

void XEPlugin_Configurator::cfg_sizebig_valueChanged(int i)
{
	cfg_ssizebig->setValue(i);
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.SizeBig=i;
	xParseTo( "xGDocker","xRecalibrate",0,NULL);
	xGDocker->xUpdateSense();
}

void XEPlugin_Configurator::cfg_space_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Icons.Separation=i;
	xGDocker->xUpdateSense();
}

void XEPlugin_Configurator::cfg_design_textChanged(const QString&d)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Matrix.Design=d;
	xGDocker->xUpdateSense();
}

void XEPlugin_Configurator::cfg_autofit_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(b)ActiveConfiguration->AutoResize=1;
	else ActiveConfiguration->AutoResize=0;
}

void XEPlugin_Configurator::cfg_thumbnails_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(b)ActiveConfiguration->Icons.EnableThumbnail=1;
	else ActiveConfiguration->Icons.EnableThumbnail=0;
}

void XEPlugin_Configurator::cfg_max_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Engine.MaxIconsShowed=i;
}

void XEPlugin_Configurator::cfg_top_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Window.TopForce=i;
	xGDocker->xUpdateSense();
}

void XEPlugin_Configurator::cfg_left_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Window.LeftForce=i;
	xGDocker->xUpdateSense();
}

void XEPlugin_Configurator::cfg_autosendbackground_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(b)ActiveConfiguration->Window.SendToBackground=1;
	else ActiveConfiguration->Window.SendToBackground=0;
}

void XEPlugin_Configurator::cfg_autoraise_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(b)ActiveConfiguration->Window.RaiseOnEvents=1;
	else ActiveConfiguration->Window.RaiseOnEvents=0;
}

void XEPlugin_Configurator::cfg_fasthiding_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(b)ActiveConfiguration->Window.FastHide=1;
	else ActiveConfiguration->Window.FastHide=0;
}

void XEPlugin_Configurator::cfg_raiseleft_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(b)ActiveConfiguration->Window.HideMouseCornerLeft=1;
	else ActiveConfiguration->Window.HideMouseCornerLeft=0;
}

void XEPlugin_Configurator::cfg_raiseright_toggled(bool b)
{
	if(UpdatingFields>0)return;
	if(b)ActiveConfiguration->Window.HideMouseCornerRight=1;
	else ActiveConfiguration->Window.HideMouseCornerRight=0;
}

void XEPlugin_Configurator::cfg_hide_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Window.HideTimeout=i;
}

void XEPlugin_Configurator::cfg_raise_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Window.SendToForgroundTimeout=i;
}

void XEPlugin_Configurator::cfg_desktop_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Window.HeightDesktop=i;
}

void XEPlugin_Configurator::pluginPars_itemRenamed(QListViewItem*item)
{
	if(UpdatingFields>0)return;
	if(pPlugin!=NULL && ActiveConfiguration->Plugins.Plugin.find(pPlugin)>=0)
	{
		// ok we are going on the same route
	connect(this, SIGNAL(xSetupParameter(const QString,const QString)),
		XEObject::xFindObject(pPlugin->Info.Name),
		SLOT(xSetupParameter(const QString,const QString)));
		
		xSetupParameter(item->text(0),item->text(1));
	
	disconnect(this, SIGNAL(xSetupParameter(const QString,const QString)),
		XEObject::xFindObject(pPlugin->Info.Name),
		SLOT(xSetupParameter(const QString,const QString)));
	
	}
}

void XEPlugin_Configurator::cfg_plugin_name_textChanged(const QString&a)
{
	if(UpdatingFields>0)return;
	if(pPlugin!=NULL && ActiveConfiguration->Plugins.Plugin.find(pPlugin)>=0)
	{
		pPlugin->Info.Name=a;
	}
	UpdatingFields=1;
	cfg_update_plugins();
	UpdatingFields=0;

}

void XEPlugin_Configurator::cfg_plugin_so_textChanged(const QString&a)
{
	if(UpdatingFields>0)return;
	if(pPlugin!=NULL && ActiveConfiguration->Plugins.Plugin.find(pPlugin)>=0)
	{
		pPlugin->Info.fileName=a;
	}
}

void XEPlugin_Configurator::cfg_interpolation_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Engine.InterpolationValue=i;
}


/*!
    \fn XEPlugin_Configurator::cfg_update_stats()
 */
void XEPlugin_Configurator::cfg_update_stats()
{
	//0.36
	QDateTime tempo;
	tempo.setTime_t(ActiveConfiguration->Statistics.lastStart);
	int secConta=tempo.secsTo(QDateTime::currentDateTime());
	int minuti=secConta/60;
	int ore=minuti/60;
	int giorni=ore/24;
	secConta=secConta%60;
	minuti=minuti%60;
	ore=ore%24;

	stats_cfg->setText(QString("%1").arg(ActiveConfiguration->Statistics.startedConfigurator));
	stats_starts->setText(QString("%1").arg(ActiveConfiguration->Statistics.dockerStarts));
	stats_days->setText(QString("%1").arg(giorni));
	stats_minutes->setText(QString("%1").arg(minuti));
	stats_hours->setText(QString("%1").arg(ore));
	stats_secs->setText(QString("%1").arg(secConta));
	tempo.setTime_t(ActiveConfiguration->Statistics.dockerFirstStart);
	
	stats_first->setText(tempo.toString("ddd d MMMM yyyy"));

	stats_max->setText(QString("%1").arg(ActiveConfiguration->Statistics.maxIconsDisplayed));
	stats_bg->setText(QString("%1").arg(ActiveConfiguration->Statistics.changedBackgroundTheme));
	if(ActiveConfiguration->Statistics.avgCounter>0)
	{
	stats_avg->setText(QString("%1 (%1)").arg(
		ActiveConfiguration->Statistics.avgIconsDisplayed/
			ActiveConfiguration->Statistics.avgCounter
		).arg(
		ActiveConfiguration->Statistics.avgCounter
		));
	}
}

void XEPlugin_Configurator::cfg_sleep_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Engine.SleepFPS=i;
}

void XEPlugin_Configurator::cfg_smooth_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Engine.SmoothTimeout=i;
}

void XEPlugin_Configurator::cfg_threads_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Engine.SleepThreads=i;
}

void XEPlugin_Configurator::cfg_animations_valueChanged(int i)
{
	if(UpdatingFields>0)return;
	ActiveConfiguration->Engine.SleepAnimations=i;
}


/*!
    \fn XEPlugin_Configurator::popup_alias_casella_disable()
 */
void XEPlugin_Configurator::popup_alias_casella_disable()
{
	if(aliasCasella==NULL)return;
	for(int i=ActiveConfiguration->Plugins.Matches.count()-1; i>=0;i--)
	{
		XSCfgMatchIcons *newalias=ActiveConfiguration->Plugins.Matches.at(i);
		if(newalias==NULL)break;
		XSGObjectIcon *icon=newalias->Icon;
		if(icon==NULL)break;
		if(newalias->SystemName==aliasCasella->text(0))
		{
			icon->Info.className="disabled";
		}
	}
	UpdatingFields=1;
	cfg_update_aliases();
	UpdatingFields=0;
}


/*!
    \fn XEPlugin_Configurator::popup_icon_casella_configura()
 */
void XEPlugin_Configurator::popup_icon_casella_configura()
{
	if(iconsCasella==NULL)return;
	for(int i=0; i<(int)ActiveConfiguration->RollingIcons.count();i++)
	{
		XSGObjectIcon *icon=ActiveConfiguration->RollingIcons.at(i);
		if(icon==NULL)break;
		if(icon->Info.Name==iconsCasella->text(1))
		{
			xParse( "configure",i,(void *)icon);
			break;
		}
	}
}


/*!
    \fn XEPlugin_Configurator::popup_icon_casella_disable()
 */
void XEPlugin_Configurator::popup_icon_casella_disable()
{
	if(iconsCasella==NULL)return;
	for(int i=0; i<(int)ActiveConfiguration->RollingIcons.count();i++)
	{
		XSGObjectIcon *icon=ActiveConfiguration->RollingIcons.at(i);
		if(icon==NULL)break;
		if(icon->Info.Name==iconsCasella->text(1))
		{
			int idx=ActiveConfiguration->ObjectsIcons.find(icon);
			if(idx>=0)
			{
				Configurator->xEventInRemovingIcon(idx,0);
			}
			icon->Info.className="disabled";
			break;
		}
	}
}

void XEPlugin_Configurator::store_clicked()
{
	if(connect(this, SIGNAL(xStore()),XEObject::xGetXMLParser(),SLOT(xSave())))
	{
		emit xStore();
		disconnect(this, SIGNAL(xStore()));
	}
}



/*!
    \fn XEPlugin_Configurator::popup_icon_casella_aggiungi()
 */
void XEPlugin_Configurator::popup_icon_casella_aggiungi()
{
	//if(iconsCasella==NULL)return;
	XSGObjectIcon *addedCfg=Configurator->iconAdd();

	addedCfg->Tasks.Proces.clear();
	addedCfg->Info.className="GIcon";
	addedCfg->Info.fileName="";
	QDateTime a=QDateTime::currentDateTime();
	QString randomName=a.toString("mmss");
	
	QString b="AddedIcon_";
	b=b+randomName;
	b="Group_";
	b=b+randomName;
	b="AddedIcon_";
	b=b+randomName;
	
	addedCfg->Info.Name=b;
	addedCfg->Info.Group=b;
	addedCfg->Actions.onClickExec="";
	addedCfg->Actions.onDropExec="";
	addedCfg->OverText=b;
	addedCfg->Images.imgFileName="default";	
	addedCfg->Tasks.ShowThumbnail=0;
	addedCfg->Actions.iAnimationMask=0;
	addedCfg->Tasks.TaskInfo=NULL;
	addedCfg->TimeToLive=0;
	addedCfg->Tasks.dcopReady=0;
	addedCfg->Tasks.forceRunning=0;
	addedCfg->Tasks.PopupMenu=NULL;
	addedCfg->PluginPopupMenu=NULL;


	ActiveConfiguration->ObjectsIcons.append(addedCfg);
	ActiveConfiguration->RollingIcons.append(addedCfg);

	xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
	
	UpdatingFields=1;
	cfg_update_icons();
	UpdatingFields=0;
}
