/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_CONFIGURATOR_H
#define XEPLUGIN_CONFIGURATOR_H

#include <qwidget.h>
#include <configurator_panel.h>

class XEPlugin_CfgIcon;

/**
	@author Stefano Zingarini <stefano@xiaprojects.com>
*/
class XEPlugin_Configurator : public ConfiguratorPanelForm
{
Q_OBJECT
public:
    XEPlugin_Configurator(QWidget *parent = 0, const char *name = 0);
    ~XEPlugin_Configurator();
public slots:
    virtual void xParse(const QString &, int, void *);
    virtual void xStop();
    virtual void xSetup();
    virtual void xStart();
    virtual void xConfigure();
    virtual void buttonHelp_clicked();
    virtual void cfg_desaturate_valueChanged(int);
    virtual void cfg_tile_toggled(bool);
    virtual void kColorButton1_2_changed(const QColor&);
    virtual void kColorButton1_changed(const QColor&);
    virtual void cfg_font2_fontSelected(const QFont&);
    virtual void cfg_font1_fontSelected(const QFont&);
    virtual void cfg_path5_textChanged(const QString&);
    virtual void cfg_path4_textChanged(const QString&);
    virtual void cfg_path3_textChanged(const QString&);
    virtual void cfg_path2_textChanged(const QString&);
    virtual void cfg_path1_textChanged(const QString&);
    virtual void sfoglia_clicked();
    virtual void open_konqueror(const QString&);
    virtual void rev_clicked();
    virtual void aliases_rightButtonClicked(QListViewItem*,const QPoint&,int);
    void popup_alias_casella_configura();
    void popup_alias_casella_del();
    void popup_alias_casella_add();
    virtual void plugins_selectionChanged(QListViewItem*);
    virtual void kListView15_rightButtonClicked(QListViewItem*,const QPoint&,int);
    virtual void plugins_rightButtonClicked(QListViewItem*,const QPoint&,int);
    virtual void icons_rightButtonClicked(QListViewItem*,const QPoint&,int);
    virtual void icons_itemRenamed(QListViewItem*);
    void popup_plugin_casella_del();
    void popup_plugin_casella_add();
    void popup_icon_casella_del();
    void popup_plugin_path_add();
    void popup_plugin_path_del();
    virtual void aliases_itemRenamed(QListViewItem*);

    virtual void pluginPars_itemRenamed(QListViewItem*);
    virtual void cfg_desktop_valueChanged(int);
    virtual void cfg_raise_valueChanged(int);
    virtual void cfg_hide_valueChanged(int);
    virtual void cfg_raiseright_toggled(bool);
    virtual void cfg_raiseleft_toggled(bool);
    virtual void cfg_fasthiding_toggled(bool);
    virtual void cfg_autoraise_toggled(bool);
    virtual void cfg_autosendbackground_toggled(bool);
    virtual void cfg_left_valueChanged(int);
    virtual void cfg_top_valueChanged(int);
    virtual void cfg_max_valueChanged(int);
    virtual void cfg_thumbnails_toggled(bool);
    virtual void cfg_autofit_toggled(bool);
    virtual void cfg_design_textChanged(const QString&);
    virtual void cfg_space_valueChanged(int);
    virtual void cfg_sizebig_valueChanged(int);
    virtual void cfg_size_valueChanged(int);
    virtual void themes_rightButtonClicked(QListBoxItem*,const QPoint&);
    void popup_theme_casella_default();
    void popup_theme_casella_add();
    void popup_theme_casella_del();
    virtual void cfg_plugin_so_textChanged(const QString&);
    virtual void cfg_plugin_name_textChanged(const QString&);
    virtual void cfg_interpolation_valueChanged(int);
    virtual void cfg_animations_valueChanged(int);
    virtual void cfg_threads_valueChanged(int);
    virtual void cfg_smooth_valueChanged(int);
    virtual void cfg_sleep_valueChanged(int);
    void popup_alias_casella_disable();
    void popup_icon_casella_configura();
    void popup_icon_casella_disable();
    virtual void store_clicked();
protected:
	class XEPlugin_CfgIcon	*CfgIcon;
	class XEConfiguration* Configurator;
	class XGDocker *xGDocker;
	class XSConfigurations *ActiveConfiguration;
	int UpdatingFields;
	class QListViewItem* aliasCasella;
	class QListViewItem* iconsCasella;
	class QListViewItem* pluginsCasella;
	class KPopupMenu* pAliasMenu;
	class KPopupMenu* pIconsMenu;
	class KPopupMenu* pPluginsMenu;
	class KPopupMenu* pThemeMenu;
	class QListBoxItem* themeCasella;
	class XSGObjectPlugin *pPlugin;
    void cfg_reload();
    void cfg_default();
    void cfg_fill_paths(KComboBox *,const QString &);
    void cfg_setbases();
    void cfg_update_aliases();
    void cfg_update_plugins();
    void cfg_update_icons();
signals:
	void xParseTo( const QString&, const QString&, int, void* );
	void xGetParameterList(QStringList *);
	void xGetParameter(const QString,QString&);
	void xSetupParameter(const QString,const QString);
	void xStore();

protected:
    void cfg_update_stats();
};

#endif
