/***************************************************************************
 *   Copyright (C) 2006 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xeplugin_bluetooth.h"

#include <kdebug.h>
#include <btmanager.h>
#include <qtimer.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <klocale.h>


extern "C" QObject *xeplugin_register(QObject *parent)
{
	const char NOME[]="xBluetooth";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XEPlugin_Bluetooth(parent,NOME));
}

XEPlugin_Bluetooth::XEPlugin_Bluetooth(QObject *parent, const char *name)
 : QObject(parent, name)
{
	if(name!=NULL)XEObject::xPluginAdd(this);
	showControlIcon=0;
	btManager=new BTManager();
	connect(btManager,SIGNAL(dirty( const QStringList& )),this,SLOT(dirty( const QStringList& )));
	MutexData=0;
	ExternalEntryManager="";
	AutoAddMounts="yes";
	checkEvery=60;
	onClickExec="konqueror --caption \"browse %MOUNTPOINT%\" \"sdp://%MOUNTPOINT%\"";
	prefixCaption="browse ";
}


XEPlugin_Bluetooth::~XEPlugin_Bluetooth()
{
	XEObject::xPluginDel(this);
}


#include "xeplugin_bluetooth.moc"


/*!
    \fn XEPlugin_Bluetooth::xGetInfo(QStringList &)
 */
void XEPlugin_Bluetooth::xGetInfo(QStringList &a)
{
	QStringList PluginInformations;
	QString Version="1.0.0";
	PluginInformations.append("KXDocker Bluetooth");	// Project name
	PluginInformations.append(Version); // version
	PluginInformations.append("20060122"); // date
	PluginInformations.append("Stefano");	// Author
	PluginInformations.append("stefano@xiaprojects.com");	// Author mail
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download");	// url download
	PluginInformations.append("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=manual");	// url documentation
	PluginInformations.append(QString("http://www.xiaprojects.com/www/prodotti/kxdocker/main.php?action=download")); // url update
	
	a=PluginInformations;
}


/*!
    \fn XEPlugin_Bluetooth::xGetParameter(const QString, QString&)
 */
void XEPlugin_Bluetooth::xGetParameter(const QString sName, QString &sValue)
{
	if(sName=="showControlIcon")
	{
		sValue.setNum(showControlIcon);
	}
	if(sName=="checkEvery")
	{
		sValue.setNum(checkEvery);
	}

	if(sName=="AutoAddMounts")sValue=(AutoAddMounts);
	if(sName=="onClickExec")sValue=(onClickExec);
	if(sName=="prefixCaption")sValue=(prefixCaption);
	if(sName=="ExternalEntryManager")sValue=(ExternalEntryManager);

}


/*!
    \fn XEPlugin_Bluetooth::xGetParameterList(QStringList *)
 */
void XEPlugin_Bluetooth::xGetParameterList(QStringList *a)
{
	//a->append("showControlIcon");
	a->append("checkEvery");
	a->append("AutoAddMounts");
	a->append("onClickExec");
	a->append("prefixCaption");
	a->append("ExternalEntryManager");
}


/*!
    \fn XEPlugin_Bluetooth::xSetup()
 */
void XEPlugin_Bluetooth::xSetup()
{
	Configurator=(XEConfiguration *)XEObject::xGetConfiguration();
	xGDocker=(XGDocker *)XEObject::xGetDocker();
	if(Configurator==NULL || xGDocker==NULL)
	{
		return;
	}
	ActiveConfiguration=Configurator->xGetConfiguration();

	onClickExec="konqueror --caption \"browse %MOUNTPOINT%\" \"sdp://%MOUNTPOINT%\"";
	prefixCaption="browse ";


	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
		
			if(ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.count())
			{
xSetupParameter("showControlIcon",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("showControlIcon"));
xSetupParameter("AutoAddMounts",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("AutoAddMounts","yes"));
xSetupParameter("onClickExec",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("onClickExec","konqueror --caption \"browse %MOUNTPOINT%\" \"sdp://%MOUNTPOINT%\""));
xSetupParameter("prefixCaption",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("prefixCaption","browse "));
xSetupParameter("ExternalEntryManager",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("ExternalEntryManager","Bluetooth"));
xSetupParameter("checkEvery",ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().attribute("checkEvery","60"));
			}
			else
			{
				// Creating fake document
				QDomDocument 	doc( "KXDocker_Conf" );
				// the fake root
				QDomElement fakeRoot=doc.createElement("FakeRoot");
				// appending childs
				doc.appendChild(fakeRoot);
				// now creating the configuration
				QDomElement CreatingCfg=doc.createElement("pluginconf");
				// Ok this is a plugin Configuration
				QStringList	a;
				// Creating the Attributes via the standard plugin interface
				xGetParameterList(&a);
				for(uint istoringXML=0;istoringXML<a.count();istoringXML++)
				{
					QString returnValue;
					xGetParameter(a[istoringXML],returnValue);
					CreatingCfg.setAttribute(a[istoringXML],returnValue);
				}
				// Now appending to the configuration
				fakeRoot.appendChild(CreatingCfg);
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration=fakeRoot.childNodes();//fakeRoot.elementsByTagName("pluginconf");
			}
		break;
		}
	}
}


/*!
    \fn XEPlugin_Bluetooth::xSetupParameter(const QString, const QString)
 */
void XEPlugin_Bluetooth::xSetupParameter(const QString sName, const QString sValue)
{
	bool okRet=false;
	if(sName=="showControlIcon")
	{
		showControlIcon=sValue.toInt(&okRet);
		if(okRet==false)
		{
			showControlIcon=0;
		}
		updateXMLcfg(sName);
	}
	if(sName=="checkEvery")
	{
		checkEvery=sValue.toInt(&okRet);
		if(okRet==false)
		{
			checkEvery=60;
		}
		updateXMLcfg(sName);
		btManager->setCmd("hcitool scan","",checkEvery,1);
	}
	if(sName=="AutoAddMounts")
	{
		AutoAddMounts=sValue;
		updateXMLcfg(sName);
	}
	if(sName=="onClickExec")
	{
		onClickExec=sValue;
		updateXMLcfg(sName);
	}
	if(sName=="prefixCaption")
	{
		prefixCaption=sValue;
		updateXMLcfg(sName);
	}
	if(sName=="ExternalEntryManager")
	{
		ExternalEntryManager=sValue;
		updateXMLcfg(sName);
	}
}


/*!
    \fn XEPlugin_Bluetooth::xStart()
 */
void XEPlugin_Bluetooth::xStart()
{
	btManager->setCmd("hcitool scan","",checkEvery,1);
	btManager->start();
	// new engine with popupmenu on tray
	KPopupMenu *BtMenu;
	BtMenu=new KPopupMenu();
	KIconLoader KDEIcons;
	BtMenu->insertItem(KDEIcons.loadIcon("start",KIcon::Small),i18n("Discovery now"),this,SLOT(discoveryNow()));
	BtMenu->insertItem(KDEIcons.loadIcon("stop",KIcon::Small),i18n("Stop discovering"),this,SLOT(discoveryStop()));

	//XERoot::xParseTo("xTray","xAppendGenericMenu(",0,BtMenu);
	if(connect(this, SIGNAL(xParseTo(const QString &, int, void *)),XEObject::xFindObject("xTray"),SLOT(xParse(const QString &, int, void *))))
	{
		xParseTo(QString("xAppendGenericMenu(Bluetooth helper)"),0,(void*)BtMenu);
		disconnect(this, SIGNAL(xParseTo(const QString &, int, void *)),XEObject::xFindObject("xConfigurator"),SLOT(xParse(const QString &, int, void *)));
	}

	QTimer::singleShot( 20*1000, this, SLOT(polling()));
}


/*!
    \fn XEPlugin_Bluetooth::xStop()
 */
void XEPlugin_Bluetooth::xStop()
{
    /// @todo implement me
}


/*!
    \fn XEPlugin_Bluetooth::updateXMLcfg(const QString sName)
 */
void XEPlugin_Bluetooth::updateXMLcfg(const QString sName)
{
	for(uint i=0;i<ActiveConfiguration->Plugins.Plugin.count(); i++)
	{
		if(ActiveConfiguration->Plugins.Plugin.at(i)->Info.Name==name())
		{
			// update xml configuration
			if(sName=="showControlIcon")
			{
				ActiveConfiguration->Plugins.Plugin.at(i)->xmlConfiguration.item(0).toElement().setAttribute("showControlIcon",showControlIcon);
			}
			break;
		}
	}
}


/*!
    \fn XEPlugin_Bluetooth::dirty(const QStringList &)
 */
void XEPlugin_Bluetooth::dirty(const QStringList &a)
{
	MutexData=-1;
	deviceList=a;
	MutexData=1;
	//kdWarning()<<"Bluetooth new data ready";
}


/*!
    \fn XEPlugin_Bluetooth::polling()
 */
void XEPlugin_Bluetooth::polling()
{
	if(MutexData>0)
	{
		QStringList deviceLocal=deviceList;
		MutexData=-1;
		for(uint i=0;i<deviceLocal.count();i++)
		{
			kdWarning()<<QString("Bluetooth sensor discovered:[%1]\n").arg(deviceLocal[i]);
			Discovered( deviceLocal[i]);
		}
/****************************************/
		int indexfind;
		int checkSeparators=0;
		for(int iconIndex=(int)ActiveConfiguration->ObjectsIcons.count()-1;iconIndex>=0;iconIndex--)
		{
			if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className=="Bluetooth" ||
			(ExternalEntryManager!=""
				&& ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.className==ExternalEntryManager
				&& ActiveConfiguration->ObjectsIcons.at(iconIndex)->TimeToLive==-1))
			{
				indexfind=-1;
				for (unsigned int i=0;i<deviceLocal.count();i++)
				{
					if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==deviceLocal[i])
					{
						indexfind=i;
						break;
					}
				}
				if(indexfind<0)
				{
				// remove it
					Configurator->xEventInRemovingIcon(iconIndex,0);
					checkSeparators++;
				}
			}
		}
		if(checkSeparators)xGDocker->xCheckBackgroundSeparators();
/****************************************/





	}
	QTimer::singleShot( checkEvery *1000 /2, this, SLOT(polling()));
}


/*!
    \fn XEPlugin_Bluetooth::Discovered(const QString &)
 */
void XEPlugin_Bluetooth::Discovered(const QString &newMount)
{
	for(unsigned int i=0; i<ActiveConfiguration->Plugins.Matches.count();i++)
	{
		if(ActiveConfiguration->Plugins.Matches.at(i)->SystemName==newMount)
		{
			// searching if it's being showed
			for(unsigned int iconIndex=0;iconIndex<ActiveConfiguration->ObjectsIcons.count();iconIndex++)
			{
	if(ActiveConfiguration->ObjectsIcons.at(iconIndex)==NULL)qWarning("void XEPlugin_GMounts::MountAdded(const QString &newMount) [125] Cazzo e' null");
				if(ActiveConfiguration->ObjectsIcons.at(iconIndex)->Info.fileName==newMount)return;
			}
			// copy the informations
			// is disabled?
			if(ActiveConfiguration->Plugins.Matches.at(i)->Icon->Info.className=="disabled")return;
			// if there are too icons, we can exit because no more will be added
			int autoAddSeparator=1;
			if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;
			if(autoAddSeparator)
			{
				XSGObjectIcon *iP=ActiveConfiguration->ObjectsIcons.at(ActiveConfiguration->ObjectsIcons.count()-1);
				QString cn=iP->Info.className;
				if(!cn.startsWith("x") && cn!="GSeparator" && iP->TimeToLive==0)
					{
						XSGObjectIcon *addedSpace=Configurator->iconAddSeparator();
						ActiveConfiguration->ObjectsIcons.append(addedSpace);
						xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
					}
			}
			XSGObjectIcon *addedCfg=Configurator->iconAdd();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			ActiveConfiguration->ObjectsIcons.append(addedCfg);
			ActiveConfiguration->RollingIcons.append(addedCfg);
			addedCfg->OverText=ActiveConfiguration->Plugins.Matches.at(i)->Icon->OverText;
			addedCfg->Info.fileName=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Name=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			addedCfg->Info.Group=ActiveConfiguration->Plugins.Matches.at(i)->SystemName;
			if(ExternalEntryManager!="")addedCfg->Info.className=ExternalEntryManager;
			else addedCfg->Info.className="Bluetooth";
			addedCfg->TimeToLive=-1;
			addedCfg->Tasks.Proces.clear();
			addedCfg->Actions.iAnimationMask=0;
			addedCfg->Tasks.TaskInfo=NULL;
			addedCfg->Tasks.MiniTextShow=2;
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.TaskInfo=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskInfo;
			addedCfg->Tasks.TaskName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.TaskName;
			addedCfg->Tasks.WindowTitle=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Tasks.WindowTitle;
			addedCfg->Images.imgFileName=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images.imgFileName;
			addedCfg->Images.imgFileOverlay=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Images.imgFileOverlay;
			//network_local
			//qWarning(QString("Cerco:%1").arg(addedCfg->Images.imgFileName));
			QString networkName=addedCfg->Images.imgFileName;
			Configurator->xFindResource("icon",networkName);
			if(networkName=="")
			{
				addedCfg->Images.imgFileName="bluetooth_generic";
				//qWarning(addedCfg->Images.imgFileName);
			}
			else {
				//qWarning("icona trovata");
				addedCfg->Images.imgFileName=networkName;
			}
			addedCfg->Images.imgFileOverlay="kxdocker/plugins/bluetooth/bluetooth_none.png";
			addedCfg->Actions.onClickExec=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions.onClickExec;
			addedCfg->Actions.onDropExec=ActiveConfiguration->Plugins.Matches.at(i)->Icon->Actions.onDropExec;
			
			xGDocker->xEventTaskAppend(ActiveConfiguration->ObjectsIcons.count()-1);
			return;
		}
	}
	// 0.34
	// check if we like to auto attach
	if(AutoAddMounts!="no")
	{
			if(ActiveConfiguration->ObjectsIcons.count()>=(uint)ActiveConfiguration->Engine.MaxIconsShowed)return;
			// 0.35
			XSGObjectIcon *addedCfg=Configurator->iconAdd();
			addedCfg->Tasks.PopupMenu=NULL;
			addedCfg->PluginPopupMenu=NULL;
			addedCfg->OverText=newMount;
			addedCfg->Info.fileName=newMount;
			addedCfg->Info.Name=newMount;
			addedCfg->Info.Group=newMount;
			if(ExternalEntryManager!="")addedCfg->Info.className=ExternalEntryManager;
			else addedCfg->Info.className="Bluetooth";
			
			addedCfg->Actions.iAnimationMask=0;
			addedCfg->Tasks.Proces.clear();
			addedCfg->Tasks.TaskInfo=NULL;
			addedCfg->TimeToLive=0;
			addedCfg->Tasks.MiniTextShow=1;
			addedCfg->Tasks.ShowThumbnail=0;
			addedCfg->Tasks.WindowTitle=QString("%1%1").arg(prefixCaption).arg(newMount);
			addedCfg->Tasks.TaskName=addedCfg->Tasks.WindowTitle;
			addedCfg->Tasks.ClassName=addedCfg->Tasks.WindowTitle;

			addedCfg->Images.imgFileName=newMount;
			/*
			QString networkName=addedCfg->Images.imgFileName;
			Configurator->xFindResource("icon",networkName);
			if(networkName=="")addedCfg->Images.imgFileName="bluetooth_generic";
			else addedCfg->Images.imgFileName=networkName;
			addedCfg->Images.imgFileOverlay="kxdocker/plugins/bluetooth/bluetooth_none.png";
			*/
			

			// 0.38
			//addedCfg->Actions.onClickExec=QString("konqueror %1%1").arg("lan://localhost/").arg(newMount);
			addedCfg->Actions.onClickExec=onClickExec;
			addedCfg->Actions.onClickExec=addedCfg->Actions.onClickExec.replace("%MOUNTPOINT%",newMount);
			addedCfg->Actions.onDropExec="kbtobexclient %1";
			XSCfgMatchIcons *addedCfgMatch=new XSCfgMatchIcons;
			addedCfgMatch->Icon=addedCfg;
			addedCfgMatch->SystemName=newMount;
			ActiveConfiguration->Plugins.Matches.append(addedCfgMatch);
			Discovered(newMount);
			return;
	}
}


/*!
    \fn XEPlugin_Bluetooth::discoveryNow()
 */
void XEPlugin_Bluetooth::discoveryNow()
{
	btManager->setCmd("hcitool scan","",checkEvery,1);
	btManager->start();
}


/*!
    \fn XEPlugin_Bluetooth::discoveryStop()
 */
void XEPlugin_Bluetooth::discoveryStop()
{
	btManager->setCmd("hcitool scan","",0,1);
	btManager->terminate();
}
